/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.CadreResumeApplicationService;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.common.bo.TimePeriodBo;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class CadreResumeCommonService {
    private static final Log LOG = LogFactory.getLog(CadreResumeCommonService.class);
    private static final Map<String, String> FIELD_MAPPING = Maps.newLinkedHashMap();
    private static final String UPDATE_LIMIT = "4715a0df000000ac";
    private static final String PRINT_LIMIT = "4730fc9e000000ac";
    private final String TIPS_NEW_DATA_KEY = "tips_newdata";
    private static final String YES = "Yes";
    private static final CadreResumeApplicationService CADRE_RESUME_APPLICATION_SERVICE = (CadreResumeApplicationService)ServiceFactory.getService(CadreResumeApplicationService.class);

    public CadreResumeCommonService() {
        FIELD_MAPPING.put("folk", "folk_id");
        FIELD_MAPPING.put("formername", "formername");
        FIELD_MAPPING.put("birthday", "birthday");
        FIELD_MAPPING.put("nativeplace", "nativeplace");
        FIELD_MAPPING.put("birthplace", "birthplace");
        FIELD_MAPPING.put("marriagestatus", "marriagestatus_id");
        FIELD_MAPPING.put("healthstatus", "healthstatus_id");
    }

    public String getMainPosition(Map<Long, List<Map<String, Object>>> empMap, Long personId) {
        Map<String, Object> primaryMap = this.getMainPos(empMap, personId);
        if (null == primaryMap) {
            return "";
        }
        Object positionType = primaryMap.get("apositiontype");
        if (null == positionType) {
            return "";
        }
        return this.getPositionName(primaryMap, positionType);
    }

    public String getMainCompany(Map<Long, List<Map<String, Object>>> empMap, Long personId) {
        Map<String, Object> primaryMap = this.getMainPos(empMap, personId);
        if (null == primaryMap) {
            return "";
        }
        return primaryMap.get("company") == null ? "" : primaryMap.get("company").toString();
    }

    public Map<String, Object> getMainPos(Map<Long, List<Map<String, Object>>> empMap, Long personId) {
        if (null == empMap) {
            return null;
        }
        List<Map<String, Object>> currentEmpPos = empMap.get(personId);
        if (CollectionUtils.isEmpty(currentEmpPos)) {
            return null;
        }
        List primaryList = currentEmpPos.stream().filter(map -> "1".equals(map.get("isprimary"))).sorted(Comparator.comparing(map -> (Date)map.get("startdate"), Comparator.reverseOrder())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(primaryList)) {
            return null;
        }
        return (Map)primaryList.get(0);
    }

    public String getPositionName(Map<String, Object> posMap, Object positionType) {
        String positionName = "";
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            positionName = posMap.get("position") == null ? "" : posMap.get("position").toString();
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            positionName = posMap.get("job") == null ? "" : posMap.get("job").toString();
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            positionName = posMap.get("stdposition") == null ? "" : posMap.get("stdposition").toString();
        }
        return positionName;
    }

    public String appendWorkUnitAndPosition(Map<Long, List<Map<String, Object>>> empMap, Long personId) {
        if (null == empMap) {
            return "";
        }
        List<Map<String, Object>> currentEmpPos = empMap.get(personId);
        if (CollectionUtils.isEmpty(currentEmpPos)) {
            return "";
        }
        List inUsedEmpPosList = currentEmpPos.stream().filter(map -> "1".equals(map.get("businessstatus"))).collect(Collectors.toList());
        List<Map> sortEmpPosList = inUsedEmpPosList.stream().sorted(Comparator.comparing(map -> map.get("postype_id") == null ? 0L : Long.parseLong(map.get("postype_id").toString()))).collect(Collectors.toList());
        LinkedHashMap sortEmpPosMap = Maps.newLinkedHashMap();
        sortEmpPosList.forEach(map -> {
            String company = map.get("company") == null ? "" : map.get("company");
            String adminOrg = map.get("adminOrg") == null ? "" : map.get("adminOrg");
            String key = company + "," + adminOrg;
            List maps = (List)sortEmpPosMap.get(key);
            if (CollectionUtils.isEmpty((Collection)maps)) {
                maps = Lists.newArrayList();
            }
            maps.add(map);
            sortEmpPosMap.put(key, maps);
        });
        LinkedHashMap workUnitMap = Maps.newLinkedHashMap();
        sortEmpPosMap.forEach((org, empPosList) -> {
            if (HRStringUtils.isBlank((CharSequence)org) || org.equals(",") || CollectionUtils.isEmpty((Collection)empPosList)) {
                return;
            }
            String company = org.split(",")[0];
            ArrayList unitList = Lists.newArrayList();
            workUnitMap.put(company, unitList);
            empPosList = empPosList.stream().sorted(Comparator.comparing(map -> map.get("postype_id") == null ? 0L : Long.parseLong(map.get("postype_id").toString()))).collect(Collectors.toList());
            empPosList.forEach(map -> {
                Object positionType = map.get("apositiontype");
                if (null == positionType) {
                    return;
                }
                String positionName = this.getPositionName((Map<String, Object>)map, positionType);
                if (HRStringUtils.isBlank((CharSequence)positionName)) {
                    positionName = this.defaultPositionName();
                }
                unitList.add(positionName);
            });
        });
        ArrayList resultList = Lists.newArrayList();
        String defaultCompany = ResManager.loadKDString((String)"\u3010\u6240\u5c5e\u516c\u53f8\u3011", (String)"CadreResumeCommonService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        workUnitMap.forEach((companyName, positionNameList) -> {
            if (HRStringUtils.isBlank((CharSequence)companyName)) {
                companyName = defaultCompany;
            }
            String positionName = positionNameList.size() == 1 ? (String)positionNameList.get(0) : String.join((CharSequence)"\u3001", positionNameList);
            String result = companyName + positionName;
            if (defaultCompany.equals(companyName) && this.defaultPositionName().equals(positionName)) {
                return;
            }
            resultList.add(result);
        });
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return "";
        }
        return String.join((CharSequence)"\uff0c", resultList);
    }

    public String getFirstPos(Map<Long, List<Map<String, Object>>> empMap, List<Map<String, Object>> perWorkExpList, Long personId) {
        if (CollectionUtils.isEmpty(perWorkExpList)) {
            List<Map<String, Object>> currentPosList = empMap.get(personId);
            return this.fistPosName(currentPosList, "company");
        }
        perWorkExpList.stream().filter(map -> map.get("startdate") != null).forEach(map -> {
            Date startdate = this.parseDate((Map<String, Object>)map, "startdate");
            map.put("startdate", startdate);
        });
        return this.fistPosName(perWorkExpList, "unitname");
    }

    public String getEducationInfo(List<Map<String, Object>> educationalInfoList) {
        if (CollectionUtils.isEmpty(educationalInfoList)) {
            return "";
        }
        if (CollectionUtils.isEmpty(this.getFullTimeEducationList(educationalInfoList))) {
            return "";
        }
        List<Map<String, Object>> fullTimeEducationList = this.getFullTimeEducationList(educationalInfoList);
        Map<String, Object> highestEducationMap = this.getHighestEducationInfo(fullTimeEducationList);
        return this.highestEducation(highestEducationMap);
    }

    private List<Map<String, Object>> getFullTimeEducationList(List<Map<String, Object>> educationalInfoList) {
        ArrayList fullTimeEducationList = Lists.newArrayList();
        educationalInfoList.forEach(map -> {
            Object edunatureId = map.get("edunature_id");
            if (null == edunatureId || Long.parseLong(edunatureId.toString()) == 0L) {
                return;
            }
            if (1010L == Long.parseLong(edunatureId.toString())) {
                fullTimeEducationList.add(map);
            }
        });
        return fullTimeEducationList;
    }

    public String commonGraduateInfo(List<Map<String, Object>> educationalInfoList) {
        List<Object> commonEducationList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(educationalInfoList) && CollectionUtils.isEmpty((Collection)(commonEducationList = this.getCommonEducationList(educationalInfoList)))) {
            return "";
        }
        Map<String, Object> commonHighestEducationInfo = this.getHighestEducationInfo(commonEducationList);
        return this.schoolMajorInfo(commonHighestEducationInfo);
    }

    public String commonEducationInfo(List<Map<String, Object>> educationalInfoList) {
        if (CollectionUtils.isEmpty(educationalInfoList)) {
            return "";
        }
        List<Map<String, Object>> commonEducationList = this.getCommonEducationList(educationalInfoList);
        if (CollectionUtils.isEmpty(commonEducationList)) {
            return "";
        }
        Map<String, Object> highestEducationInfo = this.getHighestEducationInfo(commonEducationList);
        return this.highestEducation(highestEducationInfo);
    }

    public String fullTimeGraduateInfo(List<Map<String, Object>> educationalInfoList) {
        if (CollectionUtils.isEmpty(educationalInfoList)) {
            return "";
        }
        List<Map<String, Object>> fullTimeEducationList = this.getFullTimeEducationList(educationalInfoList);
        if (CollectionUtils.isEmpty(fullTimeEducationList)) {
            return "";
        }
        Map<String, Object> fullTimeHighestEducationInfo = this.getHighestEducationInfo(fullTimeEducationList);
        return this.schoolMajorInfo(fullTimeHighestEducationInfo);
    }

    public String schoolMajorInfo(Map<String, Object> highestEducationInfo) {
        Object secondMajor;
        String major;
        String collegeDepartment;
        String school;
        String defaultSchool = ResManager.loadKDString((String)"\u3010\u6bd5\u4e1a\u9662\u6821\u3011", (String)"CadreResumeCommonService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String defaultCollegeDepartment = ResManager.loadKDString((String)"\u3010\u6240\u5728\u9662\u7cfb\u3011", (String)"CadreResumeCommonService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String defaultMajor = ResManager.loadKDString((String)"\u3010\u4e13\u4e1a\u3011", (String)"CadreResumeCommonService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        Object graduateSchoolIdObj = highestEducationInfo.get("graduateschool_id");
        if (graduateSchoolIdObj instanceof Long) {
            Long graduateSchoolId = (Long)graduateSchoolIdObj;
            school = 1386848073895945216L == graduateSchoolId ? (highestEducationInfo.get("schoolrecord") == null ? "" : highestEducationInfo.get("schoolrecord").toString()) : (highestEducationInfo.get("graduateschool_name") == null ? defaultSchool : highestEducationInfo.get("graduateschool_name").toString());
        } else {
            String string = school = highestEducationInfo.get("graduateschool_name") == null ? defaultSchool : highestEducationInfo.get("graduateschool_name").toString();
        }
        if (HRStringUtils.isBlank((CharSequence)school)) {
            school = defaultSchool;
        }
        String string = collegeDepartment = highestEducationInfo.get("collegedepartment") == null ? defaultCollegeDepartment : highestEducationInfo.get("collegedepartment").toString();
        if (HRStringUtils.isBlank((CharSequence)collegeDepartment)) {
            collegeDepartment = defaultCollegeDepartment;
        }
        String string2 = major = highestEducationInfo.get("major") == null ? defaultMajor : highestEducationInfo.get("major").toString();
        if (HRStringUtils.isBlank((CharSequence)major)) {
            major = defaultMajor;
        }
        if ((secondMajor = highestEducationInfo.get("secondmajor")) instanceof String && HRStringUtils.isNotEmpty((String)secondMajor.toString())) {
            major = ResManager.loadKDString((String)"{0}\uff1b{1}", (String)"CadreResumeCommonService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{major, highestEducationInfo.get("secondmajor")});
        }
        String result = school + collegeDepartment + major;
        if (defaultSchool.equals(school) && defaultCollegeDepartment.equals(collegeDepartment) && defaultMajor.equals(major)) {
            result = "";
        }
        return result;
    }

    private List<Map<String, Object>> getCommonEducationList(List<Map<String, Object>> educationalInfoList) {
        ArrayList notFullTimeEducationList = Lists.newArrayList();
        educationalInfoList.forEach(map -> {
            if (null == map.get("edunature_id") || Long.parseLong(map.get("edunature_id").toString()) == 0L) {
                return;
            }
            if (1010L != Long.parseLong(map.get("edunature_id").toString())) {
                notFullTimeEducationList.add(map);
            }
        });
        return notFullTimeEducationList;
    }

    private String highestEducation(Map<String, Object> highestEducationMap) {
        String degree;
        String defaultEducation = ResManager.loadKDString((String)"\u3010\u5b66\u5386\u3011", (String)"CadreResumeCommonService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String defaultDegree = ResManager.loadKDString((String)"\u3010\u5b66\u4f4d\u3011", (String)"CadreResumeCommonService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String education = highestEducationMap.get("education_name") == null ? defaultEducation : highestEducationMap.get("education_name").toString();
        String string = degree = highestEducationMap.get("degree_name") == null ? defaultDegree : highestEducationMap.get("degree_name").toString();
        if (defaultEducation.equals(education) && defaultDegree.equals(degree)) {
            return "";
        }
        if (HRStringUtils.isBlank((CharSequence)degree)) {
            degree = defaultDegree;
        }
        if (HRStringUtils.isBlank((CharSequence)education)) {
            education = defaultEducation;
        }
        return education + degree;
    }

    private Map<String, Object> getHighestEducationInfo(List<Map<String, Object>> educationList) {
        if (CollectionUtils.isEmpty(educationList)) {
            return Maps.newHashMap();
        }
        educationList.forEach(map -> {
            Date endDate = this.parseDate((Map<String, Object>)map, "gradutiondate");
            try {
                if (null == endDate || "2199".equals(HRDateTimeUtils.format((Date)endDate, (String)"yyyy"))) {
                    endDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
                }
                map.put("gradutiondate", endDate);
            }
            catch (ParseException e) {
                LOG.error("getHighestEducationInfo parse date error ", (Throwable)e);
            }
        });
        List<Map> orderFullTimeEducationList = educationList.stream().sorted(Comparator.comparing(map -> (Date)map.get("gradutiondate"), Comparator.reverseOrder())).collect(Collectors.toList());
        ArrayList highestDegreeList = Lists.newArrayList();
        orderFullTimeEducationList.forEach(map -> {
            Object isHighestDegree = map.get("ishighestdegree");
            if ("1".equals(isHighestDegree)) {
                highestDegreeList.add(map);
            }
        });
        if (CollectionUtils.isEmpty((Collection)highestDegreeList) && !CollectionUtils.isEmpty(orderFullTimeEducationList)) {
            highestDegreeList.add(orderFullTimeEducationList.get(0));
        }
        if (CollectionUtils.isEmpty((Collection)highestDegreeList)) {
            return Maps.newHashMap();
        }
        return (Map)highestDegreeList.get(0);
    }

    public String getCredentialNumber(Long personId) {
        List perCre = ExternalDataService.getPerCre((Long)personId);
        ArrayList numberList = Lists.newArrayList();
        if (null != perCre) {
            perCre.forEach(map -> {
                long credentialsType;
                long l = credentialsType = map.get("credentialstype_id") == null ? 0L : Long.parseLong(map.get("credentialstype_id").toString());
                if (1010L == credentialsType && null != map.get("number")) {
                    numberList.add(map.get("number").toString());
                }
            });
        }
        return numberList.size() > 0 ? (String)numberList.get(0) : "-";
    }

    public String getWorkTitle(List<Map<String, Object>> workTitleList) {
        String getDate = ResManager.loadKDString((String)"\u3010\u6388\u4e88\u65f6\u95f4\u3011", (String)"CadreResumeCommonService_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String by = ResManager.loadKDString((String)"\u7ecf", (String)"CadreResumeCommonService_15", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String unit = ResManager.loadKDString((String)"\u3010\u8bc4\u5b9a\u5355\u4f4d\u3011", (String)"CadreResumeCommonService_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String sure = ResManager.loadKDString((String)"\u8ba4\u5b9a\u4e3a", (String)"CadreResumeCommonService_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String name = ResManager.loadKDString((String)"\u3010\u804c\u79f0\u540d\u79f0\u3011", (String)"CadreResumeCommonService_18", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String level = ResManager.loadKDString((String)"\u3010\u804c\u79f0\u7b49\u7ea7\u3011", (String)"CadreResumeCommonService_19", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(workTitleList)) {
            return "";
        }
        Map<Object, List<Map>> professionalMap = workTitleList.stream().filter(map -> map.get("professional_id") != null).collect(Collectors.groupingBy(map -> map.get("professional_id")));
        ArrayList resultList = Lists.newArrayList();
        professionalMap.forEach((professionalId, list) -> {
            if (Long.parseLong(professionalId.toString()) == 0L) {
                return;
            }
            HashSet isHighSet = Sets.newHashSet();
            list.forEach(map -> {
                Boolean isHigh = (Boolean)map.get("ishigh");
                isHighSet.add(isHigh != null && isHigh != false);
            });
            if (isHighSet.contains(true) && isHighSet.contains(false)) {
                list = list.stream().filter(map -> (Boolean)map.get("ishigh")).collect(Collectors.toList());
            }
            list.forEach(map -> {
                Date data = this.parseDate((Map<String, Object>)map, "awardtime");
                String awardDate = map.get("awardtime") == null || data == null ? getDate : HRDateTimeUtils.format((Date)data, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"CadreResumeCommonService_35", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                String awardUnit = map.get("unit") == null || HRStringUtils.isBlank((CharSequence)map.get("unit").toString()) ? unit : map.get("unit").toString();
                String professionalName = map.get("professional_name") == null || HRStringUtils.isBlank((CharSequence)map.get("professional_name").toString()) ? name : map.get("professional_name").toString();
                String professionalLevel = map.get("prolevel_name") == null || HRStringUtils.isBlank((CharSequence)map.get("prolevel_name").toString()) ? level : map.get("prolevel_name").toString();
                String result = awardDate + by + awardUnit + sure + professionalName + professionalLevel;
                if (getDate.equals(awardDate) && unit.equals(awardUnit) && name.equals(professionalName) && level.equals(professionalLevel)) {
                    return;
                }
                resultList.add(result);
            });
        });
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return "";
        }
        return String.join((CharSequence)";\n", resultList);
    }

    private Date parseDate(Map<String, Object> map, String key) {
        Date data = null;
        if (map.get(key) != null) {
            try {
                if (map.get(key) instanceof Date) {
                    data = (Date)map.get(key);
                    data = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)data, (String)"yyyy-MM-dd"));
                } else if (map.get(key) instanceof String) {
                    data = HRDateTimeUtils.parseDate((String)map.get(key).toString(), (String)"yyyy-MM-dd");
                }
            }
            catch (ParseException e) {
                LOG.error("parse awardtime fail ", (Throwable)e);
            }
        }
        return data;
    }

    public String languageAndSkillInfo(List<Map<String, Object>> languageSkillsList, List<Map<String, Object>> skillList) {
        String languageType = ResManager.loadKDString((String)"\u3010\u8bed\u8a00\u79cd\u7c7b\u3011", (String)"CadreResumeCommonService_20", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String languageLevel = ResManager.loadKDString((String)"\u3010\u5206\u6570\u7b49\u7ea7\u3011", (String)"CadreResumeCommonService_21", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String skillName = ResManager.loadKDString((String)"\u3010\u6280\u80fd\u540d\u79f0\u3011", (String)"CadreResumeCommonService_22", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String masterType = ResManager.loadKDString((String)"\u3010\u638c\u63e1\u7a0b\u5ea6\u3011", (String)"CadreResumeCommonService_23", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        ArrayList resultList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(languageSkillsList)) {
            languageSkillsList.forEach(map -> {
                String level;
                String language = map.get("language_name") == null || HRStringUtils.isBlank((CharSequence)map.get("language_name").toString()) ? languageType : map.get("language_name").toString();
                String string = level = map.get("grade") == null || HRStringUtils.isBlank((CharSequence)map.get("grade").toString()) ? languageLevel : map.get("grade").toString();
                if (languageType.equals(language) && languageLevel.equals(level)) {
                    return;
                }
                resultList.add(language + level);
            });
        }
        if (!CollectionUtils.isEmpty(skillList)) {
            skillList.forEach(map -> {
                String familiarity;
                String name = map.get("name") == null || HRStringUtils.isBlank((CharSequence)map.get("name").toString()) ? skillName : map.get("name").toString();
                String string = familiarity = map.get("familiarityid_name") == null || HRStringUtils.isBlank((CharSequence)map.get("familiarityid_name").toString()) ? masterType : map.get("familiarityid_name").toString();
                if (skillName.equals(name) && masterType.equals(familiarity)) {
                    return;
                }
                resultList.add(name + familiarity);
            });
        }
        if (CollectionUtils.isEmpty((Collection)resultList)) {
            return "";
        }
        return String.join((CharSequence)";\n", resultList);
    }

    public void updateEducationEntryInfo(List<Map<String, Object>> educationalInfoList, DynamicObject resume) {
        if (CollectionUtils.isEmpty(educationalInfoList)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = CADRE_RESUME_APPLICATION_SERVICE.newEducationEntry(resume);
        educationalInfoList.forEach(map -> {
            DynamicObject dynamicObject = dynamicObjectCollection.addNew();
            Date startDate = this.parseDate((Map<String, Object>)map, "admissiondate");
            Date endDate = this.parseDate((Map<String, Object>)map, "gradutiondate");
            try {
                if (null == endDate || "2199".equals(HRDateTimeUtils.format((Date)endDate, (String)"yyyy"))) {
                    endDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
                    dynamicObject.set("learnchangevalue", (Object)this.getToNow());
                } else {
                    dynamicObject.set("learnchangevalue", (Object)HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
                }
            }
            catch (ParseException e) {
                LOG.error("updateEducationEntryInfo parse date error ", (Throwable)e);
            }
            String desc = this.schoolMajorInfo((Map<String, Object>)map);
            dynamicObject.set("admissiondate", (Object)startDate);
            dynamicObject.set("gradutiondate", (Object)endDate);
            dynamicObject.set("collegedeptmajor", (Object)desc);
        });
        resume.set("learnentryentity", (Object)dynamicObjectCollection);
    }

    public void updateWorkEntryInfo(List<Map<String, Object>> perWorkExpList, Map<Long, List<Map<String, Object>>> empMap, Long personId, DynamicObject resume) {
        if (CollectionUtils.isEmpty(perWorkExpList) && (empMap == null || empMap.size() == 0)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = CADRE_RESUME_APPLICATION_SERVICE.newWorkEntry(resume);
        if (!CollectionUtils.isEmpty(perWorkExpList)) {
            perWorkExpList = this.orderByStartDate(perWorkExpList);
            perWorkExpList.forEach(map -> {
                DynamicObject workRow = dynamicObjectCollection.addNew();
                Date endDate = this.getEndDate((Map<String, Object>)map);
                String preWorkUnitName = this.getPreWorkUnitName((Map<String, Object>)map);
                Object startDate = map.get("startdate");
                if (HRStringUtils.isBlank((CharSequence)preWorkUnitName) && startDate == null) {
                    return;
                }
                String formatEndDate = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                if ("2999-12-31".equals(formatEndDate)) {
                    workRow.set("workchangevalue", (Object)this.getToNow());
                } else {
                    workRow.set("workchangevalue", (Object)formatEndDate);
                }
                workRow.set("startdate", startDate);
                workRow.set("enddate", (Object)endDate);
                workRow.set("unitname", (Object)preWorkUnitName);
            });
        }
        if (empMap != null && empMap.size() > 0) {
            List<Map<String, Object>> maps = empMap.get(personId);
            maps = this.orderByStartDate(maps);
            maps.forEach(map -> {
                Date endDate = this.getEndDate((Map<String, Object>)map);
                DynamicObject workRow = dynamicObjectCollection.addNew();
                Object startDate = map.get("startdate");
                String currentWork = this.getCurrentWork((Map<String, Object>)map);
                if (HRStringUtils.isBlank((CharSequence)currentWork) && null == startDate) {
                    return;
                }
                String formatEndDate = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                if ("2999-12-31".equals(formatEndDate)) {
                    workRow.set("workchangevalue", (Object)this.getToNow());
                } else {
                    workRow.set("workchangevalue", (Object)formatEndDate);
                }
                workRow.set("enddate", (Object)endDate);
                workRow.set("startdate", startDate);
                workRow.set("unitname", (Object)currentWork);
            });
        }
        resume.set("workentryentity", (Object)dynamicObjectCollection);
    }

    public void updateRightTable(DynamicObject resume, Map<Long, List<Map<String, Object>>> empPosMap, Long personId) {
        if (CollectionUtils.isEmpty(empPosMap)) {
            return;
        }
        if (!CollectionUtils.isEmpty(empPosMap)) {
            List<Map<String, Object>> maps = empPosMap.get(personId);
            if (CollectionUtils.isEmpty(maps)) {
                return;
            }
            DynamicObjectCollection adminOrgCollection = CADRE_RESUME_APPLICATION_SERVICE.emptyEntry(resume, "adminorgrightentity");
            DynamicObjectCollection resumeAdminOrgCollection = resume.getDynamicObjectCollection("resumeadminorg");
            if (!CollectionUtils.isEmpty((Collection)resumeAdminOrgCollection)) {
                resumeAdminOrgCollection.clear();
            }
            maps.forEach(map -> {
                Object adminOrgId = map.get("adminorg_id");
                if (null == adminOrgId) {
                    return;
                }
                DynamicObject dynamicObject = resumeAdminOrgCollection.addNew();
                dynamicObject.set("fbasedataid", adminOrgId);
                DynamicObject row = adminOrgCollection.addNew();
                row.set("empadminorg", adminOrgId);
            });
            resume.set("adminorgrightentity", (Object)adminOrgCollection);
            resume.set("resumeadminorg", (Object)resumeAdminOrgCollection);
        }
    }

    private Date getEndDate(Map<String, Object> map) {
        Date endDate = this.parseDate(map, "enddate");
        try {
            if (null == endDate || "2199".equals(HRDateTimeUtils.format((Date)endDate, (String)"yyyy"))) {
                endDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            }
        }
        catch (ParseException e) {
            LOG.error("updateEducationEntryInfo parse max end date error ", (Throwable)e);
        }
        return endDate;
    }

    public void updateFamilyEntryInfo(List<Map<String, Object>> familyMemberList, DynamicObject resume) {
        if (CollectionUtils.isEmpty(familyMemberList)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = CADRE_RESUME_APPLICATION_SERVICE.newFamilyEntry(resume);
        ArrayList wifeList = Lists.newArrayList();
        familyMemberList.forEach(map -> {
            if (this.ifWife((Map<String, Object>)map)) {
                wifeList.add(map);
                return;
            }
            DynamicObject memberRow = dynamicObjectCollection.addNew();
            memberRow.set("familymembship", map.get("familymembship_id"));
            memberRow.set("familymembername", map.get("name"));
        });
        resume.set("familyentryentity", (Object)dynamicObjectCollection);
        if (CollectionUtils.isEmpty((Collection)wifeList)) {
            return;
        }
        Map wifeMap = (Map)wifeList.get(0);
        resume.set("sname", wifeMap.get("name"));
    }

    public boolean ifWife(Map<String, Object> map) {
        return Long.parseLong(map.get("familymembship_id").toString()) == 1010L;
    }

    public List<Map<String, Object>> orderByStartDate(List<Map<String, Object>> maps) {
        if (CollectionUtils.isEmpty(maps)) {
            return Lists.newArrayList();
        }
        maps = maps.stream().sorted(Comparator.comparing(map -> {
            try {
                return map.get("startdate") == null ? HRDateTimeUtils.parseDate((String)"2999-12-31") : (Date)map.get("startdate");
            }
            catch (ParseException e) {
                LOG.error("updateWorkEntryInfo error ", (Throwable)e);
                throw new RuntimeException(e);
            }
        })).collect(Collectors.toList());
        return maps;
    }

    public String getCurrentWork(Map<String, Object> map) {
        String company;
        String companyStr = ResManager.loadKDString((String)"\u3010\u516c\u53f8\u3011", (String)"CadreResumeCommonService_24", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String positionName = this.getPositionName(map, map.get("apositiontype"));
        String string = company = map.get("company") == null ? companyStr : map.get("company").toString();
        if (companyStr.equals(company) && "".equals(positionName)) {
            return "";
        }
        return company + positionName;
    }

    public String getPreWorkUnitName(Map<String, Object> workMap) {
        String duty;
        String preUnitName = ResManager.loadKDString((String)"\u3010\u524d\u96c7\u4e3b\u540d\u79f0\u3011", (String)"CadreResumeCommonService_25", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String prePosition = ResManager.loadKDString((String)"\u3010\u62c5\u4efb\u804c\u52a1\u3011", (String)"CadreResumeCommonService_26", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String unitName = workMap.get("unitname") == null ? preUnitName : workMap.get("unitname").toString();
        String string = duty = workMap.get("duty") == null ? prePosition : workMap.get("duty").toString();
        if (preUnitName.equals(unitName) && prePosition.equals(duty)) {
            return "";
        }
        return unitName + duty;
    }

    public void getNewData(String targetKey, IFormView view, long personId) {
        String before = ResManager.loadKDString((String)"\u4eba\u5458\u6863\u6848\u5f53\u524d\u503c\uff1a", (String)"CadreResumeCommonService_33", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        Label label = (Label)view.getControl("newdata");
        IPageCache pageCache = view.getPageCache();
        switch (targetKey) {
            case "formername": 
            case "birthday": 
            case "folk": 
            case "marriagestatus": 
            case "healthstatus": {
                this.getPersonInfo(targetKey, personId, label, pageCache, before);
                break;
            }
            case "workunit": 
            case "position": 
            case "workunitposition": {
                this.setCurrentWorkExperience(targetKey, personId, label, pageCache, before);
                break;
            }
            case "firstworktimeunit": {
                this.setFirstWorkExperience(personId, label, pageCache, before);
                break;
            }
            case "ftdegree": 
            case "ftcollegedeptmajor": 
            case "inservicedegree": 
            case "iscollegedeptmajor": {
                this.setEducationInfo(targetKey, personId, label, pageCache, before);
                break;
            }
            case "idnumber": {
                this.setIdNumber(personId, label, pageCache, before);
                break;
            }
            case "dutytitle": {
                this.setDutyTitle(personId, label, pageCache, before);
                break;
            }
            case "religion": 
            case "nativeplace": 
            case "birthplace": {
                this.setReligion(personId, targetKey, label, pageCache, before);
                break;
            }
            case "langskill": {
                this.setSkill(personId, label, pageCache, before);
                break;
            }
            case "sname": {
                this.setWifeName(personId, label, pageCache, before);
                break;
            }
        }
    }

    public void showNewDataEntry(IFormView view, String targetFormId, String needShowEntryEntityName, String operateKey, IFormPlugin formPlugin) {
        IDataModel model = view.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection(needShowEntryEntityName);
        long personId = ((DynamicObject)model.getValue("person")).getLong("id");
        HashMap customParam = Maps.newHashMap();
        customParam.put("personId", personId);
        customParam.put("entryentity", SerializationUtils.serializeToBase64((Object)dynamicObjectCollection));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setCustomParams((Map)customParam);
        formShowParameter.setFormId(targetFormId);
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, operateKey));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public FormShowParameter showForm(String targetFormId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(targetFormId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        return formShowParameter;
    }

    public void createOriginalEntry(IFormView view, FormShowParameter formShowParameter, List<String> originalFields) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        Map customParams = formShowParameter.getCustomParams();
        if (null == customParams || customParams.size() == 0) {
            return;
        }
        if (null != customParams.get("entryentity")) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)customParams.get("entryentity").toString());
            TableValueSetter vs = this.beginCreateEntry(model, originalFields, "entryentity");
            dynamicObjectCollection.forEach(dynamicObject -> {
                int seq = dynamicObject.getInt("seq");
                int index = Math.max(seq - 1, 0);
                if (!this.autoDeleteEmptyRow(index, dynamicObjectCollection)) {
                    return;
                }
                ArrayList rowValues = Lists.newArrayList();
                originalFields.forEach(field -> {
                    if ("familymembship".equals(field)) {
                        rowValues.add(dynamicObject.get(field + ".id"));
                    } else if ("familypoliticalstatus".equals(field)) {
                        rowValues.add(dynamicObject.get(field + ".id"));
                    } else {
                        rowValues.add(dynamicObject.get(field));
                    }
                });
                vs.addRow(rowValues.toArray());
            });
            this.endCreateEntry(model, "entryentity", vs);
            view.updateView("entryentity");
        }
    }

    public Date updateDate(Date date) {
        if (null == date) {
            return null;
        }
        int year = HRDateTimeUtils.getYear((Date)date);
        if (year == 2199) {
            return HRDateTimeUtils.addYear((Date)date, (int)800);
        }
        return date;
    }

    public void showOrHideEndDate(IFormView view, String entryName, String endDateField, String endDateShowField, String selectKey) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        DynamicObjectCollection entityEntity = model.getEntityEntity(entryName);
        if (CollectionUtils.isEmpty((Collection)entityEntity)) {
            return;
        }
        entityEntity.forEach(dynamicObject -> {
            int req = dynamicObject.getInt("seq");
            Date endDate = dynamicObject.getDate(endDateField);
            int index = Math.max(req - 1, 0);
            if (null != endDate && (HRDateTimeUtils.format((Date)endDate, (String)"yyyy").equals("2999") || HRDateTimeUtils.format((Date)endDate, (String)"yyyy").equals("2199"))) {
                model.setValue(selectKey, (Object)Boolean.TRUE, index);
                model.setValue(endDateShowField, null, index);
                view.setEnable(Boolean.FALSE, index, new String[]{endDateShowField});
            } else {
                model.setValue(endDateShowField, (Object)endDate, index);
                model.setValue(selectKey, (Object)Boolean.FALSE, index);
            }
        });
        view.updateView(entryName);
    }

    public void endCreateEntry(AbstractFormDataModel model, String entryName, TableValueSetter vs) {
        model.batchCreateNewEntryRow(entryName, vs);
        model.endInit();
    }

    public TableValueSetter beginCreateEntry(AbstractFormDataModel model, List<String> fields, String entryName) {
        model.deleteEntryData(entryName);
        model.beginInit();
        return new TableValueSetter(fields.toArray(new String[0]));
    }

    public void entryCoverDoBefore(IFormView view, BeforeDoOperationEventArgs args, String cover, IFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (cover.equals(operateKey)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(operateKey, formPlugin);
            view.showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5f53\u524d\u6570\u636e\u5c06\u88ab\u8986\u76d6\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CadreResumeCommonService_27", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
    }

    public void coverCallBack(IFormView view, MessageBoxClosedEvent messageBoxClosedEvent, String cover) {
        IDataModel model = view.getModel();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (cover.equals(callBackId) && YES.equals(messageBoxClosedEvent.getResultValue())) {
            String newEntryName = "entryentitynew";
            DynamicObjectCollection dynamicObjectCollection = model.getDataEntity(true).getDynamicObjectCollection(newEntryName);
            view.returnDataToParent((Object)dynamicObjectCollection);
            view.close();
        }
    }

    public void coverUpdateEntry(IFormView view, DynamicObjectCollection dynamicObjectCollection, List<String> fields, String entryName) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        if (null == dynamicObjectCollection || dynamicObjectCollection.size() == 0) {
            model.deleteEntryData(entryName);
            return;
        }
        TableValueSetter vs = this.beginCreateEntry(model, fields, entryName);
        ArrayList dateFieldList = Lists.newArrayList((Object[])new String[]{"admissiondate", "gradutiondate", "startdate", "enddate", "familybirthday"});
        dynamicObjectCollection.forEach(dynamicObject -> {
            ArrayList result = Lists.newArrayList();
            fields.forEach(field -> this.setEntryValue((String)field, (DynamicObject)dynamicObject, result, dateFieldList));
            vs.addRow(result.toArray());
        });
        this.endCreateEntry(model, entryName, vs);
        view.updateView(entryName);
    }

    private void setEntryValue(String field, DynamicObject newRow, List<Object> result, List<String> dateFieldList) {
        if ("familymembship".equals(field)) {
            result.add(newRow.getLong(field + "new.id"));
        } else if ("collegedeptmajor".equals(field) || "unitname".equals(field) || "familymembername".equals(field)) {
            LocaleString localeString = new LocaleString();
            String name = RequestContext.get().getLang().name();
            Lang from = Lang.from((String)name);
            String value = newRow.getString(field + "new");
            localeString.setItem(from.toString(), (Object)value);
            result.add(localeString);
        } else if (dateFieldList.contains(field)) {
            result.add(newRow.getDate(field + "new"));
        } else if ("learnchangevalue".equals(field)) {
            String graduateDate = HRDateTimeUtils.format((Date)newRow.getDate("gradutiondatenew"), (String)"yyyy-MM-dd");
            if ("2999-12-31".equals(graduateDate)) {
                result.add(this.getToNow());
            } else {
                result.add(graduateDate);
            }
        } else if ("workchangevalue".equals(field)) {
            String endDate = HRDateTimeUtils.format((Date)newRow.getDate("enddatenew"), (String)"yyyy-MM-dd");
            if ("2999-12-31".equals(endDate)) {
                result.add(this.getToNow());
            } else {
                result.add(endDate);
            }
        } else {
            result.add(newRow.get(field + "new"));
        }
    }

    public void setAnchorItems(Map<String, String> anchorMap, IFormView view, String anchorControlName) {
        ArrayList list = Lists.newArrayList();
        anchorMap.forEach((target, caption) -> {
            AnchorItems anchorItems = new AnchorItems();
            anchorItems.setTarget(target);
            anchorItems.setCaption(caption);
            list.add(anchorItems);
        });
        AnchorControl anchorCtl = (AnchorControl)view.getControl(anchorControlName);
        anchorCtl.setHighlight(true);
        anchorCtl.addItems((List)list);
    }

    public void parentViewStatusVisible(IFormView currentView, String visibleBtn) {
        FormShowParameter formShowParameter = currentView.getParentView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW.getValue() == status.getValue()) {
            currentView.setVisible(Boolean.FALSE, new String[]{visibleBtn});
        } else if (OperationStatus.ADDNEW.getValue() == status.getValue() || OperationStatus.EDIT.getValue() == status.getValue()) {
            currentView.setVisible(Boolean.TRUE, new String[]{visibleBtn});
        }
    }

    public boolean windowUpdatePer(IFormView view) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)UPDATE_LIMIT);
        if (!hasPerm) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u4fee\u6539\u5e72\u90e8\u5c65\u5386\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CadreResumeCommonService_36", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
        return hasPerm;
    }

    public boolean windowPrintPer(IFormView view) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)PRINT_LIMIT);
        if (!hasPerm) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u6253\u5370\u5e72\u90e8\u5c65\u5386\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CadreResumeCommonService_37", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
        return hasPerm;
    }

    private void setSkill(long personId, Label label, IPageCache pageCache, String before) {
        HashMap param = Maps.newHashMap();
        param.put("identifyIdType", "PERID");
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"013", "024"}));
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> langMap = this.getTargetResult(result, "hrpi_languageskills");
        Map<Long, List<Map<String, Object>>> skillMap = this.getTargetResult(result, "hrpi_rsmproskl");
        List<Map<String, Object>> languageSkillsList = langMap.get(personId);
        List<Map<String, Object>> skillList = skillMap.get(personId);
        String newData = this.languageAndSkillInfo(languageSkillsList, skillList);
        if (HRStringUtils.isBlank((CharSequence)newData)) {
            newData = "-";
        }
        pageCache.put("tips_newdata", newData);
        label.setText(before + newData);
    }

    private void setWifeName(long personId, Label label, IPageCache pageCache, String before) {
        QFilter qFilter = new QFilter("person", "in", Collections.singletonList(personId));
        List familyMemberList = ExternalDataService.getHrpiCommonInfoByFilter((String)"person,name,familymembship", (QFilter)qFilter, (String)"hrpi_familymemb");
        String defaultName = "-";
        if (CollectionUtils.isEmpty((Collection)familyMemberList)) {
            label.setText(before + defaultName);
            return;
        }
        List wifeList = familyMemberList.stream().filter(map -> Long.parseLong(map.get("familymembship_id").toString()) == 1010L).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(wifeList)) {
            label.setText(before + defaultName);
            return;
        }
        String newData = ((Map)wifeList.get(0)).get("name") == null ? defaultName : ((Map)wifeList.get(0)).get("name");
        pageCache.put("tips_newdata", newData.toString());
        label.setText(before + newData);
    }

    private void setReligion(long personId, String targetKey, Label label, IPageCache pageCache, String before) {
        String result;
        String defaultResult = "-";
        QFilter qFilter = new QFilter("person", "in", Collections.singletonList(personId));
        List personRegionInfoList = ExternalDataService.getHrpiCommonInfoByFilter((String)"politicalstatus,party,religion,nativeplace,birthplace", (QFilter)qFilter, (String)"hrpi_perregion");
        if (CollectionUtils.isEmpty((Collection)personRegionInfoList)) {
            result = defaultResult;
        } else {
            Map perRegion = (Map)personRegionInfoList.get(0);
            if (null == perRegion.get(targetKey) || HRStringUtils.isBlank((CharSequence)perRegion.get(targetKey).toString())) {
                result = defaultResult;
            } else {
                String localeValue = perRegion.get(targetKey) instanceof OrmLocaleValue ? ((OrmLocaleValue)perRegion.get(targetKey)).getLocaleValue() : perRegion.get(targetKey).toString();
                result = HRStringUtils.isBlank((CharSequence)localeValue) ? "-" : localeValue;
            }
        }
        pageCache.put("tips_newdata", result);
        label.setText(before + result);
    }

    private void setDutyTitle(long personId, Label label, IPageCache pageCache, String before) {
        HashMap param = Maps.newHashMap();
        param.put("identifyIdType", "PERID");
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"018"}));
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> targetMap = this.getTargetResult(result, "hrpi_perprotitle");
        List<Map<String, Object>> workTitleList = targetMap.get(personId);
        String newData = this.getWorkTitle(workTitleList);
        if (HRStringUtils.isBlank((CharSequence)newData)) {
            newData = "-";
        }
        pageCache.put("tips_newdata", newData);
        label.setText(before + newData);
    }

    private void setIdNumber(long personId, Label label, IPageCache pageCache, String before) {
        String credentialNumber = this.getCredentialNumber(personId);
        pageCache.put("tips_newdata", credentialNumber);
        label.setText(before + credentialNumber);
    }

    private void setEducationInfo(String targetKey, long personId, Label label, IPageCache pageCache, String before) {
        HashMap param = Maps.newHashMap();
        param.put("identifyIdType", "PERID");
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"009"}));
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> educationMap = this.getTargetResult(result, "hrpi_pereduexp");
        List<Map<String, Object>> educationalInfoList = educationMap.get(personId);
        String newData = "ftdegree".equals(targetKey) ? this.getEducationInfo(educationalInfoList) : ("ftcollegedeptmajor".equals(targetKey) ? this.fullTimeGraduateInfo(educationalInfoList) : ("inservicedegree".equals(targetKey) ? this.commonEducationInfo(educationalInfoList) : this.commonGraduateInfo(educationalInfoList)));
        if (HRStringUtils.isBlank((CharSequence)newData)) {
            newData = "-";
        }
        pageCache.put("tips_newdata", newData);
        label.setText(before + newData);
    }

    private void setFirstWorkExperience(long personId, Label label, IPageCache pageCache, String before) {
        String firstPos;
        HashMap param = Maps.newHashMap();
        param.put("identifyIdType", "PERID");
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"015"}));
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> educationMap = this.getTargetResult(result, "hrpi_preworkexp");
        List<Map<String, Object>> perWorkExpList = educationMap.get(personId);
        if (CollectionUtils.isEmpty(perWorkExpList)) {
            Map empMap = ExternalDataService.queryEmpposorgrels(Collections.singletonList(personId));
            firstPos = this.getFirstPos(empMap, null, personId);
        } else {
            firstPos = this.getFirstPos(null, perWorkExpList, personId);
        }
        if (HRStringUtils.isBlank((CharSequence)firstPos)) {
            firstPos = "-";
        }
        pageCache.put("tips_newdata", firstPos);
        label.setText(before + firstPos);
    }

    private void setCurrentWorkExperience(String targetKey, long personId, Label label, IPageCache pageCache, String before) {
        QFilter qFilter = new QFilter("person", "in", Collections.singletonList(personId));
        List empPosList = ExternalDataService.getHrpiCommonInfoByFilter((String)"businessstatus,person,company,adminorg,apositiontype,position,job,stdposition,isprimary,postype,startdate,enddate", (QFilter)qFilter, (String)"hrpi_empposorgrel");
        HashMap empMap = Maps.newHashMap();
        empMap.put(personId, empPosList);
        String newData = "workunitposition".equals(targetKey) ? this.appendWorkUnitAndPosition(empMap, personId) : ("position".equals(targetKey) ? this.getMainPosition(empMap, personId) : this.getMainCompany(empMap, personId));
        if (HRStringUtils.isBlank((CharSequence)newData)) {
            newData = "-";
        }
        pageCache.put("tips_newdata", newData);
        label.setText(before + newData);
    }

    private void getPersonInfo(String targetKey, long personId, Label label, IPageCache pageCache, String before) {
        String newData;
        QFilter qFilter = new QFilter("person", "in", Collections.singletonList(personId));
        ArrayList personBaseKey = Lists.newArrayList((Object[])new String[]{"formername", "birthday", "folk"});
        List personInfoList = personBaseKey.contains(targetKey) ? ExternalDataService.getHrpiCommonInfoByFilter((String)"birthday,formername,folk", (QFilter)qFilter, (String)"hrpi_pernontsprop") : ExternalDataService.getHrpiCommonInfoByFilter((String)"marriagestatus,healthstatus", (QFilter)qFilter, (String)"hrpi_pertsprop");
        if (CollectionUtils.isEmpty((Collection)personInfoList)) {
            return;
        }
        Map personInfo = (Map)personInfoList.get(0);
        if (null == personInfo) {
            return;
        }
        String field = FIELD_MAPPING.get(targetKey);
        if (HRStringUtils.isBlank((CharSequence)field)) {
            return;
        }
        String defaultValue = "-";
        if (field.contains("_id")) {
            long baseDataId = personInfo.get(field) == null ? 0L : (Long)personInfo.get(field);
            newData = personInfo.get(field.split("_")[0]) == null ? defaultValue : personInfo.get(field.split("_")[0]).toString();
            pageCache.put("tips_basedataid", String.valueOf(baseDataId));
            label.setText(before + newData);
        } else if (field.equals("birthday")) {
            Date date = (Date)personInfo.get(field);
            if (null != date) {
                newData = HRDateTimeUtils.format((Date)date, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"CadreResumeCommonService_34", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                pageCache.put("tips_date", newData);
            } else {
                newData = defaultValue;
            }
            label.setText(before + newData);
        } else {
            newData = personInfo.get(field) == null ? defaultValue : personInfo.get(field).toString();
            label.setText(before + newData);
        }
        pageCache.put("tips_newdata", newData);
    }

    private String fistPosName(List<Map<String, Object>> posList, String companyField) {
        String in = ResManager.loadKDString((String)"\u5728", (String)"CadreResumeCommonService_28", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String work = ResManager.loadKDString((String)"\u53c2\u52a0\u5de5\u4f5c", (String)"CadreResumeCommonService_29", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String workUnit = ResManager.loadKDString((String)"\u3010\u5de5\u4f5c\u5355\u4f4d\u3011", (String)"CadreResumeCommonService_30", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String startDate = ResManager.loadKDString((String)"\u3010\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f\u3011", (String)"CadreResumeCommonService_31", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(posList)) {
            return "";
        }
        posList.forEach(map -> {
            if (map.get("startdate") instanceof String) {
                try {
                    map.put("startdate", HRDateTimeUtils.parseDate((String)map.get("startdate").toString(), (String)"yyyy-MM-dd"));
                }
                catch (ParseException e) {
                    LOG.error("parse date error by {0}", (Object)e, map.get("startdate"));
                    map.put("startdate", null);
                }
            }
        });
        Optional<Map> optional = posList.stream().filter(map -> map.get("startdate") != null).min(Comparator.comparing(map -> (Date)map.get("startdate")));
        boolean present = optional.isPresent();
        String date = startDate;
        String company = workUnit;
        if (present) {
            Map firstEmpPosMap = optional.get();
            date = firstEmpPosMap.get("startdate") == null ? startDate : HRDateTimeUtils.format((Date)((Date)firstEmpPosMap.get("startdate")), (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"CadreResumeCommonService_35", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            String string = company = firstEmpPosMap.get(companyField) == null ? workUnit : firstEmpPosMap.get(companyField).toString();
        }
        if (workUnit.equals(company) && startDate.equals(date)) {
            return "";
        }
        return date + in + company + work;
    }

    private String defaultPositionName() {
        return ResManager.loadKDString((String)"\u3010\u4efb\u5c97\u540d\u79f0\u3011", (String)"CadreResumeCommonService_32", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
    }

    public BigDecimal setMainPostServiceLen(List<Map<String, Object>> postList) {
        ArrayList periodBoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(postList)) {
            return new BigDecimal(0);
        }
        postList.forEach(map -> {
            TimePeriodBo periodBo = new TimePeriodBo();
            Date startDate = (Date)map.get("startdate");
            Date endDate = (Date)map.get("enddate");
            if (null == endDate || HRDateTimeUtils.format((Date)endDate, (String)"yyyy").equals("2999") || HRDateTimeUtils.format((Date)endDate, (String)"yyyy").equals("2199")) {
                endDate = new Date();
            }
            periodBo.setBeginTime(startDate);
            periodBo.setEndTime(endDate);
            periodBoList.add(periodBo);
        });
        Map timePeriodsUnion = DateUtil.getTimePeriodsUnion((Boolean)false, (List)periodBoList);
        return DateUtil.getTotalYear((Map)timePeriodsUnion);
    }

    public boolean autoDeleteEmptyRow(int rowIndex, DynamicObjectCollection dynamicObjectCollection) {
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(rowIndex);
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        ArrayList rowResult = Lists.newArrayList();
        ArrayList returnFieldList = Lists.newArrayList((Object[])new String[]{"seq", "learntonowselect", "worktonowselect"});
        properties.forEach(property -> {
            String name = property.getName();
            if (returnFieldList.contains(name)) {
                return;
            }
            if ("id".equals(name) && (null == property.getValue((Object)dynamicObject) || 0L == Long.parseLong(property.getValue((Object)dynamicObject).toString()))) {
                return;
            }
            Object value = property.getValue((Object)dynamicObject);
            if (value instanceof DynamicObject) {
                rowResult.add(false);
            } else if (value instanceof Date) {
                rowResult.add(false);
            } else if (value instanceof String) {
                String strValue = (String)value;
                if (HRStringUtils.isBlank((CharSequence)strValue)) {
                    rowResult.add(true);
                } else {
                    rowResult.add(false);
                }
            } else if (null == value || 0L == Long.parseLong(value.toString())) {
                rowResult.add(true);
            } else {
                rowResult.add(false);
            }
        });
        return rowResult.contains(false);
    }

    public Map<Long, List<Map<String, Object>>> toPersonMap(List<Map<String, Object>> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        HashMap personMap = Maps.newHashMap();
        list.forEach(map -> {
            Object personObj = map.get("person_id");
            if (null == personObj || 0L == Long.parseLong(personObj.toString())) {
                return;
            }
            long personId = (Long)personObj;
            List maps = (List)personMap.get(personId);
            if (null == maps) {
                maps = Lists.newArrayList();
            }
            maps.add(map);
            personMap.put(personId, maps);
        });
        return personMap;
    }

    public boolean dataRuleValidate(IFormView view, BeforeDoOperationEventArgs args) {
        FormShowParameter formShowParameter;
        boolean cancelDataRight;
        IFormView parentView = view.getParentView();
        if (!(parentView instanceof ListView)) {
            parentView = parentView.getParentView();
        }
        if (cancelDataRight = (formShowParameter = parentView.getFormShowParameter()).isCancelDataRight()) {
            view.showConfirm(ResManager.loadKDString((String)"\u4f60\u7684\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\u3002", (String)"CadreResumePrintWindowPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener("CadreResumePrintWindowPlugin"));
            if (null != args) {
                args.setCancel(true);
            }
        }
        return cancelDataRight;
    }

    public Map<Long, List<Map<String, Object>>> getTargetResult(Map<String, Map<String, Object>> result, String targetName) {
        if (CollectionUtils.isEmpty(result)) {
            return Maps.newHashMap();
        }
        HashMap targetResultMap = Maps.newHashMap();
        result.forEach((personIdStr, map) -> {
            if (null == map) {
                return;
            }
            Long personId = Long.parseLong(personIdStr);
            Object o = map.get(targetName);
            if (null == o) {
                return;
            }
            List targetMapList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(o), ArrayList.class);
            if ("hrpi_percre".equals(targetName) && !CollectionUtils.isEmpty((Collection)targetMapList) && 1010L != Long.parseLong(((Map)targetMapList.get(0)).get("credentialstype_id").toString())) {
                return;
            }
            targetResultMap.put(personId, targetMapList);
        });
        return targetResultMap;
    }

    public LocaleString getToNow() {
        return ResManager.getLocaleString((String)"\u81f3\u4eca", (String)"CadreResumeCommonService_38", (String)"tdc-cadm-formplugin");
    }
}

