/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamPlanTypeEnum;
import kd.tdc.cadm.bussiness.util.CastUtils;

public class ExamineFormService {
    public List<Long> getControlledExamPlanData(List<Long> examPlanIds, long orgId, ExamPlanTypeEnum typeEnum) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"cadm_examplan", (Long)orgId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("cadm_examplan");
        QFilter idQFilter = new QFilter("id", "in", examPlanIds);
        QFilter statusQFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
        QFilter typeQFilter = new QFilter("examtype", "=", (Object)typeEnum.getNumber());
        DynamicObject[] ids = helper.queryOriginalArray("id", new QFilter[]{idQFilter, baseDataFilter, statusQFilter, enableQFilter, typeQFilter});
        return Arrays.stream(ids).map(dynObj -> dynObj.getLong("id")).collect(Collectors.toList());
    }

    public void openMoreDetail(IFormView view, long examId, long arrangeRecordId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("cadm_examinebill_layout");
        formShowParameter.setStatus(OperationStatus.VIEW);
        HashMap customMap = Maps.newHashMap();
        customMap.put("checkPerm", "0");
        customMap.put("caption", ResManager.loadKDString((String)"\u65b9\u6848\u8be6\u60c5", (String)"ExamCoopBillApplicationService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        customMap.put("arrangeRecordId", arrangeRecordId);
        formShowParameter.setCustomParams((Map)customMap);
        formShowParameter.setPkId((Object)examId);
        view.showForm((FormShowParameter)formShowParameter);
    }

    public void examStartOpAfterCloseCallBack(IFormView view, ClosedCallBackEvent evt) {
        Map returnData = CastUtils.castMap((Object)evt.getReturnData(), String.class);
        if (!returnData.containsKey("examplan")) {
            return;
        }
        Long examPlanSourceVid = (Long)returnData.get("examplan");
        Map intervieweeMap = (Map)returnData.get("interviewee");
        OperateOption option = OperateOption.create();
        option.setVariableValue("examplan", examPlanSourceVid.toString());
        option.setVariableValue("interviewee", SerializationUtils.serializeToBase64((Object)intervieweeMap));
        view.invokeOperation("save_startexam", option);
    }
}

