/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class IssueFormService {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);

    public String createIssueFilePdfUrl(IDataModel model, IFormView formView) {
        String pageId = formView.getPageId();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject fileObject = model.getDataEntity().getDynamicObject("appnoticedoc");
        if (fileObject == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4efb\u547d\u901a\u77e5\u6587\u4ef6\u201d\u3002", (String)"IssueFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return "";
        }
        List<Object> pkIds = this.getPkIds(model, formView);
        String templateNumber = fileObject.getString("id");
        return PRINT_FORM_SERVICE.buildPdfURL(pageId, "cadm_appointissue", PRINT_FORM_SERVICE.createPdfExtParam(dataEntity, pkIds, "cadm_appointissue"), templateNumber);
    }

    public List<Object> getPkIds(IDataModel model, IFormView formView) {
        String formId = formView.getFormShowParameter().getFormId();
        ArrayList<Object> pkIds = new ArrayList<Object>(10);
        if ("cadm_appointissue".equals(formId)) {
            Object pkId = model.getValue("id");
            pkIds.add(pkId);
        } else {
            List ids = (List)formView.getFormShowParameter().getCustomParam("ids");
            pkIds.addAll(ids);
        }
        return pkIds;
    }

    public void previewIssueFile(IDataModel model, IFormView formView) {
        String pdfUrl = this.createIssueFilePdfUrl(model, formView);
        if (!HRStringUtils.isEmpty((String)pdfUrl)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_printpreview");
            para.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, String> reservedSpace = new HashMap<String, String>(16);
            reservedSpace.put("reservedSpace", "true");
            para.getOpenStyle().setCustParam(reservedSpace);
            para.setCustomParam("src", (Object)pdfUrl);
            formView.showForm(para);
        }
    }

    public void downloadIssueFile(IDataModel model, IFormView formView) {
        String pdfUrl = this.createIssueFilePdfUrl(model, formView);
        if (!HRStringUtils.isEmpty((String)pdfUrl)) {
            String downloadUrl = pdfUrl;
            if (pdfUrl.contains("print.do")) {
                downloadUrl = pdfUrl.replace("print.do", "download.do");
            }
            formView.download(downloadUrl);
        }
    }
}

