/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class NominateCommonFormService {
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final String COMPANY_ID = "company.id";
    private static final String ADMIN_ORG_ID = "adminorg.id";
    private static final String DISMISS_POSITION = "dismissposition";
    private static final String DPOSITION_VERTOR_AP = "dpositionvectorap";
    private static final String APOSITION_VECTOR_AP = "apositionvectorap";
    private static final String POSITION = "position";
    private static final String JOB = "job";
    private static final String STANDARD_POSITION = "standardpost";
    private static final Date SYS_MIN_DATE = new Date(-9223372036854775807L);

    public void setLeaveOrRemovalInfo(IFormView view, DateEdit dateEdit, boolean mustInput) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        DynamicObject dismissDynamic = dataEntity.getDynamicObject("dismisstenure");
        if (null == dismissDynamic) {
            model.setValue("dposition", null);
            model.setValue("djob", null);
            model.setValue("dstandardposition", null);
            String dismissPosition = dataEntity.getString(DISMISS_POSITION);
            if (HRStringUtils.isNotEmpty((String)dismissPosition)) {
                model.setValue(DISMISS_POSITION, null);
            }
            model.setValue("appointstartdate", null);
            model.setValue("appointenddate", null);
            model.setValue("dcompany", null);
            model.setValue("dadminorg", null);
            model.setValue("isprimdismiss", null);
            DateEdit endDate = (DateEdit)view.getControl("appointenddate");
            endDate.setMinDate(SYS_MIN_DATE);
            return;
        }
        dateEdit.setMustInput(mustInput);
        Date startDate = dismissDynamic.getDate("planstartdate");
        model.setValue("appointstartdate", (Object)startDate);
        Long companyId = dismissDynamic.getLong(COMPANY_ID);
        Long adminOrgId = dismissDynamic.getLong(ADMIN_ORG_ID);
        model.setValue("dcompany", (Object)companyId);
        model.setValue("dadminorg", (Object)adminOrgId);
        model.setValue("isprimdismiss", (Object)dismissDynamic.getString("isprimappoint"));
        String positionType = dismissDynamic.getString("apositiontype");
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            model.setValue("dposition", (Object)HRDyObjectPropUtil.getId((DynamicObject)dismissDynamic.getDynamicObject(POSITION)));
            model.setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dismissDynamic.getDynamicObject(POSITION)));
            model.setValue("djob", null);
            model.setValue("dstandardposition", null);
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            model.setValue("djob", (Object)HRDyObjectPropUtil.getId((DynamicObject)dismissDynamic.getDynamicObject(JOB)));
            model.setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dismissDynamic.getDynamicObject(JOB)));
            model.setValue("dstandardposition", null);
            model.setValue("dposition", null);
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            model.setValue("dstandardposition", (Object)HRDyObjectPropUtil.getId((DynamicObject)dismissDynamic.getDynamicObject(STANDARD_POSITION)));
            model.setValue(DISMISS_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)dismissDynamic.getDynamicObject(STANDARD_POSITION)));
            model.setValue("dposition", null);
            model.setValue("djob", null);
        }
        Date tenurePlanDate = dismissDynamic.getDate("planenddate");
        model.setValue("appointenddate", (Object)tenurePlanDate);
        DateEdit endDate = (DateEdit)view.getControl("appointenddate");
        endDate.setMinDate(startDate);
    }

    public void openEffectTenureWindowAfterClick(IFormView view, String operateKey, IFormPlugin formPlugin) {
        IDataModel model = view.getModel();
        DynamicObject employee = model.getDataEntity().getDynamicObject("employee");
        long employeeId = HRDyObjectPropUtil.getId((DynamicObject)employee);
        FormShowParameter formShowParameter = new FormShowParameter();
        HashMap customMap = Maps.newHashMap();
        customMap.put("employee", employeeId);
        customMap.put("operateKey", operateKey);
        formShowParameter.setCustomParams((Map)customMap);
        formShowParameter.setFormId("cadm_effecttenure");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCloseCallBack(new CloseCallBack(formPlugin, operateKey));
        view.showForm(formShowParameter);
    }

    public void effectTenureAfterSelectClose(IFormView view, ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (null == returnData) {
            return;
        }
        IDataModel model = view.getModel();
        if (returnData instanceof Map) {
            Map map = (Map)returnData;
            Object tenure = map.get("tenure");
            Object operate = map.get("operateKey");
            Object showResult = map.get("showResult");
            Long posTypeId = map.get("postype") == null ? 0L : Long.parseLong(String.valueOf(map.get("postype")));
            if (DPOSITION_VERTOR_AP.equals(operate)) {
                model.setValue("dismisstenure", tenure);
                model.setValue(DISMISS_POSITION, showResult);
                model.setValue("dpostype", (Object)posTypeId);
            }
            if (APOSITION_VECTOR_AP.equals(operate)) {
                model.setValue("atenure", tenure);
                model.setValue("awillposition", showResult);
                model.setValue("dpostype", (Object)posTypeId);
                model.setValue("apostype", (Object)posTypeId);
                DynamicObject tenureObj = (DynamicObject)model.getValue("atenure");
                long demEmpId = tenureObj.getLong("depemp_id");
                long personId = (Long)view.getModel().getValue("person_id");
                List empPosOrgRelList = ExternalService.listEmpposorgrels((Long)personId);
                Optional<Map> optionalMap = empPosOrgRelList.stream().filter(p -> p.get("depemp_id") != null && p.get("depemp_id").equals(demEmpId)).findFirst();
                if (optionalMap.isPresent()) {
                    Object id = optionalMap.get().get("id");
                    model.setValue("empposrel", id);
                } else {
                    model.setValue("empposrel", null);
                }
            }
        }
    }

    public void commonF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"pubfile", (String)fieldKey)) {
            QFilter numberQFilter = new QFilter("formid.number", "=", (Object)"cadm_publicity");
            QFilter isEnable = new QFilter("enable", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(numberQFilter);
            beforeF7SelectEvent.addCustomQFilter(isEnable);
        }
    }

    public String getTenurePositionName(DynamicObject tenureDynamic) {
        DynamicObject standardPost;
        if (null == tenureDynamic) {
            return "";
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(tenureDynamic.getString("apositiontype"))) {
            DynamicObject position = tenureDynamic.getDynamicObject(POSITION);
            if (null != position) {
                return HRDyObjectPropUtil.getName((DynamicObject)position);
            }
        } else if (PositionTypeEnum.JOB.getNumber().equals(tenureDynamic.getString("apositiontype"))) {
            DynamicObject job = tenureDynamic.getDynamicObject(JOB);
            if (null != job) {
                return HRDyObjectPropUtil.getName((DynamicObject)job);
            }
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(tenureDynamic.getString("apositiontype")) && null != (standardPost = tenureDynamic.getDynamicObject(STANDARD_POSITION))) {
            return HRDyObjectPropUtil.getName((DynamicObject)standardPost);
        }
        return "";
    }

    public void setNominateAndDismissList(BeforeCreateListDataProviderArgs args, final IPageCache pageCache) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection data = super.getData(start, limit);
                List pkList = data.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = nominateApplicationService.queryOriginalNominateBillsByIds("id,positiontype,djob.name,dposition.name,dstandardposition.name,dismisstenure.id,dismisstenure.apositiontype", pkList);
                if (null != dynamicObjects && dynamicObjects.length > 0) {
                    HashMap cacheMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
                    ArrayList removeKeys = Lists.newArrayListWithCapacity((int)dynamicObjects.length);
                    Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                        String dJobName = dynamicObject.getString("djob.name");
                        String dPositionName = dynamicObject.getString("dposition.name");
                        String dStandardPositionName = dynamicObject.getString("dstandardposition.name");
                        long tenureId = dynamicObject.getLong("dismisstenure.id");
                        Long pkValue = dynamicObject.getLong("id");
                        if (tenureId == 0L) {
                            removeKeys.add(((Object)pkValue).toString());
                            return;
                        }
                        String positionType = dynamicObject.getString("dismisstenure.apositiontype");
                        if (HRStringUtils.isEmpty((String)dJobName) && HRStringUtils.isEmpty((String)dPositionName) && HRStringUtils.isEmpty((String)dStandardPositionName)) {
                            return;
                        }
                        if (PositionTypeEnum.JOB.getNumber().equals(positionType) && HRStringUtils.isNotEmpty((String)dJobName)) {
                            cacheMap.put(((Object)pkValue).toString(), dJobName);
                        }
                        if (PositionTypeEnum.POSITION.getNumber().equals(positionType) && HRStringUtils.isNotEmpty((String)dPositionName)) {
                            cacheMap.put(((Object)pkValue).toString(), dPositionName);
                        }
                        if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) && HRStringUtils.isNotEmpty((String)dStandardPositionName)) {
                            cacheMap.put(((Object)pkValue).toString(), dStandardPositionName);
                        }
                    });
                    pageCache.batchRemove((List)removeKeys);
                    pageCache.put((Map)cacheMap);
                }
                return data;
            }
        });
    }
}

