/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.login.utils.DateUtils;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.PrintWork;
import kd.bos.print.api.metedata.PrintMetadata;
import kd.bos.print.business.metedata.PrintMetadataUtil;
import kd.bos.print.core.service.PrtAttach;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateAttachmentApplicationService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.common.bo.CommissionPersonBo;

public class PrintFormService {
    private static final ReleaseBillApplicationService RELEASE_BILL_APPLICATION_SERVICE = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);
    private static final PublicityBillApplicationService PUBLICITY_BILL_APPLICATION_SERVICE = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final IssueBillApplicationService ISSUE_BILL_APPLICATION_SERVICE = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    public static final ThreadLocal<String> THREAD_LOCAL = new ThreadLocal();
    private static final String NOMINATE_PERSON_NAME = "nominatebill.person.name";
    private static final String NOMINATE_PERSON_NUMBER = "nominatebill.person.number";
    private static final String NOMINATE_PERSON = "nominatebill.person.id";
    private static final String NOMINATE_APPOINTDATE = "nominatebill.appointdate";
    private static final String NOMINATE_APPLYKIND = "nominatebill.applykind";
    private static final String NOMINATE_DPOSITION = "nominatebill.dposition.name";
    private static final String NOMINATE_DJOB = "nominatebill.djob.name";
    private static final String NOMINATE_DSTANDARDPOSITION = "nominatebill.dstandardposition.name";
    private static final String NOMINATE_PLAN_NUMBER = "nominatebill.plannumber";
    private static final String NOMINATE_PLAN_UNIT = "nominatebill.planunit";
    private static final String NOMINATE_COMMISSION_DEPT = "nominatebill.aadminorg.name";
    private static final String NOMINATE_COMMISSION_POSITION = "nominatebill.aposition.name";
    private static final String NOMINATE_COMMISSION_JOB = "nominatebill.ajob.name";
    private static final String NOMINATE_COMMISSION_STANDARDPOSITION = "nominatebill.astandardposition.name";
    private static final String NOMINATE_PREVENT_DEPT = "nominatebill.dadminorg.name";
    private static final String NOMINATE_PREVENT_POSITION = "nominatebill.dposition.name";
    private static final String NOMINATE_PREVENT_JOB = "nominatebill.djob.name";
    private static final String NOMINATE_PREVENT_STANDARDPOSITION = "nominatebill.dstandardposition.name";
    private static final String NOMINATE_CURRENT_DEPT = "nominatebill.badminorghis.name";
    private static final String NOMINATE_CURRENT_POSITION = "nominatebill.bpositionhis.name";
    private static final String NOMINATE_CURRENT_JOB = "nominatebill.bjobhis";
    private static final String NOMINATE_CURRENT_STANDARDPOSITION = "nominatebill.bstandardpositionhis";
    private static final String PUBLISH_TIME = "releasetime";
    private static final String PUBLIC_START_TIME = "pubstartdate";
    private static final String PUBLIC_END_TIME = "pubenddate";
    private static final String ISSUE_TIME = "issuetime";

    public String buildPdfURL(String pageId, String formId, Map<String, Object> extParam, String printTemplateId) {
        List pkIds = (List)extParam.get("ids");
        PrintTask task = this.buildPrintTask(pageId, formId, pkIds.get(0), printTemplateId);
        PrintWork work = new PrintWork();
        work.add(task);
        return this.setUrlCommon(work, pageId, extParam);
    }

    public String buildListPdfURL(String pageId, String formId, Map<String, Object> extParam, String printTemplateId) {
        List pkIds = (List)extParam.get("ids");
        PrintWork work = new PrintWork();
        pkIds.forEach(pkId -> {
            PrintTask task = this.buildPrintTask(pageId, formId, pkId, printTemplateId);
            work.add(task);
        });
        return this.setUrlCommon(work, pageId, extParam);
    }

    private String setUrlCommon(PrintWork work, String pageId, Map<String, Object> extParam) {
        work.setPrintLang(RequestContext.get().getLang().toString());
        work.setPageId(pageId);
        work.setExpType("pdf");
        work.setExtParam(extParam);
        PrtAttach prtAttach = BosPrintServiceHelper.execPrint((PrintWork)work);
        PrtAttach.AttachDetail attachDetail = (PrtAttach.AttachDetail)prtAttach.getAttachDetail().get(0);
        String attachId = attachDetail.getAttachId();
        String taskId = prtAttach.getTaskId();
        return String.format(UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s", taskId, attachId);
    }

    public List<Object> getPkIdList(DynamicObject dataEntity, String pdfTemplateNumberKey) {
        Object[] releaseBills = PUBLICITY_BILL_APPLICATION_SERVICE.getByPubBatchNum("id", dataEntity.getString(pdfTemplateNumberKey));
        ArrayList selectList = Lists.newArrayList();
        if (HRArrayUtils.isEmpty((Object[])releaseBills)) {
            selectList.add(dataEntity.getPkValue());
        } else {
            selectList.addAll(Arrays.stream(releaseBills).map(value -> value.getLong("id")).collect(Collectors.toList()));
        }
        return selectList;
    }

    public Map<String, Object> createPdfExtParam(DynamicObject dataEntity, List<Object> selectList, String targetEntityName) {
        return NominateAttachmentApplicationService.createPdfExtParam((DynamicObject)dataEntity, selectList, (String)targetEntityName);
    }

    private PrintTask buildPrintTask(String pageId, String formId, Object pkId, String templateId) {
        PrintTask task = new PrintTask();
        task.setFormId(formId);
        task.setTplId(templateId);
        task.setPageId(pageId);
        task.setPrintType("billForm");
        PrintMetadata printMetadata = PrintMetadataUtil.getPrintMetadata((String)templateId);
        task.setMetadata(printMetadata);
        task.setPkIds(Collections.singletonList(pkId));
        return task;
    }

    public void previewFile(IFormView view, String pdfUrl) {
        this.previewFile(view, pdfUrl, ShowType.Modal);
    }

    public void previewFile(IFormView view, String pdfUrl, ShowType showType) {
        if (!HRStringUtils.isEmpty((String)pdfUrl)) {
            FormShowParameter para = new FormShowParameter();
            para.setFormId("bos_printpreview");
            para.getOpenStyle().setShowType(showType);
            HashMap reservedSpace = Maps.newHashMap();
            reservedSpace.put("reservedSpace", "true");
            para.getOpenStyle().setCustParam((Map)reservedSpace);
            para.setCustomParam("src", (Object)pdfUrl);
            view.showForm(para);
        }
    }

    public Map<String, List<DynamicObject>> getReleaseBills(Map<String, Object> extParam, String mark) {
        HashMap<String, List<DynamicObject>> resultMap = new HashMap<String, List<DynamicObject>>(16);
        ArrayList<String> selectProperties = new ArrayList<String>(30);
        selectProperties.add(NOMINATE_COMMISSION_DEPT);
        selectProperties.add(NOMINATE_COMMISSION_POSITION);
        selectProperties.add(NOMINATE_COMMISSION_JOB);
        selectProperties.add(NOMINATE_COMMISSION_STANDARDPOSITION);
        selectProperties.add(NOMINATE_PREVENT_DEPT);
        selectProperties.add("nominatebill.dposition.name");
        selectProperties.add("nominatebill");
        selectProperties.add(NOMINATE_PERSON_NAME);
        selectProperties.add(NOMINATE_PERSON_NUMBER);
        selectProperties.add(NOMINATE_APPOINTDATE);
        selectProperties.add(NOMINATE_APPLYKIND);
        selectProperties.add("nominatebill.dposition.name");
        selectProperties.add("nominatebill.djob.name");
        selectProperties.add("nominatebill.dstandardposition.name");
        selectProperties.add(NOMINATE_PLAN_NUMBER);
        selectProperties.add(NOMINATE_PLAN_UNIT);
        selectProperties.add(NOMINATE_PERSON);
        if ("cadm_appointrelease".equals(mark)) {
            selectProperties.add(PUBLISH_TIME);
        } else if ("cadm_publicity".equals(mark)) {
            selectProperties.add(NOMINATE_CURRENT_DEPT);
            selectProperties.add(NOMINATE_CURRENT_POSITION);
            selectProperties.add(NOMINATE_CURRENT_JOB);
            selectProperties.add(NOMINATE_CURRENT_STANDARDPOSITION);
            selectProperties.add(PUBLIC_START_TIME);
            selectProperties.add(PUBLIC_END_TIME);
        } else {
            selectProperties.add(ISSUE_TIME);
        }
        if (null == extParam) {
            return resultMap;
        }
        Object ids = extParam.get("ids");
        if (null == ids) {
            return resultMap;
        }
        DynamicObject[] releaseBills = "cadm_appointrelease".equals(mark) ? RELEASE_BILL_APPLICATION_SERVICE.queryReleaseBills(String.join((CharSequence)",", selectProperties), (List)ids) : ("cadm_publicity".equals(mark) ? PUBLICITY_BILL_APPLICATION_SERVICE.queryPublicityBillById(String.join((CharSequence)",", selectProperties), (List)ids) : ISSUE_BILL_APPLICATION_SERVICE.queryIssueBillById(String.join((CharSequence)",", selectProperties), (List)ids));
        return Arrays.stream(releaseBills).collect(Collectors.groupingBy(releaseBill -> releaseBill.getString(NOMINATE_APPLYKIND)));
    }

    public List<CommissionPersonBo> parseToBo(List<DynamicObject> list) {
        ArrayList<CommissionPersonBo> boList = new ArrayList<CommissionPersonBo>();
        if (CollectionUtils.isEmpty(list)) {
            return boList;
        }
        list.forEach(dynamicObject -> {
            CommissionPersonBo commissionPersonBo = new CommissionPersonBo();
            String commissionDeptName = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_COMMISSION_DEPT)) ? "" : dynamicObject.getString(NOMINATE_COMMISSION_DEPT);
            String commissionPositionName = dynamicObject.getString(NOMINATE_COMMISSION_POSITION);
            if (HRStringUtils.isEmpty((String)commissionPositionName)) {
                commissionPositionName = dynamicObject.getString(NOMINATE_COMMISSION_JOB);
            }
            if (HRStringUtils.isEmpty((String)commissionPositionName)) {
                commissionPositionName = dynamicObject.getString(NOMINATE_COMMISSION_STANDARDPOSITION);
            }
            String preventDeptName = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_PREVENT_DEPT)) ? "" : dynamicObject.getString(NOMINATE_PREVENT_DEPT);
            String preventPositionName = dynamicObject.getString("nominatebill.dposition.name");
            if (HRStringUtils.isEmpty((String)preventPositionName)) {
                preventPositionName = dynamicObject.getString("nominatebill.djob.name");
            }
            if (HRStringUtils.isEmpty((String)preventPositionName)) {
                preventPositionName = HRStringUtils.isEmpty((String)dynamicObject.getString("nominatebill.dstandardposition.name")) ? "" : dynamicObject.getString("nominatebill.dstandardposition.name");
            }
            long personId = dynamicObject.getLong(NOMINATE_PERSON);
            String personName = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_PERSON_NAME)) ? "" : dynamicObject.getString(NOMINATE_PERSON_NAME);
            commissionPersonBo.setPersonName(personName);
            commissionPersonBo.setCommissionDeptName(commissionDeptName);
            commissionPersonBo.setCommissionPositionName(commissionPositionName);
            commissionPersonBo.setPreventDeptName(preventDeptName);
            commissionPersonBo.setPreventPositionName(preventPositionName);
            String currentDept = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_CURRENT_DEPT)) ? "" : dynamicObject.getString(NOMINATE_CURRENT_DEPT);
            commissionPersonBo.setCurrentDept(currentDept);
            String currentPosition = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_CURRENT_POSITION)) ? "" : dynamicObject.getString(NOMINATE_CURRENT_POSITION);
            commissionPersonBo.setCurrentPosition(currentPosition);
            commissionPersonBo.setPersonId(Long.valueOf(personId));
            commissionPersonBo.setPlanNum(Integer.valueOf(dynamicObject.getInt(NOMINATE_PLAN_NUMBER)));
            String unit = HRStringUtils.isEmpty((String)dynamicObject.getString(NOMINATE_PLAN_UNIT)) || "20".equals(dynamicObject.getString(NOMINATE_PLAN_UNIT)) ? ResManager.loadKDString((String)"\u4e2a\u6708", (String)"PrintFormService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ("10".equals(dynamicObject.getString(NOMINATE_PLAN_UNIT)) ? ResManager.loadKDString((String)"\u5929", (String)"PrintFormService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e74", (String)"PrintFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            commissionPersonBo.setPlanUnit(unit);
            boList.add(commissionPersonBo);
        });
        return boList;
    }

    public String getOrgRootName() {
        OrgTreeParam orgTreeParam = new OrgTreeParam();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        orgTreeParam.setId(rootOrgId);
        String company = THREAD_LOCAL.get();
        if (HRStringUtils.isNotEmpty((String)company)) {
            return company;
        }
        Map treeRootNodeMapById = OrgUnitServiceHelper.getTreeRootNodeMapById((OrgTreeParam)orgTreeParam);
        if (null == treeRootNodeMapById) {
            return null;
        }
        String string = company = treeRootNodeMapById.get("name") == null ? null : treeRootNodeMapById.get("name").toString();
        if (HRStringUtils.isNotEmpty((String)company)) {
            THREAD_LOCAL.set(company);
        }
        return company;
    }

    public String getCommonDate(Date date) {
        if (null == date) {
            return "";
        }
        String publishDateStr = DateUtils.formatDate((Date)date, (Object[])new Object[0]);
        String[] split = publishDateStr.split("-");
        return ResManager.loadKDString((String)"{0}\u5e74{1}\u6708{2}\u65e5", (String)"PrintFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{split[0], split[1], split[2]});
    }
}

