/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.util.CastUtils;

public class TenureFormService {
    private static final ExpedBillApplicationService expedService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);

    public void showExploreWindow(IFormView view, Map<String, Object> params) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cadm_expedbill");
        billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        billShowParameter.setCustomParams(params);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void showApplyWindow(IFormView view, Map<String, Object> params, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_positive");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParams(params);
        view.showForm(showParameter);
    }

    public void showTerminateWindow(IFormView view, Object perName, Long expedBillId, CloseCallBack closeCallBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_stopexped");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("name", perName);
        showParameter.setCustomParam("expedBillId", (Object)expedBillId);
        view.showForm(showParameter);
    }

    public void showFinishWindow(IFormView view, Object pkValue, CloseCallBack closeCallBack) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        billShowParameter.setFormId("cadm_finishexped");
        billShowParameter.setPkId(pkValue);
        billShowParameter.setCloseCallBack(closeCallBack);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void showExpedBill(IFormView view, Object pkValue, String targetKey) {
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(targetKey);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setFormId("cadm_expedbill_info");
        billShowParameter.setPkId(pkValue);
        view.showForm((FormShowParameter)billShowParameter);
    }

    public void openMoreDetail(IFormView view, long examId, long arrangeRecordId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId("cadm_expedbill_layout");
        formShowParameter.setStatus(OperationStatus.VIEW);
        HashMap customMap = Maps.newHashMap();
        customMap.put("caption", ResManager.loadKDString((String)"\u67e5\u770b\u66f4\u591a\u8be6\u60c5", (String)"ExamCoopBillApplicationService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        customMap.put("arrangeRecordId", arrangeRecordId);
        formShowParameter.setCustomParams((Map)customMap);
        formShowParameter.setPkId((Object)examId);
        view.showForm((FormShowParameter)formShowParameter);
    }

    public void expedStartOpAfterCloseCallBack(IFormView view, ClosedCallBackEvent evt) {
        Map returnData = CastUtils.castMap((Object)evt.getReturnData(), String.class);
        Long expedPlanSourceVid = (Long)returnData.get("expedplan");
        if (expedPlanSourceVid != 0L) {
            Map intervieweeMap = (Map)returnData.get("interviewee");
            view.getModel().setValue("expedplan", (Object)expedPlanSourceVid);
            OperateOption option = OperateOption.create();
            option.setVariableValue("expedplan", expedPlanSourceVid.toString());
            option.setVariableValue("interviewee", SerializationUtils.serializeToBase64((Object)intervieweeMap));
            view.invokeOperation("save_startexped", option);
            view.invokeOperation("refresh");
        }
    }
}

