/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice.appointedit;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.DismissBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.appointedit.entity.FamilyMember;
import kd.tdc.cadm.formplugin.web.formservice.appointedit.entity.Person;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AppointEditorUtil
extends HRCoreBaseList {
    private static final Log LOG = LogFactory.getLog(AppointEditorUtil.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final DismissBillApplicationService dismissBillApplicationService = (DismissBillApplicationService)ServiceFactory.getService(DismissBillApplicationService.class);
    private static final HRBaseServiceHelper PERFORMANCE_HELPER = new HRBaseServiceHelper("tdcs_performance");
    private static final String TYPE_APPOINT = "appoint";
    private static final String TYPE_DISMISS = "dismiss";

    public static String getCacheUrl(String type, DynamicObject[] bills) {
        ArrayList<String> urls = new ArrayList<String>(10);
        HashMap<String, Integer> fileNameMap = new HashMap<String, Integer>(16);
        for (DynamicObject bill : bills) {
            long personId = bill.getLong("person_id");
            String personNumber = bill.getString("person.number");
            long employeeId = bill.getLong("employee_id");
            long billId = bill.getLong("id");
            Person person = new Person();
            AppointEditorUtil.getPersonInfo(person, personId);
            AppointEditorUtil.getPositionInfo(person, personId, employeeId);
            AppointEditorUtil.getPersonRegion(person, personId);
            AppointEditorUtil.getResume(person, personId);
            String entityNum = "";
            if (TYPE_APPOINT.equals(type)) {
                AppointEditorUtil.getAppoint(person, billId);
                entityNum = "cadm_nominatebill";
            }
            if (TYPE_DISMISS.equals(type)) {
                AppointEditorUtil.getDismiss(person, billId);
                entityNum = "cadm_dismissbill";
            }
            AppointEditorUtil.getRewardRecord(person, personId);
            AppointEditorUtil.getAssessment(person, employeeId);
            AppointEditorUtil.getFamilyMember(person, personId);
            String fileName = person.getXingMing() + "_" + personNumber;
            Integer num = (Integer)fileNameMap.get(fileName);
            if (num != null) {
                fileNameMap.put(fileName, num + 1);
                fileName = fileName + String.format("(%d)", num + 1);
            } else {
                fileNameMap.put(fileName, 0);
            }
            String cacheUrl = AppointEditorUtil.exportXml(person, fileName, entityNum);
            urls.add(cacheUrl);
        }
        if (urls.size() == 1) {
            return (String)urls.get(0);
        }
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        return cache.compress(ResManager.loadKDString((String)"\u4efb\u514d\u5ba1\u6279\u8868\u6587\u4ef6.zip", (String)"AppointEditorUtil_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), urls.toArray(new String[0]), 180);
    }

    public static String exportXml(Object obj, String fileName, String entityNum) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(obj.getClass().getSimpleName());
            Method createElementMethod = Document.class.getMethod("createElement", String.class);
            AppointEditorUtil.generateElement(document, createElementMethod, rootElement, obj.getClass(), obj);
            document.appendChild(rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer tf = transformerFactory.newTransformer();
            tf.setOutputProperty("indent", "yes");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(bos);
            tf.transform(new DOMSource(document), streamResult);
            byte[] bytes = bos.toByteArray();
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String url = cache.saveAsFullUrl(fileName + ".lrmx", bytes, 180);
            return url;
        }
        catch (Exception e) {
            LOG.error("exportXml error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void generateElement(Document document, Method method, Element rootElement, Class<?> clazz, Object curInstance) {
        try {
            Method[] methods;
            for (Method declaredMethod : methods = clazz.getDeclaredMethods()) {
                String methodName = declaredMethod.getName();
                if (!methodName.startsWith("get")) continue;
                String attribute = methodName.replaceFirst("get", "");
                Element element = (Element)method.invoke((Object)document, attribute);
                Object obj = declaredMethod.invoke(curInstance, new Object[0]);
                if (obj != null) {
                    if (obj instanceof List) {
                        List list = (List)obj;
                        Type genericType = declaredMethod.getGenericReturnType();
                        if (genericType instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType)genericType;
                            Class actualTypeArgumentClazz = (Class)pt.getActualTypeArguments()[0];
                            for (Object itemObj : list) {
                                Element item = (Element)method.invoke((Object)document, "Item");
                                AppointEditorUtil.generateElement(document, method, item, actualTypeArgumentClazz, itemObj);
                                element.appendChild(item);
                            }
                        }
                    } else {
                        String content = obj.toString();
                        element.setTextContent(content);
                    }
                }
                rootElement.appendChild(element);
            }
        }
        catch (Exception e) {
            LOG.error("generateElement error:{}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private static void getPersonInfo(Person person, Long personId) {
        List perCreList;
        Map personInfoMap = ExternalDataService.getPersonInfo((Long)personId);
        if (personInfoMap != null) {
            String name = AppointEditorUtil.getValue(personInfoMap, "name");
            AppointEditorUtil.checkLength(name, ResManager.loadKDString((String)"\u59d3\u540d", (String)"AppointEditorUtil_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), 18);
            person.setXingMing(name);
            String gender = AppointEditorUtil.getValue(personInfoMap, "gender");
            String man = ResManager.loadKDString((String)"\u7537", (String)"AppointEditorUtil_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            String woman = ResManager.loadKDString((String)"\u5973", (String)"AppointEditorUtil_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            HashSet genderSet = Sets.newHashSet((Object[])new String[]{man, woman});
            if (genderSet.contains(gender)) {
                person.setXingBie(gender);
            } else {
                person.setXingBie("");
            }
            Date birthday = (Date)personInfoMap.get("birthday");
            String birthdayStr = birthday == null ? "" : HRDateTimeUtils.format((Date)birthday, (String)"yyyyMM");
            person.setChuShengNianYue(birthdayStr);
            String headSculpture = AppointEditorUtil.getValue(personInfoMap, "headsculpture");
            if (StringUtils.isNotBlank((CharSequence)headSculpture)) {
                String base64Str = AppointEditorUtil.getImgBase64Str(headSculpture);
                person.setZhaoPian(base64Str);
            }
            String folk = AppointEditorUtil.getValue(personInfoMap, "folk");
            person.setMinZu(folk);
            Date beginServiceDate = (Date)personInfoMap.get("beginservicedate");
            String beginWorkDate = beginServiceDate == null ? "" : HRDateTimeUtils.format((Date)beginServiceDate, (String)"yyyyMM");
            person.setCanJiaGongZuoShiJian(beginWorkDate);
            String healthStatus = AppointEditorUtil.getValue(personInfoMap, "healthstatus");
            person.setJianKangZhuangKuang(healthStatus);
            String nowDateStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
            person.setTianBiaoShiJian(nowDateStr);
            String company = AppointEditorUtil.getValue(personInfoMap, "company");
            person.setChengBaoDanWei(company);
            person.setTianBiaoRen(RequestContext.get().getUserName());
        }
        if (CollectionUtils.isEmpty((Collection)(perCreList = ExternalDataService.getPerCre((Long)personId)))) {
            return;
        }
        for (Map map : perCreList) {
            long credId;
            Object credentialsTypeId = map.get("credentialstype_id");
            if (credentialsTypeId == null || (credId = Long.parseLong(credentialsTypeId.toString())) != 1010L) continue;
            String number = AppointEditorUtil.getValue(map, "number");
            person.setShenFenZheng(number);
            break;
        }
    }

    private static void getPositionInfo(Person person, Long personId, Long employeeId) {
        List perProTitleList = ExternalDataService.getPerProTitle((Long)personId);
        if (CollectionUtils.isEmpty((Collection)perProTitleList)) {
            return;
        }
        for (Map map : perProTitleList) {
            Object isHigh = map.get("ishigh");
            if (isHigh == null || !((Boolean)isHigh).booleanValue()) continue;
            String professional = AppointEditorUtil.getValue(map, "professional");
            person.setZhuanYeJiShuZhiWu(professional);
        }
        DynamicObject positionInfo = ExternalDataService.getPositionInfo((long)employeeId);
        if (!HRObjectUtils.isEmpty((Object)positionInfo)) {
            String jobClassName = AppointEditorUtil.getValue(positionInfo, "jobclass.name");
            person.setShuXiZhuanYeYouHeZhuanChang(jobClassName);
        }
    }

    private static void getPersonRegion(Person person, Long personId) {
        long partyId;
        List partyInfoList = ExternalDataService.getPerRegionList((Long)personId);
        if (CollectionUtils.isEmpty((Collection)partyInfoList)) {
            return;
        }
        Map result = (Map)partyInfoList.get(0);
        String nativePlace = AppointEditorUtil.getValue(result, "nativeplace");
        person.setJiGuan(nativePlace);
        String birthplace = AppointEditorUtil.getValue(result, "birthplace");
        person.setChuShengDi(birthplace);
        String party = AppointEditorUtil.getValue(result, "party");
        Date joinPartyDate = (Date)result.get("joinpartydate");
        String joinDateStr = "";
        long l = partyId = result.get("party_id") == null ? 0L : Long.parseLong(result.get("party_id").toString());
        if (partyId == 1010L) {
            joinDateStr = joinPartyDate == null ? "" : HRDateTimeUtils.format((Date)joinPartyDate, (String)"yyyyMM");
        } else if (StringUtils.isNotBlank((CharSequence)party)) {
            joinDateStr = party;
        }
        person.setRuDangShiJian(joinDateStr);
    }

    private static void getAppoint(Person person, long appointId) {
        DynamicObject appointDO = nominateApplicationService.queryNominateBillById(appointId);
        if (!HRObjectUtils.isEmpty((Object)appointDO)) {
            String positionType = appointDO.getString("positiontype");
            String aCompanyName = appointDO.getString("acompany.name");
            aCompanyName = StringUtils.isBlank((CharSequence)aCompanyName) ? "" : aCompanyName + " ";
            String aPositionName = "";
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                aPositionName = appointDO.getString("astandardposition.name");
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                aPositionName = appointDO.getString("aposition.name");
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                aPositionName = appointDO.getString("ajob.name");
            }
            aPositionName = StringUtils.isBlank((CharSequence)aPositionName) ? "" : aPositionName;
            AppointEditorUtil.checkLength(aPositionName, ResManager.loadKDString((String)"\u62df\u4efb\u804c\u52a1", (String)"AppointEditorUtil_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), 324);
            person.setNiRenZhiWu(aCompanyName + aPositionName);
            DynamicObject dismissTenure = appointDO.getDynamicObject("dismisstenure");
            if (dismissTenure != null) {
                String aPositionType = dismissTenure.getString("apositiontype");
                String dCompany = dismissTenure.getString("company.name");
                dCompany = StringUtils.isBlank((CharSequence)dCompany) ? "" : dCompany + " ";
                String dismissPosition = "";
                if (PositionTypeEnum.POSITION.getNumber().equals(aPositionType)) {
                    dismissPosition = dismissTenure.getString("position.name");
                } else if (PositionTypeEnum.JOB.getNumber().equals(aPositionType)) {
                    dismissPosition = dismissTenure.getString("job.name");
                } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(aPositionType)) {
                    dismissPosition = dismissTenure.getString("standardpost.name");
                }
                if (StringUtils.isNotBlank((CharSequence)dismissPosition)) {
                    String dismissStr = dCompany + dismissPosition;
                    AppointEditorUtil.checkLength(dismissStr, ResManager.loadKDString((String)"\u62df\u514d\u804c\u52a1", (String)"AppointEditorUtil_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), 324);
                    person.setNiMianZhiWu(dismissStr);
                }
            }
            String appointReason = AppointEditorUtil.getValue(appointDO, "appointreason");
            person.setRenMianLiYou(appointReason);
        }
    }

    private static void getDismiss(Person person, long billId) {
        DynamicObject dismissBill = dismissBillApplicationService.getDismissBillById("appointreason,dcompany,dismisstenure", billId);
        if (HRObjectUtils.isEmpty((Object)dismissBill)) {
            return;
        }
        DynamicObject dismissDynamic = dismissBill.getDynamicObject("dismisstenure");
        if (dismissDynamic != null) {
            String positionType = dismissDynamic.getString("apositiontype");
            String dismissPosition = "";
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                dismissPosition = dismissDynamic.getString("position.name");
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                dismissPosition = dismissDynamic.getString("job.name");
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                dismissPosition = dismissDynamic.getString("standardpost.name");
            }
            dismissPosition = StringUtils.isBlank((CharSequence)dismissPosition) ? "" : dismissPosition;
            String dCompany = dismissDynamic.getString("company.name");
            dCompany = StringUtils.isBlank((CharSequence)dCompany) ? "" : dCompany + " ";
            String dismissJob = dCompany + dismissPosition;
            AppointEditorUtil.checkLength(dismissJob, ResManager.loadKDString((String)"\u62df\u514d\u804c\u52a1", (String)"AppointEditorUtil_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), 324);
            person.setNiMianZhiWu(dismissJob);
        }
        String appointReason = AppointEditorUtil.getValue(dismissBill, "appointreason");
        person.setRenMianLiYou(appointReason);
    }

    private static void getResume(Person person, Long personId) {
        TreeMap resumeMap = Maps.newTreeMap();
        AppointEditorUtil.getEmpPosOrg(person, personId, resumeMap);
        AppointEditorUtil.getEduInfo(person, personId, resumeMap);
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : resumeMap.entrySet()) {
            buf.append((String)entry.getValue());
            buf.append(System.getProperty("line.separator"));
        }
        String resumeStr = buf.toString();
        person.setJianLi(resumeStr);
    }

    private static void getEmpPosOrg(Person person, Long personId, Map<Integer, String> resumeMap) {
        List<Map<String, String>> list = AppointEditorUtil.getEmpPosOrgRelInfo(personId);
        LOG.info("getEmpPosOrg result:{}", list);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sortedList = list.stream().sorted(Comparator.comparing(a -> (String)a.get("startdate"))).collect(Collectors.toList());
        for (Map map : sortedList) {
            String startDate = (String)map.get("startdate");
            if (StringUtils.isBlank((CharSequence)startDate)) {
                LOG.error("The start time of the appointment is empty, please check.personId:{}", (Object)personId);
                continue;
            }
            String startDateTime = AppointEditorUtil.getFormatTime(startDate, "yyyy-MM-dd", "yyyy.MM");
            String endDate = (String)map.get("enddate");
            String endDateTime = StringUtils.isBlank((CharSequence)endDate) ? "       " : AppointEditorUtil.getFormatTime(endDate, "yyyy-MM-dd", "yyyy.MM");
            String isPrimary = (String)map.get("isprimary");
            String company = (String)map.get("company");
            String positionName = "";
            if ("1".equals(isPrimary)) {
                String positionType = (String)map.get("apositiontype");
                if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                    positionName = (String)map.get("stdposition");
                }
                if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                    positionName = (String)map.get("position");
                }
                if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                    positionName = (String)map.get("job");
                }
                if (StringUtils.isNotBlank((CharSequence)company)) {
                    person.setXianRenZhiWu(company + " " + positionName);
                } else {
                    person.setXianRenZhiWu(positionName);
                }
            }
            String startDateKey = AppointEditorUtil.getFormatTime(startDate, "yyyy-MM-dd", "yyyyMMdd");
            String resumeStr = startDateTime + "--" + endDateTime + "  " + company + positionName;
            if (StringUtils.isBlank((CharSequence)startDateKey)) continue;
            resumeMap.put(Integer.parseInt(startDateKey), resumeStr);
        }
    }

    private static void getEduInfo(Person person, Long personId, Map<Integer, String> resumeMap) {
        List result = ExternalDataService.getEducationalInfo((Long)personId);
        LOG.info("getEduInfo result:{}", (Object)result);
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        for (Map resultMap : result) {
            Date admissionDate;
            String graduateSchool = AppointEditorUtil.getValue(resultMap, "graduateschool");
            String schoolRecord = AppointEditorUtil.getValue(resultMap, "schoolrecord");
            String collegeDepartment = AppointEditorUtil.getValue(resultMap, "collegedepartment");
            String major = AppointEditorUtil.getValue(resultMap, "major");
            String secondMajor = AppointEditorUtil.getValue(resultMap, "secondmajor");
            String education = AppointEditorUtil.getValue(resultMap, "education");
            String degree = AppointEditorUtil.getValue(resultMap, "degree");
            long eduNatureId = resultMap.get("edunature_id") == null ? 0L : (Long)resultMap.get("edunature_id");
            long graduateSchoolId = resultMap.get("graduateschool_id") == null ? 0L : Long.parseLong(resultMap.get("graduateschool_id").toString());
            String isHighestDegree = AppointEditorUtil.getValue(resultMap, "ishighestdegree");
            if (eduNatureId == 1010L && "1".equals(isHighestDegree)) {
                person.setQuanRiZhiJiaoYu_XueLi(education);
                person.setQuanRiZhiJiaoYu_XueWei(degree);
                if (graduateSchoolId != 1386848073895945216L) {
                    person.setQuanRiZhiJiaoYu_XueLi_BiYeYuanXiaoXi(graduateSchool + collegeDepartment + major + secondMajor);
                } else {
                    person.setQuanRiZhiJiaoYu_XueLi_BiYeYuanXiaoXi(schoolRecord + collegeDepartment + major + secondMajor);
                }
            }
            if (eduNatureId == 1020L && "1".equals(isHighestDegree)) {
                person.setZaiZhiJiaoYu_XueLi(education);
                person.setZaiZhiJiaoYu_XueWei(degree);
                if (graduateSchoolId != 1386848073895945216L) {
                    person.setZaiZhiJiaoYu_XueLi_BiYeYuanXiaoXi(graduateSchool + collegeDepartment + major + secondMajor);
                } else {
                    person.setZaiZhiJiaoYu_XueLi_BiYeYuanXiaoXi(schoolRecord + collegeDepartment + major + secondMajor);
                }
            }
            if ((admissionDate = (Date)resultMap.get("admissiondate")) == null) {
                LOG.error("Admission time is empty, please check it out. personId:{}", (Object)personId);
                continue;
            }
            String startDate = HRDateTimeUtils.format((Date)admissionDate, (String)"yyyy.MM");
            Date graduationDate = (Date)resultMap.get("gradutiondate");
            String endDate = graduationDate == null ? "       " : HRDateTimeUtils.format((Date)graduationDate, (String)"yyyy.MM");
            String startDateKey = HRDateTimeUtils.format((Date)admissionDate, (String)"yyyyMMdd");
            String resumeVal = startDate + "--" + endDate + "  " + graduateSchool + major;
            if (StringUtils.isBlank((CharSequence)startDateKey)) continue;
            resumeMap.put(Integer.parseInt(startDateKey), resumeVal);
        }
    }

    private static void getRewardRecord(Person person, Long personId) {
        List perRecordList = ExternalDataService.getPerRecord((Long)personId);
        List sortedMapList = perRecordList.stream().sorted(Comparator.nullsLast(Comparator.comparing(item -> (Date)item.get("rewarddate"), Date::compareTo))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sortedMapList)) {
            person.setJiangChengQingKuang(ResManager.loadKDString((String)"\u65e0", (String)"AppointEditorUtil_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
        StringBuilder buf = new StringBuilder();
        for (Map map : perRecordList) {
            Date rewardDate = (Date)map.get("rewarddate");
            String rewardDateStr = rewardDate == null ? "" : HRDateTimeUtils.format((Date)rewardDate, (String)"yyyy-MM-dd ");
            String type = AppointEditorUtil.getValue(map, "type");
            String content = AppointEditorUtil.getValue(map, "content");
            String startDateTime = AppointEditorUtil.getFormatTime(rewardDateStr, "yyyy-MM-dd", "yyyyMM");
            String rewardStr = StringUtils.isBlank((CharSequence)startDateTime) ? type + content : startDateTime + type + content;
            buf.append(rewardStr);
            buf.append(System.getProperty("line.separator"));
        }
        String rewardsPunishments = buf.toString();
        LOG.info("rewardsPunishments: {}", (Object)rewardsPunishments);
        person.setJiangChengQingKuang(rewardsPunishments);
    }

    private static void getAssessment(Person person, Long employeeId) {
        DynamicObject[] performanceArr = PERFORMANCE_HELPER.query("id,employee,check_startdate,score,level,rangetype", new QFilter[]{new QFilter("employee", "=", (Object)employeeId)});
        List limitList = Arrays.stream(performanceArr).filter(item -> "40".equals(item.getString("rangetype"))).sorted((o1, o2) -> o2.getDate("check_startdate").compareTo(o1.getDate("check_startdate"))).limit(2L).collect(Collectors.toList());
        StringBuilder buf = new StringBuilder();
        for (int i = limitList.size() - 1; i >= 0; --i) {
            DynamicObject performance = (DynamicObject)limitList.get(i);
            Date checkStartDate = performance.getDate("check_startdate");
            String startDateTimeStr = checkStartDate == null ? "" : HRDateTimeUtils.format((Date)checkStartDate, (String)"yyyy");
            String score = performance.getString("score");
            if (StringUtils.isNotBlank((CharSequence)score)) {
                BigDecimal value = new BigDecimal(score);
                BigDecimal noZeros = value.stripTrailingZeros();
                score = noZeros.toPlainString();
            }
            String level = performance.getString("level");
            String str = ResManager.loadKDString((String)"{0}\u5e74\u5ea6\u7684\u7ee9\u6548\u8003\u6838\u5206\u6570\u4e3a{1}\u5206\uff0c\u7b49\u7ea7\u4e3a{2}\u3002", (String)"AppointEditorUtil_11", (String)"tdc-cadm-formplugin", (Object[])new Object[]{startDateTimeStr, score, level});
            buf.append(str);
            buf.append(System.getProperty("line.separator"));
        }
        person.setNianDuKaoHeJieGuo(buf.toString());
    }

    private static void getFamilyMember(Person person, Long personId) {
        List familyMemberList = ExternalDataService.getFamilyMember((Long)personId);
        if (CollectionUtils.isEmpty((Collection)familyMemberList)) {
            return;
        }
        ArrayList<FamilyMember> appointFamilyList = new ArrayList<FamilyMember>(10);
        for (Map resultMap : familyMemberList) {
            FamilyMember familyMember = new FamilyMember();
            String familyMemberShip = AppointEditorUtil.getValue(resultMap, "familymembship");
            familyMember.setChengWei(familyMemberShip);
            String name = AppointEditorUtil.getValue(resultMap, "name");
            familyMember.setXingMing(name);
            String workUnit = AppointEditorUtil.getValue(resultMap, "workunit");
            familyMember.setGongZuoDanWeiJiZhiWu(workUnit);
            appointFamilyList.add(familyMember);
        }
        person.setJiaTingChengYuan(appointFamilyList);
    }

    private static List<Map<String, String>> getEmpPosOrgRelInfo(long personId) {
        List empPosList = ExternalDataService.listEmpPosOrgRel((Long)personId);
        if (CollectionUtils.isEmpty((Collection)empPosList)) {
            return null;
        }
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(empPosList.size());
        for (Map empMap : empPosList) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("startdate", AppointEditorUtil.getValue(empMap, "startdate"));
            map.put("enddate", AppointEditorUtil.getValue(empMap, "enddate"));
            map.put("isprimary", AppointEditorUtil.getValue(empMap, "isprimary"));
            map.put("company", AppointEditorUtil.getValue(empMap, "company"));
            map.put("apositiontype", AppointEditorUtil.getValue(empMap, "apositiontype"));
            map.put("stdposition", AppointEditorUtil.getValue(empMap, "stdposition"));
            map.put("position", AppointEditorUtil.getValue(empMap, "position"));
            map.put("job", AppointEditorUtil.getValue(empMap, "job"));
            list.add(map);
        }
        return list;
    }

    private static String getFormatTime(String timeStr, String originPattern, String curPattern) {
        String format;
        if (StringUtils.isBlank((CharSequence)timeStr)) {
            return "";
        }
        try {
            Date date = HRDateTimeUtils.parseDate((String)timeStr, (String)originPattern);
            format = HRDateTimeUtils.format((Date)date, (String)curPattern);
        }
        catch (Exception ex) {
            format = "";
            LOG.error("getFormatTime error:", (Throwable)ex);
        }
        return format;
    }

    private static String getValue(Object obj, String valName) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.get(valName) == null ? "" : map.get(valName).toString();
        }
        if (obj instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)obj;
            return dynamicObject.get(valName) == null ? "" : dynamicObject.get(valName).toString();
        }
        return "";
    }

    private static void checkLength(String str, String cnName, int maxLength) {
        if (str != null && str.length() > maxLength) {
            LOG.error("The field {0} shall not exceed {1} words.", (Object)cnName, (Object)maxLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImgBase64Str(String headSculpture) {
        String imgUrl = headSculpture.startsWith("http") ? headSculpture : System.getProperty("imageServer.url") + headSculpture;
        InputStream inputStream = null;
        byte[] data = null;
        try {
            int ch;
            URL url = new URL(imgUrl);
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((ch = inputStream.read()) != -1) {
                outputStream.write(ch);
            }
            data = outputStream.toByteArray();
            inputStream.close();
        }
        catch (IOException e) {
            LOG.error("getImgBase64Str error:{}", (Object)e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOG.error("inputStream.close() error:{}", (Object)e.getMessage());
                }
            }
        }
        String rlt = "";
        try {
            rlt = new String(Base64.getEncoder().encode(data), "UTF-8");
        }
        catch (Exception e) {
            LOG.error("getImgBase64Str UnsupportedEncodingException:{}", (Object)e.getMessage());
        }
        return rlt;
    }
}

