/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.formservice.batchopbase;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRExportHeadObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.formplugin.web.formservice.batchopbase.IBatchOpFormService;
import kd.tdc.tdcs.formplugin.web.batchconfirm.ConfirmPageUtil;

public abstract class BatchOpBaseFormService
implements IBatchOpFormService {
    private static final Log logger = LogFactory.getLog(BatchOpBaseFormService.class);

    @Override
    public void callValidatorBeforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs, String operateKey, AbstractFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)beforeDoOperationEventArgs.getSource();
        String opKey = operate.getOperateKey();
        if (!operateKey.equals(opKey)) {
            return;
        }
        String isOpCancel = operate.getOption().getVariableValue("isopcancel", null);
        if (HRStringUtils.isEmpty((String)isOpCancel)) {
            IListView listView = (IListView)formPlugin.getView();
            beforeDoOperationEventArgs.setCancel(true);
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("isopcancel", "1");
            String fromId = ((ListShowParameter)listView.getFormShowParameter()).getBillFormId();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            OperationResult preOpResult = OperationServiceHelper.executeOperate((String)operate.getOperateKey(), (String)fromId, (Object[])selectedRows.getPrimaryKeyValues(), (OperateOption)operateOption);
            this.handleValidateResult(preOpResult, operate, formPlugin);
        }
    }

    @Override
    public void doOperationClosedCallBack(Object returnData, String opKey, AbstractFormPlugin formPlugin) {
        Map result = (Map)returnData;
        if (!CollectionUtils.isEmpty((Map)result) && ((Boolean)result.get("iscofirm")).booleanValue()) {
            IListView listView = (IListView)formPlugin.getView();
            String failPkIdString = listView.getPageCache().get("failpkid");
            if (!HRStringUtils.isEmpty((String)failPkIdString)) {
                List failPkIds = (List)SerializationUtils.deSerializeFromBase64((String)failPkIdString);
                List failRows = failPkIds.stream().map(ListSelectedRow::new).collect(Collectors.toList());
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                selectedRows.removeAll(failRows);
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("isopcancel", "0");
            listView.invokeOperation(opKey, option);
        }
    }

    @Override
    public void refreshAfterDoOperation(AfterDoOperationEventArgs args, AbstractFormPlugin formPlugin) {
        OperationResult operationResult = args.getOperationResult();
        boolean isSuccess = Optional.ofNullable(operationResult).map(OperationResult::isSuccess).orElse(false);
        if (isSuccess) {
            formPlugin.getView().invokeOperation("refresh");
        }
    }

    @Override
    public void doOperationConfirmCallBack(AbstractFormPlugin formPlugin) {
    }

    protected boolean handleValidateResultForAllSuccess(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        return false;
    }

    protected boolean handleValidateResultForAllFail(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        return false;
    }

    protected abstract boolean handleValidateResultForSomeFail(OperationResult var1, FormOperate var2, int var3, int var4, AbstractFormPlugin var5);

    protected abstract List<HRExportHeadObject> createExcelHeadData(FormOperate var1);

    protected abstract List<Map<String, Object>> createExcelExportData(OperationResult var1, FormOperate var2, AbstractFormPlugin var3);

    private void handleValidateResult(OperationResult operationResult, FormOperate operate, AbstractFormPlugin formPlugin) {
        IListView listView = (IListView)formPlugin.getView();
        listView.getPageCache().remove("failpkid");
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        List failPkId = operationResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).distinct().collect(Collectors.toList());
        int failSize = failPkId.size();
        int allRowsSize = selectedRows.size();
        if (failSize == 0) {
            if (!this.handleValidateResultForAllSuccess(operationResult, operate, formPlugin)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("isopcancel", "0");
                listView.invokeOperation(operate.getOperateKey(), option);
            }
            return;
        }
        if (failSize == allRowsSize) {
            if (!this.handleValidateResultForAllFail(operationResult, operate, formPlugin)) {
                this.showValidateErrorMessage(operationResult, operate);
            }
            return;
        }
        String failPkIdString = SerializationUtils.serializeToBase64(failPkId);
        listView.getPageCache().put("failpkid", failPkIdString);
        if (!this.handleValidateResultForSomeFail(operationResult, operate, allRowsSize, failSize, formPlugin)) {
            this.showBatchConfirmPageDefault(operationResult, operate, allRowsSize, failSize, formPlugin);
        }
    }

    private void showBatchConfirmPageDefault(OperationResult operationResult, FormOperate operate, int allRowsSize, int failSize, AbstractFormPlugin formPlugin) {
        String opName = operate.getOperateName().getLocaleValue();
        String allNumLbl = ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u6570\u636e\uff0c\u5176\u4e2d\uff1a", (String)"BatchOpBaseFormService_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{allRowsSize});
        String fitNumLbl = "" + (allRowsSize - failSize);
        String fitLbl = ResManager.loadKDString((String)"\u6761\u7b26\u5408\u6761\u4ef6\uff0c\u53ef\u64cd\u4f5c{0}", (String)"BatchOpBaseFormService_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{opName});
        String noFitNumLbl = "" + failSize;
        String noFitLbl = ResManager.loadKDString((String)"\u6761\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u5c06\u4e3a\u4f60\u8df3\u8fc7", (String)"BatchOpBaseFormService_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String excelName = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u786e\u8ba4\u6570\u636e", (String)"BatchOpBaseFormService_3", (String)"tdc-cadm-formplugin", (Object[])new Object[]{opName});
        String finalLbl = ResManager.loadKDString((String)"{0}\u9009\u4e2d\u7684\u6570\u636e\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"BatchOpBaseFormService_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{opName});
        List<HRExportHeadObject> headDataList = this.createExcelHeadData(operate);
        List<Map<String, Object>> exportDataList = this.createExcelExportData(operationResult, operate, formPlugin);
        FormShowParameter confirmPage = ConfirmPageUtil.getBatchConfirmPage((String)allNumLbl, (String)fitNumLbl, (String)fitLbl, (String)noFitNumLbl, (String)noFitLbl, (String)finalLbl, (String)excelName, exportDataList, headDataList);
        confirmPage.setCloseCallBack(new CloseCallBack((IFormPlugin)formPlugin, operate.getOperateKey()));
        confirmPage.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"BatchOpBaseFormService_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        formPlugin.getView().showForm(confirmPage);
    }

    protected void showValidateErrorMessage(OperationResult operationResult, FormOperate operate) {
        IListView listView = (IListView)operate.getView();
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            return;
        }
        String firstErrorMsg = this.getErrorMsg((IOperateInfo)allErrorOrValidateInfo.get(0));
        boolean isExistsDifferentError = allErrorOrValidateInfo.stream().map(this::getErrorMsg).anyMatch(errorMsg -> !HRStringUtils.equals((String)errorMsg, (String)firstErrorMsg));
        if (isExistsDifferentError) {
            listView.showOperationResult(operationResult, operate.getOperateName().getLocaleValue());
        } else {
            listView.showErrorNotification(firstErrorMsg);
        }
    }

    private String getErrorMsg(IOperateInfo operateInfo) {
        String[] splitArrays;
        String colon;
        String splitFlag;
        String infoMessage = operateInfo.getMessage();
        int index = infoMessage.indexOf(splitFlag = (colon = ResManager.loadKDString((String)"\uff1a", (String)"BatchOpBaseFormService_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0])) + " ");
        if (index > 0 && index < infoMessage.length() - 1 && (splitArrays = infoMessage.split(splitFlag)).length == 2) {
            return infoMessage.substring(index + 1);
        }
        return infoMessage;
    }
}

