/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.issue;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.IssueFormService;

public class BatchIssueEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private final IssueFormService issueFormService = (IssueFormService)ServiceFactory.getService(IssueFormService.class);
    private final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previewfile", "downloadfile"});
        BasedataEdit noticeDocEdit = (BasedataEdit)this.getView().getControl("appnoticedoc");
        noticeDocEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if ("appnoticedoc".equals(fieldName)) {
            QFilter entityQFilter = new QFilter("formid.number", "=", (Object)"cadm_appointissue");
            QFilter isEnable = new QFilter("enable", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(entityQFilter);
            beforeF7SelectEvent.addCustomQFilter(isEnable);
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        List pkIds = (List)customParams.get("ids");
        Object batchNumObj = customParams.get("issuebatchnum");
        if (pkIds != null && pkIds.size() == 1) {
            String batchNum;
            String issueOptions;
            String appNoticeDocId;
            Date issueTime;
            long issueHandlerId;
            DynamicObject[] issueBills = this.issueBillApplicationService.queryOriginalIssueBillById("issuetype,issuehandler,issueresult,issuetime,appnoticedoc,issueoptions,issuestatus,issuebatchnum", pkIds);
            DynamicObject issueBill = issueBills[0];
            String issueType = issueBill.getString("issuetype");
            if (HRStringUtils.isNotEmpty((String)issueType)) {
                this.getModel().setValue("issuetype", (Object)issueType);
            }
            if ((issueHandlerId = issueBill.getLong("issuehandler")) != 0L) {
                this.getModel().setValue("issuehandler", (Object)issueHandlerId);
            } else {
                this.getModel().setValue("issuehandler", (Object)RequestContext.get().getCurrUserId());
            }
            String issueResult = issueBill.getString("issueresult");
            if (HRStringUtils.isNotEmpty((String)issueResult)) {
                this.getModel().setValue("issueresult", (Object)issueResult);
            }
            if ((issueTime = issueBill.getDate("issuetime")) != null) {
                this.getModel().setValue("issuetime", (Object)issueTime);
            }
            if (issueTime == null || IssueTypeEnum.ONLINE.getNumber().equals(issueType)) {
                this.getModel().setValue("issuetime", (Object)new Date());
            }
            if (HRStringUtils.isNotEmpty((String)(appNoticeDocId = issueBill.getString("appnoticedoc")))) {
                this.getModel().setValue("appnoticedoc", (Object)appNoticeDocId);
            }
            if (HRStringUtils.isNotEmpty((String)(issueOptions = issueBill.getString("issueoptions")))) {
                this.getModel().setValue("issueoptions", (Object)issueOptions);
            }
            if (HRStringUtils.isEmpty((String)(batchNum = issueBill.getString("issuebatchnum"))) && null != batchNumObj) {
                batchNum = batchNumObj.toString();
            }
            this.getModel().setValue("issuebatchnum", (Object)batchNum);
        } else {
            this.getModel().setValue("issuehandler", (Object)RequestContext.get().getCurrUserId());
            this.getModel().setValue("issuebatchnum", batchNumObj);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("donothing_ok".equals(operateKey) && operationResult != null && operationResult.isSuccess()) {
            OperationResult hasSubmitPerm = this.getView().getParentView().invokeOperation("hassubmitperm");
            if (hasSubmitPerm == null || !hasSubmitPerm.isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u63d0\u4ea4\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BatchIssueEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject issueBill = this.getModel().getDataEntity();
            String issueType = issueBill.getString("issuetype");
            long issueHandlerId = issueBill.getDynamicObject("issuehandler").getLong("id");
            String issueResult = issueBill.getString("issueresult");
            Date issueTime = issueBill.getDate("issuetime");
            String appNoticeDocId = issueBill.getDynamicObject("appnoticedoc").getString("id");
            String issueOptions = issueBill.getString("issueoptions");
            String batchNum = issueBill.getString("issuebatchnum");
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("issuetype", issueType);
            map.put("issuehandler", issueHandlerId);
            map.put("issueresult", issueResult);
            map.put("issuetime", issueTime);
            map.put("appnoticedoc", appNoticeDocId);
            map.put("issueoptions", issueOptions);
            map.put("issuebatchnum", batchNum);
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btnControl = (Control)evt.getSource();
        String key = btnControl.getKey();
        if ("previewfile".equals(key)) {
            this.issueFormService.previewIssueFile(this.getModel(), this.getView());
        }
        if ("downloadfile".equals(key)) {
            this.issueFormService.downloadIssueFile(this.getModel(), this.getView());
        }
    }
}

