/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.issue;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueTypeEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.ResultEnum;
import kd.tdc.cadm.formplugin.web.formservice.IssueFormService;

public class IssueBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final IssueFormService issueFormService = (IssueFormService)ServiceFactory.getService(IssueFormService.class);
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final String FLEX_PERSON_INFO = "perinfoflex";
    private static final String KEY_HASLOADINFO = "hasloadinfo";
    private static final String BTN_PREVIEW_FILE = "previewfile";
    private static final String BTN_DOWNLOAD_FILE = "downloadfile";
    private static final String FLEX_HEAD_BILL_INFO = "headbillinfo";
    private static final String FLEX_APPOINT_INFO = "flexnominate";

    public void preOpenForm(PreOpenFormEventArgs e) {
        long currUserId;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getFormShowParameter();
        Object pkId = billShowParameter.getCustomParam("formPkId");
        if (pkId != null) {
            billShowParameter.setPkId(pkId);
        }
        Long id = Long.valueOf(billShowParameter.getPkId().toString());
        ArrayList<Long> pkIds = new ArrayList<Long>();
        pkIds.add(id);
        DynamicObject[] bills = issueBillApplicationService.queryOriginalIssueBillById("issuestatus,handler.fbasedataid_id,person.name", pkIds);
        DynamicObject bill = bills[0];
        String issueStatus = bill.getString("issuestatus");
        if (IssueStatusEnum.UN_TRIGGER.getNumber().equals(issueStatus)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"IssueBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List userIds = Arrays.stream(bills).map(p -> p.getLong("handler.fbasedataid_id")).collect(Collectors.toList());
        if (!userIds.contains(currUserId = RequestContext.get().getCurrUserId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"IssueBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String personName = bill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u7b7e\u53d1-{0}", (String)"IssueBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String issueStatus = (String)this.getModel().getValue("issuestatus");
        if (IssueStatusEnum.TOBE_ISSUE.getNumber().equals(issueStatus)) {
            this.setHandlerDefault();
            this.setIssueResultDefault();
            this.setIssueTypeDefault();
            this.setIssueTimeDefault();
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showHeadFlex();
        String hasLoadInfo = this.getPageCache().get(KEY_HASLOADINFO);
        if (!HRStringUtils.equals((String)"1", (String)hasLoadInfo)) {
            this.showPersonCardFlex();
            this.showAppointInfoView();
            DynamicObject dataEntity = this.getModel().getDataEntity();
            String batchNum = dataEntity.getString("issuebatchnum");
            if (HRStringUtils.isBlank((CharSequence)batchNum)) {
                batchNum = CodeRuleServiceHelper.readNumber((String)"cadm_appointissue", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
                this.getModel().setValue("issuebatchnum", (Object)batchNum);
            }
            this.getPageCache().put(KEY_HASLOADINFO, "1");
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_PREVIEW_FILE, BTN_DOWNLOAD_FILE});
        BasedataEdit noticeDocEdit = (BasedataEdit)this.getView().getControl("appnoticedoc");
        noticeDocEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if ("appnoticedoc".equals(fieldName)) {
            QFilter entityQFilter = new QFilter("formid.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"cadm_appointissue", "cadm_appointrelease"}));
            QFilter isEnable = new QFilter("enable", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(entityQFilter);
            beforeF7SelectEvent.addCustomQFilter(isEnable);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("submit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setHandlerDefault() {
        DynamicObject handlerObj = (DynamicObject)this.getModel().getValue("issuehandler");
        if (HRObjectUtils.isEmpty((Object)handlerObj)) {
            long currUserId = RequestContext.get().getCurrUserId();
            this.getModel().setValue("issuehandler", (Object)currUserId);
        }
    }

    private void setIssueResultDefault() {
        String issueResult = (String)this.getModel().getValue("issueresult");
        if (HRStringUtils.isEmpty((String)issueResult)) {
            this.getModel().setValue("issueresult", (Object)ResultEnum.AGREE.getNumber());
        }
    }

    private void setIssueTypeDefault() {
        String issueType = (String)this.getModel().getValue("issuetype");
        if (HRStringUtils.isEmpty((String)issueType)) {
            this.getModel().setValue("issuetype", (Object)IssueTypeEnum.ONLINE.getNumber());
        }
    }

    private void setIssueTimeDefault() {
        Date issueDate = (Date)this.getModel().getValue("issuetime");
        String issueType = (String)this.getModel().getValue("issuetype");
        if (issueDate == null || IssueTypeEnum.ONLINE.getNumber().equals(issueType)) {
            Date now = new Date();
            this.getModel().setValue("issuetime", (Object)now);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btnControl = (Control)evt.getSource();
        String key = btnControl.getKey();
        if (BTN_PREVIEW_FILE.equals(key)) {
            issueFormService.previewIssueFile(this.getModel(), this.getView());
            return;
        }
        if (BTN_DOWNLOAD_FILE.equals(key)) {
            issueFormService.downloadIssueFile(this.getModel(), this.getView());
        }
    }

    private void showHeadFlex() {
        cadmFormService.showBillHead(this.getView(), FLEX_HEAD_BILL_INFO);
    }

    private void showPersonCardFlex() {
        cadmFormService.showPersonInfoCard(this.getView(), FLEX_PERSON_INFO);
    }

    private void showAppointInfoView() {
        ArrayList hideFlexList = Lists.newArrayList((Object[])new String[]{"recommendedsourceflex", "attachmentpanel"});
        cadmFormService.showAppointInfoFlex(this.getView(), FLEX_APPOINT_INFO, (List)hideFlexList);
    }
}

