/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.issue;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class IssueBillList
extends HRCoreBaseList {
    private static final IssueBillApplicationService ISSUE_APPLICATION_SERVICE = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final AppointBatchRejectFormService REJECT_FORM_SERVICE = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final List<String> STRING_LIST = Arrays.asList(IssueStatusEnum.UN_TRIGGER.getNumber(), IssueStatusEnum.DEL.getNumber());
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);
    private static final DismissPositionCommonService DISMISS_POSITION_COMMON_SERVICE = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter handlerFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        QFilter statusFilter = new QFilter("issuestatus", "not in", STRING_LIST);
        e.addCustomQFilter(handlerFilter);
        e.addCustomQFilter(statusFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        e.getQFilters().add(appointStatusQFilter);
        e.setOrderBy("issuestatus asc,createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        CadmFormService.CadmListShowHandler listDataProvider = new CadmFormService.CadmListShowHandler((AbstractFormPlugin)this, "handler");
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void packageData(PackageDataEvent eve) {
        ColumnDesc source = (ColumnDesc)eve.getSource();
        String fieldKey = source.getFieldKey();
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            DISMISS_POSITION_COMMON_SERVICE.packageDismissPositionData(eve, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("reject".equals(operateKey)) {
            REJECT_FORM_SERVICE.setExportBills(this.getIssueBills());
            REJECT_FORM_SERVICE.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        boolean success = Optional.ofNullable(operationResult).map(OperationResult::isSuccess).orElse(false);
        if ("batchsubmit".equals(operateKey) && success) {
            boolean isPass = this.checkIssueStatus();
            if (!isPass) {
                this.recordSubmitErrorInfo(operate);
                return;
            }
            BosLogService.recordLocalStringOpLogWithOp((IFormView)this.getView(), (String)"cadm_appointissue", (AbstractOperate)operate, (MultiLangEnumBridge)new MultiLangEnumBridge("\u70b9\u51fb\u4e86\u201c\u7b7e\u53d1\u201d\u6309\u94ae", "IssueBillList_11", "tdc-cadm-formplugin"));
            this.showBatchIssueDlg();
        }
        if (operateKey.equals("reject")) {
            REJECT_FORM_SERVICE.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    private void showBatchIssueDlg() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cadm_batchissuedlg");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchsubmit"));
        parameter.setCustomParam("ids", (Object)this.getSelectedRows().getPrimaryKeyValues());
        Long primaryKeyValue = (Long)this.getSelectedRows().getPrimaryKeyValues()[0];
        DynamicObject[] dynamicObjects = ISSUE_APPLICATION_SERVICE.queryOriginalIssueBillById("id", Collections.singletonList(primaryKeyValue));
        DynamicObject dataEntity = dynamicObjects[0];
        String batchNum = CodeRuleServiceHelper.readNumber((String)"cadm_appointissue", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
        parameter.setCustomParam("issuebatchnum", (Object)batchNum);
        this.getView().showForm(parameter);
    }

    private void recordSubmitErrorInfo(AbstractOperate operate) {
        String errorMsg = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u7b7e\u53d1\u72b6\u6001\u4e3a\u201c\u5f85\u7b7e\u53d1\u201d\u7684\u6570\u636e\u3002", (String)"IssueBillList_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(errorMsg);
        BosLogService.recordLocalStringOpLogWithOp((IFormView)this.getView(), (String)"cadm_appointissue", (AbstractOperate)operate, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u7b7e\u53d1\u72b6\u6001\u4e3a\u201c\u5f85\u7b7e\u53d1\u201d\u7684\u6570\u636e\u3002", "IssueBillList_7", "tdc-cadm-formplugin"));
    }

    private boolean checkIssueStatus() {
        DynamicObjectCollection issueBillObjs = this.getIssueBillListData();
        boolean isStatusError = issueBillObjs.stream().anyMatch(issueBill -> !IssueStatusEnum.TOBE_ISSUE.getNumber().equals(issueBill.getString("issuestatus")));
        return !isStatusError;
    }

    private DynamicObjectCollection getIssueBillListData() {
        DynamicObjectCollection issueBillObjs = new DynamicObjectCollection();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return issueBillObjs;
        }
        Object[] billIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
        String entityNumber = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        Map issueBillObjsMap = BusinessDataServiceHelper.loadFromCache((Object[])billIds, (String)entityNumber);
        issueBillObjs.addAll(issueBillObjsMap.values());
        return issueBillObjs;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("batchsubmit".equals(actionId)) {
            if (HRObjectUtils.isEmpty((Object)returnData)) {
                return;
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("batchIssueParams", SerializationUtils.serializeToBase64((Object)returnData));
            this.getView().invokeOperation("listbatchsubmit", operateOption);
        }
        Map returnMap = CastUtils.castMap((Object)returnData, String.class);
        if ("reject_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    private DynamicObject[] getIssueBills() {
        List pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return ISSUE_APPLICATION_SERVICE.queryIssueBillById("id,person.name,person.number,billno,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name,issuestatus,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }
}

