/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.nominate;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchDeleteFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchTerminateFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchUnSubmitFormService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.cadm.formplugin.web.formservice.appointedit.AppointEditorUtil;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class NominateListPlugin
extends HRCoreBaseBillList {
    private static final AppointBatchDeleteFormService deleteFormService = (AppointBatchDeleteFormService)ServiceFactory.getService(AppointBatchDeleteFormService.class);
    private static final AppointBatchTerminateFormService terminateFormService = (AppointBatchTerminateFormService)ServiceFactory.getService(AppointBatchTerminateFormService.class);
    private static final AppointBatchUnSubmitFormService unSubmitFormService = (AppointBatchUnSubmitFormService)ServiceFactory.getService(AppointBatchUnSubmitFormService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final FormCommonService formCommonService = FormServiceFactory.getService(FormCommonService.class);
    private static final NominateCommonFormService nominateCommonFormService = FormServiceFactory.getService(NominateCommonFormService.class);
    private static final String EXPORT_APPOINT = "exportappoint";
    private static final String ADD_BILL = "addBill";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object dataSource = customParams.get("dataSource");
        List fastFilterColumns = args.getFastFilterColumns();
        if ("departMsg".equals(dataSource) || "withdrawDepartMsg".equals(dataSource)) {
            Object personNumber = customParams.get("personNumber");
            Object personName = customParams.get("personName");
            fastFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("person.number".equals(fieldName) && personNumber != null) {
                    item.setDefaultValue(String.valueOf(personNumber));
                }
                if ("person.name".equals(fieldName) && personName != null) {
                    item.setDefaultValue(String.valueOf(personName));
                }
            });
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        if ("departMsg".equals(dataSource)) {
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("appointstatus".equals(fieldName)) {
                    item.setDefaultValue(AppointStatusEnum.ING_APPOINT.getVal());
                }
                if ("org.name".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
            });
        }
        if ("withdrawDepartMsg".equals(dataSource)) {
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("appointstatus".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
                if ("org.name".equals(fieldName)) {
                    item.setDefaultValue(null);
                }
            });
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter applyKindFilter = new QFilter("applykind", "=", (Object)ApplyKindEnum.APPOINT.getNumber());
        e.getQFilters().add(applyKindFilter);
        e.setOrderBy("appointstatus asc,createtime desc");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        formCommonService.beforeCreateListColumns(args, "person.number");
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        e.getParameter().setCustomParam("applytype", (Object)pageCache.get(ADD_BILL));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        FormOperate formOperate = (FormOperate)source;
        String operateKey = formOperate.getOperateKey();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (HRStringUtils.equals((String)operateKey, (String)"tblnew") || HRStringUtils.equals((String)operateKey, (String)"tblquicknew")) {
            pageCache.put(ADD_BILL, operateKey);
        }
        if ("terminate".equals(operateKey)) {
            nominateApplicationService.setDefaultReasonByDepart((AbstractFormPlugin)this);
        }
        terminateFormService.callValidatorBeforeDoOperation(args, "terminate", (AbstractFormPlugin)this);
        unSubmitFormService.callValidatorBeforeDoOperation(args, "unsubmit", (AbstractFormPlugin)this);
        deleteFormService.callValidatorBeforeDoOperation(args, "listdelete", (AbstractFormPlugin)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        DynamicObject[] nominateBills;
        boolean newTbl;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        boolean bl = newTbl = HRStringUtils.equals((String)operateKey, (String)"tblnew") || HRStringUtils.equals((String)operateKey, (String)"tblquicknew");
        if (newTbl && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("new");
        }
        if (operateKey.equals("terminate") || operateKey.equals("unsubmit")) {
            terminateFormService.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
        if (EXPORT_APPOINT.equals(operateKey) && args.getOperationResult().isSuccess() && (nominateBills = this.getNominateBills()).length > 0) {
            String url = AppointEditorUtil.getCacheUrl("appoint", nominateBills);
            this.getView().download(url);
        }
    }

    private DynamicObject[] getNominateBills() {
        List pkIds = this.getSelectedRows().stream().map(selectedRow -> Long.valueOf(selectedRow.getPrimaryKeyValue().toString())).collect(Collectors.toList());
        return nominateApplicationService.queryNominateBillsByIds("person,employee,billno,appointreason,aposition,dposition,appointstatus,nominatestatus,atenure", pkIds);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("unsubmit") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            unSubmitFormService.doOperationConfirmCallBack((AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (actionId.equals("cadm_termination")) {
            terminateFormService.doTerminateAllCloseCallBack(returnData, (AbstractFormPlugin)this);
        }
        if (actionId.equals("terminate")) {
            terminateFormService.doTerminatePartCloseCallBack(returnData, (AbstractFormPlugin)this);
        }
        if (actionId.equals("unsubmit")) {
            unSubmitFormService.doOperationClosedCallBack(returnData, "unsubmit", (AbstractFormPlugin)this);
        }
        if (actionId.equals("listdelete")) {
            deleteFormService.doOperationClosedCallBack(returnData, "listdelete", (AbstractFormPlugin)this);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        nominateCommonFormService.setNominateAndDismissList(args, this.getView().getPageCache());
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        ColumnDesc source = (ColumnDesc)e.getSource();
        String fieldKey = source.getFieldKey();
        if ("dismissposition".equals(fieldKey)) {
            IPageCache pageCache = this.getView().getPageCache();
            String pkObj = e.getRowData().getPkValue().toString();
            String dismissPosition = pageCache.get(pkObj);
            e.setFormatValue((Object)dismissPosition);
        }
    }
}

