/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.nominate;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.AfterBindingDataEvent;
import kd.bos.form.field.events.BasedataEditListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyTypeEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.NominateStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.cadm.common.enums.RecommendSourceEnum;
import kd.tdc.cadm.common.enums.StatusTypeEnum;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchTerminateFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchUnSubmitFormService;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;

public class NominatePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
BasedataEditListener {
    private static final Log logger = LogFactory.getLog(NominatePlugin.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final AppointBatchTerminateFormService terminateFormService = (AppointBatchTerminateFormService)ServiceFactory.getService(AppointBatchTerminateFormService.class);
    private static final AppointBatchUnSubmitFormService unSubmitFormService = (AppointBatchUnSubmitFormService)ServiceFactory.getService(AppointBatchUnSubmitFormService.class);
    private static final NominateCommonFormService nominateCommonFormService = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final List<String> LISTEN_FIELDS = Lists.newArrayList((Object[])new String[]{"appointdate", "plannumber", "planunit"});
    private static final Map<String, Integer> FIELD = Maps.newHashMap();
    private static final String SAVE = "save";
    private static final String FAST_LABEL = "fastlabel";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_DEL = "bar_del";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";
    private static final String BAR_TERMINATE = "bar_terminate";
    private static final String BAR_VIEWFLOWCHART = "bar_viewflowchart";
    private static final QFilter EMPTY_DATA_FILTER;
    private static final String KEY_BREW_BILL_MAP = "brewBillMap";
    private static final String KEY_DEFAULT_BREW_BILL_ID = "key_default_brew_bill_id";
    private static final String MINUS_ONE = "-1";
    private static final String FLEX_POSITIONBREW = "flexpositionbrew";
    private static final String CACHE_ISFROMBREWPASSMSG = "isfrombrewpassmsg";
    private static final String CACHE_ISINITFROMBREWBILL = "isinitfrombrewbill";
    private static final Set<String> VIEW_STATUS_SET;
    private static final String FAST_APPOINT_PERM = "1ZN7/M5XXAF8";
    private static final String NORMAL_APPOINT_PERM = "1ZN70UDYU5=+";
    private static final String KEY_POSITION_TENURE_MAP = "key_position_tenure_map";
    private static final String TERMINATION_IDEA_FLEX = "terminationideaflex";
    private static final String TERMINATER_DATE_FLEX = "terminaterdateflex";
    private static final String DPOSITION_VERTOR_AP = "dpositionvectorap";
    private static final String APOSITION_VECTOR_AP = "apositionvectorap";
    private static final String RECOMMEND_SOURCE = "recommendsource";
    private static final String A_POSITION_CONTROL = "apositioncontrol";
    private static final String D_POSITION_CONTROL = "dpositioncontrol";
    private static final String DISMISS_POSITION = "dismissposition";
    private static final String DEPT_RECOMMEND = "20";
    private static final String REFERER_RECOMMEND = "10";
    private static final Set<String> NEED_REFRESH_OP_SET;

    public void initialize() {
        super.initialize();
        this.getModel().addDataModelChangeListener((IDataModelChangeListener)this);
        BasedataEdit mulEdit = (BasedataEdit)this.getControl("empposrel");
        mulEdit.addBasedataEditListener((BasedataEditListener)this);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String formPkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)formPkId)) {
            billShowParameter.setPkId((Object)formPkId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String applyTypeCache = (String)formShowParameter.getCustomParam("applytype");
        if (HRStringUtils.equals((String)applyTypeCache, (String)"tblnew")) {
            this.getModel().setValue("applytype", (Object)ApplyTypeEnum.NORMAL.getVal());
            this.getView().setVisible(Boolean.FALSE, new String[]{FAST_LABEL});
        }
        if (HRStringUtils.equals((String)applyTypeCache, (String)"tblquicknew")) {
            this.getModel().setValue("applytype", (Object)ApplyTypeEnum.FAST.getVal());
            this.getView().setVisible(Boolean.TRUE, new String[]{FAST_LABEL});
        }
        this.getModel().setValue("applykind", (Object)ApplyKindEnum.APPOINT.getNumber());
        this.openFromBrewPassMsg();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setValueFormBrewMsg();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IFormView view = this.getView();
        this.showBtnByStatus();
        this.showPersonInfo();
        String applyType = dataEntity.getString("applytype");
        view.setVisible(Boolean.valueOf(!ApplyTypeEnum.NORMAL.getVal().equals(applyType)), new String[]{FAST_LABEL});
        view.setVisible(Boolean.valueOf(!HRObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("appointtype"))), new String[]{"appointtypename"});
        this.appointStatusBtnControl();
        long nominateId = dataEntity.getLong("id");
        Tuple judgeEnableUnSubmit = nominateApplicationService.judgeEnableUnSubmit(Long.valueOf(nominateId));
        Boolean showUnSubmitBtn = (Boolean)judgeEnableUnSubmit.item1;
        this.getView().setVisible(showUnSubmitBtn, new String[]{BAR_UNSUBMIT});
        DynamicObject brewBill = dataEntity.getDynamicObject("brewingbill");
        this.getView().setVisible(brewBill == null ? Boolean.FALSE : Boolean.TRUE, new String[]{FLEX_POSITIONBREW});
        this.loadMatchDataPage();
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (billStatus.equals("A") || billStatus.equals("G")) {
            this.personOrPositionChanged();
        }
        cadmFormService.setBrewBillRelatedField(this.getModel());
        this.setReappointInfo();
        this.setRecommendDateLimit();
        this.getModel().setDataChanged(false);
    }

    private void setReappointInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        boolean appointType = 1472625044948646912L == appointTypeId;
        DynamicObject dTenure = dataEntity.getDynamicObject("dismisstenure");
        if (!appointType) {
            if (null != dTenure) {
                this.commonReappointInfo(dTenure, D_POSITION_CONTROL, DISMISS_POSITION);
            }
            this.setAfterBindDataInitValueNotContinue();
            return;
        }
        this.commonReappointInfo(dTenure, D_POSITION_CONTROL, DISMISS_POSITION);
        DynamicObject aTenure = dataEntity.getDynamicObject("atenure");
        TextEdit textEdit = (TextEdit)this.getControl("awillposition");
        textEdit.setMustInput(true);
        DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
        dateEdit.setMustInput(true);
        this.commonReappointInfo(aTenure, A_POSITION_CONTROL, "awillposition");
        this.getView().setVisible(Boolean.FALSE, new String[]{"aposition", "astandardposition", "ajob"});
        this.setMustInput("aposition", Boolean.FALSE);
        this.setMustInput("astandardposition", Boolean.FALSE);
        this.setMustInput("ajob", Boolean.FALSE);
        this.getView().setEnable(Boolean.FALSE, new String[]{"positiontype", "aadminorg", "isprimappoint", "empposrel"});
        if (null != aTenure) {
            this.getModel().setValue("aadminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)aTenure.getDynamicObject("adminorg")));
            this.getModel().setValue("acompany", (Object)HRDyObjectPropUtil.getId((DynamicObject)aTenure.getDynamicObject("company")));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{DISMISS_POSITION});
        this.getView().setVisible(Boolean.FALSE, new String[]{DPOSITION_VERTOR_AP});
    }

    private void setAfterBindDataInitValueNotContinue() {
        boolean aAdminOrgEnable;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{A_POSITION_CONTROL});
        String appointStatus = this.getModel().getDataEntity().getString("appointstatus");
        boolean isViewStatus = VIEW_STATUS_SET.contains(appointStatus);
        this.getView().setVisible(Boolean.valueOf(!isViewStatus), new String[]{DPOSITION_VERTOR_AP});
        ComboEdit positionTypeEdit = (ComboEdit)this.getControl("positiontype");
        positionTypeEdit.setMustInput(true);
        Object positionType = this.getModel().getValue("positiontype");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("aadminorg");
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            basedataEdit.setMustInput(false);
            aAdminOrgEnable = false;
        } else {
            basedataEdit.setMustInput(true);
            aAdminOrgEnable = true;
        }
        this.getView().setEnable(Boolean.valueOf(aAdminOrgEnable), new String[]{"aadminorg"});
        this.setPositionVisible(positionType);
    }

    private void setPositionVisible(Object positionType) {
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType) || null == positionType) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"aposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ajob", "astandardposition"});
            this.setMustInput("aposition", Boolean.TRUE);
            this.setMustInput("ajob", Boolean.FALSE);
            this.setMustInput("astandardposition", Boolean.FALSE);
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ajob"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition", "astandardposition"});
            this.setMustInput("ajob", Boolean.TRUE);
            this.setMustInput("aposition", Boolean.FALSE);
            this.setMustInput("astandardposition", Boolean.FALSE);
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"astandardposition"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"ajob", "aposition"});
            this.setMustInput("astandardposition", Boolean.TRUE);
            this.setMustInput("aposition", Boolean.FALSE);
            this.setMustInput("ajob", Boolean.FALSE);
        }
    }

    private void commonReappointInfo(DynamicObject tenure, String control, String fieldName) {
        if (tenure == null) {
            return;
        }
        String appointStatus = this.getModel().getDataEntity().getString("appointstatus");
        boolean isViewStatus = VIEW_STATUS_SET.contains(appointStatus);
        if (A_POSITION_CONTROL.equals(control)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{control});
            this.getView().setVisible(Boolean.valueOf(!isViewStatus), new String[]{APOSITION_VECTOR_AP});
        } else {
            this.getView().setVisible(Boolean.valueOf(!isViewStatus), new String[]{DPOSITION_VERTOR_AP});
            DateTimeEdit appointEndDateEdit = (DateTimeEdit)this.getControl("appointenddate");
            appointEndDateEdit.setMustInput(true);
        }
        String aPositionType = tenure.getString("apositiontype");
        if (PositionTypeEnum.POSITION.getNumber().equals(aPositionType)) {
            DynamicObject position = tenure.getDynamicObject("position");
            this.getModel().setValue(fieldName, (Object)HRDyObjectPropUtil.getName((DynamicObject)position));
        } else if (PositionTypeEnum.JOB.getNumber().equals(aPositionType)) {
            DynamicObject job = tenure.getDynamicObject("job");
            this.getModel().setValue(fieldName, (Object)HRDyObjectPropUtil.getName((DynamicObject)job));
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(aPositionType)) {
            DynamicObject standardPost = tenure.getDynamicObject("standardpost");
            this.getModel().setValue(fieldName, (Object)HRDyObjectPropUtil.getName((DynamicObject)standardPost));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("perrecommendentry");
        this.getModel().setValue(RECOMMEND_SOURCE, (Object)REFERER_RECOMMEND, dynamicObjectCollection.size() - 1);
    }

    private void setRecommendDateLimit() {
        DateEdit dateEdit = (DateEdit)this.getControl("perrecmddate");
        dateEdit.setMaxDate(new Date());
        Object appointStatusObj = this.getModel().getValue("appointstatus");
        if (!AppointStatusEnum.WAIT_APPOINT.getVal().equals(appointStatusObj) && null != appointStatusObj) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection("perrecommendentry");
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        dynamicObjectCollection.forEach(dynamicObject -> {
            String recommendSource = dynamicObject.getString(RECOMMEND_SOURCE);
            if (HRStringUtils.isEmpty((String)recommendSource)) {
                this.getModel().setValue(RECOMMEND_SOURCE, (Object)REFERER_RECOMMEND);
                return;
            }
            int rowNo = Math.max(dynamicObject.getInt("seq") - 1, 0);
            if (DEPT_RECOMMEND.equals(recommendSource)) {
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"mulitreferrer"});
            } else if (REFERER_RECOMMEND.equals(recommendSource)) {
                this.getView().setEnable(Boolean.FALSE, rowNo, new String[]{"muiltrecdept"});
            }
        });
    }

    private void setTenureChange(DynamicObject dataEntity) {
        DynamicObject tenureDynamic = dataEntity.getDynamicObject("atenure");
        if (null == tenureDynamic) {
            this.getModel().setValue("dismisstenure", null);
            this.getModel().setValue("positiontype", null);
            this.getModel().setValue("aadminorg", null);
            this.getModel().setValue("acompany", null);
            this.getModel().setValue("aposition", null);
            this.getModel().setValue("ajob", null);
            this.getModel().setValue("astandardposition", null);
            return;
        }
        String currentPositionType = tenureDynamic.getString("apositiontype");
        this.getModel().setValue("dismisstenure", dataEntity.get("atenure"));
        this.getModel().setValue("positiontype", (Object)currentPositionType);
        this.getModel().setValue("isprimappoint", (Object)tenureDynamic.getString("isprimappoint"));
        if (PositionTypeEnum.POSITION.getNumber().equals(currentPositionType)) {
            DynamicObject positionDynamic = tenureDynamic.getDynamicObject("position");
            this.getModel().setValue("aposition", (Object)HRDyObjectPropUtil.getId((DynamicObject)positionDynamic));
            this.getModel().setValue("aadminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("adminorg")));
            this.getModel().setValue("acompany", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("company")));
            this.getModel().setValue("awillposition", (Object)HRDyObjectPropUtil.getName((DynamicObject)tenureDynamic.getDynamicObject("position")));
            this.getModel().setValue("ajob", null);
            this.getModel().setValue("astandardposition", null);
        } else if (PositionTypeEnum.JOB.getNumber().equals(currentPositionType)) {
            this.getModel().setValue("ajob", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("job")));
            this.getModel().setValue("awillposition", (Object)HRDyObjectPropUtil.getName((DynamicObject)tenureDynamic.getDynamicObject("job")));
            this.getModel().setValue("aadminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("adminorg")));
            this.getModel().setValue("acompany", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("company")));
            this.getModel().setValue("aposition", null);
            this.getModel().setValue("astandardposition", null);
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(currentPositionType)) {
            this.getModel().setValue("astandardposition", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("standardpost")));
            this.getModel().setValue("awillposition", (Object)HRDyObjectPropUtil.getName((DynamicObject)tenureDynamic.getDynamicObject("standardpost")));
            this.getModel().setValue("aadminorg", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("adminorg")));
            this.getModel().setValue("acompany", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenureDynamic.getDynamicObject("company")));
            this.getModel().setValue("aposition", null);
            this.getModel().setValue("ajob", null);
        }
    }

    private void showCadreType() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject personDynamic = (DynamicObject)dataEntity.get("employee");
        if (personDynamic == null) {
            return;
        }
        DynamicObject currentCadre = (DynamicObject)dataEntity.get("cadrecat");
        if (null != currentCadre) {
            return;
        }
        Object personId = personDynamic.getPkValue();
        Object[] dynamicObjects = tenureApplicationService.queryNonLeaveDataByEmployee("cadrecat.id", Long.parseLong(personId.toString()));
        if (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
            Object pkValue = dynamicObjects[0].getPkValue();
            this.getModel().setValue("cadrecat", pkValue);
        }
    }

    private void appointStatusBtnControl() {
        String appointStatus = this.getModel().getDataEntity().getString("appointstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"underway", "completed", "invalid"});
        if (HRStringUtils.isNotEmpty((String)appointStatus)) {
            AppointStatusEnum appointStatusEnum = AppointStatusEnum.getEnumByVal((String)appointStatus);
            String statusType = appointStatusEnum.getStatusType().name();
            String statusName = appointStatusEnum.getName();
            if (StatusTypeEnum.INVALID.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"invalid"});
            }
            if (StatusTypeEnum.UNDERWAY.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"underway"});
            }
            if (StatusTypeEnum.COMPLETED.name().equals(statusType)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"completed"});
            }
            this.getModel().setValue("underway", (Object)statusName);
            this.getModel().setValue("completed", (Object)statusName);
            this.getModel().setValue("invalid", (Object)statusName);
        }
    }

    private void loadMatchDataPage() {
        DynamicObject brewBill = this.getModel().getDataEntity().getDynamicObject("brewingbill");
        if (brewBill == null) {
            return;
        }
        DynamicObject employee = (DynamicObject)this.getModel().getValue("employee");
        DynamicObject person = (DynamicObject)this.getModel().getValue("person");
        long brewBillId = HRDyObjectPropUtil.getId((DynamicObject)brewBill);
        long employeeId = HRDyObjectPropUtil.getId((DynamicObject)employee);
        long personId = HRDyObjectPropUtil.getId((DynamicObject)person);
        String positionType = (String)this.getModel().getValue("positiontype");
        long id = 0L;
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            id = HRDyObjectPropUtil.getId((DynamicObject)this.getModel().getDataEntity().getDynamicObject("aposition"));
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            id = HRDyObjectPropUtil.getId((DynamicObject)this.getModel().getDataEntity().getDynamicObject("ajob"));
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            id = HRDyObjectPropUtil.getId((DynamicObject)this.getModel().getDataEntity().getDynamicObject("astandardposition"));
        }
        cadmFormService.showPositionMatchPage(Long.valueOf(brewBillId), Long.valueOf(personId), Long.valueOf(employeeId), positionType, id, "flexmatchdata", this.getView());
    }

    private boolean checkAppointPersonIsEmpty() {
        DynamicObject appointPerson = this.getModel().getDataEntity().getDynamicObject("depemp");
        return appointPerson == null;
    }

    private void setValueFormBrewMsg() {
        String isInitFromBrewBillValue = this.getPageCache().get(CACHE_ISINITFROMBREWBILL);
        String isFormBrew = this.getPageCache().get(CACHE_ISFROMBREWPASSMSG);
        if (HRStringUtils.equals((String)isFormBrew, (String)"1") && !HRStringUtils.equals((String)isInitFromBrewBillValue, (String)"1")) {
            this.getPageCache().put(CACHE_ISINITFROMBREWBILL, "1");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String depempId = (String)formShowParameter.getCustomParam("depemp");
            String positionId = (String)formShowParameter.getCustomParam("brewposition");
            String jobId = (String)formShowParameter.getCustomParam("brewjob");
            String standardPositionId = (String)formShowParameter.getCustomParam("brewstandardposition");
            String positionType = (String)formShowParameter.getCustomParam("positiontype");
            String brewBillId = (String)formShowParameter.getCustomParam("cadm_brewbill");
            this.getModel().setValue("depemp", (Object)Long.valueOf(depempId));
            this.getModel().setValue("positiontype", (Object)positionType);
            this.getModel().setValue("brewingbill", (Object)Long.valueOf(brewBillId));
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                this.getModel().setValue("aposition", (Object)Long.parseLong(positionId));
            } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                this.getModel().setValue("ajob", (Object)Long.parseLong(jobId));
            } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                this.getModel().setValue("astandardposition", (Object)standardPositionId);
            }
        }
    }

    private void openFromBrewPassMsg() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String depempId = (String)formShowParameter.getCustomParam("depemp");
        if (HRStringUtils.isEmpty((String)depempId)) {
            return;
        }
        this.getPageCache().put(CACHE_ISFROMBREWPASSMSG, "1");
    }

    private void showBtnByStatus() {
        String nominateStatus = (String)this.getModel().getValue("nominatestatus");
        String appointStatus = (String)this.getModel().getValue("appointstatus");
        if (HRStringUtils.isEmpty((String)nominateStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DEL, BAR_UNSUBMIT, BAR_TERMINATE, BAR_VIEWFLOWCHART});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT});
        }
        if (AppointStatusEnum.WAIT_APPOINT.getVal().equals(appointStatus) && NominateStatusEnum.WAIT_NOMINATE.getVal().equals(nominateStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_UNSUBMIT, BAR_TERMINATE, BAR_VIEWFLOWCHART});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT, BAR_DEL});
        }
        if (AppointStatusEnum.WAIT_APPOINT.getVal().equals(appointStatus) && NominateStatusEnum.RESUBMIT_NOMINATE.getVal().equals(nominateStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_DEL, BAR_UNSUBMIT});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_SAVE, BAR_SUBMIT, BAR_TERMINATE, BAR_VIEWFLOWCHART});
        }
        if (AppointStatusEnum.ING_APPOINT.getVal().equals(appointStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_SUBMIT, BAR_DEL});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_UNSUBMIT, BAR_TERMINATE, BAR_VIEWFLOWCHART});
        }
        if (AppointStatusEnum.SUCCESS_APPOINT.getVal().equals(appointStatus) || AppointStatusEnum.TERMINATE_APPOINT.getVal().equals(appointStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_SAVE, BAR_SUBMIT, BAR_DEL, BAR_UNSUBMIT, BAR_TERMINATE});
            this.getView().setVisible(Boolean.TRUE, new String[]{BAR_VIEWFLOWCHART});
        }
    }

    private void showPersonInfo() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String appointStatus = dataEntity.getString("appointstatus");
        boolean isViewStatus = VIEW_STATUS_SET.contains(appointStatus);
        this.getView().setVisible(Boolean.valueOf(isViewStatus), new String[]{"headflexview"});
        this.getView().setVisible(Boolean.valueOf(!isViewStatus), new String[]{"headflexedit"});
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (HRObjectUtils.isEmpty((Object)person)) {
            logger.info(MessageFormat.format("NominatePlugin showPersonInfo is fail, person is {0} or employee is {1}", person));
            this.getView().setVisible(Boolean.FALSE, new String[]{"personinfocardedit"});
            return;
        }
        if (isViewStatus) {
            this.getModel().setValue("billnocopy", (Object)dataEntity.getString("billno"));
            this.getModel().setValue("orgcopy", (Object)dataEntity.getDynamicObject("org").getString("name"));
            DynamicObject creator = dataEntity.getDynamicObject("creator");
            String creatorNameNumber = String.format("%s %s", creator.getString("name"), creator.getString("number"));
            this.getModel().setValue("creatorcopy", (Object)creatorNameNumber);
            this.getModel().setValue("createtimecopy", (Object)dataEntity.getDate("createtime"));
            boolean isTermination = AppointStatusEnum.TERMINATE_APPOINT.getVal().equals(appointStatus);
            this.getView().setVisible(Boolean.valueOf(isTermination), new String[]{TERMINATION_IDEA_FLEX, TERMINATER_DATE_FLEX});
            this.showPerInfoCardFlex(dataEntity, "personinfocardview");
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"personinfocardedit"});
            this.showPerInfoCardFlex(dataEntity, "personinfocardedit");
        }
    }

    private void showPerInfoCardFlex(DynamicObject dataEntity, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_appointbaseinfo");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.setCustomParam("depEmpId", (Object)dataEntity.getString("depemp.id"));
        showParameter.setCustomParam("personId", (Object)dataEntity.getString("person.id"));
        showParameter.setCustomParam("employee", (Object)dataEntity.getString("employee.id"));
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof FormOperate) {
            FormOperate operate = (FormOperate)source;
            String operateKey = operate.getOperateKey();
            if (HRStringUtils.equals((String)operateKey, (String)SAVE)) {
                if (this.checkAppointPersonIsEmpty()) {
                    return;
                }
                BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                BillOperationStatus billOperationStatus = billShowParameter.getBillStatus();
                if (BillOperationStatus.ADDNEW.equals((Object)billOperationStatus)) {
                    String permItemId = "";
                    permItemId = ApplyTypeEnum.FAST.getVal().equals(this.getModel().getDataEntity().getString("applytype")) ? FAST_APPOINT_PERM : NORMAL_APPOINT_PERM;
                    String formId = "cadm_nominatebill";
                    boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"cadm", (String)formId, (String)permItemId);
                    if (!hasPerm) {
                        LocaleString formName = FormMetadataCache.getFormConfig((String)formId).getCaption();
                        String errorMsg = ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u65b0\u589e\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NominatePlugin_11", (String)"tdc-cadm-formplugin", (Object[])new Object[]{formName});
                        args.setCancel(true);
                        this.getView().showErrorNotification(errorMsg);
                    }
                }
            }
            if (HRStringUtils.equals((String)operateKey, (String)"unsubmit")) {
                unSubmitFormService.callSingleBillValidatorBeforeDoOp(args, (AbstractFormPlugin)this);
            }
            if (operateKey.equals("terminate")) {
                nominateApplicationService.setDefaultReasonByDepart((AbstractFormPlugin)this);
                terminateFormService.callSingleBillTerminateValidatorBeforeDoOp(args, (AbstractFormPlugin)this);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult() == null) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (SAVE.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showBtnByStatus();
        }
        if (NEED_REFRESH_OP_SET.contains(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (callBackId.equals("unsubmit") && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            unSubmitFormService.doOperationConfirmCallBack((AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals("cadm_termination")) {
            returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            terminateFormService.doTerminateAllCloseCallBack(returnData, (AbstractFormPlugin)this);
        } else if (APOSITION_VECTOR_AP.equals(actionId) || DPOSITION_VERTOR_AP.equals(actionId)) {
            nominateCommonFormService.effectTenureAfterSelectClose(this.getView(), closedCallBackEvent);
        }
        if (actionId.equals("empposrel")) {
            returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map) {
                Map dataMap = (Map)returnData;
                DynamicObject empposrel = (DynamicObject)dataMap.get("empposrel");
                this.getModel().setValue("empposrel", (Object)empposrel.getLong("id"));
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        boolean appointType;
        super.propertyChanged(args);
        String changeName = args.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        boolean bl = appointType = 1472625044948646912L == appointTypeId;
        if (HRStringUtils.equals((String)changeName, (String)"aposition")) {
            this.aPositionChanged();
            this.personOrPositionChanged();
        }
        if (HRStringUtils.equals((String)changeName, (String)"ajob") || HRStringUtils.equals((String)changeName, (String)"astandardposition")) {
            this.personOrPositionChanged();
        }
        if (HRStringUtils.equals((String)changeName, (String)"aadminorg")) {
            this.aAdminOrgChange();
        }
        if (HRStringUtils.equals((String)changeName, (String)"appointtype")) {
            this.appointTypeChanged(args);
            this.setRepeatSuit();
        }
        if (HRStringUtils.equals((String)changeName, (String)"depemp")) {
            this.afterSetValByDepempChanged();
            this.getPageCache().remove(CACHE_ISFROMBREWPASSMSG);
            this.showCadreType();
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("depemp");
            if (null == dynamicObject) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"personinfocardedit"});
            }
        }
        if (HRStringUtils.equals((String)changeName, (String)"person")) {
            this.resetAppointInfo();
            this.getModel().setValue("appointtype", null);
            this.personOrPositionChanged();
            this.showPersonInfo();
        }
        if (HRStringUtils.equals((String)args.getProperty().getName(), (String)"brewingbill")) {
            this.brewBillChanged(args);
        }
        this.dateValidate(changeName);
        if ("positiontype".equals(changeName)) {
            this.positionTypeChange(args);
        }
        if (RECOMMEND_SOURCE.equals(changeName)) {
            ChangeData[] changeSet = args.getChangeSet();
            this.recommendSourceChange(changeSet);
        }
        if ("atenure".equals(changeName) && appointType) {
            this.setTenureChange(model.getDataEntity());
        }
        if ("awillposition".equals(changeName)) {
            this.willPositionChange(args);
        }
        if ("dismisstenure".equals(changeName)) {
            DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
            nominateCommonFormService.setLeaveOrRemovalInfo(this.getView(), dateEdit, true);
        }
        if (DISMISS_POSITION.equals(changeName)) {
            this.dismissPositionChange(args, appointType);
        }
    }

    private void willPositionChange(PropertyChangedArgs args) {
        ChangeData changeData = args.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        if (HRStringUtils.isEmpty((String)newValue)) {
            this.getModel().setValue("atenure", null);
        } else {
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("atenure");
            this.getModel().setValue("awillposition", (Object)nominateCommonFormService.getTenurePositionName(dynamicObject));
        }
    }

    private void dismissPositionChange(PropertyChangedArgs args, boolean ifRepeat) {
        ChangeData changeData = args.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        if (HRStringUtils.isEmpty((String)newValue)) {
            this.getModel().setValue("dismisstenure", null);
            if (!ifRepeat) {
                DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
                dateEdit.setMustInput(false);
            }
        } else {
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("dismisstenure");
            this.getModel().setValue(DISMISS_POSITION, (Object)nominateCommonFormService.getTenurePositionName(dynamicObject));
        }
    }

    private void commonClean() {
        this.getModel().setValue("atenure", null);
        this.getModel().setValue("aposition", null);
        this.getModel().setValue("awillposition", null);
        this.getModel().setValue("ajob", null);
        this.getModel().setValue("astandardposition", null);
        this.getModel().setValue("aadminorg", null);
        this.getModel().setValue("acompany", null);
        this.getModel().setValue("positiontype", null);
        this.getModel().setValue("dismisstenure", null);
        this.getModel().setValue("dposition", null);
        this.getModel().setValue("djob", null);
        this.getModel().setValue("dstandardposition", null);
        this.getModel().setValue("appointenddate", null);
        this.getModel().setValue("appointstartdate", null);
        this.getModel().setValue("dadminorg", null);
        this.getModel().setValue("dcompany", null);
        this.getModel().setValue("positionclass", null);
        this.getView().updateView("positionclass");
        this.getModel().setValue("empposrel", null);
    }

    private void resetAppointInfo() {
        this.commonClean();
        this.getModel().setValue("isprimappoint", (Object)"1");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"positiontype", "adminorg", "isprimappoint", D_POSITION_CONTROL, "empposrel"});
        ComboEdit positionTypeEdit = (ComboEdit)this.getControl("positiontype");
        positionTypeEdit.setMustInput(true);
        this.getModel().setValue("positiontype", (Object)PositionTypeEnum.POSITION.getNumber());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"aposition"});
        this.setMustInput("positionclass", true);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("aadminorg");
        basedataEdit.setMustInput(false);
        this.getView().setEnable(Boolean.FALSE, new String[]{"aadminorg"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"ajob", "astandardposition"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{A_POSITION_CONTROL});
        TextEdit textEdit = (TextEdit)this.getControl("awillposition");
        textEdit.setMustInput(false);
        DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
        dateEdit.setMustInput(false);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{DPOSITION_VERTOR_AP});
        this.getView().setEnable(Boolean.TRUE, new String[]{DISMISS_POSITION});
    }

    private void dateValidate(String changeName) {
        boolean needEmptyField;
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)changeName, (String)"appointdate") && (needEmptyField = this.compareDate())) {
            this.getModel().setValue("appointdate", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u62df\u4efb\u4fe1\u606f-\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u201c\u62df\u514d\u4fe1\u606f-\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"NominatePlugin_16", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)changeName, (String)"appointenddate") && (needEmptyField = this.compareDate())) {
            this.getModel().setValue("appointenddate", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u62df\u514d\u4fe1\u606f-\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u62df\u4efb\u4fe1\u606f-\u4efb\u671f\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"NominatePlugin_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
        if (LISTEN_FIELDS.contains(changeName)) {
            Date appointDate = (Date)model.getValue("appointdate");
            String planUnit = (String)model.getValue("planunit");
            Integer planNum = (Integer)model.getValue("plannumber");
            if (!Objects.isNull(appointDate) && !HRStringUtils.isEmpty((String)planUnit) && planNum != 0) {
                Calendar prePositiveDate = Calendar.getInstance();
                prePositiveDate.setTime(appointDate);
                prePositiveDate.add(FIELD.get(planUnit), planNum);
                model.setValue("prepositivedate", (Object)prePositiveDate.getTime());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\"\u9884\u8f6c\u6b63\u65e5\u671f\"\u3002", (String)"NominatePlugin_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void aAdminOrgChange() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        if (1472625044948646912L == appointTypeId) {
            return;
        }
        DynamicObject adminOrgDynamic = (DynamicObject)dataEntity.get("aadminorg");
        if (null == adminOrgDynamic) {
            this.getModel().setValue("acompany", null);
            return;
        }
        this.getModel().setValue("acompany", adminOrgDynamic.get("company"));
    }

    private void recommendSourceChange(ChangeData[] changeSet) {
        Arrays.stream(changeSet).forEach(changeData -> {
            DynamicObject dataEntity = changeData.getDataEntity();
            String recommendSource = dataEntity.getString(RECOMMEND_SOURCE);
            int rowIndex = changeData.getRowIndex();
            if (RecommendSourceEnum.PERSON.getNumber().equals(recommendSource)) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"muiltrecdept"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"mulitreferrer"});
                this.getModel().setValue("muiltrecdept", null, rowIndex);
            }
            if (RecommendSourceEnum.DEPT.getNumber().equals(recommendSource)) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"mulitreferrer"});
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"muiltrecdept"});
                this.getModel().setValue("mulitreferrer", null, rowIndex);
            }
        });
    }

    private void positionTypeChange(PropertyChangedArgs args) {
        boolean appointType;
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        boolean bl = appointType = 1472625044948646912L == appointTypeId;
        if (appointType) {
            return;
        }
        ChangeData changeData = args.getChangeSet()[0];
        String newValue = (String)changeData.getNewValue();
        if (HRStringUtils.isEmpty((String)newValue)) {
            this.resetAppointInfo();
            return;
        }
        this.getModel().setValue("aposition", null);
        this.getModel().setValue("ajob", null);
        this.getModel().setValue("astandardposition", null);
        this.getModel().setValue("aadminorg", null);
        this.getModel().setValue("positionclass", null);
        this.getModel().setValue("empposrel", null);
        if (PositionTypeEnum.POSITION.getNumber().equals(newValue)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"aadminorg"});
            this.setMustInput("aadminorg", false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"ajob", "astandardposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"aposition"});
            this.setMustInput("aposition", Boolean.TRUE);
            this.setMustInput("ajob", Boolean.FALSE);
            this.setMustInput("astandardposition", Boolean.FALSE);
        } else if (PositionTypeEnum.JOB.getNumber().equals(newValue)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"aadminorg"});
            this.setMustInput("aadminorg", true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"aposition", "astandardposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"ajob"});
            this.setMustInput("ajob", Boolean.TRUE);
            this.setMustInput("aposition", Boolean.FALSE);
            this.setMustInput("astandardposition", Boolean.FALSE);
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(newValue)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"aadminorg"});
            this.setMustInput("aadminorg", true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"ajob", "aposition"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"astandardposition"});
            this.setMustInput("astandardposition", Boolean.TRUE);
            this.setMustInput("aposition", Boolean.FALSE);
            this.setMustInput("ajob", Boolean.FALSE);
        }
    }

    private void setMustInput(String basedataEditKey, boolean ifMustInput) {
        BasedataEdit aPositionEdit = (BasedataEdit)this.getControl(basedataEditKey);
        aPositionEdit.setMustInput(ifMustInput);
    }

    private boolean compareDate() {
        boolean isReappointment;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Date appointDate = dataEntity.getDate("appointdate");
        Date appointEndDate = dataEntity.getDate("appointenddate");
        if (appointDate == null || appointEndDate == null) {
            return false;
        }
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        boolean bl = isReappointment = 1472625044948646912L == appointTypeId;
        if (isReappointment) {
            return !HRDateTimeUtils.dayAfter((Date)appointDate, (Date)appointEndDate);
        }
        return false;
    }

    private void appointTypeChanged(PropertyChangedArgs args) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        if (appointTypeId == 0L) {
            this.resetAppointInfo();
            return;
        }
        ChangeData changeData = args.getChangeSet()[0];
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        boolean reappointToContinue = 1472625044948646912L == HRDyObjectPropUtil.getId((DynamicObject)newValue);
        boolean continueToReappoint = 1472625044948646912L == HRDyObjectPropUtil.getId((DynamicObject)oldValue);
        DateEdit dateEdit = (DateEdit)this.getControl("appointenddate");
        if (continueToReappoint) {
            this.resetAppointInfo();
        } else if (reappointToContinue) {
            this.commonClean();
            TextEdit textEdit = (TextEdit)this.getControl("awillposition");
            textEdit.setMustInput(true);
            ComboEdit positionTypeEdit = (ComboEdit)this.getControl("positiontype");
            positionTypeEdit.setMustInput(false);
            ComboEdit primaryEdit = (ComboEdit)this.getControl("isprimappoint");
            primaryEdit.setMustInput(false);
            dateEdit.setMustInput(true);
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl("aadminorg");
            basedataEdit.setMustInput(false);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isprimappoint", "positiontype", "aadminorg", D_POSITION_CONTROL, "empposrel"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{A_POSITION_CONTROL});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"aposition", "ajob", "astandardposition", DPOSITION_VERTOR_AP});
            this.setMustInput("positionclass", false);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{A_POSITION_CONTROL});
            this.getModel().setValue("isprimappoint", (Object)"1");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{DPOSITION_VERTOR_AP});
        }
    }

    private void aPositionChanged() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        if (1472625044948646912L == appointTypeId) {
            return;
        }
        DynamicObject aPosition = dataEntity.getDynamicObject("aposition");
        if (HRObjectUtils.isEmpty((Object)aPosition)) {
            this.getModel().setValue("aadminorg", null);
            return;
        }
        DynamicObject adminorg = aPosition.getDynamicObject("adminorg");
        this.getModel().setValue("aadminorg", (Object)adminorg);
    }

    private void brewBillChanged(PropertyChangedArgs args) {
        Object newValue = args.getChangeSet()[0].getNewValue();
        if (newValue == null) {
            this.setBrewBillRelatedField(null);
            return;
        }
        long brewBillId = ((DynamicObject)this.getModel().getValue("brewingbill")).getLong("id");
        String brewBillMapStr = this.getView().getPageCache().get(KEY_BREW_BILL_MAP);
        if (HRStringUtils.isEmpty((String)brewBillMapStr)) {
            return;
        }
        Map brewBillMap = (Map)SerializationUtils.deSerializeFromBase64((String)brewBillMapStr);
        DynamicObject brewBill = (DynamicObject)brewBillMap.get(brewBillId);
        DynamicObject person = this.getModel().getDataEntity().getDynamicObject("person");
        Long personId = HRDyObjectPropUtil.getId((DynamicObject)person);
        Optional<DynamicObject> optionalPersonDy = brewBill.getDynamicObjectCollection("entryentity").stream().filter(entity -> personId.equals(HRDyObjectPropUtil.getId((DynamicObject)entity.getDynamicObject("person")))).findFirst();
        String brewComment = null;
        if (optionalPersonDy.isPresent()) {
            brewComment = optionalPersonDy.get().getString("brewcomment");
        }
        this.setBrewBillRelatedField(brewComment);
        this.loadMatchDataPage();
    }

    private void setBrewBillRelatedField(String brewComment) {
        this.getModel().setValue("brewcomment", (Object)brewComment);
    }

    private void personOrPositionChanged() {
        boolean hasOneBrewBill;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        IPageCache pageCache = this.getView().getPageCache();
        DynamicObject person = dataEntity.getDynamicObject("person");
        DynamicObject position = dataEntity.getDynamicObject("aposition");
        DynamicObject job = dataEntity.getDynamicObject("ajob");
        DynamicObject standardPosition = dataEntity.getDynamicObject("astandardposition");
        String positionType = dataEntity.getString("positiontype");
        DynamicObject[] brewBills = new DynamicObject[]{};
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType) && position != null && person != null) {
            brewBills = nominateApplicationService.queryBrewBills(person.getLong("id"), position.getLong("boid"), RequestContext.get().getCurrUserId());
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType) && job != null && person != null) {
            brewBills = nominateApplicationService.queryBrewBillsByJob(person.getLong("id"), job.getLong("boid"), RequestContext.get().getCurrUserId());
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType) && standardPosition != null && person != null) {
            brewBills = nominateApplicationService.queryBrewBillsByStandardPositon(person.getLong("id"), standardPosition.getLong("boid"), RequestContext.get().getCurrUserId());
        }
        String defaultBrewBillId = MINUS_ONE;
        boolean positionTypeMatch = Boolean.TRUE;
        boolean bl = hasOneBrewBill = brewBills != null && brewBills.length > 0 && brewBills[0] != null;
        if (hasOneBrewBill) {
            defaultBrewBillId = brewBills[0].getString("id");
            if (HRStringUtils.isBlank((CharSequence)positionType) || !positionType.equals(brewBills[0].getString("positiontype"))) {
                positionTypeMatch = Boolean.FALSE;
            }
        }
        pageCache.put(KEY_DEFAULT_BREW_BILL_ID, defaultBrewBillId);
        if (!hasOneBrewBill || !positionTypeMatch) {
            this.getModel().setValue("brewingbill", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_POSITIONBREW});
            pageCache.remove(KEY_BREW_BILL_MAP);
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{FLEX_POSITIONBREW});
        Map brewBillMap = Stream.of(brewBills).collect(Collectors.toMap(dynObj -> dynObj.getLong("id"), Function.identity()));
        pageCache.put(KEY_BREW_BILL_MAP, SerializationUtils.serializeToBase64(brewBillMap));
        long brewBillId = 0L;
        ArrayList<Long> brewBillIds = new ArrayList<Long>(brewBillMap.keySet());
        if (!MINUS_ONE.equals(defaultBrewBillId) && !brewBillIds.contains(brewBillId)) {
            this.getModel().setValue("brewingbill", (Object)defaultBrewBillId);
        }
        this.loadMatchDataPage();
    }

    private void setRepeatSuit() {
        boolean appointType;
        logger.info(" setRepeatSuit switch appointType  start");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        boolean bl = appointType = 1472625044948646912L == appointTypeId;
        if (!appointType) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String brewIdStr = (String)formShowParameter.getCustomParam("cadm_brewbill");
        if (HRStringUtils.isBlank((CharSequence)brewIdStr)) {
            logger.error("setRepeatSuit  switch appointType to repeat but brewId is empty");
            return;
        }
        DynamicObject employee = (DynamicObject)this.getModel().getValue("employee");
        if (null == employee) {
            logger.error("setRepeatSuit  switch appointType to repeat but employee is empty");
            return;
        }
        Long employeeId = HRDyObjectPropUtil.getId((DynamicObject)employee);
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (null == person) {
            logger.error("setRepeatSuit  switch appointType to repeat but person is empty");
            return;
        }
        DynamicObject brew = nominateApplicationService.queryBrewById(Long.parseLong(brewIdStr), person.getLong("id"), RequestContext.get().getCurrUserId());
        if (null == brew) {
            return;
        }
        String positionType = brew.getString("positiontype");
        logger.info("setRepeatSuit  switch appointType to repeat brew positionType {}", (Object)positionType);
        QFilter filter = null;
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            DynamicObject brewPosition = brew.getDynamicObject("brewposition");
            filter = new QFilter("position", "=", (Object)brewPosition.getLong("boid"));
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            DynamicObject brewJob = brew.getDynamicObject("brewjob");
            filter = new QFilter("job", "=", (Object)brewJob.getLong("boid"));
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            DynamicObject brewStandardPosition = brew.getDynamicObject("brewstandardposition");
            filter = new QFilter("standardpost", "=", (Object)brewStandardPosition.getLong("boid"));
        }
        if (null == filter) {
            logger.error("setRepeatSuit  switch appointType to repeat but filter is null ");
            return;
        }
        DynamicObject[] dynamicObjects = tenureApplicationService.queryEmployeeTenureData("position,job,standardpost,apositiontype,id", new QFilter[]{new QFilter("employee", "=", (Object)employeeId), new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber()), new QFilter("apositiontype", "=", (Object)positionType), filter}, "createtime desc");
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            this.getModel().setValue("brewingbill", null);
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEX_POSITIONBREW});
            logger.error("setRepeatSuit  switch appointType to repeat but get tenure is null by employee {} ,filter {}", (Object)employeeId, (Object)filter);
            return;
        }
        DynamicObject tenure = dynamicObjects[0];
        this.getModel().setValue("atenure", (Object)HRDyObjectPropUtil.getId((DynamicObject)tenure));
        this.getModel().setValue("brewingbill", (Object)Long.parseLong(brewIdStr));
    }

    private void afterSetValByDepempChanged() {
        IDataModel model = this.getModel();
        DynamicObject depEmp = (DynamicObject)model.getValue("depemp");
        if (depEmp == null) {
            return;
        }
        DynamicObject person = depEmp.getDynamicObject("person");
        DynamicObject employee = depEmp.getDynamicObject("employee");
        DynamicObject cmpEmp = depEmp.getDynamicObject("cmpemp");
        model.setValue("employee", (Object)employee);
        model.setValue("person", (Object)person);
        model.setValue("cmpemp", (Object)cmpEmp);
        Map primaryEmpposorgrel = ExternalDataService.queryPrimaryEmpposorgrel((Long)person.getLong("id"));
        Long companyId = (Long)primaryEmpposorgrel.get("company_id");
        Long adminOrgId = (Long)primaryEmpposorgrel.get("adminorg_id");
        Long positionId = (Long)primaryEmpposorgrel.get("position_id");
        Long jobId = (Long)primaryEmpposorgrel.get("job_id");
        Long standardPositionId = (Long)primaryEmpposorgrel.get("stdposition_id");
        model.setValue("bpositionhis", (Object)positionId);
        model.setValue("bjobhis", (Object)jobId);
        model.setValue("badminorghis", (Object)adminOrgId);
        model.setValue("bcompanyhis", (Object)companyId);
        model.setValue("bstandardpositionhis", (Object)standardPositionId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit;
        boolean f7Click;
        QFilter isManagerFilter;
        QFilter idFilter;
        DynamicObject[] tenures;
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long appointTypeId = HRDyObjectPropUtil.getId((DynamicObject)dataEntity.getDynamicObject("appointtype"));
        if ("atenure".equals(fieldName) && 1472625044948646912L == appointTypeId) {
            this.setTenureClickValueFilter(beforeF7SelectEvent);
        }
        if ("dismisstenure".equals(fieldName) && 1472625044948646912L != appointTypeId) {
            this.setTenureClickValueFilter(beforeF7SelectEvent);
        }
        if ("aposition".equals(fieldName)) {
            tenures = tenureApplicationService.queryNonLeaveDataByEmployee("position", dataEntity.getLong("employee.id"));
            List positionIds = Arrays.stream(tenures).map(tenure -> tenure.getLong("position.id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "not in", positionIds);
            beforeF7SelectEvent.addCustomQFilter(idFilter);
            isManagerFilter = new QFilter("positiontype.ismanagetype", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(isManagerFilter);
        }
        if ("ajob".equals(fieldName)) {
            tenures = tenureApplicationService.queryNonLeaveDataByEmployee("job", dataEntity.getLong("employee.id"));
            List jobIds = Arrays.stream(tenures).map(tenure -> tenure.getLong("job.id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "not in", jobIds);
            beforeF7SelectEvent.addCustomQFilter(idFilter);
            isManagerFilter = new QFilter("jobseq.standardjobseq.id", "=", (Object)1010L);
            beforeF7SelectEvent.addCustomQFilter(isManagerFilter);
        }
        if ("astandardposition".equals(fieldName)) {
            tenures = tenureApplicationService.queryNonLeaveDataByEmployee("standardpost", dataEntity.getLong("employee.id"));
            List standardPositionIds = Arrays.stream(tenures).map(tenure -> tenure.getLong("standardpost.id")).collect(Collectors.toList());
            idFilter = new QFilter("id", "not in", standardPositionIds);
            beforeF7SelectEvent.addCustomQFilter(idFilter);
            isManagerFilter = new QFilter("positiontype.ismanagetype", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(isManagerFilter);
        }
        if ("empposrel".equals(fieldName) && (f7Click = (basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource()).isF7Click())) {
            beforeF7SelectEvent.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("tdcs_empposrel_form");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("personId", (Object)String.valueOf(this.getModel().getValue("person_id")));
            formShowParameter.setCustomParam("employeeId", (Object)String.valueOf(this.getModel().getValue("employee_id")));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "empposrel"));
            this.getView().showForm(formShowParameter);
        }
    }

    private void setTenureClickValueFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("employee.id", "=", (Object)this.getModel().getDataEntity().getLong("employee.id")));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(TenureStatusEnum.ASSUME.getNumber());
        statusList.add(TenureStatusEnum.PROBATION.getNumber());
        beforeF7SelectEvent.getCustomQFilters().add(new QFilter("tenurestatus", "in", statusList));
    }

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        Vector dPosition = (Vector)this.getControl(DPOSITION_VERTOR_AP);
        dPosition.addClickListener((ClickListener)this);
        Vector aPositionVector = (Vector)this.getControl(APOSITION_VECTOR_AP);
        aPositionVector.addClickListener((ClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("positionclass");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit aPosition = (BasedataEdit)this.getControl("aposition");
        aPosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit aJob = (BasedataEdit)this.getControl("ajob");
        aJob.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit aStandardPosition = (BasedataEdit)this.getControl("astandardposition");
        aStandardPosition.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit empposrel = (BasedataEdit)this.getControl("empposrel");
        empposrel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        empposrel.addBasedataEditListener((BasedataEditListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (DPOSITION_VERTOR_AP.equals(source.getKey()) || APOSITION_VECTOR_AP.equals(source.getKey())) {
            nominateCommonFormService.openEffectTenureWindowAfterClick(this.getView(), source.getKey(), (IFormPlugin)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        String caption;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String formPkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)formPkId)) {
            billShowParameter.setPkId((Object)formPkId);
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        OperationStatus operationStatus = billShowParameter.getStatus();
        String applyType = (String)billShowParameter.getCustomParam("applytype");
        String depEmpId = (String)billShowParameter.getCustomParam("depemp");
        if (OperationStatus.ADDNEW.equals((Object)operationStatus)) {
            String caption2;
            if (HRStringUtils.equals((String)applyType, (String)"tblnew") || HRStringUtils.isNotEmpty((String)depEmpId)) {
                caption2 = ResManager.loadKDString((String)"\u65b0\u589e\u4efb\u547d\u63d0\u540d", (String)"NominatePlugin_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                billShowParameter.setCaption(caption2);
            }
            if (HRStringUtils.equals((String)applyType, (String)"tblquicknew")) {
                caption2 = ResManager.loadKDString((String)"\u65b0\u589e\u5feb\u901f\u4efb\u547d", (String)"NominatePlugin_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                billShowParameter.setCaption(caption2);
            }
            return;
        }
        long pkId = Long.parseLong(billShowParameter.getPkId().toString());
        DynamicObject nominateBill = nominateApplicationService.queryNominateBillById("applytype,person", pkId);
        String applyTypeInDb = nominateBill.getString("applytype");
        if (HRStringUtils.equals((String)applyTypeInDb, (String)ApplyTypeEnum.NORMAL.getVal())) {
            caption = ResManager.loadKDString((String)"\u4efb\u547d\u63d0\u540d-{0}", (String)"NominatePlugin_14", (String)"tdc-cadm-formplugin", (Object[])new Object[]{nominateBill.getString("person.name")});
            billShowParameter.setCaption(caption);
        }
        if (HRStringUtils.equals((String)applyTypeInDb, (String)ApplyTypeEnum.FAST.getVal())) {
            caption = ResManager.loadKDString((String)"\u5feb\u901f\u4efb\u547d-{0}", (String)"NominatePlugin_15", (String)"tdc-cadm-formplugin", (Object[])new Object[]{nominateBill.getString("person.name")});
            billShowParameter.setCaption(caption);
        }
    }

    public void afterBindingData(AfterBindingDataEvent evt) {
        BasedataEdit edit;
        String key;
        Object source = evt.getSource();
        if (source instanceof BasedataEdit && "empposrel".equals(key = (edit = (BasedataEdit)evt.getSource()).getKey())) {
            DynamicObject empposrel = (DynamicObject)this.getModel().getValue("empposrel");
            String positionType = empposrel.getString("apositiontype");
            String displayName = "";
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                displayName = empposrel.getString("stdposition.name");
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                displayName = empposrel.getString("position.name");
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                displayName = empposrel.getString("job.name");
            }
            evt.setDisplayProp(displayName);
        }
    }

    static {
        FIELD.put(REFERER_RECOMMEND, 7);
        FIELD.put(DEPT_RECOMMEND, 2);
        FIELD.put("30", 1);
        EMPTY_DATA_FILTER = new QFilter("id", "=", (Object)-1);
        VIEW_STATUS_SET = Sets.newHashSet((Object[])new String[]{AppointStatusEnum.ING_APPOINT.getVal(), AppointStatusEnum.SUCCESS_APPOINT.getVal(), AppointStatusEnum.TERMINATE_APPOINT.getVal()});
        NEED_REFRESH_OP_SET = Sets.newHashSet((Object[])new String[]{"submit", "unsubmit", "terminate"});
    }
}

