/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.publicity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointPublicityWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class PublicityBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static final AppointBatchWithdrawFormService withdrawService = (AppointBatchWithdrawFormService)ServiceFactory.getService(AppointBatchWithdrawFormService.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    public static final AppointPublicityWithdrawFormService APPOINT_PUBLICITY_WITHDRAW_FORM_SERVICE = (AppointPublicityWithdrawFormService)ServiceFactory.getService(AppointPublicityWithdrawFormService.class);
    private static final String PUBLICITY = "publicity";
    private static final String UN_PUBLICITY = "unpublicity";
    private static final String TARGET_FLEX_NAME = "perinfo";
    private static final String SAVE = "bar_save";
    private static final String SUBMIT = "bar_submit";
    private static final String HAS_PUB_PERM = "haspubperm";
    private static final String FLEX_NOMINATE = "flexnominate";

    public void registerListener(EventObject eve) {
        super.registerListener(eve);
        BasedataEdit pubFile = (BasedataEdit)this.getView().getControl("pubfile");
        pubFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"filepreview"});
    }

    public void beforeBindData(EventObject eve) {
        super.beforeBindData(eve);
        this.btnShow();
    }

    private void btnShow() {
        IFormView view = this.getView();
        String status = this.getModel().getDataEntity().getString("pubstatus");
        view.setVisible(Boolean.FALSE, new String[]{"pubresultflex"});
        if (PublicityStatusEnum.BE_SUBMIT.getPubStatus().equals(status) || PublicityStatusEnum.COMPLETED.getPubStatus().equals(status)) {
            view.setVisible(Boolean.TRUE, new String[]{"pubresultflex"});
            view.setEnable(Boolean.FALSE, new String[]{"pubstartdate", "pubenddate", "pubfile", "pubinstruction"});
        }
        if (PublicityStatusEnum.TERMINATED.getPubStatus().equals(status)) {
            view.setEnable(Boolean.FALSE, new String[]{"pubstartdate", "pubenddate", "pubfile", "pubinstruction"});
            view.setVisible(Boolean.valueOf(!HRStringUtils.isEmpty((String)this.getModel().getDataEntity().getString("pubresult"))), new String[]{"pubresultflex"});
        }
        this.getView().setVisible(Boolean.valueOf(PublicityStatusEnum.canBePublicity((String)status)), new String[]{PUBLICITY});
        this.getView().setVisible(Boolean.valueOf(PublicityStatusEnum.canBeWithdraw((String)status)), new String[]{UN_PUBLICITY});
        this.getView().setVisible(Boolean.valueOf(PublicityStatusEnum.canSubmit((String)status)), new String[]{SUBMIT});
        this.getView().setVisible(Boolean.valueOf(PublicityStatusEnum.canSave((String)status)), new String[]{SAVE});
    }

    public void afterBindData(EventObject eve) {
        String batchNum;
        super.afterBindData(eve);
        cadmFormService.showBillHead(this.getView(), "headbillinfo");
        cadmFormService.showPersonInfoCard(this.getView(), TARGET_FLEX_NAME);
        ArrayList hideFlexList = Lists.newArrayList((Object[])new String[]{"recommendedsourceflex", "attachmentpanel"});
        cadmFormService.showAppointInfoFlex(this.getView(), FLEX_NOMINATE, (List)hideFlexList);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String status = this.getModel().getDataEntity().getString("pubstatus");
        if (PublicityStatusEnum.BE_SUBMIT.getPubStatus().equals(status) || PublicityStatusEnum.COMPLETED.getPubStatus().equals(status) || PublicityStatusEnum.TERMINATED.getPubStatus().equals(status)) {
            ComboEdit control = (ComboEdit)this.getControl("pubresult");
            control.setMustInput(true);
        }
        if (PublicityStatusEnum.BE_PUBLIC.getPubStatus().equals(status) || PublicityStatusEnum.RE_PUBLICIZED.getPubStatus().equals(status)) {
            batchNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicity", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
            model.setValue("pubbatchnum", (Object)batchNum);
            String fileNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicitybasebill", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
            model.setValue("pubfilenum", (Object)fileNum);
        } else {
            if (HRStringUtils.isEmpty((String)dataEntity.getString("pubbatchnum"))) {
                batchNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicity", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
                model.setValue("pubbatchnum", (Object)batchNum);
            }
            if (HRStringUtils.isEmpty((String)dataEntity.getString("pubfilenum"))) {
                String fileNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicitybasebill", (DynamicObject)dataEntity, (String)String.valueOf(RequestContext.get().getOrgId()));
                model.setValue("pubfilenum", (Object)fileNum);
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        String fieldName = sControl.getKey();
        if ("filepreview".equals(fieldName)) {
            DynamicObject pubFileDy = this.getModel().getDataEntity().getDynamicObject("pubfile");
            if (pubFileDy == null || HRStringUtils.isEmpty((String)pubFileDy.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u516c\u793a\u6a21\u677f\u201d\u3002", (String)"PublicityBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            Object[] pubBills = publicityBillApplicationService.getByPubBatchNum("id", dataEntity.getString("pubbatchnum"));
            ArrayList selectList = Lists.newArrayList();
            if (HRArrayUtils.isEmpty((Object[])pubBills)) {
                selectList.add(dataEntity.getPkValue());
            } else {
                selectList.addAll(Arrays.stream(pubBills).map(pubBill -> pubBill.getLong("id")).collect(Collectors.toList()));
            }
            String pinFormId = dataEntity.getString("pubfile.number");
            if (!HRStringUtils.isEmpty((String)pinFormId)) {
                String pdfURL = PRINT_FORM_SERVICE.buildPdfURL(this.getView().getPageId(), "cadm_publicity", PRINT_FORM_SERVICE.createPdfExtParam(dataEntity, selectList, "cadm_publicity"), dataEntity.getString("pubfile.id"));
                PRINT_FORM_SERVICE.previewFile(this.getView(), pdfURL);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u516c\u793a\u6a21\u677f", (String)"PublicityBillEdit_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        NOMINATE_COMMON_FORM_SERVICE.commonF7Select(beforeF7SelectEvent);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        OperationResult hasPubPerm;
        super.confirmCallBack(messageBoxClosedEvent);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(Boolean.TRUE.booleanValue());
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("inPublicity".equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            hasPubPerm = this.getView().invokeOperation(HAS_PUB_PERM);
            if (hasPubPerm == null || !hasPubPerm.isSuccess()) {
                return;
            }
            this.buildAndSavePublicityInfo(dataEntity, PublicityStatusEnum.IN_PUBLIC.getPubStatus());
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if ("completed".equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            hasPubPerm = this.getView().invokeOperation(HAS_PUB_PERM);
            if (hasPubPerm == null || !hasPubPerm.isSuccess()) {
                return;
            }
            this.buildAndSavePublicityInfo(dataEntity, PublicityStatusEnum.BE_SUBMIT.getPubStatus());
        }
    }

    private void buildAndSavePublicityInfo(DynamicObject dataEntity, String pubStatus) {
        publicityBillApplicationService.updatePublicityBillByStatus(dataEntity, pubStatus);
        IFormView view = this.getView();
        view.showSuccessNotification(ResManager.loadKDString((String)"\u516c\u793a\u6210\u529f\u3002", (String)"PublicityBillEdit_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        view.invokeOperation("refresh");
        view.sendFormAction(view);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)"pubstartdate", (String)name) || HRStringUtils.equals((String)"pubenddate", (String)name)) {
            Date startDate = (Date)model.getValue("pubstartdate");
            Date endDate = (Date)model.getValue("pubenddate");
            if (startDate != null && endDate != null && HRDateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PublicityBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("withdraw".equals(operateKey)) {
            APPOINT_PUBLICITY_WITHDRAW_FORM_SERVICE.beforeWithdrawOperationWithSingle(args, (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult operationResult;
        boolean isSuccess;
        super.afterDoOperation(args);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity();
        String operateKey = args.getOperateKey();
        if (("submit".equals(operateKey) || "withdraw".equals(operateKey) || HAS_PUB_PERM.equals(operateKey)) && (isSuccess = Optional.ofNullable(operationResult = args.getOperationResult()).map(OperationResult::isSuccess).orElse(false).booleanValue())) {
            cadmFormService.showBillHead(this.getView(), "headbillinfo");
            if ("withdraw".equals(operateKey)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SAVE, PUBLICITY, "bar_close"});
                this.getView().setVisible(Boolean.FALSE, new String[]{UN_PUBLICITY});
                this.getView().setStatus(OperationStatus.EDIT);
            } else {
                this.btnShow();
            }
        }
        if ("donothing_publicity".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Date startDate = dataEntity.getDate("pubstartdate");
            Date endDate = dataEntity.getDate("pubenddate");
            Date today = HRDateTimeUtils.truncateDate((Date)new Date());
            if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PublicityBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (HRDateTimeUtils.dayBefore((Date)today, (Date)startDate)) {
                this.buildAndSavePublicityInfo(dataEntity, PublicityStatusEnum.BE_EFFECTIVE.getPubStatus());
                this.getView().setStatus(OperationStatus.VIEW);
                return;
            }
            if (!HRDateTimeUtils.dayAfter((Date)today, (Date)endDate)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("inPublicity");
                view.showConfirm(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u3002", (String)"PublicityBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("completed");
                view.showConfirm(ResManager.loadKDString((String)"\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u5c06\u4e0d\u4f1a\u89e6\u53d1\u516c\u793a\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"PublicityBillEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
        if ("withdraw".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnMap = CastUtils.castMap((Object)closedCallBackEvent.getReturnData(), String.class);
        String actionId = closedCallBackEvent.getActionId();
        if ("withdraw_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            withdrawService.withdrawAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs eve) {
        super.preOpenForm(eve);
        BillShowParameter billShowParameter = (BillShowParameter)eve.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)Long.valueOf(pkId));
        }
        DynamicObject[] pubBills = publicityBillApplicationService.queryOriginalById("pubstatus,handler.fbasedataid_id,person.name", billShowParameter.getPkId());
        DynamicObject pubBill = pubBills[0];
        String pubStatus = pubBill.getString("pubstatus");
        if (PublicityStatusEnum.NOT_TRIGGER.getPubStatus().equals(pubStatus)) {
            eve.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"PublicityBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            eve.setCancel(true);
            return;
        }
        List userIds = Arrays.stream(pubBills).map(p -> p.getLong("handler.fbasedataid_id")).collect(Collectors.toList());
        if (!userIds.contains(RequestContext.get().getCurrUserId())) {
            eve.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PublicityBillEdit_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            eve.setCancel(true);
            return;
        }
        if (PublicityStatusEnum.isViewStatus((String)pubStatus)) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        String personName = pubBill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u516c\u793a-{0}", (String)"PublicityBillEdit_10", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }
}

