/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.publicity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointPublicityWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class PublicityBillList
extends HRCoreBaseBillList {
    private static final String HAS_PUB_PERM = "haspubperm";
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);
    private static final PublicityBillApplicationService PUBLICITY_BILL_APPLICATION_SERVICE = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final AppointBatchRejectFormService REJECT_FORM_SERVICE = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final AppointBatchWithdrawFormService WITHDRAW_FORM_SERVICE = (AppointBatchWithdrawFormService)ServiceFactory.getService(AppointBatchWithdrawFormService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final List<String> STATUS_LIST = Arrays.asList(PublicityStatusEnum.NOT_TRIGGER.getPubStatus(), PublicityStatusEnum.DEL.getPubStatus());
    private static final DismissPositionCommonService DISMISS_POSITION_COMMON_SERVICE = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    public static final AppointPublicityWithdrawFormService APPOINT_PUBLICITY_WITHDRAW_FORM_SERVICE = (AppointPublicityWithdrawFormService)ServiceFactory.getService(AppointPublicityWithdrawFormService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";

    public void packageData(PackageDataEvent eve) {
        ColumnDesc source = (ColumnDesc)eve.getSource();
        String fieldKey = source.getFieldKey();
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            DISMISS_POSITION_COMMON_SERVICE.packageDismissPositionData(eve, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter handlerFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        setFilterEvent.getQFilters().add(handlerFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        setFilterEvent.getQFilters().add(appointStatusQFilter);
        setFilterEvent.getQFilters().add(new QFilter("pubstatus", "not in", STATUS_LIST));
        setFilterEvent.setOrderBy("pubstatus asc,createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        CadmFormService.CadmListShowHandler listDataProvider = new CadmFormService.CadmListShowHandler((AbstractFormPlugin)this, "handler");
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("reject".equals(operateKey)) {
            REJECT_FORM_SERVICE.setExportBills(this.getPublicityBills());
            REJECT_FORM_SERVICE.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
        if ("withdraw".equals(operateKey)) {
            APPOINT_PUBLICITY_WITHDRAW_FORM_SERVICE.setExportBills(this.getPublicityBillsByWithdraw());
            APPOINT_PUBLICITY_WITHDRAW_FORM_SERVICE.callValidatorBeforeDoOperation(args, operateKey, (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("donothing_publicity_list")) {
            DynamicObject[] pubBills = PUBLICITY_BILL_APPLICATION_SERVICE.queryPublicityBillById("id,nominatebill,pubstatus", (List)HRArrayUtils.objects2ArrayList((Object[])this.getSelectedRows().getPrimaryKeyValues()));
            boolean checkResult = Arrays.stream(pubBills).anyMatch(pubBill -> !PublicityStatusEnum.canBePublicity((String)pubBill.getString("pubstatus")));
            if (checkResult) {
                String tipNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u516c\u793a/\u5f85\u91cd\u65b0\u516c\u793a\u201d\u7684\u6570\u636e\u3002", (String)"PublicityBillList_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipNotification);
                BosLogService.recordLocalStringOpLogWithOp((IFormView)this.getView(), (String)"cadm_publicity", (AbstractOperate)operate, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u516c\u793a/\u5f85\u91cd\u65b0\u516c\u793a\u201d\u7684\u6570\u636e\u3002", "PublicityBillList_9", "tdc-cadm-formplugin"));
                return;
            }
            this.showPubWindowForm();
        }
        if (operateKey.equals("reject") || operateKey.equals("withdraw")) {
            WITHDRAW_FORM_SERVICE.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    private void showPubWindowForm() {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_pubwindow");
        HashMap customParam = Maps.newHashMap();
        if (HRStringUtils.equals((String)"publicity", (String)"publicity")) {
            DynamicObject pubBill = PUBLICITY_BILL_APPLICATION_SERVICE.queryOriginalOneById("id,pubstartdate,pubenddate,pubfile,pubinstruction", this.getSelectedRows().getPrimaryKeyValues()[0]);
            String pubBatchNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicity", (DynamicObject)pubBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            String pubFileNum = CodeRuleServiceHelper.readNumber((String)"cadm_publicitybasebill", (DynamicObject)pubBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            customParam.put("pubbatchnum", pubBatchNum);
            customParam.put("pubfilenum", pubFileNum);
            customParam.put("ids", this.getSelectedRows().getPrimaryKeyValues());
            showParameter.setStatus(OperationStatus.ADDNEW);
            if (this.getSelectedRows().size() == 1) {
                customParam.put("pubfile", pubBill.getString("pubfile"));
                customParam.put("pubstartdate", pubBill.getDate("pubstartdate"));
                customParam.put("pubenddate", pubBill.getDate("pubenddate"));
                customParam.put("pubinstruction", pubBill.getString("pubinstruction"));
            }
        }
        customParam.put("ids", this.getSelectedRows().getPrimaryKeyValues());
        showParameter.setCustomParams((Map)customParam);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "publicity"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        Map returnMap = CastUtils.castMap((Object)callBackEvent.getReturnData(), String.class);
        String actionId = callBackEvent.getActionId();
        if ("withdraw_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            WITHDRAW_FORM_SERVICE.withdrawPartCloseCallBackPublicity(returnMap, (AbstractFormPlugin)this);
        }
        if ("withdraw_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            WITHDRAW_FORM_SERVICE.withdrawAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        Boolean isOperationClose = (Boolean)returnMap.get("isClose");
        if ("publicity".equals(actionId) && Boolean.TRUE.equals(isOperationClose)) {
            OperationResult hasPubPerm = this.getView().invokeOperation(HAS_PUB_PERM);
            if (hasPubPerm == null || !hasPubPerm.isSuccess()) {
                return;
            }
            String opName = ResManager.loadKDString((String)"\u516c\u793a", (String)"PublicityBillList_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u516c\u793a", "PublicityBillList_13", "tdc-cadm-formplugin");
            if (CollectionUtils.isEmpty((Map)returnMap)) {
                if (HRStringUtils.isNotEmpty((String)opName)) {
                    BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_publicity", (String)actionId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u516c\u793a\u5df2\u53d6\u6d88\u3002", "PublicityBillList_21", "tdc-cadm-formplugin"));
                }
                return;
            }
            IFormView view = this.getView();
            String successNotification = ResManager.loadKDString((String)"\u516c\u793a\u6210\u529f\u3002", (String)"PublicityBillList_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            List pkIds = Arrays.stream(primaryKeyValues).map(primaryKey -> Long.valueOf(primaryKey.toString())).collect(Collectors.toList());
            Set failedBillNos = PUBLICITY_BILL_APPLICATION_SERVICE.doPublicAfterConfirmOp(returnMap, pkIds);
            if (CollectionUtils.isEmpty((Collection)failedBillNos)) {
                view.showSuccessNotification(successNotification);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_publicity", (String)actionId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u516c\u793a\u6210\u529f\u3002", "PublicityBillList_5", "tdc-cadm-formplugin"));
                view.invokeOperation("refresh");
                view.sendFormAction(view);
                return;
            }
            String tipNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u516c\u793a/\u5f85\u91cd\u65b0\u516c\u793a\u201d\u7684\u6570\u636e\u3002", (String)"PublicityBillList_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            if (this.getSelectedRows().size() == 1) {
                view.showErrorNotification(tipNotification);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_publicity", (String)actionId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u516c\u793a\u72b6\u6001\u4e3a\u201c\u5f85\u516c\u793a/\u5f85\u91cd\u65b0\u516c\u793a\u201d\u7684\u6570\u636e\u3002", "PublicityBillList_9", "tdc-cadm-formplugin"));
                view.invokeOperation("refresh");
                view.sendFormAction(view);
                return;
            }
            ArrayList errorMsgList = Lists.newArrayList();
            int total = this.getSelectedRows().size();
            int failedNum = failedBillNos.size();
            int successNum = total - failedNum;
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u516c\u793a\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"PublicityBillList_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), total, successNum, failedNum);
            failedBillNos.forEach(billNo -> errorMsgList.add(billNo + ":" + tipNotification));
            CADM_FORM_SERVICE.showBosDefaultOperationResult(title, (List)errorMsgList, view);
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_publicity", (String)actionId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u516c\u793a", "PublicityBillList_13", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5171{0}\u6761\u5355\u636e\uff0c\u516c\u793a\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", "PublicityBillList_1", "tdc-cadm-formplugin"), null, null, (String[])new String[]{"" + total, "" + successNum, "" + failedNum});
        }
    }

    private DynamicObject[] getPublicityBillsByWithdraw() {
        List<Object> pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] batchNumDynamic = PUBLICITY_BILL_APPLICATION_SERVICE.queryPublicityBillById("pubbatchnum", pkIds);
        if (null == batchNumDynamic || batchNumDynamic.length == 0) {
            return new DynamicObject[0];
        }
        Map<Object, String> pkMapBatchNum = Arrays.stream(batchNumDynamic).collect(Collectors.toMap(dynamicObject -> dynamicObject.get("id"), dynamicObject -> dynamicObject.getString("pubbatchnum"), (v1, v2) -> v1));
        List batchNumList = Arrays.stream(batchNumDynamic).map(dynamicObject -> dynamicObject.getString("pubbatchnum")).distinct().collect(Collectors.toList());
        ArrayList notBatchNumList = Lists.newArrayList();
        if (batchNumList.contains(null) || batchNumList.contains("") || batchNumList.contains(" ")) {
            pkIds.forEach(pk -> {
                String batchNum = (String)pkMapBatchNum.get(pk);
                if (HRStringUtils.isBlank((CharSequence)batchNum)) {
                    notBatchNumList.add(pk);
                }
            });
        }
        batchNumList.remove(null);
        batchNumList.remove("");
        batchNumList.remove(" ");
        String selectProperties = "id,person.name,person.number,billno,nominatebill.aposition.name,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.appointstatus,nominatebill.dposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name,pubstatus,pubbatchnum";
        Object[] haveBatchData = PUBLICITY_BILL_APPLICATION_SERVICE.getAllByPubBatchNumList(selectProperties, batchNumList);
        DynamicObject[] dynamicObjects = PUBLICITY_BILL_APPLICATION_SERVICE.queryPublicityBillById(selectProperties, (List)notBatchNumList);
        ArrayList result = Lists.newArrayList((Object[])haveBatchData);
        result.addAll(Arrays.asList(dynamicObjects));
        return result.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] getPublicityBills() {
        List pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return PUBLICITY_BILL_APPLICATION_SERVICE.queryPublicityBillById("id,person.name,person.number,billno,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name,pubstatus,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }
}

