/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.publicity;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.common.bo.CommissionPersonBo;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class PublicityPrintPlugin
extends AbstractPrintPlugin {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static final String PUBLICITY_PRINT_MARK = "publictiy";
    private static final String COMMISSION_TEMPLATE = "commission";
    private static final String PREVENT_TEMPLATE = "prevent";
    private static final String COMMISSION_AND_PREVENT = "commissionAndPrevent";

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        if (!PUBLICITY_PRINT_MARK.equals(dataSource.getDsName())) {
            return;
        }
        try {
            this.constructData(evt);
        }
        finally {
            PrintFormService.THREAD_LOCAL.remove();
        }
    }

    private void constructData(CustomDataLoadEvent evt) {
        List customDataRows = evt.getCustomDataRows();
        Map extParam = this.getExtParam();
        Map<String, List<DynamicObject>> resultMap = PRINT_FORM_SERVICE.getReleaseBills(extParam, "cadm_publicity");
        List<DynamicObject> commissionList = resultMap.get(ApplyKindEnum.APPOINT.getNumber());
        List<DynamicObject> preventList = resultMap.get(ApplyKindEnum.DISMISS.getNumber());
        if (CollectionUtils.isEmpty(commissionList) && CollectionUtils.isEmpty(preventList)) {
            return;
        }
        List<CommissionPersonBo> boList = PRINT_FORM_SERVICE.parseToBo(commissionList);
        boList.addAll(PRINT_FORM_SERVICE.parseToBo(preventList));
        String content = this.appendPublicityPrintContent(boList, commissionList, preventList);
        DataRowSet dataRowSet = new DataRowSet();
        String title = this.getTitle(commissionList, preventList);
        dataRowSet.put("title", (Field)new TextField(title));
        dataRowSet.put("content", (Field)new TextField(content));
        dataRowSet.put("org", (Field)new TextField(PRINT_FORM_SERVICE.getOrgRootName()));
        Date startDate = (Date)extParam.get("pubstartdate");
        Date endDate = (Date)extParam.get("pubenddate");
        if (null != startDate) {
            dataRowSet.put("publicStartDate", (Field)new TextField(PRINT_FORM_SERVICE.getCommonDate(startDate)));
        }
        if (null != endDate) {
            dataRowSet.put("publicEndDate", (Field)new TextField(PRINT_FORM_SERVICE.getCommonDate(endDate)));
        }
        customDataRows.add(dataRowSet);
    }

    public String getTitle(List<DynamicObject> commissionList, List<DynamicObject> preventList) {
        String company = PRINT_FORM_SERVICE.getOrgRootName();
        if (HRStringUtils.isEmpty((String)company)) {
            return "";
        }
        String title = !CollectionUtils.isEmpty(preventList) && CollectionUtils.isEmpty(commissionList) ? ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u514d\u804c\u516c\u793a", (String)"PublicityPrintPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}) : (CollectionUtils.isEmpty(preventList) && !CollectionUtils.isEmpty(commissionList) ? ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u4efb\u547d\u516c\u793a", (String)"PublicityPrintPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}) : ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u4efb\u514d\u516c\u793a", (String)"PublicityPrintPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}));
        return String.format(title, company);
    }

    private String appendPublicityPrintContent(List<CommissionPersonBo> boList, List<DynamicObject> commissionList, List<DynamicObject> preventList) {
        Set personIdSet = boList.stream().map(CommissionPersonBo::getPersonId).collect(Collectors.toSet());
        Map<Long, List<CommissionPersonBo>> boMap = boList.stream().collect(Collectors.groupingBy(CommissionPersonBo::getPersonId));
        Map personBaseInfoMap = ExternalDataService.getPersonBaseInfo(personIdSet);
        Map educationInfoMap = ExternalDataService.getEducationInfoList(personIdSet);
        Map politicInfoMap = ExternalDataService.getPoliticInfoList(personIdSet);
        StringBuilder contentBuilder = new StringBuilder();
        boMap.forEach((personId, list) -> {
            CommissionPersonBo commissionPersonBo = (CommissionPersonBo)personBaseInfoMap.get(personId);
            String personGender = commissionPersonBo.getPersonGender();
            String personName = commissionPersonBo.getPersonName();
            String number = commissionPersonBo.getNumber();
            String birthDay = HRStringUtils.isBlank((CharSequence)commissionPersonBo.getBirthDay()) ? "" : commissionPersonBo.getBirthDay();
            String nation = HRStringUtils.isBlank((CharSequence)commissionPersonBo.getNation()) ? "" : commissionPersonBo.getNation();
            CommissionPersonBo educationBo = (CommissionPersonBo)educationInfoMap.get(personId);
            CommissionPersonBo politicBo = (CommissionPersonBo)politicInfoMap.get(personId);
            list.forEach(bo -> {
                bo.setPersonGender(personGender);
                bo.setPersonName(personName);
                bo.setNumber(number);
                bo.setBirthDay(birthDay);
                bo.setNation(nation);
                if (null != educationBo) {
                    bo.setHighLeve(educationBo.getHighLeve());
                }
                if (null != politicBo) {
                    bo.setPolitic(politicBo.getPolitic());
                }
                String preventPositionName = bo.getPreventPositionName();
                String replace = CollectionUtils.isEmpty((Collection)commissionList) && !CollectionUtils.isEmpty((Collection)preventList) ? this.commonAppend((CommissionPersonBo)bo, PREVENT_TEMPLATE) : (!CollectionUtils.isEmpty((Collection)commissionList) && CollectionUtils.isEmpty((Collection)preventList) ? (HRStringUtils.isEmpty((String)preventPositionName) ? this.commonAppend((CommissionPersonBo)bo, COMMISSION_TEMPLATE) : this.commonAppend((CommissionPersonBo)bo, COMMISSION_AND_PREVENT)) : (HRStringUtils.isEmpty((String)bo.getPreventPositionId()) ? this.commonAppend((CommissionPersonBo)bo, COMMISSION_TEMPLATE) : this.commonAppend((CommissionPersonBo)bo, PREVENT_TEMPLATE)));
                contentBuilder.append(replace).append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            });
        });
        return contentBuilder.toString();
    }

    private String commonAppend(CommissionPersonBo bo, String template) {
        String politic;
        String preventDeptName = HRStringUtils.isEmpty((String)bo.getPreventDeptName()) ? "" : bo.getPreventDeptName();
        String preventPositionName = HRStringUtils.isEmpty((String)bo.getPreventPositionName()) ? "" : bo.getPreventPositionName();
        String currentDept = HRStringUtils.isEmpty((String)bo.getCurrentDept()) ? "" : bo.getCurrentDept();
        String currentPosition = HRStringUtils.isEmpty((String)bo.getCurrentPosition()) ? "" : bo.getCurrentPosition();
        String commissionDeptName = HRStringUtils.isEmpty((String)bo.getCommissionDeptName()) ? "" : bo.getCommissionDeptName();
        String commissionPositionName = HRStringUtils.isEmpty((String)bo.getCommissionPositionName()) ? "" : bo.getCommissionPositionName();
        String personGender = HRStringUtils.isEmpty((String)bo.getPersonGender()) ? "" : bo.getPersonGender();
        String personName = HRStringUtils.isEmpty((String)bo.getPersonName()) ? "" : bo.getPersonName();
        String number = HRStringUtils.isEmpty((String)bo.getNumber()) ? "" : bo.getNumber();
        String birthDay = HRStringUtils.isEmpty((String)bo.getBirthDay()) ? "" : bo.getBirthDay();
        String nation = HRStringUtils.isEmpty((String)bo.getNation()) ? "" : bo.getNation();
        String highLeve = HRStringUtils.isEmpty((String)bo.getHighLeve()) ? "" : bo.getHighLeve();
        String string = politic = HRStringUtils.isEmpty((String)bo.getPolitic()) ? "" : bo.getPolitic();
        if (COMMISSION_TEMPLATE.equals(template)) {
            return ResManager.loadKDString((String)"{0}\uff0c{1}\uff0c{2}\uff0c{3}\uff0c{4}\u51fa\u751f\uff0c{5}\uff0c{6}\uff0c\u73b0\u4efb{7}{8}\uff0c\u62df\u4efb{9}{10}\u3002", (String)"PublicityPrintPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, number, personGender, nation, birthDay, highLeve, politic, currentDept, currentPosition, commissionDeptName, commissionPositionName});
        }
        if (PREVENT_TEMPLATE.equals(template)) {
            return ResManager.loadKDString((String)"\u514d\u53bb{0}\u7684{1}{2}\u804c\u52a1\u3002", (String)"PublicityPrintPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, preventDeptName, preventPositionName});
        }
        return ResManager.loadKDString((String)"{0}\uff0c{1}\uff0c{2}\uff0c{3}\uff0c{4}\u51fa\u751f\uff0c{5}\uff0c{6}\uff0c\u514d\u53bb\u73b0\u4efb\u7684{7}{8}\u804c\u52a1\uff0c\u62df\u4efb{9}{10}\u3002", (String)"PublicityPrintPlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, number, personGender, nation, birthDay, highLeve, politic, preventDeptName, preventPositionName, commissionDeptName, commissionPositionName});
    }
}

