/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.publicity;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class PublicityWindowPlugin
extends HRDynamicFormBasePlugin
implements BeforeF7SelectListener {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit pubFile = (BasedataEdit)this.getView().getControl("pubfile");
        pubFile.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"filepreview"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        IDataModel model = this.getModel();
        Object pubBatchNum = customParams.get("pubbatchnum");
        model.setValue("pubbatchnum", pubBatchNum);
        Object pubFileNum = customParams.get("pubfilenum");
        model.setValue("pubfilenum", pubFileNum);
        model.setValue("pubfile", customParams.get("pubfile"));
        model.setValue("pubstartdate", customParams.get("pubstartdate"));
        model.setValue("pubenddate", customParams.get("pubenddate"));
        model.setValue("pubinstruction", customParams.get("pubinstruction"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IFormView view = this.getView();
        if (HRStringUtils.equals((String)"donothing_publicity", (String)args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            IDataModel model = this.getModel();
            Date startDate = (Date)model.getValue("pubstartdate");
            Date endDate = (Date)model.getValue("pubenddate");
            Date today = HRDateTimeUtils.truncateDate((Date)new Date());
            if (HRDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PublicityWindowPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (Objects.isNull(this.getModel().getDataEntity().getDynamicObject("pubfile"))) {
                return;
            }
            if (HRDateTimeUtils.dayBefore((Date)today, (Date)startDate)) {
                this.returnDataThanRefresh(view, PublicityStatusEnum.BE_EFFECTIVE);
                return;
            }
            if (!HRDateTimeUtils.dayAfter((Date)today, (Date)endDate)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("inPublicity");
                view.showConfirm(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u3002", (String)"PublicityWindowPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            } else {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("completed");
                view.showConfirm(ResManager.loadKDString((String)"\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u5c06\u4e0d\u4f1a\u89e6\u53d1\u516c\u793a\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"PublicityWindowPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String fieldName = control.getKey();
        if ("filepreview".equals(fieldName)) {
            DynamicObject pubFileDy = this.getModel().getDataEntity().getDynamicObject("pubfile");
            if (pubFileDy == null || HRStringUtils.isEmpty((String)pubFileDy.getString("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u516c\u793a\u6a21\u677f\u201d\u3002", (String)"PublicityWindowPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject dataEntity = this.getModel().getDataEntity();
            JSONArray idsArray = (JSONArray)this.getView().getFormShowParameter().getCustomParams().get("ids");
            List selectList = idsArray.toJavaList(Object.class);
            String pinFormId = dataEntity.getString("pubfile.number");
            if (!HRStringUtils.isEmpty((String)pinFormId)) {
                String pdfURL = PRINT_FORM_SERVICE.buildPdfURL(this.getView().getPageId(), "cadm_publicity", PRINT_FORM_SERVICE.createPdfExtParam(dataEntity, selectList, "cadm_publicity"), dataEntity.getString("pubfile.id"));
                PRINT_FORM_SERVICE.previewFile(this.getView(), pdfURL);
            }
        }
    }

    private void returnDataToParent(String pubStatus) {
        HashMap returnMap = Maps.newHashMap();
        IDataModel model = this.getModel();
        returnMap.put("isClose", Boolean.TRUE);
        returnMap.put("pubstartdate", model.getValue("pubstartdate"));
        returnMap.put("pubenddate", model.getValue("pubenddate"));
        returnMap.put("pubfile", model.getDataEntity().getString("pubfile.id"));
        returnMap.put("pubstatus", pubStatus);
        returnMap.put("pubinstruction", model.getValue("pubinstruction"));
        this.getView().returnDataToParent((Object)returnMap);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        IFormView view = this.getView();
        if ("inPublicity".equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.returnDataThanRefresh(view, PublicityStatusEnum.IN_PUBLIC);
        }
        if ("completed".equals(callBackId) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.returnDataThanRefresh(view, PublicityStatusEnum.BE_SUBMIT);
        }
    }

    private void returnDataThanRefresh(IFormView view, PublicityStatusEnum inPublic) {
        this.returnDataToParent(inPublic.getPubStatus());
        view.close();
        view.sendFormAction(view);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u516c\u793a\u6a21\u677f", (String)"PublicityBillEdit_12", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        NOMINATE_COMMON_FORM_SERVICE.commonF7Select(beforeF7SelectEvent);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)"pubstartdate", (String)name) || HRStringUtils.equals((String)"pubenddate", (String)name)) {
            Date startDate = (Date)model.getValue("pubstartdate");
            Date endDate = (Date)model.getValue("pubenddate");
            if (startDate != null && endDate != null && HRDateTimeUtils.dayAfter((Date)startDate, (Date)endDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u516c\u793a\u5f00\u59cb\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u516c\u793a\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"PublicityWindowPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

