/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.release;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class AppointReleaseEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static final String BAR_RELEASE = "release";
    private static final String VALIDATE_DATE = "validateDate";
    private static final String RELEASEDATE_VALIDATE = "dateValidate";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit actvEntity = (BasedataEdit)this.getView().getControl("relsprinttpl");
        actvEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"hyperlinkap"});
        this.addClickListeners(new String[]{"btnrelease"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String releaseBatchId = (String)this.getView().getFormShowParameter().getCustomParam("releaseBatchId");
        String releaseStatus = (String)this.getView().getFormShowParameter().getCustomParam("releasestatus");
        String fileId = (String)this.getView().getFormShowParameter().getCustomParam("fileId");
        Map paramsMap = CastUtils.castMap((Object)this.getView().getFormShowParameter().getCustomParam("paramsMap"), String.class);
        this.getModel().setValue("relsbatchnum", (Object)releaseBatchId);
        this.getModel().setValue("relsfilenum", (Object)fileId);
        this.getModel().setValue("releasestatus", (Object)releaseStatus);
        if (!CollectionUtils.isEmpty((Map)paramsMap)) {
            this.getModel().setValue("releasetime", paramsMap.get("releasetime"));
            this.getModel().setValue("signer", paramsMap.get("signer"));
            this.getModel().setValue("signdate", paramsMap.get("signdate"));
            this.getModel().setValue("relsprinttpl", paramsMap.get("relsprinttpl"));
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Date releaseDate = this.getModel().getDataEntity().getDate("releasetime");
        Date signDate = this.getModel().getDataEntity().getDate("signdate");
        if (this.validateSignDate(releaseDate, signDate)) {
            this.getModel().setValue("signdate", null);
            args.setCancel(true);
            return;
        }
        if (this.validateReleaseDate(releaseDate)) {
            this.getView().getPageCache().put(RELEASEDATE_VALIDATE, RELEASEDATE_VALIDATE);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (VALIDATE_DATE.equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.releaseCore();
            this.getView().close();
        }
    }

    private void releaseCore() {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("relsbatchnum", this.getModel().getValue("relsbatchnum"));
        map.put("relsfilenum", this.getModel().getValue("relsfilenum"));
        map.put("releasetime", this.getModel().getValue("releasetime"));
        map.put("signdate", this.getModel().getValue("signdate"));
        map.put("signer.id", this.getModel().getDataEntity().getLong("signer.id"));
        map.put("relsprinttpl.id", this.getModel().getDataEntity().getString("relsprinttpl.id"));
        this.getModel().setDataChanged(false);
        this.getView().returnDataToParent(map);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getOperationResult().isSuccess() && args.getOperateKey().equals(BAR_RELEASE) && StringUtils.isEmpty((String)this.getView().getPageCache().get(RELEASEDATE_VALIDATE))) {
            this.releaseCore();
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"relsprinttpl", (String)fieldKey)) {
            QFilter entityQFilter = new QFilter("formid.number", "=", (Object)"cadm_appointissue");
            QFilter isEnable = new QFilter("enable", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(entityQFilter);
            beforeF7SelectEvent.addCustomQFilter(isEnable);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        String fileldName = sControl.getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("hyperlinkap".equals(fileldName)) {
            List selectList = CastUtils.castList((Object)this.getView().getFormShowParameter().getCustomParam("releasePkvalueList"), Object.class);
            String formId = dataEntity.getString("relsprinttpl.number");
            if (HRStringUtils.isEmpty((String)formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7b7e\u53d1\u6a21\u677f\u201d\u3002", (String)"AppointReleaseEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
            if (!HRStringUtils.isEmpty((String)formId)) {
                String pdfURL = PRINT_FORM_SERVICE.buildPdfURL(this.getView().getPageId(), "cadm_appointrelease", PRINT_FORM_SERVICE.createPdfExtParam(dataEntity, selectList, "cadm_appointrelease"), dataEntity.getString("relsprinttpl.id"));
                PRINT_FORM_SERVICE.previewFile(this.getView(), pdfURL);
            }
        }
    }

    private boolean validateSignDate(Date releaseDate, Date signDate) {
        if (DateUtil.dayAfter((Date)signDate, (Date)releaseDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7b7e\u53d1\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u53d1\u5e03\u65e5\u671f\u201d\u3002", (String)"AppointReleaseEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateReleaseDate(Date releaseDate) {
        Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
        if ((releaseDate = HRDateTimeUtils.truncateDate((Date)releaseDate)).before(currDate)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(VALIDATE_DATE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d1\u5e03\u65e5\u671f\u201d\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u3002", (String)"AppointReleaseEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return true;
        }
        return false;
    }
}

