/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.release;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class AppointReleaseList
extends HRCoreBaseBillList {
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);
    private static final ReleaseBillApplicationService RELEASE_BILL_APPLICATION_SERVICE = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final AppointBatchRejectFormService REJECT_FORM_SERVICE = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final AppointBatchWithdrawFormService WITHDRAW_FORM_SERVICE = (AppointBatchWithdrawFormService)ServiceFactory.getService(AppointBatchWithdrawFormService.class);
    private static final List<String> STATUS_LIST = Arrays.asList(ReleaseStatusEnum.NOT_TRIGGER.getNum(), ReleaseStatusEnum.DEL.getNum());
    private static final DismissPositionCommonService DISMISS_POSITION_COMMON_SERVICE = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";
    private static final String HAS_RELEASE_PERM = "hasreleaseperm";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"release", "recallrelease", "reject"});
    }

    public void setFilter(SetFilterEvent e) {
        QFilter handlerFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        QFilter statusFilter = new QFilter("releasestatus", "not in", STATUS_LIST);
        e.getQFilters().add(handlerFilter);
        e.getQFilters().add(statusFilter);
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        e.getQFilters().add(appointStatusQFilter);
        e.setOrderBy("releasestatus asc,createtime desc");
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        CadmFormService.CadmListShowHandler listDataProvider = new CadmFormService.CadmListShowHandler((AbstractFormPlugin)this, "handler");
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }

    public void packageData(PackageDataEvent evt) {
        ColumnDesc source = (ColumnDesc)evt.getSource();
        String fieldKey = source.getFieldKey();
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            DISMISS_POSITION_COMMON_SERVICE.packageDismissPositionData(evt, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject[] releaseArr;
        List statusNoOkList;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("listrelease".equals(operateKey) && !CollectionUtils.isEmpty(statusNoOkList = Arrays.stream(releaseArr = this.getSelectRows()).filter(releaseBill -> !ReleaseStatusEnum.canBeRelease((String)releaseBill.getString("releasestatus"))).map(release -> release.getString("billno")).collect(Collectors.toList()))) {
            String errorMess = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", (String)"AppointReleaseList_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(errorMess);
            BosLogService.recordLocalStringOpLogWithOp((IFormView)this.getView(), (String)"cadm_appointrelease", (AbstractOperate)formOperate, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", "AppointReleaseList_5", "tdc-cadm-formplugin"));
            args.setCancel(true);
            return;
        }
        if ("reject".equals(operateKey)) {
            REJECT_FORM_SERVICE.setExportBills(this.queryReleaseBills());
            REJECT_FORM_SERVICE.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
        if ("withdraw".equals(operateKey)) {
            WITHDRAW_FORM_SERVICE.setExportBills(this.queryReleaseBills());
            WITHDRAW_FORM_SERVICE.callValidatorBeforeDoOperation(args, "withdraw", (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("listrelease".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.releaseCore();
        }
        if (operateKey.equals("reject") || operateKey.equals("withdraw")) {
            REJECT_FORM_SERVICE.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actId = closedCallBackEvent.getActionId();
        Map returnMap = CastUtils.castMap((Object)closedCallBackEvent.getReturnData(), String.class);
        if (CollectionUtils.isEmpty((Map)returnMap)) {
            return;
        }
        if ("cadm_releasewindow".equals(actId)) {
            OperationResult hasReleasePerm = this.getView().invokeOperation(HAS_RELEASE_PERM);
            if (hasReleasePerm == null || !hasReleasePerm.isSuccess()) {
                return;
            }
            DynamicObject[] releaseArr = this.getSelectRows();
            List idList = Arrays.stream(releaseArr).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = RELEASE_BILL_APPLICATION_SERVICE.queryReleaseBills("id,billno,relsbatchnum,relsfilenum,releasetime,signer,signdate,relsprinttpl,releasestatus,modifytime,relsdealtime,subhandler,instanceid,billstatus", idList);
            this.noticeMessage(dynamicObjects, actId);
            DynamicObject[] releaseBills = (DynamicObject[])Arrays.stream(dynamicObjects).filter(dynamicObject -> ReleaseStatusEnum.canBeRelease((String)dynamicObject.getString("releasestatus"))).toArray(DynamicObject[]::new);
            RELEASE_BILL_APPLICATION_SERVICE.doReleaseForBatchBill(releaseBills, returnMap);
            this.getView().invokeOperation("refresh");
        }
        if ("withdraw_all".equals(actId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            WITHDRAW_FORM_SERVICE.withdrawAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("withdraw_part".equals(actId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            WITHDRAW_FORM_SERVICE.withdrawPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_all".equals(actId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            REJECT_FORM_SERVICE.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
    }

    private void noticeMessage(DynamicObject[] dynamicObjects, String actId) {
        List statusNotOk = Arrays.stream(dynamicObjects).filter(releaseBill -> !ReleaseStatusEnum.canBeRelease((String)releaseBill.getString("releasestatus"))).map(release -> release.getString("billno")).collect(Collectors.toList());
        List<String> statusOk = Arrays.stream(dynamicObjects).filter(releaseBill -> ReleaseStatusEnum.canBeRelease((String)releaseBill.getString("releasestatus"))).map(release -> release.getString("billno")).collect(Collectors.toList());
        String mess = ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f", (String)"AppointReleaseList_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d1\u5e03", "AppointReleaseList_6", "tdc-cadm-formplugin");
        if (CollectionUtils.isEmpty(statusNotOk)) {
            this.getView().showSuccessNotification(mess);
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_appointrelease", (String)actId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d1\u5e03\u6210\u529f", "AppointReleaseList_9", "tdc-cadm-formplugin"));
            return;
        }
        int failedNum = statusNotOk.size();
        String errorMess = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", (String)"AppointReleaseList_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty(statusNotOk) && failedNum == 1) {
            this.getView().showErrorNotification(errorMess);
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_appointrelease", (String)actId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", "AppointReleaseList_5", "tdc-cadm-formplugin"));
            return;
        }
        ArrayList errorMsgList = Lists.newArrayList();
        int total = dynamicObjects.length;
        int successNum = statusOk.size();
        String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u53d1\u5e03\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"AppointReleaseList_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), total, successNum, failedNum);
        statusOk.forEach(billNo -> errorMsgList.add(billNo + ":" + errorMess));
        CADM_FORM_SERVICE.showBosDefaultOperationResult(title, (List)errorMsgList, this.getView());
        BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_appointrelease", (String)actId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d1\u5e03", "AppointReleaseList_6", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5171{0}\u6761\u5355\u636e\uff0c\u53d1\u5e03\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", "AppointReleaseList_2", "tdc-cadm-formplugin"), null, null, (String[])new String[]{"" + total, "" + successNum, "" + failedNum});
    }

    private void releaseCore() {
        Object[] releaseArr = this.getSelectRows();
        if (HRArrayUtils.isEmpty((Object[])releaseArr)) {
            return;
        }
        String releaseBatchId = CodeRuleServiceHelper.getNumber((String)"cadm_appointrelease", (DynamicObject)this.getModel().getDataEntity(), (String)String.valueOf(RequestContext.get().getOrgId()));
        String fileId = CodeRuleServiceHelper.getNumber((String)"cadm_releasebasebill", (DynamicObject)this.getModel().getDataEntity(), (String)String.valueOf(RequestContext.get().getOrgId()));
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("cadm_releasewindow");
        showParameter.setCustomParam("releaseBatchId", (Object)releaseBatchId);
        showParameter.setCustomParam("fileId", (Object)fileId);
        List billList = Arrays.stream(releaseArr).map(release -> release.getString("billno")).collect(Collectors.toList());
        List billIdList = Arrays.stream(releaseArr).map(release -> release.getLong("id")).collect(Collectors.toList());
        showParameter.setCustomParam("releaseIdList", billList);
        showParameter.setCustomParam("releasePkvalueList", billIdList);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        if (releaseArr.length == 1) {
            paramsMap.put("releasetime", releaseArr[0].get("releasetime"));
            paramsMap.put("signer", releaseArr[0].get("signer"));
            paramsMap.put("signdate", releaseArr[0].get("signdate"));
            paramsMap.put("relsprinttpl", releaseArr[0].get("relsprinttpl"));
        }
        showParameter.setCustomParam("paramsMap", paramsMap);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cadm_releasewindow"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private DynamicObject[] getSelectRows() {
        List pkIds = this.getSelectedRows().stream().map(releaseBill -> (Long)releaseBill.getPrimaryKeyValue()).collect(Collectors.toList());
        return RELEASE_BILL_APPLICATION_SERVICE.getOriginalReleaseBillById("id,billno,releasestatus,relsbatchnum,person.number,person.name,releasetime,signer,signdate,relsprinttpl,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name", pkIds);
    }

    private DynamicObject[] queryReleaseBills() {
        List pkIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        return RELEASE_BILL_APPLICATION_SERVICE.queryReleaseBills("id,billno,releasestatus,relsbatchnum,person.number,person.name,releasetime,signer,signdate,relsprinttpl,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }
}

