/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.release;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.bussiness.util.DateUtil;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchWithdrawFormService;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class AppointReleasePlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static final AppointBatchWithdrawFormService withdrawService = (AppointBatchWithdrawFormService)ServiceFactory.getService(AppointBatchWithdrawFormService.class);
    private static final String RELEASE_CONFIRM = "releaseConfirm";
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ReleaseBillApplicationService releaseBillApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"release"});
        this.addClickListeners(new String[]{"previewfile"});
        BasedataEdit actvEntity = (BasedataEdit)this.getView().getControl("relsprinttpl");
        actvEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        String releaseBatchId;
        super.beforeBindData(e);
        DynamicObject releaseBill = this.getModel().getDataEntity();
        String releaseStatus = releaseBill.getString("releasestatus");
        if (ReleaseStatusEnum.BE_EFFECTIVE.getNum().equals(releaseStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"release", "bar_save"});
        }
        this.getView().setVisible(Boolean.valueOf(ReleaseStatusEnum.canBeRelease((String)releaseStatus)), new String[]{"release"});
        this.getView().setVisible(Boolean.valueOf(ReleaseStatusEnum.canBeWithdraw((String)releaseStatus)), new String[]{"withdraw"});
        if (!HRStringUtils.isEmpty((String)releaseBill.getString("relsbatchnum")) && ReleaseStatusEnum.RE_PUBLICIZED.getNum().equals(this.getModel().getDataEntity().getString("releasestatus"))) {
            releaseBatchId = CodeRuleServiceHelper.readNumber((String)"cadm_appointrelease", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            releaseBill.set("relsbatchnum", (Object)releaseBatchId);
            String fileId = CodeRuleServiceHelper.readNumber((String)"cadm_releasebasebill", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            releaseBill.set("relsfilenum", (Object)fileId);
        }
        if (HRStringUtils.isEmpty((String)releaseBill.getString("relsbatchnum"))) {
            releaseBatchId = CodeRuleServiceHelper.readNumber((String)"cadm_appointrelease", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            releaseBill.set("relsbatchnum", (Object)releaseBatchId);
        }
        if (HRStringUtils.isEmpty((String)releaseBill.getString("relsfilenum"))) {
            String fileId = CodeRuleServiceHelper.readNumber((String)"cadm_releasebasebill", (DynamicObject)releaseBill, (String)String.valueOf(RequestContext.get().getOrgId()));
            releaseBill.set("relsfilenum", (Object)fileId);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        cadmFormService.showBillHead(this.getView(), "headbillinfo");
        this.showPersonInfo();
        this.showAppointInfo();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey)) {
            String oldStatus = this.getModel().getDataEntity().getString("releasestatus");
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            ArrayList<Long> pkIds = new ArrayList<Long>();
            pkIds.add(Long.valueOf(pkValue.toString()));
            DynamicObject[] releaseBill = releaseBillApplicationService.getOriginalReleaseBillById("releasestatus", pkIds);
            if (!Objects.isNull(releaseBill) && !oldStatus.equals(releaseBill[0].getString("releasestatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"AppointReleasePlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
        if ("release".equals(operateKey)) {
            DynamicObject releaseBill = this.getModel().getDataEntity();
            Date releaseDate = releaseBill.getDate("releasetime");
            Date signDate = releaseBill.getDate("signdate");
            if (releaseDate == null || signDate == null) {
                return;
            }
            if (this.validateSignDate(releaseDate, signDate)) {
                args.setCancel(true);
                return;
            }
            if (this.validateReleaseDate(releaseDate)) {
                args.setCancel(true);
                return;
            }
        }
        if ("release".equals(operateKey)) {
            if (this.validateReleaseStauts()) {
                args.setCancel(true);
                return;
            }
            this.getView().invokeOperation("submitafterrelease");
            return;
        }
        if ("withdraw".equals(operateKey)) {
            withdrawService.beforeWithdrawOperationWithSingle(args, (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submitafterrelease".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if ("withdraw".equals(operateKey)) {
            withdrawService.afterWithdrawOperationWithSingle(args, (AbstractFormPlugin)this);
        }
        if ("withdraw".equals(operateKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
            withdrawService.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnMap = CastUtils.castMap((Object)closedCallBackEvent.getReturnData(), String.class);
        String actionId = closedCallBackEvent.getActionId();
        if ("withdraw_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            withdrawService.withdrawAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (RELEASE_CONFIRM.equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().invokeOperation("submitafterrelease");
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)"relsprinttpl", (String)fieldKey)) {
            QFilter entityQFilter = new QFilter("formid.number", "=", (Object)"cadm_appointissue");
            QFilter isEnable = new QFilter("enable", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(entityQFilter);
            beforeF7SelectEvent.addCustomQFilter(isEnable);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control sControl = (Control)evt.getSource();
        String fileldName = sControl.getKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("previewfile".equals(fileldName)) {
            String formId = dataEntity.getString("relsprinttpl.number");
            if (HRStringUtils.isEmpty((String)formId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7b7e\u53d1\u6a21\u677f\u201d\u3002", (String)"AppointReleasePlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
            List<Object> selectList = PRINT_FORM_SERVICE.getPkIdList(dataEntity, "relsbatchnum");
            if (!HRStringUtils.isEmpty((String)formId)) {
                String pdfURL = PRINT_FORM_SERVICE.buildPdfURL(this.getView().getPageId(), "cadm_appointrelease", PRINT_FORM_SERVICE.createPdfExtParam(dataEntity, selectList, "cadm_appointrelease"), dataEntity.getString("relsprinttpl.id"));
                PRINT_FORM_SERVICE.previewFile(this.getView(), pdfURL);
            }
        }
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)pkId);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        long currUserId;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)Long.valueOf(pkId));
        }
        ArrayList pkIds = Lists.newArrayList((Object[])new Long[]{(Long)billShowParameter.getPkId()});
        DynamicObject[] bills = releaseBillApplicationService.getOriginalReleaseBillById("releasestatus,handler.fbasedataid_id,person.name", (List)pkIds);
        DynamicObject bill = bills[0];
        String releaseStatus = bill.getString("releasestatus");
        if (ReleaseStatusEnum.NOT_TRIGGER.getNum().equals(releaseStatus)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"AppointReleasePlugin_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List userIds = Arrays.stream(bills).map(p -> p.getLong("handler.fbasedataid_id")).collect(Collectors.toList());
        if (!userIds.contains(currUserId = RequestContext.get().getCurrUserId())) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AppointReleasePlugin_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (ReleaseStatusEnum.COMPLETED.getNum().equals(releaseStatus) || ReleaseStatusEnum.TERMINATED.getNum().equals(releaseStatus)) {
            billShowParameter.setStatus(OperationStatus.VIEW);
        }
        String personName = bill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u53d1\u5e03-{0}", (String)"AppointReleasePlugin_10", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }

    private void showPersonInfo() {
        cadmFormService.showPersonInfoCard(this.getView(), "personpanel");
    }

    private void showAppointInfo() {
        ArrayList<String> pageList = new ArrayList<String>();
        pageList.add("recommendedsourceflex");
        pageList.add("attachmentpanel");
        cadmFormService.showAppointInfoFlex(this.getView(), "appointinfo", pageList);
    }

    private boolean validateSignDate(Date releaseDate, Date signDate) {
        if (DateUtil.dayAfter((Date)signDate, (Date)releaseDate)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u7b7e\u53d1\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u53d1\u5e03\u65e5\u671f\u201d\u3002", (String)"AppointReleasePlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean validateReleaseDate(Date releaseDate) {
        Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
        if ((releaseDate = HRDateTimeUtils.truncateDate((Date)releaseDate)).before(currDate)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(RELEASE_CONFIRM);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d1\u5e03\u65e5\u671f\u201d\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\uff0c\u8bf7\u8c28\u614e\u9009\u62e9\u3002", (String)"AppointReleasePlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            return true;
        }
        return false;
    }

    private boolean validateReleaseStauts() {
        String releaseStatus = this.getModel().getDataEntity().getString("releasestatus");
        if (!ReleaseStatusEnum.BE_RELEASE.getNum().equals(releaseStatus) && !ReleaseStatusEnum.RE_PUBLICIZED.getNum().equals(releaseStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u63d0\u4ea4\u53d1\u5e03\u72b6\u6001\u4e3a\u201c\u5f85\u53d1\u5e03/\u5f85\u91cd\u65b0\u53d1\u5e03\u201d\u7684\u6570\u636e\u3002", (String)"AppointReleasePlugin_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }
}

