/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.release;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyKindEnum;
import kd.tdc.cadm.common.bo.CommissionPersonBo;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class PublishPrintPlugin
extends AbstractPrintPlugin {
    private static final PrintFormService PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
    private static String PUBLISH = "publish";

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        if (!PUBLISH.equals(dataSource.getDsName())) {
            return;
        }
        this.publishData(evt);
    }

    private void publishData(CustomDataLoadEvent evt) {
        Date releaseTime;
        Map<String, List<DynamicObject>> map;
        List customDataRows = evt.getCustomDataRows();
        Map extParam = this.getExtParam();
        Object targetEntityName = extParam.get("entity");
        if ("cadm_appointrelease".equals(targetEntityName)) {
            map = PRINT_FORM_SERVICE.getReleaseBills(extParam, "cadm_appointrelease");
            releaseTime = (Date)extParam.get("releasetime");
        } else {
            map = PRINT_FORM_SERVICE.getReleaseBills(extParam, "cadm_appointissue");
            releaseTime = (Date)extParam.get("issuetime");
        }
        List<DynamicObject> preventList = map.get(ApplyKindEnum.DISMISS.getNumber());
        List<DynamicObject> commissionList = map.get(ApplyKindEnum.APPOINT.getNumber());
        if (CollectionUtils.isEmpty(commissionList) && CollectionUtils.isEmpty(preventList)) {
            return;
        }
        List<CommissionPersonBo> boList = PRINT_FORM_SERVICE.parseToBo(commissionList);
        boList.addAll(PRINT_FORM_SERVICE.parseToBo(preventList));
        String content = this.appendContent(boList, commissionList, preventList);
        DataRowSet dataRowSet = new DataRowSet();
        String title = this.getTitle(commissionList, preventList);
        dataRowSet.put("title", (Field)new TextField(title));
        dataRowSet.put("content", (Field)new TextField(content));
        dataRowSet.put("date", (Field)new TextField(PRINT_FORM_SERVICE.getCommonDate(releaseTime)));
        customDataRows.add(dataRowSet);
    }

    public String getTitle(List<DynamicObject> commissionList, List<DynamicObject> preventList) {
        String company = PRINT_FORM_SERVICE.getOrgRootName();
        if (HRStringUtils.isEmpty((String)company)) {
            return "";
        }
        String title = !CollectionUtils.isEmpty(preventList) && CollectionUtils.isEmpty(commissionList) ? ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u514d\u804c\u901a\u77e5", (String)"PublishPrintPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}) : (CollectionUtils.isEmpty(preventList) && !CollectionUtils.isEmpty(commissionList) ? ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u4efb\u547d\u901a\u77e5", (String)"PublishPrintPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}) : ResManager.loadKDString((String)"\u5173\u4e8e{0}\u7684\u4eba\u4e8b\u4efb\u514d\u901a\u77e5", (String)"PublishPrintPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{company}));
        return String.format(title, company);
    }

    private String appendContent(List<CommissionPersonBo> boList, List<DynamicObject> commissionList, List<DynamicObject> preventList) {
        Map<Long, List<CommissionPersonBo>> boMap = boList.stream().collect(Collectors.groupingBy(CommissionPersonBo::getPersonId));
        Set personIdSet = boList.stream().map(CommissionPersonBo::getPersonId).collect(Collectors.toSet());
        Map personBaseInfo = ExternalDataService.getPersonBaseInfo(personIdSet);
        StringBuilder contentBuilder = new StringBuilder();
        boMap.forEach((personId, list) -> {
            CommissionPersonBo commissionPersonBo = (CommissionPersonBo)personBaseInfo.get(personId);
            String personGender = commissionPersonBo.getPersonGender();
            String personName = commissionPersonBo.getPersonName();
            list.forEach(bo -> {
                String preventPositionName;
                String replace = CollectionUtils.isEmpty((Collection)commissionList) && !CollectionUtils.isEmpty((Collection)preventList) ? ResManager.loadKDString((String)"\u514d\u53bb{0},{1},{2}{3}", (String)"PublishPrintPlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getPreventDeptName(), bo.getPreventPositionName()}) : (!CollectionUtils.isEmpty((Collection)commissionList) && CollectionUtils.isEmpty((Collection)preventList) ? (HRStringUtils.isEmpty((String)(preventPositionName = bo.getPreventPositionName())) ? ResManager.loadKDString((String)"\u4efb\u547d{0}\uff0c{1}\uff0c\u4e3a{2}{3}", (String)"PublishPrintPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getCommissionDeptName(), bo.getCommissionPositionName()}) : ResManager.loadKDString((String)"\u4efb\u547d{0}\uff0c{1}\uff0c\u4e3a{2}{3}\uff0c\u8bd5\u7528\u671f{4}{5}\uff0c\u540c\u65f6\u514d\u53bb\u5176{6}{7}\u804c\u52a1", (String)"PublishPrintPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getCommissionDeptName(), bo.getCommissionPositionName(), bo.getPlanNum(), bo.getPlanUnit(), bo.getPreventDeptName(), bo.getPreventPositionName()})) : (HRStringUtils.isNotEmpty((String)bo.getPreventPositionName()) && HRStringUtils.isNotEmpty((String)bo.getCommissionPositionName()) ? ResManager.loadKDString((String)"\u4efb\u547d{0}\uff0c{1}\uff0c\u4e3a{2}{3}\uff0c\u8bd5\u7528\u671f{4}{5}\uff0c\u540c\u65f6\u514d\u53bb\u5176{6}{7}\u804c\u52a1", (String)"PublishPrintPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getCommissionDeptName(), bo.getCommissionPositionName(), bo.getPlanNum(), bo.getPlanUnit(), bo.getPreventDeptName(), bo.getPreventPositionName()}) : (HRStringUtils.isBlank((CharSequence)bo.getPreventPositionName()) && HRStringUtils.isNotEmpty((String)bo.getCommissionPositionName()) ? ResManager.loadKDString((String)"\u4efb\u547d{0}\uff0c{1}\uff0c\u4e3a{2}{3}", (String)"PublishPrintPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getCommissionDeptName(), bo.getCommissionPositionName()}) : ResManager.loadKDString((String)"\u514d\u53bb{0},{1},{2}{3}", (String)"PublishPrintPlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName, personGender, bo.getPreventDeptName(), bo.getPreventPositionName()}))));
                contentBuilder.append(replace).append(",").append(System.getProperty("line.separator")).append(System.getProperty("line.separator"));
            });
        });
        int i = contentBuilder.lastIndexOf(",");
        StringBuilder replace = contentBuilder.replace(i, i + 1, "\u3002");
        return replace.toString();
    }
}

