/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.AfterShowTipsEvent;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.control.events.TipsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.CadreResumeApplicationService;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;
import kd.tdc.cadm.formplugin.web.formservice.PrintFormService;

public class CadreResumePlugin
extends HRCoreBaseBillEdit
implements TipsListener {
    private static final Log LOG = LogFactory.getLog(CadreResumePlugin.class);
    private static final String VIEW_LIMIT = "47150e89000000ac";
    private static final String LOOK_INSTRUCTION = "lookeditdesc";
    private static final String WIFE_FLEX = "sflex";
    private static final String YES = "Yes";
    private static final String USE_NEW_DADA = "usenewdata";
    private static final String USE_NEW_DADA_BEFORE = "usenewdatabefore";
    private static final String LEARN_GET_NEWDATA = "learngetnewdata";
    private static final String WORK_GET_NEWDATA = "workgetnewdata";
    private static final String FAMILY_GET_NEWDATA = "familygetnewdata";
    private static final String LEARN_ENTRY = "learnentryentity";
    private static final String WORK_ENTRY = "workentryentity";
    private static final String FAMILY_ENTRY = "familyentryentity";
    private static final String PRINT = "formprint";
    private static final String WORK_TONOW_SELECT = "worktonowselect";
    private static final String WORK_ENDDATE_SHOW = "enddateshow";
    private static final String WORK_ENDDATE = "enddate";
    private static final String LEARN_TONOW_SELECT = "learntonowselect";
    private static final String GRADUATION_DATE_SHOW = "gradutiondateshow";
    private static final String GRADUATION_DATE = "gradutiondate";
    private static final String SUPERIOR_NAME = "superior.name";
    private static final String SUPERIOR_HEADSCULPTURE = "superior.headsculpture";
    private static List<String> TEXT_TIPS_LIST;
    private static List<String> DATE_TIPS_LIST;
    private static List<String> BASEDATA_TIPS_LIST;
    private static final Map<String, String> ANCHOR_MAP;
    public static List<String> DELETE_BTN_LIST;
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE;
    private static final CadmFormService cadmFormService;
    private static final PrintFormService PRINT_FORM_SERVICE;
    private static final CadreResumeApplicationService CADRE_RESUME_APPLICATION_SERVICE;
    private static final Map<String, String> MAPPING;
    private static final List<String> WIFE_FIELD_LIST;

    public CadreResumePlugin() {
        DELETE_BTN_LIST = Lists.newArrayList((Object[])new String[]{"learnentryentitydelete", "workentryentitydelete", "entryentitydelete", "familyentryentitydelete", "cadresocialreentryentitydelete"});
        ANCHOR_MAP.put("headflex", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreResumePlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("personinfoanchor", ResManager.loadKDString((String)"\u4e2a\u4eba\u57fa\u672c\u60c5\u51b5", (String)"CadreResumePlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("learnresume", ResManager.loadKDString((String)"\u5b66\u4e60\u7b80\u5386", (String)"CadreResumePlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("workresume", ResManager.loadKDString((String)"\u5de5\u4f5c\u7ecf\u5386", (String)"CadreResumePlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("advconap", ResManager.loadKDString((String)"\u5f53\u9009\u4f1a\u8bae\u3001\u515a\u6d3e\u4ee3\u8868\u3001\u59d4\u5458\u60c5\u51b5", (String)"CadreResumePlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("labelap", ResManager.loadKDString((String)"\u5bb6\u5ead\u6210\u5458", (String)"CadreResumePlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("advconap1", ResManager.loadKDString((String)"\u91cd\u8981\u793e\u4f1a\u5173\u7cfb\u60c5\u51b5", (String)"CadreResumePlugin_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("advconap2", ResManager.loadKDString((String)"\u5176\u4ed6\u9700\u8981\u8bf4\u660e\u7684\u60c5\u51b5", (String)"CadreResumePlugin_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        ANCHOR_MAP.put("signatureinfo", ResManager.loadKDString((String)"\u5c65\u5386\u7b7e\u540d\u548c\u65e5\u671f\u4fe1\u606f", (String)"CadreResumePlugin_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        TEXT_TIPS_LIST = Lists.newArrayList((Object[])new String[]{"workunit", "position", "formername", "nativeplace", "birthplace", "idnumber", "ftdegree", "ftcollegedeptmajor", "inservicedegree", "iscollegedeptmajor", "workunitposition", "firstworktimeunit", "dutytitle", "religion", "langskill", "sname"});
        DATE_TIPS_LIST = Lists.newArrayList((Object[])new String[]{"birthday"});
        BASEDATA_TIPS_LIST = Lists.newArrayList((Object[])new String[]{"folk", "marriagestatus", "healthstatus"});
        MAPPING.put(LEARN_GET_NEWDATA, "cadm_resumelearn,learnentryentity");
        MAPPING.put(WORK_GET_NEWDATA, "cadm_resumework,workentryentity");
        MAPPING.put(FAMILY_GET_NEWDATA, "cadm_resumefamily,familyentryentity");
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        DynamicObject person;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        long pkId = Long.parseLong(billShowParameter.getPkId().toString());
        DynamicObject[] dynamicObjects = CADRE_RESUME_APPLICATION_SERVICE.queryBills("person", (List)Lists.newArrayList((Object[])new Object[]{pkId}));
        String defaultCaption = ResManager.loadKDString((String)"\u5e72\u90e8\u5c65\u5386", (String)"CadreResumePlugin_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        String name = "";
        if (null != dynamicObjects && dynamicObjects.length > 0 && null != (person = dynamicObjects[0].getDynamicObject("person"))) {
            name = person.getString("name");
        }
        String caption = HRStringUtils.isEmpty((String)name) ? defaultCaption : defaultCaption + "-" + name;
        billShowParameter.setCaption(caption);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        CADRE_RESUME_COMMON_SERVICE.setAnchorItems(ANCHOR_MAP, this.getView(), "anchorcontrolap");
        this.setTips();
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String number = this.getModel().getDataEntity().getDynamicObject("person").getString("number");
        this.getModel().setValue("workno", (Object)number);
        this.setImmediateSuperior();
        this.viewStatusVisible();
        this.setLenLab();
        CADRE_RESUME_COMMON_SERVICE.showOrHideEndDate(this.getView(), LEARN_ENTRY, GRADUATION_DATE, GRADUATION_DATE_SHOW, LEARN_TONOW_SELECT);
        CADRE_RESUME_COMMON_SERVICE.showOrHideEndDate(this.getView(), WORK_ENTRY, WORK_ENDDATE, WORK_ENDDATE_SHOW, WORK_TONOW_SELECT);
        this.wifeTipsHideOrPerformance();
        this.getModel().setValue("company", this.getModel().getValue("workunit"));
        this.getModel().setValue("positionlabel", this.getModel().getValue("position"));
        this.hideNotValueLabel();
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void hideNotValueLabel() {
        this.getView().setVisible(Boolean.valueOf(null != ((DynamicObject)this.getModel().getValue("employee")).getDynamicObject("laborreltype")), new String[]{"laborreltype"});
        this.getView().setVisible(Boolean.valueOf(null != ((DynamicObject)this.getModel().getValue("employee")).getDynamicObject("laborrelstatus")), new String[]{"laborrelstatus"});
        this.setLabelVisible("poststatus", "poststatus");
        this.setLabelVisible("cadrecategory", "cadrecategory");
        this.setLabelVisible("gendervector", "gender");
        this.setLabelVisible("companyvectorap", "company");
        this.setLabelVisible("adminorgvectorap", "adminorg");
        this.setLabelVisible("positionnamevector", "positionlabel");
    }

    private void setLabelVisible(String labelKey, String valueKey) {
        Object laborType = this.getModel().getValue(valueKey);
        this.getView().setVisible(Boolean.valueOf(null != laborType && HRStringUtils.isNotEmpty((String)laborType.toString())), new String[]{labelKey});
        if (!labelKey.equals(valueKey)) {
            this.getView().setVisible(Boolean.valueOf(null != laborType && HRStringUtils.isNotEmpty((String)laborType.toString())), new String[]{valueKey});
        }
    }

    private void wifeTipsHideOrPerformance() {
        DynamicObject marriageStatus = (DynamicObject)this.getModel().getValue("marriagestatus");
        if (null == marriageStatus) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"wifetip"});
            return;
        }
        long marriageStatusId = HRDyObjectPropUtil.getId((DynamicObject)marriageStatus);
        if (1010L == marriageStatusId) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"wifetip"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"wifetip"});
        }
    }

    private void setLenLab() {
        Object entServiceLenObj = this.getModel().getValue("entservicelen");
        this.setLenCommon(entServiceLenObj, "entservicelenstr");
        Object serviceLen = this.getModel().getValue("servicelen");
        this.setLenCommon(serviceLen, "servicelenstr");
        Object managerLenObj = this.getModel().getValue("manpostservicelen");
        this.setLenCommon(managerLenObj, "manpostservicelenstr");
    }

    private void setLenCommon(Object len, String key) {
        if (null == len) {
            this.getModel().setValue(key, (Object)"-");
            return;
        }
        BigDecimal bigDecimal = new BigDecimal(len.toString());
        BigDecimal resultDecimal = bigDecimal.setScale(1, RoundingMode.HALF_UP);
        String result = ResManager.loadKDString((String)"{0}\u5e74", (String)"CadreResumePlugin_12", (String)"tdc-cadm-formplugin", (Object[])new Object[]{resultDecimal.toString()});
        this.getModel().setValue(key, (Object)result);
    }

    private void viewStatusVisible() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.VIEW.getValue() != status.getValue()) {
            return;
        }
        ArrayList btnList = Lists.newArrayList((Object[])new String[]{"learnaddnewentry", "learndeleteentry", "moveentryup", "moveentrydown", "workaddentry", "workdelete", "workmoveentryup", "workmoveentrydown", "addparyentry", "partydeleteentry", "partymoveentryup", "partymoveentrydown", "familyaddnewentry", "familydeleteentry", "familymoveentryup", "familymoveentrydown", "socialaddnewentry", "socialdeleteentry", "socialmoveentryup", "socialmoveentrydown", "advcontoolbarap2"});
        this.getView().setVisible(Boolean.FALSE, btnList.toArray(new String[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String changeField = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        if ("marriagestatus".equals(changeField)) {
            this.marryChange(changeData);
        }
        this.toNowChange(changeSet, changeField);
        if (changeField.equals("idnumber")) {
            this.idNumberChange();
        }
        if (changeField.equals("workunit")) {
            cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"company"});
            if (changeData.getNewValue() != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"companyvectorap", "company"});
            }
        }
        if (changeField.equals("position")) {
            cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"positionlabel"});
            if (changeData.getNewValue() != null) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"positionnamevector", "positionlabel"});
            }
        }
    }

    private void idNumberChange() {
        Object idNumber = this.getModel().getValue("idnumber");
        if (null == idNumber || HRStringUtils.isBlank((CharSequence)idNumber.toString())) {
            return;
        }
        boolean isPass = ExternalDataService.validateIdNumber((String)idNumber.toString());
        if (!isPass) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\"\u516c\u6c11\u8eab\u4efd\u8bc1\u53f7\"\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"CadreResumePlugin_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
    }

    private void toNowChange(ChangeData[] changeSet, String changeField) {
        if (WORK_TONOW_SELECT.equals(changeField)) {
            this.toNowSelectChange(changeSet, WORK_TONOW_SELECT, WORK_ENDDATE_SHOW, WORK_ENDDATE);
        }
        if (LEARN_TONOW_SELECT.equals(changeField)) {
            this.toNowSelectChange(changeSet, LEARN_TONOW_SELECT, GRADUATION_DATE_SHOW, GRADUATION_DATE);
        }
        if (WORK_ENDDATE_SHOW.equals(changeField)) {
            this.setEndDateShowNotDataChange(WORK_ENTRY, WORK_ENDDATE_SHOW, WORK_ENDDATE, changeSet);
            this.setEndDateValue(WORK_ENDDATE_SHOW, WORK_ENDDATE, WORK_TONOW_SELECT, changeSet);
        }
        if (GRADUATION_DATE_SHOW.equals(changeField)) {
            this.setEndDateShowNotDataChange(LEARN_ENTRY, GRADUATION_DATE_SHOW, GRADUATION_DATE, changeSet);
            this.setEndDateValue(GRADUATION_DATE_SHOW, GRADUATION_DATE, LEARN_TONOW_SELECT, changeSet);
        }
    }

    private void marryChange(ChangeData changeData) {
        DynamicObject newValue = (DynamicObject)changeData.getNewValue();
        DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
        if (null == newValue || newValue.getLong("id") == 1010L) {
            TextEdit textEdit = (TextEdit)this.getControl("sname");
            textEdit.hideTips();
            Boolean repeatMarry = (Boolean)this.getModel().getValue("repeatmarry");
            if (repeatMarry.booleanValue()) {
                this.getModel().setValue("repeatmarry", (Object)Boolean.FALSE);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"wifetip"});
        } else {
            Boolean repeatMarry;
            this.getDataFromCache();
            TextEdit textEdit = (TextEdit)this.getControl("sname");
            textEdit.addTips(this.getTip());
            this.getView().setVisible(Boolean.FALSE, new String[]{"wifetip"});
            if (newValue.getLong("id") != 1020L && (repeatMarry = (Boolean)this.getModel().getValue("repeatmarry")).booleanValue()) {
                this.getModel().setValue("repeatmarry", (Object)Boolean.FALSE);
            }
        }
        if (oldValue != null && oldValue.getLong("id") == 1020L) {
            this.cacheWifeValue();
        }
        this.getView().updateView(WIFE_FLEX);
    }

    private void setEndDateShowNotDataChange(String entryName, String showField, String field, ChangeData[] changeSet) {
        Arrays.stream(changeSet).forEach(changeData -> {
            boolean equals;
            int rowIndex = changeData.getRowIndex();
            Object date = this.getModel().getValue(field, rowIndex);
            Object dateShow = this.getModel().getValue(showField, rowIndex);
            boolean bl = equals = date == null && dateShow == null || date != null && date.equals(dateShow) || dateShow != null && dateShow.equals(date);
            if (equals) {
                cadmFormService.setEntryPropertyNotDataChangedByRow(this.getModel(), entryName, rowIndex, new String[]{showField});
            }
        });
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{GRADUATION_DATE, WORK_ENDDATE, WORK_TONOW_SELECT, LEARN_TONOW_SELECT});
    }

    private void setEndDateValue(String showField, String endDateKey, String selectKey, ChangeData[] changeSet) {
        Arrays.stream(changeSet).forEach(changeData -> {
            DynamicObject dataEntity = changeData.getDataEntity();
            Date endDateShow = dataEntity.getDate(showField);
            Date endDate = dataEntity.getDate(endDateKey);
            int rowIndex = changeData.getRowIndex();
            if (null != endDateShow && HRDateTimeUtils.dayEquals((Date)endDateShow, (Date)endDate)) {
                return;
            }
            if (null != endDateShow && !HRDateTimeUtils.dayEquals((Date)endDateShow, (Date)endDate)) {
                Date newValue = (Date)changeData.getNewValue();
                this.getModel().setValue(endDateKey, (Object)newValue, rowIndex);
            } else {
                boolean select = (Boolean)this.getModel().getValue(selectKey, rowIndex);
                if (select) {
                    IPageCache pageCache = this.getView().getPageCache();
                    Object endDateObj = this.getModel().getValue(endDateKey, rowIndex);
                    if (null != endDateObj && !HRDateTimeUtils.format((Date)((Date)endDateObj), (String)"yyyy").equals("2999")) {
                        String endDateStr = HRDateTimeUtils.format((Date)((Date)endDateObj), (String)"yyyy.MM.dd");
                        String key = this.getModel().getDataEntity().getPkValue() + endDateKey + rowIndex;
                        pageCache.put(key, endDateStr);
                    }
                    Date maxEndDate = null;
                    try {
                        maxEndDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
                    }
                    catch (ParseException e) {
                        LOG.error("setEndDateValue parse max end date error ", (Throwable)e);
                    }
                    this.getModel().setValue(endDateKey, (Object)maxEndDate, rowIndex);
                } else {
                    this.getModel().setValue(endDateKey, null);
                }
            }
        });
    }

    private void toNowSelectChange(ChangeData[] changeSet, String selectKey, String lockShowKey, String endDateKey) {
        Arrays.stream(changeSet).forEach(changeData -> {
            DynamicObject dataEntity = changeData.getDataEntity();
            boolean selectValue = dataEntity.getBoolean(selectKey);
            int rowIndex = changeData.getRowIndex();
            if (selectValue) {
                this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{lockShowKey});
                this.getModel().setValue(lockShowKey, null, rowIndex);
                try {
                    Date maxEndDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
                    this.getModel().setValue(endDateKey, (Object)maxEndDate, rowIndex);
                }
                catch (ParseException e) {
                    LOG.error("parse MAX_ENDDATE error ", (Throwable)e);
                }
            } else {
                this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{lockShowKey});
                Date end = (Date)this.getModel().getValue(endDateKey);
                this.getEndDateFromCache(end, endDateKey, lockShowKey, rowIndex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getEndDateFromCache(Date currentEnd, String endDateKey, String lockShowKey, int rowIndex) {
        if (null == currentEnd || HRDateTimeUtils.format((Date)currentEnd, (String)"yyyy").equals("2999")) {
            String key = this.getModel().getDataEntity().getPkValue() + endDateKey + rowIndex;
            String endDateStr = this.getView().getPageCache().get(key);
            Date endDate = null;
            if (HRStringUtils.isNotEmpty((String)endDateStr)) {
                try {
                    endDate = HRDateTimeUtils.parseDate((String)endDateStr, (String)"yyyy.MM.dd");
                }
                catch (ParseException e) {
                    LOG.error("toNowSelectChange parse date from cache error {}", (Object)endDateStr, (Object)e);
                }
                finally {
                    this.getView().getPageCache().remove(key);
                }
            }
            this.getModel().setValue(lockShowKey, (Object)endDate, rowIndex);
            if (HRDateTimeUtils.format((Date)currentEnd, (String)"yyyy").equals("2999") && endDate == null) {
                this.getModel().setValue(endDateKey, null);
            }
            this.getView().getPageCache().remove(key);
        } else {
            this.getModel().setValue(lockShowKey, (Object)currentEnd, rowIndex);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (USE_NEW_DADA.equals(callBackId) && YES.equals(messageBoxClosedEvent.getResultValue())) {
            String tipsNewDataCache = this.getView().getPageCache().get("tipsNewDataCache");
            Map paramMap = (Map)SerializationUtils.deSerializeFromBase64((String)tipsNewDataCache);
            paramMap.forEach((key, value) -> this.getModel().setValue(key, value));
        }
        if (DELETE_BTN_LIST.contains(callBackId) && YES.equals(messageBoxClosedEvent.getResultValue())) {
            this.getView().getPageCache().put(callBackId, "1");
            this.getView().invokeOperation(callBackId);
            this.getView().getPageCache().remove(callBackId);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ArrayList fieldList;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (USE_NEW_DADA_BEFORE.equals(actionId) && null != returnData) {
            this.getView().getPageCache().put("tipsNewDataCache", SerializationUtils.serializeToBase64((Object)returnData));
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(USE_NEW_DADA, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5f53\u524d\u6570\u636e\u5c06\u88ab\u8986\u76d6\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CadreResumePlugin_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
        }
        if (LEARN_GET_NEWDATA.equals(actionId) && null != returnData) {
            fieldList = Lists.newArrayList((Object[])new String[]{"admissiondate", GRADUATION_DATE, GRADUATION_DATE_SHOW, LEARN_TONOW_SELECT, "graduation", "collegedeptmajor", "learnreterence", "learnchangevalue"});
            this.updateEntry(fieldList, LEARN_ENTRY, returnData);
            cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{GRADUATION_DATE, GRADUATION_DATE_SHOW, LEARN_TONOW_SELECT});
        }
        if (WORK_GET_NEWDATA.equals(actionId) && null != returnData) {
            fieldList = Lists.newArrayList((Object[])new String[]{"startdate", WORK_ENDDATE, WORK_ENDDATE_SHOW, WORK_TONOW_SELECT, "unitname", "workreterence", "workchangevalue"});
            this.updateEntry(fieldList, WORK_ENTRY, returnData);
            cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{WORK_ENDDATE, WORK_ENDDATE_SHOW, WORK_TONOW_SELECT});
        }
        if (FAMILY_GET_NEWDATA.equals(actionId) && null != returnData) {
            fieldList = Lists.newArrayList((Object[])new String[]{"familymembship", "familymembername", "familybirthday", "familypoliticalstatus", "familyworkunitposition"});
            this.updateEntry(fieldList, FAMILY_ENTRY, returnData);
        }
        if (PRINT.equals(actionId) && null != returnData) {
            PRINT_FORM_SERVICE.previewFile(this.getView(), returnData.toString(), ShowType.MainNewTabPage);
        }
    }

    private void updateEntry(List<String> fieldList, String entryName, Object returnData) {
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)returnData;
        CADRE_RESUME_COMMON_SERVICE.coverUpdateEntry(this.getView(), dynamicObjectCollection, fieldList, entryName);
    }

    public void beforeShowTips(BeforeShowTipsEvent beforeShowTipsEvent) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)VIEW_LIMIT);
        if (!hasPerm) {
            beforeShowTipsEvent.setCancel(true);
            return;
        }
        FormShowParameter formshowParameter = beforeShowTipsEvent.getFormshowParameter();
        if (formshowParameter == null) {
            formshowParameter = new FormShowParameter();
            beforeShowTipsEvent.setFormshowParameter(formshowParameter);
        }
        formshowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, USE_NEW_DADA_BEFORE));
    }

    public void afterShowTips(AfterShowTipsEvent afterShowTipsEvent) {
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IPageCache pageCache = this.getView().getPageCache();
        Object entryEntityName = e.getVarMap().get("entryProp.name");
        String callId = entryEntityName + "delete";
        String result = pageCache.get(callId);
        if ("1".equals(result)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntityName.toString());
        int[] rowIndex = e.getRowIndexs();
        ArrayList rowResult = Lists.newArrayListWithCapacity((int)rowIndex.length);
        for (int index : rowIndex) {
            rowResult.add(CADRE_RESUME_COMMON_SERVICE.autoDeleteEmptyRow(index, dynamicObjectCollection));
        }
        if (rowResult.contains(true)) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(callId, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5df2\u9009\u4e2d\u7684\u6570\u636e\u5c06\u88ab\u5220\u9664\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"CadreResumePlugin_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
            e.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TEXT_TIPS_LIST.forEach(field -> {
            TextEdit textEdit = (TextEdit)this.getControl((String)field);
            textEdit.addTipsListener((TipsListener)this);
        });
        DATE_TIPS_LIST.forEach(field -> {
            DateEdit dateEdit = (DateEdit)this.getControl((String)field);
            dateEdit.addTipsListener((TipsListener)this);
        });
        BASEDATA_TIPS_LIST.forEach(field -> {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl((String)field);
            basedataEdit.addTipsListener((TipsListener)this);
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            this.setEndDate(LEARN_ENTRY, GRADUATION_DATE_SHOW, GRADUATION_DATE, LEARN_TONOW_SELECT, "learnchangevalue");
            this.setEndDate(WORK_ENTRY, WORK_ENDDATE_SHOW, WORK_ENDDATE, WORK_TONOW_SELECT, "workchangevalue");
            DynamicObject marriageStatus = (DynamicObject)this.getModel().getValue("marriagestatus");
            if (null != marriageStatus && HRDyObjectPropUtil.getId((DynamicObject)marriageStatus) == 1010L) {
                String key = this.getModel().getDataEntity().getPkValue().toString();
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.remove(key);
            }
        }
        if (PRINT.equals(operateKey)) {
            this.autoSaveDeleteEmptyRow();
        }
    }

    private void autoSaveDeleteEmptyRow() {
        DynamicObjectCollection learnEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(LEARN_ENTRY);
        DynamicObjectCollection workEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(WORK_ENTRY);
        DynamicObjectCollection familyEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(FAMILY_ENTRY);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObjectCollection socialEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("cadresocialreentryentity");
        this.setDeleteEntry(learnEntryEntity, workEntryEntity, familyEntryEntity, entryEntity, socialEntryEntity);
    }

    private void setDeleteEntry(DynamicObjectCollection ... collections) {
        Arrays.stream(collections).forEach(collection -> {
            ArrayList needDeleteRowList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                collection.forEach(dynamicObject -> {
                    int seq = dynamicObject.getInt("seq");
                    int index = Math.max(seq - 1, 0);
                    if (!CADRE_RESUME_COMMON_SERVICE.autoDeleteEmptyRow(index, (DynamicObjectCollection)collection)) {
                        needDeleteRowList.add(index);
                    }
                });
                int[] indexArrays = Arrays.stream(needDeleteRowList.toArray(new Integer[0])).mapToInt(Integer::valueOf).toArray();
                this.getModel().deleteEntryRows(((DynamicObject)collection.get(0)).getDataEntityType().getName(), indexArrays);
            }
        });
    }

    private void setEndDate(String entryEntityName, String endDateShowKey, String endDateKey, String selectKey, String changeField) {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(entryEntityName);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        try {
            Date maxEndDate = HRDateTimeUtils.parseDate((String)"2999-12-31", (String)"yyyy-MM-dd");
            entryEntity.forEach(dynamicObject -> {
                Date endDate = dynamicObject.getDate(endDateShowKey) == null && dynamicObject.getBoolean(selectKey) ? maxEndDate : dynamicObject.getDate(endDateShowKey);
                dynamicObject.set(endDateKey, (Object)endDate);
                if (null == endDate) {
                    return;
                }
                String formatEndDate = HRDateTimeUtils.format((Date)endDate, (String)"yyyy-MM-dd");
                if ("2999-12-31".equals(formatEndDate)) {
                    dynamicObject.set(changeField, (Object)CADRE_RESUME_COMMON_SERVICE.getToNow());
                } else {
                    dynamicObject.set(changeField, (Object)formatEndDate);
                }
            });
        }
        catch (ParseException e) {
            LOG.error("parse MAX_ENDDATE error ", (Throwable)e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (MAPPING.containsKey(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            long currUserId = RequestContext.get().getCurrUserId();
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)VIEW_LIMIT);
            if (!hasPerm) {
                return;
            }
            CADRE_RESUME_COMMON_SERVICE.showNewDataEntry(this.getView(), MAPPING.get(operateKey).split(",")[0], MAPPING.get(operateKey).split(",")[1], operateKey, (IFormPlugin)this);
        }
        if (LOOK_INSTRUCTION.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            FormShowParameter formShowParameter = CADRE_RESUME_COMMON_SERVICE.showForm("cadm_resumeinstruction");
            this.getView().showForm(formShowParameter);
        }
        if (PRINT.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.showPrintWindow();
        }
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.setLenLab();
        }
    }

    private void showPrintWindow() {
        FormShowParameter formShowParameter = CADRE_RESUME_COMMON_SERVICE.showForm("cadm_resumeprint");
        HashMap paramMap = Maps.newHashMap();
        ArrayList pkIdList = Lists.newArrayList((Object[])new Object[]{this.getModel().getDataEntity().getPkValue()});
        paramMap.put("id", pkIdList);
        formShowParameter.setCustomParams((Map)paramMap);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PRINT));
        this.getView().showForm(formShowParameter);
    }

    private void cacheWifeValue() {
        IPageCache pageCache = this.getView().getPageCache();
        HashMap cacheMap = Maps.newHashMap();
        WIFE_FIELD_LIST.forEach(field -> cacheMap.put(field, this.getModel().getValue(field)));
        pageCache.put(this.getModel().getDataEntity().getPkValue().toString(), SerializationUtils.serializeToBase64((Object)cacheMap));
    }

    private void getDataFromCache() {
        String key;
        IPageCache pageCache = this.getView().getPageCache();
        if (pageCache.get(key = this.getModel().getDataEntity().getPkValue().toString()) == null) {
            return;
        }
        Map cacheMap = (Map)SerializationUtils.deSerializeFromBase64((String)pageCache.get(key));
        WIFE_FIELD_LIST.forEach(field -> this.getModel().setValue(field, cacheMap.get(field)));
        pageCache.remove(key);
        cadmFormService.setPropertyNotDataChanged(this.getModel(), WIFE_FIELD_LIST.toArray(new String[0]));
    }

    private void setTips() {
        TEXT_TIPS_LIST.forEach(field -> {
            if ("sname".equals(field) && !this.isGetMarried()) {
                return;
            }
            TextEdit textEdit = (TextEdit)this.getControl((String)field);
            textEdit.addTips(this.getTip());
        });
        DATE_TIPS_LIST.forEach(field -> {
            DateEdit dateEdit = (DateEdit)this.getControl((String)field);
            dateEdit.addTips(this.getTip());
        });
        BASEDATA_TIPS_LIST.forEach(field -> {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl((String)field);
            basedataEdit.addTips(this.getTip());
        });
    }

    private boolean isGetMarried() {
        Object marriedStatus = this.getModel().getValue("marriagestatus");
        if (null == marriedStatus) {
            return Boolean.FALSE;
        }
        long marriedStatusId = ((DynamicObject)marriedStatus).getLong("id");
        if (1010L == marriedStatusId) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private Tips getTip() {
        Tips tips = new Tips();
        tips.setTriggerType("hover");
        tips.setType("bill");
        tips.setBillno("cadm_resumetips");
        tips.setIconClassName("kdfont kdfont-lishichaxun");
        tips.setShowIcon(true);
        return tips;
    }

    private void setImmediateSuperior() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject person = dataEntity.getDynamicObject("person");
        long personId = HRDyObjectPropUtil.getId((DynamicObject)person);
        Map primaryEmpposorgrel = ExternalDataService.queryPrimaryEmpposorgrel((Long)personId);
        Long depempId = (Long)primaryEmpposorgrel.get("depemp_id");
        Map superiorList = ExternalDataService.getDirectSuperiorByDepEmpId((List)Lists.newArrayList((Object[])new Long[]{depempId}));
        if (superiorList != null && superiorList.size() > 0) {
            String superiorName = (String)((Map)((List)superiorList.get(depempId)).get(0)).get(SUPERIOR_NAME);
            String supHeadSculpture = (String)((Map)((List)superiorList.get(depempId)).get(0)).get(SUPERIOR_HEADSCULPTURE);
            Label label = (Label)this.getControl("supername");
            label.setText(superiorName);
            Image image = (Image)this.getControl("superiorimage");
            image.setUrl(HRImageUrlUtil.getImageFullUrl((String)supHeadSculpture));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"superiorflex"});
        }
    }

    static {
        ANCHOR_MAP = Maps.newLinkedHashMap();
        CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
        cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
        PRINT_FORM_SERVICE = (PrintFormService)ServiceFactory.getService(PrintFormService.class);
        CADRE_RESUME_APPLICATION_SERVICE = (CadreResumeApplicationService)ServiceFactory.getService(CadreResumeApplicationService.class);
        MAPPING = Maps.newHashMap();
        WIFE_FIELD_LIST = Lists.newArrayList((Object[])new String[]{"sname", "sflok", "snativeplace", "sbirthday", "sjoinworktime", "spoliticalstatus", "sbirthplace", "sproftechposition", "seducation", "scollegedeptmajor", "sworkunitposition"});
    }
}

