/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.CustomDataLoadEvent;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.CadreResumeApplicationService;

public class CadreResumePrintPlugin
extends AbstractPrintPlugin {
    private static final String LEARN_ENTRY = "learn";
    private static final String WORK_ENTRY = "work";
    private static final String MARRY_STATUS = "marrystatus";
    private static final String WRITE_DATE = "writedate";
    private static final String APPROVE_DATE = "approvedate";
    private static final List<String> SELF_DS_LIST = Lists.newArrayList((Object[])new String[]{"learn", "work", "marrystatus", "writedate", "approvedate"});
    private static final CadreResumeApplicationService CADRE_RESUME_APPLICATION_SERVICE = (CadreResumeApplicationService)ServiceFactory.getService(CadreResumeApplicationService.class);

    public void loadCustomData(CustomDataLoadEvent evt) {
        super.loadCustomData(evt);
        CustomDataSource dataSource = evt.getDataSource();
        String dsName = dataSource.getDsName();
        if (!SELF_DS_LIST.contains(dsName)) {
            return;
        }
        Map extParam = this.getExtParam();
        Object id = extParam.get("ids");
        List customDataRows = evt.getCustomDataRows();
        this.initData(dsName, id, customDataRows);
    }

    private void initData(String dsName, Object pkId, List<DataRowSet> customDataRows) {
        if (LEARN_ENTRY.equals(dsName) || WORK_ENTRY.equals(dsName)) {
            String selectProperties;
            String entryEntityName;
            if (LEARN_ENTRY.equals(dsName)) {
                entryEntityName = "learnentryentity";
                selectProperties = "learnentryentity.admissiondate,learnentryentity.gradutiondate,learnentryentity.collegedeptmajor,learnentryentity.graduation,learnentryentity.learnreterence";
            } else {
                entryEntityName = "workentryentity";
                selectProperties = "workentryentity.startdate,workentryentity.enddate,workentryentity.unitname,workentryentity.workreterence";
            }
            DynamicObject dynamicObject = CADRE_RESUME_APPLICATION_SERVICE.queryEntryEntityById(selectProperties, pkId);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entryEntityName);
            String toNow = ResManager.loadKDString((String)"\u81f3\u4eca", (String)"CadreResumePrintPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            dynamicObjectCollection.forEach(dynamic -> {
                DataRowSet dataRowSet = new DataRowSet();
                if (LEARN_ENTRY.equals(dsName)) {
                    Date admissionDate = dynamic.getDate("admissiondate");
                    Date graduateDate = dynamic.getDate("gradutiondate");
                    this.dealTime(dataRowSet, admissionDate, graduateDate, toNow);
                    dataRowSet.put("college", (Field)new TextField(dynamic.getString("collegedeptmajor")));
                    dataRowSet.put("gradution", (Field)new TextField(dynamic.getString("graduation")));
                    dataRowSet.put("reference", (Field)new TextField(dynamic.getString("learnreterence")));
                } else {
                    Date startDate = dynamic.getDate("startdate");
                    Date endDate = dynamic.getDate("enddate");
                    this.dealTime(dataRowSet, startDate, endDate, toNow);
                    dataRowSet.put("unitname", (Field)new TextField(dynamic.getString("unitname")));
                    dataRowSet.put("reference", (Field)new TextField(dynamic.getString("workreterence")));
                }
                customDataRows.add(dataRowSet);
            });
        } else if (MARRY_STATUS.equals(dsName)) {
            DynamicObject dynamicObject = CADRE_RESUME_APPLICATION_SERVICE.queryMarryStatus(pkId);
            if (null == dynamicObject) {
                return;
            }
            DynamicObject marriageStatus = dynamicObject.getDynamicObject("marriagestatus");
            if (null == marriageStatus) {
                return;
            }
            String name = marriageStatus.getString("name");
            boolean repeatMarry = dynamicObject.getBoolean("repeatmarry");
            if (repeatMarry) {
                String repeatDes = ResManager.loadKDString((String)"\uff08\u518d\u5a5a\uff09", (String)"CadreResumePrintPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                name = name + repeatDes;
            }
            if (HRStringUtils.isBlank((CharSequence)name)) {
                name = "";
            }
            DataRowSet dataRowSet = new DataRowSet();
            dataRowSet.put("marrystatusdesc", (Field)new TextField(name));
            customDataRows.add(dataRowSet);
        } else if (WRITE_DATE.equals(dsName)) {
            DynamicObject dynamicObject = CADRE_RESUME_APPLICATION_SERVICE.getWriteAndApproveInfo(pkId);
            if (null == dynamicObject) {
                return;
            }
            Date editDate = dynamicObject.getDate("editdate");
            if (null == editDate) {
                return;
            }
            DataRowSet dataRowSet = new DataRowSet();
            dataRowSet.put("writeyearstr", (Field)new TextField(HRDateTimeUtils.format((Date)editDate, (String)"yyyy")));
            dataRowSet.put("writemonthstr", (Field)new TextField(HRDateTimeUtils.format((Date)editDate, (String)"MM")));
            dataRowSet.put("writedatestr", (Field)new TextField(HRDateTimeUtils.format((Date)editDate, (String)"dd")));
            customDataRows.add(dataRowSet);
        } else if (APPROVE_DATE.equals(dsName)) {
            DynamicObject dynamicObject = CADRE_RESUME_APPLICATION_SERVICE.getWriteAndApproveInfo(pkId);
            if (null == dynamicObject) {
                return;
            }
            Date examineDate = dynamicObject.getDate("examinedate");
            if (null == examineDate) {
                return;
            }
            DataRowSet dataRowSet = new DataRowSet();
            dataRowSet.put("approveyearstr", (Field)new TextField(HRDateTimeUtils.format((Date)examineDate, (String)"yyyy")));
            dataRowSet.put("approvemonthstr", (Field)new TextField(HRDateTimeUtils.format((Date)examineDate, (String)"MM")));
            dataRowSet.put("approvedatestr", (Field)new TextField(HRDateTimeUtils.format((Date)examineDate, (String)"dd")));
            customDataRows.add(dataRowSet);
        }
    }

    private void dealTime(DataRowSet dataRowSet, Date start, Date end, String toNow) {
        String startTime = "";
        String endTime = "";
        String format = ResManager.loadKDString((String)"yyyy\u5e74MM\u6708", (String)"CadreResumePrintPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        if (null != start) {
            startTime = HRDateTimeUtils.format((Date)start, (String)format);
        }
        if (null != end && (endTime = HRDateTimeUtils.format((Date)end, (String)format)).contains("2999")) {
            endTime = toNow;
        }
        dataRowSet.put("startEnd", (Field)new TextField(startTime + "-" + endTime));
    }
}

