/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeShowFamilyPlugin
extends HRDynamicFormBasePlugin {
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final List<String> FIELD_LIST = Lists.newArrayList((Object[])new String[]{"familymembship", "familymembername", "familybirthday", "familypoliticalstatus", "familyworkunitposition"});
    private static final String COVER = "familycover";
    private static final String UPDATE_LIMIT = "4715a0df000000ac";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.initData();
        long currUserId = RequestContext.get().getCurrUserId();
        if (!PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)UPDATE_LIMIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usedata"});
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.parentViewStatusVisible(this.getView(), "usedata");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            args.setCancel(true);
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), args);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.entryCoverDoBefore(this.getView(), args, COVER, (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            return;
        }
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CadreResumePrintWindowPlugin".equals(callBackId)) {
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), null);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.coverCallBack(this.getView(), messageBoxClosedEvent, COVER);
    }

    private void initData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        CADRE_RESUME_COMMON_SERVICE.createOriginalEntry(this.getView(), formShowParameter, FIELD_LIST);
        Long personId = (Long)customParams.get("personId");
        HashMap param = Maps.newHashMap();
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"025"}));
        param.put("identifyIdType", "PERID");
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> familyMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_familymemb");
        List<Map<String, Object>> familyMemberList = familyMap.get(personId);
        ArrayList newEntryFields = Lists.newArrayList();
        FIELD_LIST.forEach(field -> newEntryFields.add(field + "new"));
        if (CollectionUtils.isEmpty(familyMemberList) || familyMemberList.size() == 0) {
            return;
        }
        String newEntryName = "entryentitynew";
        TableValueSetter vs = CADRE_RESUME_COMMON_SERVICE.beginCreateEntry(model, newEntryFields, newEntryName);
        familyMemberList.forEach(map -> {
            if (CADRE_RESUME_COMMON_SERVICE.ifWife((Map<String, Object>)map)) {
                return;
            }
            vs.addRow(new Object[]{map.get("familymembship_id"), map.get("name")});
        });
        CADRE_RESUME_COMMON_SERVICE.endCreateEntry(model, newEntryName, vs);
        this.getView().updateView("entryentity");
        this.getView().updateView(newEntryName);
    }
}

