/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeShowLearnPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(CadreResumeShowLearnPlugin.class);
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final List<String> FIELD_LIST = Lists.newArrayList((Object[])new String[]{"admissiondate", "gradutiondate", "gradutiondateshow", "learntonowselect", "graduation", "collegedeptmajor", "learnreterence"});
    private static final String COVER = "learncover";
    private static final String UPDATE_LIMIT = "4715a0df000000ac";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.getView().setStatus(OperationStatus.VIEW);
        this.initData();
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPer = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)UPDATE_LIMIT);
        if (!hasPer) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usedata"});
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.parentViewStatusVisible(this.getView(), "usedata");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CADRE_RESUME_COMMON_SERVICE.showOrHideEndDate(this.getView(), "entryentitynew", "gradutiondatenew", "gradutiondateshownew", "learntonowselectnew");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            args.setCancel(true);
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), args);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.entryCoverDoBefore(this.getView(), args, COVER, (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CadreResumePrintWindowPlugin".equals(callBackId)) {
            return;
        }
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), null);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.coverCallBack(this.getView(), messageBoxClosedEvent, COVER);
    }

    private void initData() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        CADRE_RESUME_COMMON_SERVICE.createOriginalEntry(this.getView(), formShowParameter, FIELD_LIST);
        Long personId = (Long)customParams.get("personId");
        ArrayList personIdList = Lists.newArrayList((Object[])new Long[]{personId});
        HashMap param = Maps.newHashMap();
        List stringPersonIdList = personIdList.stream().map(String::valueOf).collect(Collectors.toList());
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"009"}));
        param.put("identifyIdType", "PERID");
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> learnMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_pereduexp");
        List<Map<String, Object>> educationalInfoList = learnMap.get(personId);
        if (CollectionUtils.isEmpty(educationalInfoList) || educationalInfoList.size() == 0) {
            return;
        }
        educationalInfoList.forEach(map -> {
            try {
                Object graduationDateObj;
                Object admissionDataObj = map.get("admissiondate");
                if (admissionDataObj instanceof String) {
                    map.put("admissiondate", HRDateTimeUtils.parseDate((String)admissionDataObj.toString(), (String)"yyyy-MM-dd"));
                }
                if ((graduationDateObj = map.get("gradutiondate")) instanceof String) {
                    map.put("gradutiondate", HRDateTimeUtils.parseDate((String)graduationDateObj.toString(), (String)"yyyy-MM-dd"));
                }
            }
            catch (ParseException e) {
                LOG.error("CadreResumeShowLearnPlugin parse date error", (Throwable)e);
            }
        });
        ArrayList newEntryFields = Lists.newArrayList();
        FIELD_LIST.forEach(field -> newEntryFields.add(field + "new"));
        String newEntryName = "entryentitynew";
        TableValueSetter vs = CADRE_RESUME_COMMON_SERVICE.beginCreateEntry(model, newEntryFields, newEntryName);
        educationalInfoList.forEach(map -> {
            ArrayList rowValues = Lists.newArrayList();
            FIELD_LIST.forEach(field -> {
                switch (field) {
                    case "collegedeptmajor": {
                        rowValues.add(CADRE_RESUME_COMMON_SERVICE.schoolMajorInfo((Map<String, Object>)map));
                        break;
                    }
                    case "gradutiondateshow": 
                    case "gradutiondate": {
                        rowValues.add(CADRE_RESUME_COMMON_SERVICE.updateDate((Date)map.get("gradutiondate")));
                        break;
                    }
                    default: {
                        rowValues.add(map.get(field));
                    }
                }
            });
            vs.addRow(rowValues.toArray());
        });
        CADRE_RESUME_COMMON_SERVICE.endCreateEntry(model, newEntryName, vs);
        this.getView().updateView("entryentity");
        this.getView().updateView(newEntryName);
    }
}

