/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeShowWorkPlugin
extends HRDynamicFormBasePlugin {
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final List<String> FIELD_LIST = Lists.newArrayList((Object[])new String[]{"startdate", "enddate", "enddateshow", "worktonowselect", "unitname", "workreterence"});
    private static final String COVER = "workcover";
    private static final String UPDATE_LIMIT = "4715a0df000000ac";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        long currUserId = RequestContext.get().getCurrUserId();
        this.initData();
        if (!PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)UPDATE_LIMIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"usedata"});
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.parentViewStatusVisible(this.getView(), "usedata");
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CADRE_RESUME_COMMON_SERVICE.showOrHideEndDate(this.getView(), "entryentitynew", "enddatenew", "enddateshownew", "worktonowselectnew");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            args.setCancel(true);
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), args);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.entryCoverDoBefore(this.getView(), args, COVER, (IFormPlugin)this);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("CadreResumePrintWindowPlugin".equals(callBackId)) {
            return;
        }
        if (!CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView())) {
            return;
        }
        boolean cancelDataRight = CADRE_RESUME_COMMON_SERVICE.dataRuleValidate(this.getView(), null);
        if (cancelDataRight) {
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.coverCallBack(this.getView(), messageBoxClosedEvent, COVER);
    }

    private void initData() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        Map customParams = formShowParameter.getCustomParams();
        CADRE_RESUME_COMMON_SERVICE.createOriginalEntry(this.getView(), formShowParameter, FIELD_LIST);
        Long personId = (Long)customParams.get("personId");
        HashMap param = Maps.newHashMap();
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"015"}));
        ArrayList stringPersonIdList = Lists.newArrayList((Object[])new String[]{String.valueOf(personId)});
        param.put("identifyIdType", "PERID");
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> preWorkExpMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_preworkexp");
        List<Object> perWorkExpList = preWorkExpMap.get(personId);
        QFilter qFilter = new QFilter("person", "in", Collections.singletonList(personId));
        List empPosList = ExternalDataService.getHrpiCommonInfoByFilter((String)"company,adminorg,apositiontype,position,job,stdposition,isprimary,postype,startdate,enddate", (QFilter)qFilter, (String)"hrpi_empposorgrel");
        HashMap empMap = Maps.newHashMap();
        empMap.put(personId, empPosList);
        if ((CollectionUtils.isEmpty(perWorkExpList) || perWorkExpList.size() == 0) && empMap.size() == 0) {
            return;
        }
        if (null == perWorkExpList) {
            perWorkExpList = Lists.newArrayList();
        }
        perWorkExpList.forEach(map -> {
            Object startDateObject = map.get("startdate");
            Object endDateObj = map.get("enddate");
            try {
                map.put("startdate", startDateObject == null ? null : HRDateTimeUtils.parseDate((String)startDateObject.toString(), (String)"yyyy-MM-dd"));
                map.put("enddate", endDateObj == null ? null : HRDateTimeUtils.parseDate((String)endDateObj.toString(), (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                map.put("startdate", null);
                map.put("enddate", null);
            }
        });
        List<Map<String, Object>> maps = (List<Map<String, Object>>)empMap.get(personId);
        perWorkExpList = CADRE_RESUME_COMMON_SERVICE.orderByStartDate((List<Map<String, Object>>)perWorkExpList);
        maps = CADRE_RESUME_COMMON_SERVICE.orderByStartDate(maps);
        ArrayList newEntryFields = Lists.newArrayList();
        FIELD_LIST.forEach(field -> newEntryFields.add(field + "new"));
        String newEntryName = "entryentitynew";
        TableValueSetter vs = CADRE_RESUME_COMMON_SERVICE.beginCreateEntry(model, newEntryFields, newEntryName);
        perWorkExpList.forEach(map -> {
            ArrayList rowValues = Lists.newArrayList();
            FIELD_LIST.forEach(field -> {
                if ("unitname".equals(field)) {
                    rowValues.add(CADRE_RESUME_COMMON_SERVICE.getPreWorkUnitName((Map<String, Object>)map));
                } else if ("enddateshow".equals(field)) {
                    rowValues.add(map.get("enddate"));
                } else {
                    rowValues.add(map.get(field));
                }
            });
            vs.addRow(rowValues.toArray());
        });
        maps.forEach(map -> {
            ArrayList rowValues = Lists.newArrayList();
            FIELD_LIST.forEach(field -> {
                if ("unitname".equals(field)) {
                    rowValues.add(CADRE_RESUME_COMMON_SERVICE.getCurrentWork((Map<String, Object>)map));
                } else if ("enddateshow".equals(field)) {
                    rowValues.add(map.get("enddate"));
                } else {
                    rowValues.add(map.get(field));
                }
            });
            vs.addRow(rowValues.toArray());
        });
        CADRE_RESUME_COMMON_SERVICE.endCreateEntry(model, newEntryName, vs);
        this.getView().updateView("entryentity");
        this.getView().updateView(newEntryName);
    }
}

