/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.resume;

import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeTipsPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(CadreResumeTipsPlugin.class);
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final String TARGET_KEY = "targetkey";
    private static final String USE_NEW_DADA = "usenewdata";
    private static final String UPDATE_LIMIT = "4715a0df000000ac";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String targetKey = formShowParameter.getOpenStyle().getTargetKey();
        this.getView().getPageCache().put(TARGET_KEY, targetKey);
        long personId = ((DynamicObject)this.getView().getParentView().getModel().getValue("person")).getLong("id");
        CADRE_RESUME_COMMON_SERVICE.getNewData(targetKey, this.getView(), personId);
        long currUserId = RequestContext.get().getCurrUserId();
        boolean hasPer = PermissionServiceHelper.checkPermission((Long)currUserId, (String)"cadm", (String)"cadm_resume", (String)UPDATE_LIMIT);
        if (!hasPer) {
            this.getView().setVisible(Boolean.FALSE, new String[]{USE_NEW_DADA});
            return;
        }
        CADRE_RESUME_COMMON_SERVICE.parentViewStatusVisible(this.getView(), USE_NEW_DADA);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        boolean hasPer = CADRE_RESUME_COMMON_SERVICE.windowUpdatePer(this.getView());
        if (!hasPer) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (USE_NEW_DADA.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            IPageCache pageCache = this.getView().getPageCache();
            String fieldKey = pageCache.get(TARGET_KEY);
            String dateStr = pageCache.get("tips_date");
            String baseDataId = pageCache.get("tips_basedataid");
            String newData = pageCache.get("tips_newdata");
            HashMap paramMap = Maps.newHashMap();
            try {
                if (HRStringUtils.isNotEmpty((String)dateStr)) {
                    paramMap.put(fieldKey, HRDateTimeUtils.parseDate((String)dateStr, (String)ResManager.loadKDString((String)"yyyy\u5e74MM\u6708dd\u65e5", (String)"CadreResumeTipsPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0])));
                } else if (HRStringUtils.isNotEmpty((String)baseDataId) && Long.parseLong(baseDataId) != 0L) {
                    paramMap.put(fieldKey, Long.parseLong(baseDataId));
                } else {
                    if ("-".equals(newData)) {
                        newData = "";
                    }
                    paramMap.put(fieldKey, newData);
                }
            }
            catch (ParseException e) {
                LOG.error("parse date error by {}", (Object)dateStr, (Object)e);
            }
            this.getView().returnDataToParent((Object)paramMap);
            this.getView().close();
        }
    }
}

