/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.review;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopResultEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;

public class ReviewBillEdit
extends HRCoreBaseBillEdit
implements HyperLinkClickListener {
    private static final String A_REVIEW = "areview";
    private static final String VIEW_HIS = "viewhistory";
    private static final String REVIEW_DYNAMIC = "cadm_reviewhisdynamic";
    private static final int CACHE_ONE_DAY = 1800;
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ReviewBillApplicationService reviewHelpService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);

    public void registerListener(EventObject eve) {
        super.registerListener(eve);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        toolbar.addItemClickListener((ItemClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("cooperateentry");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid entryShowGrid = (EntryGrid)this.getView().getControl("coopershowentry");
        entryShowGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"coopershowentry"});
    }

    private void showHistory() {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(REVIEW_DYNAMIC);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        HashMap customParam = Maps.newHashMap();
        customParam.put("review", pkValue);
        formShowParameter.setCustomParams((Map)customParam);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public void beforeBindData(EventObject eve) {
        super.beforeBindData(eve);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String status = (String)model.getValue("reviewstatus");
        this.updateShowEntry();
        this.getModel().setDataChanged(false);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.getValue() == operationStatus.getValue() || OperationStatus.ADDNEW.getValue() == operationStatus.getValue()) {
            view.setVisible(Boolean.valueOf(ReviewStatusEnum.IN_REVIEW.getReviewStatus().equals(status)), new String[]{"urge"});
            view.setVisible(Boolean.valueOf(ReviewStatusEnum.IN_REVIEW.getReviewStatus().equals(status)), new String[]{"urgeshow"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"urge"});
            view.setVisible(Boolean.FALSE, new String[]{"urgeshow"});
        }
    }

    public void afterBindData(EventObject eve) {
        super.afterBindData(eve);
        cadmFormService.showBillHead(this.getView(), "headbillinfo");
        cadmFormService.showPersonInfoCard(this.getView(), "perinfo");
        cadmFormService.showAppointInfoFlex(this.getView(), "nominateflex");
        this.showOrHide();
        this.setReviewResult();
        this.getModel().setDataChanged(false);
    }

    private void setReviewResult() {
        String selectProperties = "coopstatus,revresult";
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObject[] reviewHelpByReviewId = reviewBillApplicationService.getReviewHelpByReviewId(selectProperties, pkValue);
        if (reviewHelpByReviewId == null || reviewHelpByReviewId.length == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW_HIS});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_HIS});
        int successCooperate = 0;
        int disagreeNum = 0;
        int slowNum = 0;
        for (DynamicObject entry : reviewHelpByReviewId) {
            if (HRStringUtils.equals((String)entry.getString("coopstatus"), (String)CoopStatusEnum.DISCARD.getVal()) || HRStringUtils.equals((String)entry.getString("coopstatus"), (String)CoopStatusEnum.WAIT.getVal())) continue;
            if (HRStringUtils.equals((String)entry.getString("revresult"), (String)"1")) {
                ++successCooperate;
            }
            if (CoopResultEnum.DISAGREE.getNumber().equals(entry.getString("revresult"))) {
                ++disagreeNum;
            }
            if (!CoopResultEnum.SLOW.getNumber().equals(entry.getString("revresult"))) continue;
            ++slowNum;
        }
        String result = ResManager.loadKDString((String)"\u540c\u610f {0} \u4e0d\u540c\u610f {1} \u7f13\u8bae {2}", (String)"ReviewBillEdit_14", (String)"tdc-cadm-formplugin", (Object[])new Object[]{successCooperate, disagreeNum, slowNum});
        this.getModel().setValue("statisticrate", (Object)result);
    }

    private void showOrHide() {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        QFilter filter = new QFilter("review", "=", pkValue);
        if (!reviewHelpService.ifExistReviewHelp(new QFilter[]{filter})) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            String reviewStatus = this.getModel().getDataEntity().getString("reviewstatus");
            if (ReviewStatusEnum.BE_REVIEW.getReviewStatus().equals(reviewStatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"nonstartexamflex"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"nodataimage", "nodatatips"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"nonstartexamflex"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"nodataimage", "nodatatips"});
            }
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanebanklap"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
    }

    public void preOpenForm(PreOpenFormEventArgs eve) {
        super.preOpenForm(eve);
        BillShowParameter billShowParameter = (BillShowParameter)eve.getSource();
        String pkId = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            billShowParameter.setPkId((Object)pkId);
        }
        Long id = Long.valueOf(String.valueOf(billShowParameter.getPkId()));
        ArrayList pkIds = Lists.newArrayList((Object[])new Long[]{id});
        DynamicObject[] bills = reviewBillApplicationService.getOriginalReviewBillById("reviewstatus,handler.fbasedataid_id,person.name", (List)pkIds);
        DynamicObject bill = bills[0];
        String reviewStatus = bill.getString("reviewstatus");
        if (ReviewStatusEnum.NOT_TRIGGER.getReviewStatus().equals(reviewStatus)) {
            eve.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u60a8\u7684\u8bbf\u95ee\u94fe\u63a5\u5df2\u5931\u6548\u3002", (String)"ReviewBillEdit_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            eve.setCancel(true);
            return;
        }
        List userIds = Arrays.stream(bills).map(p -> p.getLong("handler.fbasedataid_id")).collect(Collectors.toList());
        if (!userIds.contains(RequestContext.get().getCurrUserId())) {
            eve.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReviewBillEdit_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            eve.setCancel(true);
            return;
        }
        String personName = bill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u8bc4\u8bae\u8bb0\u5f55-{0}", (String)"ReviewBillEdit_13", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_areview") && args.getOperationResult().isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("cadm_areview");
            HashMap<String, ArrayList> customParam = new HashMap<String, ArrayList>(16);
            customParam.put("ids", Lists.newArrayList((Object[])new Object[]{this.getModel().getValue("id")}));
            showParameter.setCustomParams(customParam);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, A_REVIEW));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"submit") && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"submit") && !args.getOperationResult().isSuccess()) {
            this.updateShowEntry();
            this.getModel().setDataChanged(false);
        }
        if (HRStringUtils.equals((String)operateKey, (String)VIEW_HIS)) {
            this.showHistory();
        }
    }

    private boolean isChangeStatus(String fieldName) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String reviewStatus = dataEntity.getString("reviewstatus");
        ArrayList<Long> pkIds = new ArrayList<Long>();
        pkIds.add(Long.valueOf(dataEntity.getPkValue().toString()));
        DynamicObject[] bills = reviewBillApplicationService.getOriginalReviewBillById("reviewstatus", pkIds);
        DynamicObject reviewBill = bills[0];
        if (HRStringUtils.equals((String)reviewStatus, (String)reviewBill.getString("reviewstatus"))) {
            return false;
        }
        String opDescription = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(opDescription);
        BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)fieldName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u50ac\u529e", "ReviewBillEdit_0", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", "ReviewBillEdit_4", "tdc-cadm-formplugin"));
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent eve) {
        String fieldName = eve.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"urgeshow")) {
            int thousand;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("coopershowentry", eve.getRowIndex());
            Object pkValue = entryRowEntity.getPkValue();
            if (this.isChangeStatus(fieldName)) {
                return;
            }
            IFormView view = this.getView();
            ArrayList<Long> pkIds = new ArrayList<Long>();
            pkIds.add(Long.valueOf(pkValue.toString()));
            DynamicObject[] bills = reviewBillApplicationService.getOriginalReviewHelpBillById("coopstatus", pkIds);
            if (!HRStringUtils.equals((String)entryRowEntity.getString("coopstatusshow"), (String)bills[0].getString("coopstatus"))) {
                String opDescription = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                view.showErrorNotification(opDescription);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)fieldName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u50ac\u529e", "ReviewBillEdit_0", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", "ReviewBillEdit_5", "tdc-cadm-formplugin"));
                return;
            }
            DynamicObject entryShowRow = this.getModel().getEntryRowEntity("coopershowentry", eve.getRowIndex());
            Date sendShowTime = entryShowRow.getDate("sendshowtime");
            if (HRObjectUtils.isEmpty((Object)sendShowTime)) {
                this.sendUrgeMessage(entryRowEntity, fieldName);
                reviewBillApplicationService.updateSendMsgTime(Long.valueOf(entryRowEntity.getLong("id")));
                this.getModel().setValue("sendshowtime", (Object)new Date(), eve.getRowIndex());
                cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"sendshowtime"});
                return;
            }
            Long sendTime = sendShowTime.getTime();
            Long currentTime = System.currentTimeMillis();
            long costTime = currentTime - sendTime;
            if (costTime > (long)(1800 * (thousand = 1000))) {
                this.sendUrgeMessage(entryRowEntity, fieldName);
                reviewBillApplicationService.updateSendMsgTime(Long.valueOf(entryRowEntity.getLong("id")));
                this.getModel().setValue("sendshowtime", (Object)new Date(), eve.getRowIndex());
                cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"sendshowtime"});
            } else {
                long waitMinutesTime = ((long)(1800 * thousand) - costTime) / (long)thousand / 60L;
                long waitSecondsTime = ((long)(1800 * thousand) - costTime) / (long)thousand % 60L;
                String opDescription = MessageFormat.format(ResManager.loadKDString((String)"\u8be5\u534f\u529e\u5df2\u53d1\u9001\u50ac\u529e\u6d88\u606f\uff0c\u518d\u6b21\u53d1\u9001\u8fd8\u9700\u7b49\u5f85{0}\u5206{1}\u79d2\u3002", (String)"ReviewBillEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), waitMinutesTime, waitSecondsTime);
                this.getView().showTipNotification(opDescription);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), null, (String)fieldName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u50ac\u529e", "ReviewBillEdit_0", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8be5\u534f\u529e\u5df2\u53d1\u9001\u50ac\u529e\u6d88\u606f\uff0c\u518d\u6b21\u53d1\u9001\u8fd8\u9700\u7b49\u5f85{0}\u5206{1}\u79d2\u3002", "ReviewBillEdit_6", "tdc-cadm-formplugin"), null, null, (String[])new String[]{"" + waitMinutesTime, "" + waitSecondsTime});
            }
        }
    }

    private void sendUrgeMessage(DynamicObject entryRowEntity, String fieldName) {
        Object pkValue = entryRowEntity.getPkValue();
        Long nominateId = this.getModel().getDataEntity().getLong("nominatebill.id");
        String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_reviewhelpbill").setParameter("formPkId", String.valueOf(pkValue)).builder();
        BosMessageService.sendTemplateMessage((String)contentUrl, (List)Lists.newArrayList((Object[])new Long[]{entryRowEntity.getLong("cooperatershow.id")}), (Long)nominateId, (String)"cadm_reviewbill", (String)"cadm_cb", (Long)((Long)pkValue));
        String opDescription = ResManager.loadKDString((String)"\u50ac\u529e\u6210\u529f\u3002", (String)"ReviewBillEdit_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        this.getView().showSuccessNotification(opDescription);
        BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)fieldName, (MultiLangEnumBridge)new MultiLangEnumBridge("\u50ac\u529e", "ReviewBillEdit_0", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u50ac\u529e\u6210\u529f\u3002", "ReviewBillEdit_7", "tdc-cadm-formplugin"));
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        IFormView view = this.getView();
        Map returnMap = CastUtils.castMap((Object)callBackEvent.getReturnData(), String.class);
        String actionId = callBackEvent.getActionId();
        if (CollectionUtils.isEmpty((Map)returnMap)) {
            if (A_REVIEW.equals(actionId)) {
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)actionId, (MultiLangEnumBridge)this.getOpName(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bc4\u8bae\u5df2\u53d6\u6d88\u3002", "ReviewBillEdit_11", "tdc-cadm-formplugin"));
            }
            return;
        }
        if (A_REVIEW.equals(actionId) && Boolean.TRUE.equals(returnMap.get("isClose"))) {
            Set failedBillNos = CastUtils.castSet(returnMap.get("failedIds"), String.class);
            if (CollectionUtils.isEmpty((Collection)failedBillNos)) {
                String opDescription = ResManager.loadKDString((String)"\u53d1\u8d77\u8bc4\u8bae\u6210\u529f\u3002", (String)"ReviewBillEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                view.showSuccessNotification(opDescription);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)actionId, (MultiLangEnumBridge)this.getOpName(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d1\u8d77\u8bc4\u8bae\u6210\u529f\u3002", "ReviewBillEdit_8", "tdc-cadm-formplugin"));
            } else {
                String opDescription = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ReviewBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                view.showErrorNotification(opDescription);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)actionId, (MultiLangEnumBridge)this.getOpName(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", "ReviewBillEdit_4", "tdc-cadm-formplugin"));
            }
            view.sendFormAction(view);
            this.showOrHide();
            view.invokeOperation("refresh");
        }
    }

    private MultiLangEnumBridge getOpName() {
        return new MultiLangEnumBridge("\u53d1\u8d77\u8bc4\u8bae", "ReviewBillEdit_12", "tdc-cadm-formplugin");
    }

    private String getUrgeOpName() {
        return ResManager.loadKDString((String)"\u50ac\u529e", (String)"ReviewBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
    }

    private void updateShowEntry() {
        DynamicObject reviewBill = reviewBillApplicationService.queryOne("cooperateentry.cooperater,cooperateentry.coopstatus,cooperateentry.coopcreatetime,cooperateentry.entrynominatebill,cooperateentry.entrycreator,cooperateentry.entryperson,cooperateentry.coopsla,cooperateentry.sendtime,cooperateentry.revresult,cooperateentry.revcomment,cooperateentry.cooptaketime,reviewpassrate,coopcomprate,cooperateentry.hisrevrecord", this.getModel().getDataEntity().getPkValue());
        this.getModel().setValue("coopcomprate", reviewBill.get("coopcomprate"));
        AbstractFormDataModel formDataModel = (AbstractFormDataModel)this.getModel();
        formDataModel.deleteEntryData("coopershowentry");
        formDataModel.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"id", "cooperatershow", "coopstatusshow", "showresultshow", "showcommentshow", "showtimeshow", "entrynomibillshow", "entrycreatorshow", "entrypersonshow", "coopslashow", "urgeshow", "sendshowtime"});
        DynamicObjectCollection cooperateEntry = reviewBill.getDynamicObjectCollection("cooperateentry");
        for (DynamicObject entry : cooperateEntry) {
            if (CoopStatusEnum.DISCARD.getVal().equals(entry.get("coopstatus"))) continue;
            String urge = "";
            String comment = "";
            String result = "";
            double takeTime = new Double("0");
            if (HRStringUtils.equals((String)((String)entry.get("coopstatus")), (String)CoopStatusEnum.WAIT.getVal())) {
                Date createTime = entry.getDate("coopcreatetime");
                double takeTimeDay = (double)(System.currentTimeMillis() - createTime.getTime()) / 1000.0 / 60.0 / 60.0 / 24.0;
                BigDecimal bigDecimal = BigDecimal.valueOf(takeTimeDay);
                urge = this.getUrgeOpName();
                takeTime = bigDecimal.setScale(1, RoundingMode.HALF_UP).doubleValue();
            }
            if (CoopStatusEnum.PROCESSED.getVal().equals(entry.get("coopstatus"))) {
                result = entry.getString("revresult");
                comment = entry.getString("revcomment");
                takeTime = entry.getBigDecimal("cooptaketime").doubleValue();
            }
            setter.addRow(new Object[]{entry.getLong("id"), entry.getLong("cooperater.id"), entry.getString("coopstatus"), result, comment, takeTime, entry.getLong("entrynominatebill.id"), entry.getLong("entrycreator.id"), entry.getLong("entryperson.id"), entry.getString("coopsla"), urge, entry.getDate("sendtime")});
        }
        formDataModel.batchCreateNewEntryRow("coopershowentry", setter);
        formDataModel.endInit();
        this.setReviewResult();
        this.getView().updateView("coopershowentry");
    }
}

