/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.review;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.AppointBatchRejectFormService;
import kd.tdc.cadm.formplugin.web.formservice.DismissPositionCommonService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.NominateCommonFormService;
import kd.tdc.tdcs.bussiness.application.external.BosLogService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ReviewBillList
extends HRCoreBaseBillList {
    private static final String A_REVIEW = "areview";
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final AppointBatchRejectFormService rejectFormService = (AppointBatchRejectFormService)ServiceFactory.getService(AppointBatchRejectFormService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final List<String> STATUS_LIST = Arrays.asList(ReviewStatusEnum.NOT_TRIGGER.getReviewStatus(), ReviewStatusEnum.DEL.getReviewStatus());
    private static final FormCommonService formCommonService = FormServiceFactory.getService(FormCommonService.class);
    private static final DismissPositionCommonService dismissPositionCommonService = (DismissPositionCommonService)ServiceFactory.getService(DismissPositionCommonService.class);
    private static final NominateCommonFormService NOMINATE_COMMON_FORM_SERVICE = (NominateCommonFormService)ServiceFactory.getService(NominateCommonFormService.class);
    private static final String WILL_DISMISS_POSITION = "nominatebill.dposition.name";

    public void packageData(PackageDataEvent eve) {
        super.packageData(eve);
        ColumnDesc source = (ColumnDesc)eve.getSource();
        String fieldKey = source.getFieldKey();
        if (WILL_DISMISS_POSITION.equals(fieldKey)) {
            dismissPositionCommonService.packageDismissPositionData(eve, WILL_DISMISS_POSITION, "nominatebill.djob.name", "nominatebill.dstandardposition.name");
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        formCommonService.beforeCreateListColumns(args, "person.number");
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter handlerFilter = new QFilter("handler.fbasedataid", "in", (Object)RequestContext.get().getCurrUserId());
        setFilterEvent.getQFilters().add(handlerFilter);
        setFilterEvent.getQFilters().add(new QFilter("reviewstatus", "not in", STATUS_LIST));
        QFilter appointStatusQFilter = new QFilter("nominatebill.appointstatus", "!=", (Object)AppointStatusEnum.WAIT_APPOINT.getVal());
        setFilterEvent.getQFilters().add(appointStatusQFilter);
        setFilterEvent.setOrderBy("reviewstatus asc,createtime desc");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("reject".equals(operateKey)) {
            rejectFormService.setExportBills(this.getReviewBills());
            rejectFormService.callValidatorBeforeDoOperation(args, "reject", (AbstractFormPlugin)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if ("donothing_areview_list".equals(operateKey)) {
            Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
            List pkIds = Arrays.stream(primaryKeyValues).map(primaryKeyValue -> Long.valueOf(primaryKeyValue.toString())).collect(Collectors.toList());
            DynamicObject[] reviewBills = reviewBillApplicationService.getOriginalReviewBillById("id,reviewstatus", pkIds);
            boolean checkResult = Arrays.stream(reviewBills).anyMatch(reviewBill -> !ReviewStatusEnum.canReview((String)reviewBill.getString("reviewstatus")));
            if (checkResult) {
                String tipNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8bc4\u8bae\u72b6\u6001\u4e3a\u201c\u5f85\u8bc4\u8bae/\u8bc4\u8bae\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ReviewBillList_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(tipNotification);
                BosLogService.recordLocalStringOpLogWithOp((IFormView)this.getView(), (String)"cadm_reviewbill", (AbstractOperate)operate, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8bc4\u8bae\u72b6\u6001\u4e3a\u201c\u5f85\u8bc4\u8bae/\u8bc4\u8bae\u4e2d\u201d\u7684\u6570\u636e\u3002", "ReviewBillList_0", "tdc-cadm-formplugin"));
            } else {
                this.showReviewWindowForm();
            }
        }
        if (operateKey.equals("reject")) {
            rejectFormService.refreshAfterDoOperation(args, (AbstractFormPlugin)this);
        }
    }

    private void showReviewWindowForm() {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_areview");
        HashMap customParam = Maps.newHashMap();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows.size() == 0) {
            return;
        }
        customParam.put("ids", HRArrayUtils.objects2ArrayList((Object[])selectedRows.getPrimaryKeyValues()));
        showParameter.setCustomParams((Map)customParam);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, A_REVIEW));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        super.closedCallBack(callBackEvent);
        IFormView view = this.getView();
        Map returnMap = CastUtils.castMap((Object)callBackEvent.getReturnData(), String.class);
        String actionId = callBackEvent.getActionId();
        if ("reject_all".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            rejectFormService.rejectAllCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if ("reject_part".equals(actionId) && !CollectionUtils.isEmpty((Map)returnMap)) {
            rejectFormService.rejectPartCloseCallBack(returnMap, (AbstractFormPlugin)this);
        }
        if (A_REVIEW.equals(actionId) && Boolean.TRUE.equals(returnMap.get("isClose"))) {
            String opName = ResManager.loadKDString((String)"\u53d1\u8d77\u8bc4\u8bae", (String)"ReviewBillList_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u53d1\u8d77\u8bc4\u8bae", "ReviewBillList_1", "tdc-cadm-formplugin");
            if (CollectionUtils.isEmpty((Map)returnMap)) {
                if (HRStringUtils.isNotEmpty((String)opName)) {
                    BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_reviewbill", (String)actionId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8bc4\u8bae\u5df2\u53d6\u6d88\u3002", "ReviewBillList_2", "tdc-cadm-formplugin"));
                }
                return;
            }
            Set failedIds = CastUtils.castSet(returnMap.get("failedIds"), Long.class);
            boolean isFailed = CollectionUtils.isEmpty((Collection)failedIds);
            if (isFailed) {
                String successNotification = ResManager.loadKDString((String)"\u53d1\u8d77\u8bc4\u8bae\u6210\u529f\u3002", (String)"ReviewBillList_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                view.showSuccessNotification(successNotification);
                view.invokeOperation("refresh");
                view.sendFormAction(view);
                BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_reviewbill", (String)actionId, (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d1\u8d77\u8bc4\u8bae\u6210\u529f\u3002", "ReviewBillList_3", "tdc-cadm-formplugin"));
                return;
            }
            ArrayList errorMsgList = Lists.newArrayList();
            List<String> billNoList = this.getBillNoList(failedIds);
            String tipNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8bc4\u8bae\u72b6\u6001\u4e3a\u201c\u5f85\u8bc4\u8bae/\u8bc4\u8bae\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ReviewBillList_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            billNoList.forEach(billNo -> errorMsgList.add(billNo + ":" + tipNotification));
            int total = this.getSelectedRows().size();
            int failedNum = failedIds.size();
            int successNum = total - failedNum;
            String title = MessageFormat.format(ResManager.loadKDString((String)"\u5171{0}\u6761\u5355\u636e\uff0c\u53d1\u8d77\u8bc4\u8bae\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", (String)"ReviewBillList_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), total, successNum, failedNum);
            cadmFormService.showBosDefaultOperationResult(title, (List)errorMsgList, view);
            BosLogService.recordLocalStringOpLogWithNoOp((IFormView)this.getView(), (String)"cadm_reviewbill", (String)actionId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u53d1\u8d77\u8bc4\u8bae", "ReviewBillList_1", "tdc-cadm-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5171{0}\u6761\u5355\u636e\uff0c\u53d1\u8d77\u8bc4\u8bae\u64cd\u4f5c\u6210\u529f{1}\u6761\uff0c\u5931\u8d25{2}\u6761\u3002", "ReviewBillList_4", "tdc-cadm-formplugin"), null, null, (String[])new String[]{"" + total, "" + successNum, "" + failedNum});
        }
        view.invokeOperation("refresh");
        view.sendFormAction(view);
    }

    private List<String> getBillNoList(Set<Long> failedIds) {
        DynamicObject[] reviewBills = reviewBillApplicationService.getOriginalReviewBillById("billno", new ArrayList<Long>(failedIds));
        return Arrays.stream(reviewBills).map(reviewBill -> reviewBill.getString("billno")).collect(Collectors.toList());
    }

    private DynamicObject[] getReviewBills() {
        List pkIds = this.getSelectedRows().stream().map(value -> (Long)value.getPrimaryKeyValue()).collect(Collectors.toList());
        return reviewBillApplicationService.queryReviewBillById("person.name,person.number,billno,nominatebill.aposition.name,nominatebill.appointstatus,nominatebill.dposition.name,reviewstatus,nominatebill.positiontype,nominatebill.ajob.name,nominatebill.astandardposition.name,nominatebill.djob.name,nominatebill.dstandardposition.name", pkIds);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        CadmFormService.CadmListShowHandler listDataProvider = new CadmFormService.CadmListShowHandler((AbstractFormPlugin)this, "handler");
        args.setListDataProvider((IListDataProvider)listDataProvider);
    }
}

