/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.review;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.nominate.enums.ApplyTypeEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;

public class ReviewHelpPlugin
extends HRDataBaseEdit {
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final String REVIEWPOINTS = "reviewpoints";
    private static final String REVIEWTOPIC = "reviewtopic";

    public void preOpenForm(PreOpenFormEventArgs e) {
        Long pkId;
        DynamicObject[] dataEntities;
        super.preOpenForm(e);
        BillShowParameter billShowParameter = (BillShowParameter)e.getSource();
        String pkIdStr = (String)billShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkIdStr)) {
            billShowParameter.setPkId((Object)pkIdStr);
        }
        if ((dataEntities = reviewBillApplicationService.getOriginalReviewHelpBillById("coopstatus,person.name", Collections.singletonList(pkId = Long.valueOf(Long.parseLong(billShowParameter.getPkId().toString()))))) == null || dataEntities.length == 0) {
            return;
        }
        DynamicObject reviewHelpBill = dataEntities[0];
        String coopStatus = reviewHelpBill.getString("coopstatus");
        CoopStatusEnum coopStatusEnum = CoopStatusEnum.getEnumByVal((String)coopStatus);
        if (coopStatusEnum != CoopStatusEnum.WAIT) {
            e.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        String personName = reviewHelpBill.getString("person.name");
        String caption = ResManager.loadKDString((String)"\u8bc4\u8bae\u534f\u4f5c-{0}", (String)"ReviewHelpPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{personName});
        billShowParameter.setCaption(caption);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        cadmFormService.showAppointInfoFlex(this.getView(), "nominateflex");
        cadmFormService.showPersonInfoCard(this.getView(), "personcardflex");
        Map<String, Object> customParams = this.buildCustomParams();
        cadmFormService.showBillHead(this.getView(), "headbillinfo", customParams);
        this.showBtnByCoopStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long recordId = dataEntity.getLong("hisrevrecord");
        if (recordId != 0L) {
            DynamicObject reviewHistoryDynamic = reviewBillApplicationService.getReviewHisByRecordId("reviewtopic,reviewpoints,reviewtime,reviewplace", (Object)recordId);
            if (null == reviewHistoryDynamic) {
                return;
            }
            this.getModel().setValue(REVIEWTOPIC, (Object)reviewHistoryDynamic.getString(REVIEWTOPIC));
            this.getModel().setValue(REVIEWPOINTS, (Object)reviewHistoryDynamic.getString(REVIEWPOINTS));
            this.getModel().setValue("reviewtime", (Object)reviewHistoryDynamic.getDate("reviewtime"));
            this.getModel().setValue("reviewplace", (Object)reviewHistoryDynamic.getString("reviewplace"));
        }
        this.getView().getModel().setDataChanged(false);
    }

    private Map<String, Object> buildCustomParams() {
        DynamicObject bill = this.getModel().getDataEntity();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        DynamicObject nominateBill = bill.getDynamicObject("nominatebill");
        customParams.put("billno", nominateBill.getString("billno"));
        customParams.put("appointtype", nominateBill.getString("appointtype.name"));
        customParams.put("orgname", nominateBill.getString("org.name"));
        customParams.put("billtypename", ResManager.loadKDString((String)"\u8bc4\u8bae\u534f\u4f5c", (String)"ReviewHelpPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        CoopStatusEnum coopStatusEnum = CoopStatusEnum.getEnumByVal((String)bill.getString("coopstatus"));
        customParams.put("statusname", coopStatusEnum.getName());
        customParams.put("statustype", coopStatusEnum.getStatusType());
        DynamicObject handler = bill.getDynamicObject("cooperater");
        if (!Objects.isNull(handler) && coopStatusEnum != CoopStatusEnum.WAIT) {
            String handlerName = handler.getString("name");
            String handlerNumber = handler.getString("number");
            customParams.put("handlername", handlerName);
            customParams.put("handlernumber", handlerNumber);
        }
        customParams.put("handletime", bill.getDate("coopdealtime"));
        String applyType = bill.getString("nominatebill.applytype");
        customParams.put("isfastapply", ApplyTypeEnum.FAST.getVal().equals(applyType));
        return customParams;
    }

    private void showBtnByCoopStatus() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String coopStatus = dataEntity.getString("coopstatus");
        CoopStatusEnum coopStatusEnum = CoopStatusEnum.getEnumByVal((String)coopStatus);
        if (coopStatusEnum != CoopStatusEnum.WAIT) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_edit", "bar_submit"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("submit".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }
}

