/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.review;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.util.CastUtils;

public class ReviewWindowPlugin
extends HRDynamicFormBasePlugin {
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final String A_REVIEW = "areview";
    private static final String HAS_REVIEW_PERM = "hasreviewperm";
    private static final String PK_IDS = "pkIds";
    private static final String REPEAT_START_REVIEW = "repeatstartreview";

    public void registerListener(EventObject eve) {
        super.registerListener(eve);
        Button btn = (Button)this.getView().getControl(A_REVIEW);
        btn.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject eve) {
        super.beforeBindData(eve);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        IDataModel model = this.getModel();
        List pkIds = CastUtils.castList(customParams.get("ids"), Long.class);
        this.getView().getPageCache().put(PK_IDS, SerializationUtils.serializeToBase64((Object)pkIds));
        if (pkIds.size() == 1) {
            String reviewPlace;
            Date reviewTime;
            String reviewPoints;
            DynamicObject[] reviewBills = reviewBillApplicationService.queryReviewBillById("reviewtopic,reviewpoints,cooperateentry.cooperater,cooperateentry.coopsla,cooperateentry.coopstatus,reviewtime,reviewplace", pkIds);
            if (reviewBills == null || reviewBills.length == 0) {
                this.getView().setVisible(Boolean.FALSE, new String[]{REPEAT_START_REVIEW});
                return;
            }
            DynamicObject reviewBill = reviewBills[0];
            DynamicObjectCollection cooperEntry = reviewBill.getDynamicObjectCollection("cooperateentry");
            List notDisCardCoopBills = cooperEntry.stream().filter(coopBill -> !CoopStatusEnum.DISCARD.getVal().equals(coopBill.getString("coopstatus"))).collect(Collectors.toList());
            Object[] reviewerIds = new Long[notDisCardCoopBills.size()];
            for (int i = 0; i < notDisCardCoopBills.size(); ++i) {
                reviewerIds[i] = ((DynamicObject)notDisCardCoopBills.get(i)).getLong("cooperater.id");
            }
            if (ArrayUtils.isNotEmpty((Object[])reviewerIds)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{REPEAT_START_REVIEW});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{REPEAT_START_REVIEW});
            }
            model.setValue("reviewer", (Object)reviewerIds);
            String reviewTopic = reviewBill.getString("reviewtopic");
            if (HRStringUtils.isNotEmpty((String)reviewTopic)) {
                model.setValue("reviewtopic", (Object)reviewTopic);
            }
            if (HRStringUtils.isNotEmpty((String)(reviewPoints = reviewBill.getString("reviewpoints")))) {
                model.setValue("reviewpoints", (Object)reviewPoints);
            }
            if ((reviewTime = reviewBill.getDate("reviewtime")) != null) {
                model.setValue("reviewtime", (Object)reviewTime);
            }
            if (HRStringUtils.isNotEmpty((String)(reviewPlace = reviewBill.getString("reviewplace")))) {
                model.setValue("reviewplace", (Object)reviewPlace);
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{REPEAT_START_REVIEW});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (HRStringUtils.equals((String)"donothing_areview", (String)args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            OperationResult hasReviewPerm = this.getView().getParentView().invokeOperation(HAS_REVIEW_PERM);
            if (hasReviewPerm == null || !hasReviewPerm.isSuccess()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u53d1\u8d77\u8bc4\u8bae\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ReviewWindowPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            DynamicObjectCollection reviewers = (DynamicObjectCollection)model.getDataEntity().get("reviewer");
            String reviewPoints = (String)model.getValue("reviewpoints");
            String reviewTopic = (String)model.getValue("reviewtopic");
            Date reviewTime = (Date)model.getValue("reviewtime");
            String reviewPlace = (String)model.getValue("reviewplace");
            String pkIdsStr = this.getView().getPageCache().get(PK_IDS);
            List pkIds = (List)SerializationUtils.deSerializeFromBase64((String)pkIdsStr);
            DynamicObject[] dynamicObjects = reviewBillApplicationService.queryReviewBillByIdAndStatus(Arrays.asList(ReviewStatusEnum.BE_REVIEW, ReviewStatusEnum.IN_REVIEW), pkIds);
            if (dynamicObjects.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u5f02\u5e38\u3002", (String)"ReviewWindowPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            Set failedBillNos = reviewBillApplicationService.doReview(pkIds, reviewers, reviewPoints, reviewTopic, reviewTime, reviewPlace);
            HashMap returnMap = Maps.newHashMap();
            returnMap.put("isClose", Boolean.TRUE);
            returnMap.put("failedIds", failedBillNos);
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        }
    }
}

