/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.publicity;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;

public class ToInPublicityTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ToInPublicityTask.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] pubBills = publicityBillApplicationService.queryByPubStatus("id,pubstatus,pubstartdate,modifier,modifytime", PublicityStatusEnum.BE_EFFECTIVE.getPubStatus());
        if (HRObjectUtils.isEmpty((Object)pubBills)) {
            LOG.info("There-is-no-data-to-update");
            return;
        }
        Date currentDate = new Date();
        long currUserId = requestContext.getCurrUserId();
        Arrays.stream(pubBills).forEach(pubBill -> {
            if (Objects.isNull(pubBill.getDate("pubstartdate"))) {
                return;
            }
            if (HRDateTimeUtils.dayBefore((Date)pubBill.getDate("pubstartdate"), (Date)currentDate)) {
                pubBill.set("pubstatus", (Object)PublicityStatusEnum.IN_PUBLIC.getPubStatus());
                pubBill.set("modifier", (Object)currUserId);
                pubBill.set("modifytime", (Object)currentDate);
            }
        });
        publicityBillApplicationService.update(pubBills);
    }
}

