/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.publicity;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.util.UrlBuilder;

public class ToPublicityCompletedTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ToPublicityCompletedTask.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] pubBills = publicityBillApplicationService.queryByPubStatus("id,pubstatus,handler,pubenddate,nominatebill,modifier,modifytime", PublicityStatusEnum.IN_PUBLIC.getPubStatus());
        if (HRObjectUtils.isEmpty((Object)pubBills)) {
            LOG.info("There-is-no-data-to-update");
            return;
        }
        Date currentDate = new Date();
        long currUserId = requestContext.getCurrUserId();
        DynamicObjectCollection pubList = new DynamicObjectCollection();
        Arrays.stream(pubBills).forEach(pubBill -> {
            if (Objects.isNull(pubBill.getDate("pubenddate"))) {
                return;
            }
            if (HRDateTimeUtils.dayBefore((Date)pubBill.getDate("pubenddate"), (Date)currentDate)) {
                long pubId = pubBill.getLong("id");
                long nominateId = pubBill.getLong("nominatebill.id");
                List userIds = pubBill.getDynamicObjectCollection("handler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
                LOG.info("ToPublicityCompletedTask-sendMessage-userIds:{}", userIds);
                String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_publicity").setParameter("formPkId", String.valueOf(pubId)).builder();
                BosMessageService.sendTemplateMessage((String)contentUrl, userIds, (Long)nominateId, (String)"cadm_publicity", (String)"cadm_gswc", (Long)pubId);
                pubBill.set("pubstatus", (Object)PublicityStatusEnum.BE_SUBMIT.getPubStatus());
                pubBill.set("modifier", (Object)currUserId);
                pubBill.set("modifytime", (Object)currentDate);
                pubList.add(pubBill);
            }
        });
        publicityBillApplicationService.update((DynamicObject[])pubList.toArray((Object[])new DynamicObject[0]));
    }
}

