/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.release;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.actv.ActvGenerateExtService;
import kd.tdc.cadm.bussiness.domain.release.ReleaseValidateHelper;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;

public class ToReleaseCompletedTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ToReleaseCompletedTask.class);
    private static final ActvGenerateExtService ACTV_SERVICE = (ActvGenerateExtService)ServiceFactory.getService(ActvGenerateExtService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOG.info("start run release task");
        this.releaseBeEffectiveCore();
        LOG.info("end run release task");
    }

    private void releaseBeEffectiveCore() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("cadm_appointrelease");
        QFilter statusFilter = new QFilter("releasestatus", "=", (Object)ReleaseStatusEnum.BE_EFFECTIVE.getNum());
        Object[] dynamicObjects = serviceHelper.query("id,releasestatus,releasetime,modifytime,billno,relsdealtime,subhandler,instanceid", new QFilter[]{statusFilter});
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        Date date = new Date();
        Date currDate = HRDateTimeUtils.truncateDate((Date)date);
        ArrayList insIds = new ArrayList();
        Arrays.stream(dynamicObjects).filter(releaseBill -> !ObjectUtils.isEmpty((Object)releaseBill.getDate("releasetime"))).forEach(releaseBill -> {
            Date relsDate = HRDateTimeUtils.truncateDate((Date)releaseBill.getDate("releasetime"));
            if (HRDateTimeUtils.dayBefore((Date)relsDate, (Date)currDate) || HRDateTimeUtils.dayEquals((Date)relsDate, (Date)currDate)) {
                LOG.info("start release billno: {}", (Object)releaseBill.getString("billno"));
                releaseBill.set("releasestatus", (Object)ReleaseStatusEnum.COMPLETED.getNum());
                releaseBill.set("releasetime", (Object)relsDate);
                Date newRelsDate = ReleaseValidateHelper.dateConvert((Date)date);
                if (newRelsDate != null) {
                    releaseBill.set("relsdealtime", (Object)newRelsDate);
                }
                releaseBill.set("subhandler", (Object)UserServiceHelper.getCurrentUser((String)"number"));
                releaseBill.set("modifytime", (Object)date);
                insIds.add(releaseBill.getLong("instanceid"));
            }
        });
        serviceHelper.save((DynamicObject[])dynamicObjects);
        ACTV_SERVICE.batchConsentTask(insIds, "");
    }
}

