/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.external.TalentService;
import kd.tdc.cadm.bussiness.application.service.CadreResumeApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.resume.enums.CadreResumeStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.common.bo.CadreResumeBatchBo;
import kd.tdc.cadm.common.bo.CadreResumeBo;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeInitTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(CadreResumeInitTask.class);
    private static final TenureApplicationService TENURE_APPLICATION_SERVICE = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final CadreResumeApplicationService CADRE_RESUME_APPLICATION_SERVICE = (CadreResumeApplicationService)ServiceFactory.getService(CadreResumeApplicationService.class);
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"CadreResumeInitPool", (int)10, (int)20);
    private static final TalentService TALENT_SERVICE = (TalentService)ServiceFactory.getService(TalentService.class);
    private static final int MAX_EXECUTE_SIZE = 5000;
    private static final int MAX_SAVE_SIZE = 2000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.initCadreResumeInfo();
    }

    public void initCadreResumeInfo() {
        DynamicObject[] dynamicObjects = TENURE_APPLICATION_SERVICE.queryAllOriginalTenure();
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            LOG.info("not tenure to execute CadreResumeInitTask");
            return;
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("person.id")));
        Date now = new Date();
        ArrayList personBoList = Lists.newArrayList();
        map.forEach((personId, dynamicObjectList) -> {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
            long employeeId = dynamicObject.getLong("employee.id");
            if (0L == personId || 0L == employeeId) {
                return;
            }
            long cadreId = this.getCadreType((List<DynamicObject>)dynamicObjectList);
            CadreResumeBo bo = new CadreResumeBo();
            bo.setPersonId(personId);
            bo.setEmployeeId(Long.valueOf(employeeId));
            bo.setCadreId(Long.valueOf(cadreId));
            bo.setTenureStatus(this.getPostStatus((List<DynamicObject>)dynamicObjectList));
            bo.setNow(now);
            personBoList.add(bo);
        });
        ArrayList futureList = Lists.newArrayList();
        int size = personBoList.size();
        if (size > 5000) {
            int num = (size + 5000 - 1) / 5000;
            for (int i = 0; i < num; ++i) {
                int fromIndex = i * 5000;
                int toIndex = Math.min((i + 1) * 5000, size);
                List<CadreResumeBo> cadreResumeBos = personBoList.subList(fromIndex, toIndex);
                Future<List<DynamicObject>> futures = this.batchInit(cadreResumeBos);
                futureList.add(futures);
            }
        } else {
            futureList.add(this.batchInit(personBoList));
        }
        CopyOnWriteArrayList resultList = Lists.newCopyOnWriteArrayList();
        futureList.forEach(listFuture -> {
            try {
                this.dealFuture((Future<List<DynamicObject>>)listFuture, resultList);
            }
            catch (Exception e) {
                LOG.error("future result get error ", (Throwable)e);
            }
        });
        int len = resultList.size();
        if (len > 2000) {
            int num = (len + 2000 - 1) / 2000;
            for (int i = 0; i < num; ++i) {
                int fromIndex = i * 2000;
                int toIndex = Math.min((i + 1) * 2000, len);
                List newList = resultList.subList(fromIndex, toIndex);
                CADRE_RESUME_APPLICATION_SERVICE.batchSave(newList.toArray(new DynamicObject[0]));
            }
            return;
        }
        CADRE_RESUME_APPLICATION_SERVICE.batchSave(resultList.toArray(new DynamicObject[0]));
    }

    private Long getCadreType(List<DynamicObject> dynamicObjectList) {
        dynamicObjectList = dynamicObjectList.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("createTime"), Comparator.reverseOrder())).collect(Collectors.toList());
        String postStatus = this.getPostStatus(dynamicObjectList);
        if (!CadreResumeStatusEnum.LEAVE.getNumber().equals(postStatus)) {
            dynamicObjectList = dynamicObjectList.stream().filter(dynamicObject -> !TenureStatusEnum.LEAVE.getNumber().equals(dynamicObject.getString("tenurestatus"))).collect(Collectors.toList());
        }
        return ((DynamicObject)dynamicObjectList.get(0)).getLong("cadrecat.id");
    }

    private void dealFuture(Future<List<DynamicObject>> listFuture, List<DynamicObject> resultList) throws Exception {
        while (!listFuture.isDone()) {
        }
        List<DynamicObject> dynamicObjectList = listFuture.get();
        if (!CollectionUtils.isEmpty(dynamicObjectList)) {
            resultList.addAll(dynamicObjectList);
        }
    }

    private Future<List<DynamicObject>> batchInit(List<CadreResumeBo> cadreResumeBos) {
        return THREAD_POOL.submit(() -> this.batchExecuteTask(cadreResumeBos));
    }

    private List<DynamicObject> batchExecuteTask(List<CadreResumeBo> cadreResumeBos) {
        Map<Long, CadreResumeBo> personMappingMap = cadreResumeBos.stream().collect(Collectors.toMap(CadreResumeBo::getPersonId, bo -> bo, (v1, v2) -> v1));
        List personIdList = cadreResumeBos.stream().map(CadreResumeBo::getPersonId).collect(Collectors.toList());
        DynamicObject[] resumeArrays = CADRE_RESUME_APPLICATION_SERVICE.queryByPersonIds(personIdList);
        Date sysUpdateTime = null;
        ArrayList resumeList = Lists.newArrayList();
        ArrayList addResumeList = Lists.newArrayList();
        ArrayList updateResumeList = Lists.newArrayList();
        if (resumeArrays != null && resumeArrays.length > 0) {
            Map<Long, List<DynamicObject>> resumePersonMapping = Arrays.stream(resumeArrays).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("person_id")));
            resumePersonMapping.remove(0L);
            Map<Long, List<DynamicObject>> finalResumePersonMapping = resumePersonMapping;
            cadreResumeBos.forEach(bo -> {
                Long personId = bo.getPersonId();
                if (personId == null || personId == 0L) {
                    return;
                }
                List dynamicObjectList = (List)finalResumePersonMapping.get(personId);
                if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) {
                    DynamicObject newObj = this.returnAddDynamic((CadreResumeBo)bo);
                    if (null != newObj) {
                        addResumeList.add(newObj);
                    }
                } else {
                    DynamicObject dynamicObject = (DynamicObject)dynamicObjectList.get(0);
                    updateResumeList.add(dynamicObject);
                }
            });
            sysUpdateTime = resumeArrays[0].getDate("sysupdatetime");
        } else {
            cadreResumeBos.forEach(bo -> addResumeList.add(this.returnAddDynamic((CadreResumeBo)bo)));
        }
        resumeList.addAll(addResumeList);
        resumeList.addAll(updateResumeList);
        resumeList.forEach(dynamicObject -> {
            boolean userSaved = dynamicObject.getBoolean("usersaved");
            long id = dynamicObject.getLong("id");
            long personId = 0L == id ? dynamicObject.getLong("person") : dynamicObject.getLong("person_id");
            if (0L == personId) {
                return;
            }
            CadreResumeBo bo = (CadreResumeBo)personMappingMap.get(personId);
            dynamicObject.set("sysupdatetime", (Object)bo.getNow());
            if (!userSaved) {
                dynamicObject.set("businessupdatetime", (Object)bo.getNow());
            }
            Long cadreId = bo.getCadreId();
            String tenureStatus = bo.getTenureStatus();
            dynamicObject.set("cadrecategory", (Object)cadreId);
            dynamicObject.set("poststatus", (Object)tenureStatus);
        });
        if (!CollectionUtils.isEmpty((Collection)addResumeList)) {
            List<Long> addPersonIdList = addResumeList.stream().map(dynamic -> dynamic.getLong("person")).collect(Collectors.toList());
            QFilter addQFilter = new QFilter("person", "in", addPersonIdList);
            this.batchTaskDeal(addResumeList, addPersonIdList, addQFilter, null);
        }
        if (!CollectionUtils.isEmpty((Collection)updateResumeList)) {
            List<Long> updatePersonIdList = updateResumeList.stream().map(dynamic -> dynamic.getLong("person_id")).collect(Collectors.toList());
            QFilter updateQFilter = new QFilter("person", "in", updatePersonIdList);
            if (null != sysUpdateTime) {
                updateQFilter.and("modifytime", ">=", (Object)sysUpdateTime);
            }
            QFilter commonQFilter = new QFilter("person", "in", updatePersonIdList);
            this.batchTaskDeal(updateResumeList, updatePersonIdList, updateQFilter, commonQFilter);
        }
        return resumeList;
    }

    private void batchTaskDeal(List<DynamicObject> resumeList, List<Long> personIdList, QFilter qFilter, QFilter commonQFilter) {
        HashMap param = Maps.newHashMap();
        param.put("searchType", Lists.newArrayList((Object[])new String[]{"001", "002", "004", "007", "009", "013", "015", "018", "024", "025"}));
        List stringPersonIdList = personIdList.stream().map(String::valueOf).collect(Collectors.toList());
        param.put("identifyIdType", "PERID");
        param.put("identifyId", stringPersonIdList);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{param});
        Map<Long, List<Map<String, Object>>> personBaseMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_pernontsprop");
        Map<Long, List<Map<String, Object>>> personReginInfoMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_perregion");
        Map<Long, List<Map<String, Object>>> jobInfoListMap = this.getPersonJobInfo(qFilter);
        Map<Long, List<Map<String, Object>>> empPosMap = this.getEmpPosInfo(commonQFilter == null ? qFilter : commonQFilter);
        this.setBaseInfo(resumeList, personBaseMap, personReginInfoMap, empPosMap, jobInfoListMap);
        QFilter idNumberFilter = new QFilter("person", "in", personIdList);
        idNumberFilter.and(new QFilter("credentialstype", "=", (Object)1010L));
        Map<Long, List<Map<String, Object>>> idNumberMap = this.getPersonIdNumber(idNumberFilter);
        List<DynamicObject> unUserSavedList = resumeList.stream().filter(dynamicObject -> !dynamicObject.getBoolean("usersaved")).collect(Collectors.toList());
        this.setUnSaveInfo(unUserSavedList, personBaseMap, empPosMap, personReginInfoMap, idNumberMap, result);
    }

    private Map<Long, List<Map<String, Object>>> getPersonIdNumber(QFilter idNumberFilter) {
        List idNumberList = ExternalDataService.getHrpiCommonInfoByFilter((String)"credentialstype,number,person", (QFilter)idNumberFilter, (String)"hrpi_percre");
        return CADRE_RESUME_COMMON_SERVICE.toPersonMap(idNumberList);
    }

    private void setUnSaveInfo(List<DynamicObject> unUserSavedList, Map<Long, List<Map<String, Object>>> personBaseMap, Map<Long, List<Map<String, Object>>> empPosMap, Map<Long, List<Map<String, Object>>> personReginInfoMap, Map<Long, List<Map<String, Object>>> idNumberMap, Map<String, Map<String, Object>> result) {
        Map<Long, List<Map<String, Object>>> personPerInfoMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_pertsprop");
        Map<Long, List<Map<String, Object>>> preEmpPosListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_preworkexp");
        Map<Long, List<Map<String, Object>>> learnListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_pereduexp");
        Map<Long, List<Map<String, Object>>> titleListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_perprotitle");
        Map<Long, List<Map<String, Object>>> langListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_languageskills");
        Map<Long, List<Map<String, Object>>> skillListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_rsmproskl");
        Map<Long, List<Map<String, Object>>> familyListMap = CADRE_RESUME_COMMON_SERVICE.getTargetResult(result, "hrpi_familymemb");
        unUserSavedList.forEach(resume -> {
            long personId;
            long id = resume.getLong("id");
            if (0L == id) {
                personId = resume.getLong("person");
            } else {
                DynamicObject person = resume.getDynamicObject("person");
                if (null == person) {
                    return;
                }
                personId = person.getLong("id");
            }
            Map<String, Object> personInfo = this.getInfo(personBaseMap, personId);
            Map<String, Object> personPreInfo = this.getInfo(personPerInfoMap, personId);
            Map<String, Object> reginInfo = this.getInfo(personReginInfoMap, personId);
            Map<String, Object> idNumberInfo = this.getInfo(idNumberMap, personId);
            String idNumber = (String)idNumberInfo.get("number");
            List<Map<String, Object>> titleInfoList = this.getCurrentPersonMultiInfo(titleListMap, personId);
            List<Map<String, Object>> educationInfoList = this.getCurrentPersonMultiInfo(learnListMap, personId);
            List<Map<String, Object>> langInfoList = this.getCurrentPersonMultiInfo(langListMap, personId);
            List<Map<String, Object>> preEmpPosInfoList = this.getCurrentPersonMultiInfo(preEmpPosListMap, personId);
            List<Map<String, Object>> skillInfoList = this.getCurrentPersonMultiInfo(skillListMap, personId);
            List<Map<String, Object>> familyInfoList = this.getCurrentPersonMultiInfo(familyListMap, personId);
            List currentEmpPosList = (List)empPosMap.get(personId);
            HashMap currentEmpPosMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)currentEmpPosList)) {
                currentEmpPosMap.put(personId, currentEmpPosList);
            }
            CadreResumeBatchBo bo = new CadreResumeBatchBo.CadreResumeBatchBoBuilder().Resume(resume).PersonBaseMap(personInfo).PersonPreMap(personPreInfo).EmpPosMap((Map)currentEmpPosMap).ReginInfo(reginInfo).EducationInfoList(educationInfoList).PreWorkExpList(preEmpPosInfoList).TitleInfoList(titleInfoList).LangList(langInfoList).SkillList(skillInfoList).FamilyList(familyInfoList).IdNUmber(idNumber).build();
            this.updateUnSaveInfo(bo, personId);
        });
    }

    private Map<Long, List<Map<String, Object>>> getEmpPosInfo(QFilter qFilter) {
        List empPosList = ExternalDataService.getHrpiCommonInfoByFilter((String)"businessstatus,person,company,adminorg,apositiontype,position,job,stdposition,isprimary,postype,startdate,enddate", (QFilter)qFilter, (String)"hrpi_empposorgrel");
        return CADRE_RESUME_COMMON_SERVICE.toPersonMap(empPosList);
    }

    private Map<Long, List<Map<String, Object>>> getPersonJobInfo(QFilter qFilter) {
        List jobInfoList = ExternalDataService.getHrpiCommonInfoByFilter((String)"joblevel,jobgrade,person", (QFilter)qFilter, (String)"hrpi_empjobrel");
        return CADRE_RESUME_COMMON_SERVICE.toPersonMap(jobInfoList);
    }

    private List<Map<String, Object>> getCurrentPersonMultiInfo(Map<Long, List<Map<String, Object>>> map, long personId) {
        return map.get(personId);
    }

    private Map<String, Object> getInfo(Map<Long, List<Map<String, Object>>> map, long personId) {
        List<Map<String, Object>> personBaseInfoList = map.get(personId);
        Map<Object, Object> result = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(personBaseInfoList)) {
            result = personBaseInfoList.get(0);
        }
        return result;
    }

    private void setBaseInfo(List<DynamicObject> resumeList, Map<Long, List<Map<String, Object>>> personBaseMap, Map<Long, List<Map<String, Object>>> personReginInfoMap, Map<Long, List<Map<String, Object>>> empPosMap, Map<Long, List<Map<String, Object>>> jobInfoListMap) {
        resumeList.forEach(resume -> {
            long personId;
            long id = resume.getLong("id");
            if (0L == id) {
                personId = resume.getLong("person");
            } else {
                DynamicObject person = resume.getDynamicObject("person");
                if (null == person) {
                    return;
                }
                personId = person.getLong("id");
            }
            List personBaseInfoList = (List)personBaseMap.get(personId);
            Map personInfo = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)personBaseInfoList)) {
                personInfo = (Map)personBaseInfoList.get(0);
            }
            List personReginInfoList = (List)personReginInfoMap.get(personId);
            Map perRegion = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)personReginInfoList)) {
                perRegion = (Map)personReginInfoList.get(0);
            }
            List jobInfoList = (List)jobInfoListMap.get(personId);
            Map jobInfoMap = Maps.newHashMap();
            if (!CollectionUtils.isEmpty((Collection)jobInfoList)) {
                jobInfoMap = (Map)jobInfoList.get(0);
            }
            this.updateBaseInfo((DynamicObject)resume, personInfo, perRegion, personId, jobInfoMap, empPosMap);
        });
    }

    private DynamicObject returnAddDynamic(CadreResumeBo bo) {
        Long personId = bo.getPersonId();
        Long employeeId = bo.getEmployeeId();
        if (personId == null || personId == 0L || employeeId == null || employeeId == 0L) {
            return null;
        }
        DynamicObject dynamicObject = CADRE_RESUME_APPLICATION_SERVICE.newDynamic();
        dynamicObject.set("employee", (Object)employeeId);
        dynamicObject.set("person", (Object)personId);
        dynamicObject.set("creator", (Object)1);
        dynamicObject.set("modifier", (Object)1);
        return dynamicObject;
    }

    private void updateBaseInfo(DynamicObject resume, Map<String, Object> personInfo, Map<String, Object> perRegion, Long personId, Map<String, Object> jobInfoMap, Map<Long, List<Map<String, Object>>> empMap) {
        Map<String, Object> mainPos;
        CADRE_RESUME_COMMON_SERVICE.updateRightTable(resume, empMap, personId);
        if (null != personInfo && personInfo.size() > 0) {
            resume.set("gender", personInfo.get("gender_id"));
            resume.set("servicelen", personInfo.get("servicelen"));
            resume.set("entservicelen", personInfo.get("entservicelen"));
        }
        if (null != perRegion && perRegion.size() > 0) {
            resume.set("politicalstatus", perRegion.get("politicalstatus_id"));
        }
        if (null != jobInfoMap && jobInfoMap.size() > 0) {
            Long jobLevel = jobInfoMap.get("joblevel_id") == null ? 0L : Long.parseLong(jobInfoMap.get("joblevel_id").toString());
            Long jobGrade = jobInfoMap.get("jobgrade_id") == null ? 0L : Long.parseLong(jobInfoMap.get("jobgrade_id").toString());
            resume.set("joblevel", (Object)jobLevel);
            resume.set("jobgrade", (Object)jobGrade);
        }
        if (!CollectionUtils.isEmpty(mainPos = CADRE_RESUME_COMMON_SERVICE.getMainPos(empMap, personId))) {
            resume.set("adminorg", mainPos.get("adminorg_id"));
        }
        if (HRDyObjectPropUtil.getId((DynamicObject)resume) == 0L) {
            List<Map<String, Object>> empPosMapList = empMap.get(personId);
            if (CollectionUtils.isEmpty(empPosMapList)) {
                resume.set("manpostservicelen", (Object)new BigDecimal(0));
                return;
            }
            List managerEmpPosList = ExternalDataService.filterManagerEmpPos(empPosMapList);
            BigDecimal bigDecimal = CADRE_RESUME_COMMON_SERVICE.setMainPostServiceLen(managerEmpPosList);
            resume.set("manpostservicelen", (Object)bigDecimal);
        }
    }

    private void updateUnSaveInfo(CadreResumeBatchBo bo, long personId) {
        List familyMemberList;
        List workTitleList;
        List perWorkExpList;
        List educationalInfoList;
        String idNumber;
        Map empMap;
        DynamicObject resume = bo.getResume();
        Map personInfo = bo.getPersonBaseMap();
        Map personPreInfo = bo.getPersonPreMap();
        Map perRegion = bo.getReginInfo();
        if (null != personInfo && personInfo.size() > 0) {
            resume.set("headsculpture", personInfo.get("headsculpture"));
            resume.set("folk", personInfo.get("folk_id"));
            resume.set("formername", personInfo.get("formername"));
            if (personInfo.get("birthday") != null) {
                try {
                    resume.set("birthday", (Object)HRDateTimeUtils.parseDate((String)personInfo.get("birthday").toString(), (String)"yyyy-MM-dd"));
                }
                catch (ParseException e) {
                    LOG.error("parse date fail by str date {}", personInfo.get("birthday"), (Object)e);
                }
            }
        }
        if (perRegion != null && perRegion.size() > 0) {
            resume.set("nativeplace", perRegion.get("nativeplace"));
            resume.set("birthplace", perRegion.get("birthplace"));
        }
        if (personPreInfo != null && personPreInfo.size() > 0) {
            resume.set("marriagestatus", personPreInfo.get("marriagestatus_id"));
            resume.set("healthstatus", personPreInfo.get("healthstatus_id"));
        }
        if (null != (empMap = bo.getEmpPosMap()) && empMap.size() > 0) {
            resume.set("workunitposition", (Object)CADRE_RESUME_COMMON_SERVICE.appendWorkUnitAndPosition(empMap, personId));
            resume.set("workunit", (Object)CADRE_RESUME_COMMON_SERVICE.getMainCompany(empMap, personId));
            resume.set("position", (Object)CADRE_RESUME_COMMON_SERVICE.getMainPosition(empMap, personId));
        }
        if (!HRStringUtils.isBlank((CharSequence)(idNumber = bo.getIdNumber()))) {
            resume.set("idnumber", (Object)idNumber);
        }
        if (!CollectionUtils.isEmpty((Collection)(educationalInfoList = bo.getEducationInfoList()))) {
            CADRE_RESUME_COMMON_SERVICE.updateEducationEntryInfo(educationalInfoList, resume);
            resume.set("ftdegree", (Object)CADRE_RESUME_COMMON_SERVICE.getEducationInfo(educationalInfoList));
            resume.set("ftcollegedeptmajor", (Object)CADRE_RESUME_COMMON_SERVICE.fullTimeGraduateInfo(educationalInfoList));
            resume.set("inservicedegree", (Object)CADRE_RESUME_COMMON_SERVICE.commonEducationInfo(educationalInfoList));
            resume.set("iscollegedeptmajor", (Object)CADRE_RESUME_COMMON_SERVICE.commonGraduateInfo(educationalInfoList));
        }
        if (!CollectionUtils.isEmpty((Collection)(perWorkExpList = bo.getPreWorkExpList())) || empMap != null && empMap.size() > 0) {
            resume.set("firstworktimeunit", (Object)CADRE_RESUME_COMMON_SERVICE.getFirstPos(empMap, perWorkExpList, personId));
        }
        if (!CollectionUtils.isEmpty((Collection)(workTitleList = bo.getTitleInfoList()))) {
            resume.set("dutytitle", (Object)CADRE_RESUME_COMMON_SERVICE.getWorkTitle(workTitleList));
        }
        if (null != perRegion && perRegion.size() > 0) {
            resume.set("religion", (Object)(perRegion.get("religion_name") == null ? "" : perRegion.get("religion_name").toString()));
        }
        List languageSkillsList = bo.getLangList();
        List skillList = bo.getSkillList();
        if (!CollectionUtils.isEmpty((Collection)languageSkillsList) || !CollectionUtils.isEmpty((Collection)skillList)) {
            resume.set("langskill", (Object)CADRE_RESUME_COMMON_SERVICE.languageAndSkillInfo(languageSkillsList, skillList));
        }
        if (!CollectionUtils.isEmpty((Collection)perWorkExpList) || empMap != null && empMap.size() > 0) {
            CADRE_RESUME_COMMON_SERVICE.updateWorkEntryInfo(perWorkExpList, empMap, personId, resume);
        }
        if (!CollectionUtils.isEmpty((Collection)(familyMemberList = bo.getFamilyList()))) {
            CADRE_RESUME_COMMON_SERVICE.updateFamilyEntryInfo(familyMemberList, resume);
        }
    }

    private String getPostStatus(List<DynamicObject> dynamicObjectList) {
        ArrayList statusList = Lists.newArrayList();
        dynamicObjectList.forEach(dynamicObject -> {
            String tenureStatus = dynamicObject.getString("tenurestatus");
            String postStatus = TenureStatusEnum.LEAVE.getNumber().equals(tenureStatus) ? CadreResumeStatusEnum.LEAVE.getNumber() : CadreResumeStatusEnum.IN_WORK.getNumber();
            statusList.add(postStatus);
        });
        if (statusList.contains(CadreResumeStatusEnum.IN_WORK.getNumber())) {
            return CadreResumeStatusEnum.IN_WORK.getNumber();
        }
        return CadreResumeStatusEnum.LEAVE.getNumber();
    }
}

