/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.resume;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.CadreResumeApplicationService;
import kd.tdc.cadm.formplugin.web.formservice.CadreResumeCommonService;

public class CadreResumeManagerLenTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(CadreResumeManagerLenTask.class);
    private static final int MAX_SAVE_SIZE = 2000;
    private static final CadreResumeCommonService CADRE_RESUME_COMMON_SERVICE = (CadreResumeCommonService)ServiceFactory.getService(CadreResumeCommonService.class);
    private static final CadreResumeApplicationService CADRE_RESUME_APPLICATION_SERVICE = (CadreResumeApplicationService)ServiceFactory.getService(CadreResumeApplicationService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] dynamicObjects = CADRE_RESUME_APPLICATION_SERVICE.getNeedUpdateManagerLenData();
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return;
        }
        this.executeServiceLen(dynamicObjects);
    }

    private void executeServiceLen(DynamicObject[] dynamicObjects) {
        Map<Long, DynamicObject> personDynamicMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("person_id"), dynamicObject -> dynamicObject, (v1, v2) -> v1));
        List<Long> personIdList = Arrays.stream(dynamicObjects).map(dynamic -> dynamic.getLong("person_id")).collect(Collectors.toList());
        ConcurrentMap empMap = Maps.newConcurrentMap();
        int len = personIdList.size();
        if (len > 2000) {
            int num = (len + 2000 - 1) / 2000;
            for (int i = 0; i < num; ++i) {
                int fromIndex = i * 2000;
                int toIndex = Math.min((i + 1) * 2000, len);
                List newList = personIdList.subList(fromIndex, toIndex);
                QFilter qFilter = new QFilter("person", "in", newList);
                List empPosList = ExternalDataService.getHrpiCommonInfoByFilter((String)"person,company,adminorg,apositiontype,position,job,stdposition,isprimary,postype,startdate,enddate", (QFilter)qFilter, (String)"hrpi_empposorgrel");
                List managerEmpPosList = ExternalDataService.filterManagerEmpPos((List)empPosList);
                empMap.putAll(CADRE_RESUME_COMMON_SERVICE.toPersonMap(managerEmpPosList));
            }
        } else {
            QFilter qFilter = new QFilter("person", "in", personIdList);
            List empPosList = ExternalDataService.getHrpiCommonInfoByFilter((String)"person,company,adminorg,apositiontype,position,job,stdposition,isprimary,postype,startdate,enddate", (QFilter)qFilter, (String)"hrpi_empposorgrel");
            empMap.putAll(CADRE_RESUME_COMMON_SERVICE.toPersonMap(ExternalDataService.filterManagerEmpPos((List)empPosList)));
        }
        Date now = new Date();
        personIdList.forEach(personId -> {
            List maps = (List)empMap.get(personId);
            DynamicObject dynamicObject = (DynamicObject)personDynamicMap.get(personId);
            BigDecimal bigDecimal = CADRE_RESUME_COMMON_SERVICE.setMainPostServiceLen(maps);
            dynamicObject.set("manpostservicelen", (Object)bigDecimal);
            if (!dynamicObject.getBoolean("usersaved")) {
                long currUserId = RequestContext.get().getCurrUserId();
                dynamicObject.set("modifier", (Object)currUserId);
                dynamicObject.set("modifytime", (Object)now);
                dynamicObject.set("businessupdatetime", (Object)now);
            }
        });
        int length = dynamicObjects.length;
        if (length > 2000) {
            int num = (len + 2000 - 1) / 2000;
            List<DynamicObject> resultList = Arrays.asList(dynamicObjects);
            for (int i = 0; i < num; ++i) {
                int fromIndex = i * 2000;
                int toIndex = Math.min((i + 1) * 2000, len);
                CADRE_RESUME_APPLICATION_SERVICE.commonBatchSave(resultList.subList(fromIndex, toIndex).toArray(new DynamicObject[0]));
            }
        } else {
            CADRE_RESUME_APPLICATION_SERVICE.commonBatchSave(dynamicObjects);
        }
    }
}

