/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.task.tenure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.helper.CadreParamHelper;
import kd.tdc.cadm.bussiness.license.CertHandleService;
import kd.tdc.tdcs.bussiness.license.TDCSCertCommonHelper;

public class GenerateInvalidTenureContinueTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(GenerateInvalidTenureContinueTask.class);
    private final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isOpenCadm = new CadreParamHelper().getOpenCadm();
        log.info("start to execute GenerateInvalidTenureContinueTask isOpenCadm\uff1a{}", (Object)isOpenCadm);
        Object[] allWaitEffectBills = this.nominateApplicationService.getAllWaitEffectBills("id,dismisseffectstatus,appointeffectstatus,appointdate,appointenddate,cmpemp,appointtype,person,employee,dposition,djob,dstandardposition,aposition,ajob,astandardposition,apositiontype,dismisstenure,atenure,prepositivedate,planenddate,isprimappoint,cadrecat");
        if (ArrayUtils.isEmpty((Object[])allWaitEffectBills)) {
            log.info("start to execute GenerateInvalidTenureContinueTask   fail by data is empty ");
            return;
        }
        List personIds = Arrays.stream(allWaitEffectBills).map(dynObj -> dynObj.getLong("person.id")).collect(Collectors.toList());
        Map certRstMap = TDCSCertCommonHelper.verifyCertByPersonId((String)"1W6FQ9DP=KX3", (String)"cadm_tenure", personIds);
        CertHandleService.handleForbidden((Map)certRstMap);
        Set nPermSet = CertHandleService.getNoCertPersonSet((Map)certRstMap);
        ArrayList appointList = Lists.newArrayList();
        ArrayList dismissList = Lists.newArrayList();
        ArrayList validTenureAppointList = Lists.newArrayList();
        long currentTime = System.currentTimeMillis();
        ArrayList validTenureList = Lists.newArrayList();
        ArrayList inValidTenureList = Lists.newArrayList();
        try {
            Arrays.stream(allWaitEffectBills).forEach(nominateBill -> {
                boolean dismissWaitEffectFlag;
                boolean appointWaitEffectFlag;
                Date appointDate = nominateBill.getDate("appointdate");
                String appointEffectStatus = nominateBill.getString("appointeffectstatus");
                Date appointEndDate = nominateBill.getDate("appointenddate");
                String dismissEffectStatus = nominateBill.getString("dismisseffectstatus");
                boolean personHasPerm = !nPermSet.contains(nominateBill.getLong("person.id"));
                boolean bl = appointWaitEffectFlag = null != appointDate && currentTime >= appointDate.getTime() && (HRStringUtils.isEmpty((String)appointEffectStatus) || "0".equals(appointEffectStatus)) && personHasPerm;
                if (appointWaitEffectFlag && isOpenCadm) {
                    appointList.add(nominateBill);
                    DynamicObject tenureNew = tenureApplicationService.directEffectiveTenure(nominateBill);
                    if (null != tenureNew) {
                        validTenureList.add(tenureNew);
                        validTenureAppointList.add(nominateBill);
                    }
                }
                boolean bl2 = dismissWaitEffectFlag = null != appointEndDate && currentTime > appointEndDate.getTime() && (HRStringUtils.isEmpty((String)dismissEffectStatus) || "0".equals(dismissEffectStatus));
                if (dismissWaitEffectFlag) {
                    dismissList.add(nominateBill);
                    long employeeId = HRDyObjectPropUtil.getId((DynamicObject)nominateBill.getDynamicObject("employee"));
                    DynamicObject[] invalidTenures = tenureApplicationService.directInvalidTenure(employeeId, nominateBill);
                    if (null != invalidTenures && invalidTenures.length > 0) {
                        inValidTenureList.addAll(Arrays.asList(invalidTenures));
                    }
                }
            });
            try (TXHandle required = TX.required();){
                DynamicObject[] dynamicObjects;
                if (!CollectionUtils.isEmpty((Collection)appointList)) {
                    appointList.forEach(dynamicObject -> dynamicObject.set("appointeffectstatus", (Object)"1"));
                    dynamicObjects = new DynamicObject[appointList.size()];
                    dynamicObjects = appointList.toArray(dynamicObjects);
                    this.nominateApplicationService.updateData(dynamicObjects);
                }
                if (!CollectionUtils.isEmpty((Collection)dismissList)) {
                    dismissList.forEach(dynamicObject -> dynamicObject.set("dismisseffectstatus", (Object)"1"));
                    dynamicObjects = new DynamicObject[dismissList.size()];
                    dynamicObjects = dismissList.toArray(dynamicObjects);
                    this.nominateApplicationService.updateData(dynamicObjects);
                }
                if (validTenureList.size() > 0) {
                    tenureApplicationService.batchSave(validTenureList.toArray(new DynamicObject[0]));
                }
                if (inValidTenureList.size() > 0) {
                    tenureApplicationService.updateData(inValidTenureList.toArray(new DynamicObject[0]));
                }
            }
            if (!required.isRollback()) {
                tenureApplicationService.updateAppointRemoveRelByReAppointment((List)validTenureAppointList);
            }
        }
        finally {
            CertHandleService.handleFail((Map)certRstMap);
        }
    }
}

