/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.CoopStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.formplugin.web.formservice.ExamineFormService;

public class AppointInfoPlugin
extends HRCoreBaseBillList {
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    private static final String COOPERATE_ENTRY = "cooperateentry";
    private static final String ISSUE_TIME = "issuetime";
    private static final String ISSUE_HANDLER = "issuehandler";
    private static final String PUB_START_DATE = "pubstartdate";
    private static final String PUB_END_DATE = "pubenddate";
    private static final String PUB_FILE_NUM = "pubfilenum";
    private static final String REVIEW_TOPIC = "reviewtopic";
    private static final String REVIEW_RESULT = "reviewresult";
    private static final String REVIEW_POINTS = "reviewpoints";
    private static final String REVIEW_COMMENT = "reviewcomment";
    private static final String EXAM_PLAN = "examplan";
    private static final String FORM_PLUGIN = "tdc-cadm-formplugin";
    private static final String PUBLICITY_PANEL = "attachmentpanelap";
    private static final String ISSUE_PANEL = "issueattachmentpanel";
    private static final String RELEASE_PANEL = "releaseattachmentpanel";
    private static final String GET_MORE_DETAIL = "getmoredetail";
    private static final ExamineFormService examineFormService = (ExamineFormService)ServiceFactory.getService(ExamineFormService.class);
    private static final AuditBillApplicationService auditBillApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ExamCoopBillApplicationService examCoopBillApplicationService = (ExamCoopBillApplicationService)ServiceFactory.getService(ExamCoopBillApplicationService.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ReleaseBillApplicationService releaseBillApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long tenureId = (Long)formShowParameter.getCustomParam("tenure");
        long appointId = tenureApplicationService.getAppointIdById(tenureId.longValue());
        if (appointId == 0L) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"appoint_panel"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"default_panel"});
        DynamicObject appointDO = nominateApplicationService.queryNominateBillById("applykind,id", appointId);
        if (HRObjectUtils.isEmpty((Object)appointDO)) {
            return;
        }
        cadmFormService.tenureShowAppointInfo(this.getView(), "appointinfoflex", appointDO);
        this.showAppointAudit(appointId);
        this.showExamInfo(appointId);
        this.showReviewInfo(appointId);
        this.showIssueInfo(appointId);
        this.showPublicInfo(appointId);
        this.showReleaseInfo(appointId);
        this.getView().setStatus(OperationStatus.VIEW);
        this.setDefaultValue();
        this.getModel().setDataChanged(false);
    }

    private void setDefaultValue() {
        DynamicObjectType dynamicObjectType = this.getModel().getDataEntity().getDynamicObjectType();
        DataEntityPropertyCollection properties = dynamicObjectType.getProperties();
        properties.forEach(property -> {
            String name = property.getName();
            if ("id".equals(name)) {
                return;
            }
            if (HRStringUtils.isBlank((CharSequence)name) || name.contains("entry")) {
                return;
            }
            String propertyName = property.getName();
            String typeName = property.getPropertyType().getName();
            Object value = this.getModel().getValue(propertyName);
            if ("java.lang.String".equals(typeName) && (null == value || HRStringUtils.isEmpty((String)value.toString()))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{propertyName});
                Label label = (Label)this.getControl(propertyName + "default");
                if (null == label) {
                    return;
                }
                label.setText("-");
                return;
            }
            if (null == value && "java.util.Date".equals(typeName)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{propertyName});
                Label label = (Label)this.getControl(propertyName + "default");
                if (null == label) {
                    return;
                }
                label.setText("-");
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{propertyName});
        });
    }

    private void showReleaseInfo(long appointId) {
        DynamicObject dynamicObject = releaseBillApplicationService.getEffectiveReleaseBillByNominateId(Long.valueOf(appointId));
        if (null == dynamicObject) {
            return;
        }
        String fileNum = dynamicObject.getString("relsfilenum");
        String batchNum = dynamicObject.getString("relsbatchnum");
        Date releaseTime = dynamicObject.getDate("releasetime");
        this.getModel().setValue("relsfilenum", (Object)fileNum);
        this.getModel().setValue("relsbatchnum", (Object)batchNum);
        this.getModel().setValue("releasetime", (Object)releaseTime);
        List releaseAttachment = AttachmentServiceHelper.getAttachments((String)"cadm_appointrelease", (Object)dynamicObject.getPkValue(), (String)ATTACHMENT_PANEL);
        if (null != releaseAttachment && !releaseAttachment.isEmpty()) {
            AttachmentPanel releaseAttachmentPanel = (AttachmentPanel)this.getView().getControl(RELEASE_PANEL);
            releaseAttachmentPanel.bindData(releaseAttachment);
        }
        this.getView().updateView("releaseflex");
    }

    private void showAppointAudit(long appointId) {
        IFormView view = this.getView();
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObject dynamicObject = auditBillApplicationService.queryAuditByAppointId("auditscheme,appoauditresult,comment,auditentry.audititem,auditentry.require,auditentry.result,auditentry.description,auditentry.attachment,attachmentpanel", Long.valueOf(appointId));
        if (null == dynamicObject) {
            return;
        }
        model.setValue("auditscheme", (Object)HRDyObjectPropUtil.getName((DynamicObject)dynamicObject.getDynamicObject("auditscheme")));
        model.setValue("appoauditresult", (Object)dynamicObject.getString("appoauditresult"));
        model.setValue("comment", (Object)dynamicObject.getString("comment"));
        List appointAuditAttachment = AttachmentServiceHelper.getAttachments((String)"cadm_publicity", (Object)dynamicObject.getPkValue(), (String)ATTACHMENT_PANEL);
        if (null != appointAuditAttachment && !appointAuditAttachment.isEmpty()) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)view.getControl("attachmentfield");
            attachmentPanel.bindData(appointAuditAttachment);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"attachmentfield"});
        }
        DynamicObjectCollection auditEntry = dynamicObject.getDynamicObjectCollection("auditentry");
        if (null == auditEntry || auditEntry.size() == 0) {
            return;
        }
        model.deleteEntryData("appointauditentryentity");
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"audititem", "require", "result", "description", "attachment"});
        for (int i = 0; i < auditEntry.size(); ++i) {
            tableValueSetter.addRow(new Object[]{HRDyObjectPropUtil.getName((DynamicObject)((DynamicObject)auditEntry.get(i)).getDynamicObject("audititem")), ((DynamicObject)auditEntry.get(i)).getString("require"), ((DynamicObject)auditEntry.get(i)).getString("result"), ((DynamicObject)auditEntry.get(i)).getString("description"), ((DynamicObject)auditEntry.get(i)).get("attachment")});
        }
        model.batchCreateNewEntryRow("appointauditentryentity", tableValueSetter);
        model.endInit();
        this.getView().updateView("auditschemeinfoflex");
        this.getView().updateView("appointauditentryentity");
    }

    private void showExamInfo(long appointId) {
        DynamicObjectCollection examPlanResultCollection;
        DynamicObject examDO = examineBillApplicationService.getExamInfo(appointId);
        if (HRObjectUtils.isEmpty((Object)examDO) || 0L == examDO.getLong("id")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GET_MORE_DETAIL});
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        long examineId = examDO.getLong("id");
        this.getPageCache().put("examid", String.valueOf(examineId));
        Long latestArrangeId = examineBillApplicationService.getLatestArrangeId(Long.valueOf(examineId));
        this.getPageCache().put("examarrangeId", String.valueOf(latestArrangeId));
        long examPlanId = examDO.getLong("examplan.id");
        model.setValue(EXAM_PLAN, (Object)examDO.getString("examplan.name"));
        model.setValue("examcomment", (Object)examDO.getString("examcomment"));
        long examPlanResultId = examineBillApplicationService.getExamPlanResultByExamPlanId(Long.valueOf(examPlanId));
        DynamicObject examPlanResultDO = examCoopBillApplicationService.queryExamResultPlanByExamResultPlanId(Long.valueOf(examPlanResultId));
        Set<Object> examPlanResultSet = new HashSet();
        if (!HRObjectUtils.isEmpty((Object)examPlanResultDO) && !(examPlanResultCollection = examPlanResultDO.getDynamicObjectCollection("entryentity")).isEmpty()) {
            examPlanResultSet = examPlanResultCollection.stream().map(dynamicObject -> dynamicObject.getString("result")).collect(Collectors.toSet());
        }
        DynamicObject[] examCooDOList = this.getExamCoopDataByExamineId(examineId);
        HashMap<String, Integer> resultStatistic = new HashMap<String, Integer>();
        if (!HRObjectUtils.isEmpty((Object)examCooDOList) && examCooDOList.length > 0) {
            this.getModel().deleteEntryData("entryentity");
            int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", examCooDOList.length);
            for (int i = 0; i < indexArr.length; ++i) {
                DynamicObject dynamicObject2 = examCooDOList[i];
                DynamicObjectCollection entryCollection = dynamicObject2.getDynamicObjectCollection("entryentity");
                Object[] examItemList = entryCollection.stream().map(entry -> entry.getDynamicObject("examitem").getLong("id")).toArray();
                this.getModel().setValue("planexamitem", (Object)examItemList, indexArr[i]);
                this.getModel().setValue("coopresultvalue", dynamicObject2.get("coopresult"), indexArr[i]);
                this.getModel().setValue("examinecoop", dynamicObject2.get("id"), indexArr[i]);
                String resultStr = dynamicObject2.getString("coopresult");
                if (!examPlanResultSet.contains(resultStr)) continue;
                resultStatistic.put(resultStr, resultStatistic.get(resultStr) == null ? 1 : (Integer)resultStatistic.get(resultStr) + 1);
            }
            this.getView().updateView("entryentity");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GET_MORE_DETAIL});
        }
        StringBuilder resultStatisticStr = new StringBuilder();
        resultStatistic.keySet().forEach(key -> resultStatisticStr.append((String)key).append(" : ").append(resultStatistic.get(key)).append("     "));
        this.getModel().setValue("examresult", (Object)resultStatisticStr);
        this.getView().updateView("examinflex");
    }

    public DynamicObject[] getExamCoopDataByExamineId(Long examineId) {
        String selectProperties = "coopstatus,examplan,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score";
        DynamicObject[] coops = examineBillApplicationService.queryExamineCoopById(selectProperties, examineId);
        Arrays.stream(coops).forEach(coop -> {
            if (!ExamCoopStatusEnum.COMPLETED.getNumber().equals(coop.getString("coopstatus"))) {
                coop.set("coopresult", (Object)"");
                coop.set("coopcomment", (Object)"");
                DynamicObjectCollection entryEntity = coop.getDynamicObjectCollection("entryentity");
                entryEntity.forEach(element -> element.set("score", (Object)0));
            }
        });
        return coops;
    }

    private void showReviewInfo(long appointId) {
        String selectField = "reviewtopic,reviewresult,reviewpoints,reviewcomment,reviewtime,reviewplace,cooperateentry.cooperater,cooperateentry.coopstatus,cooperateentry,cooperateentry.revresult,cooperateentry.revcomment";
        DynamicObject reviewBill = reviewBillApplicationService.getCompleteOneByNominateId(selectField, appointId);
        if (Objects.isNull(reviewBill)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.setValue(REVIEW_TOPIC, reviewBill.get(REVIEW_TOPIC));
        String result = "";
        result = !HRObjectUtils.isEmpty((Object)reviewBill.get(REVIEW_RESULT)) && "1".equals(reviewBill.get(REVIEW_RESULT).toString()) ? ResManager.loadKDString((String)"\u540c\u610f", (String)"AppointInfoPlugin_0", (String)FORM_PLUGIN, (Object[])new Object[0]) : (!HRObjectUtils.isEmpty((Object)reviewBill.get(REVIEW_RESULT)) && "2".equals(reviewBill.get(REVIEW_RESULT).toString()) ? ResManager.loadKDString((String)"\u4e0d\u540c\u610f", (String)"AppointInfoPlugin_1", (String)FORM_PLUGIN, (Object[])new Object[0]) : "");
        model.setValue(REVIEW_RESULT, (Object)result);
        model.setValue(REVIEW_POINTS, reviewBill.get(REVIEW_POINTS));
        model.setValue(REVIEW_COMMENT, reviewBill.get(REVIEW_COMMENT));
        model.setValue("reviewtime", (Object)reviewBill.getDate("reviewtime"));
        model.setValue("reviewplace", (Object)reviewBill.getString("reviewplace"));
        DynamicObjectCollection dynamicObjectCollection = reviewBill.getDynamicObjectCollection(COOPERATE_ENTRY);
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            this.getView().updateView("reviewflex");
            return;
        }
        model.deleteEntryData(COOPERATE_ENTRY);
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"cooperater", "reviewcoopstatus", "showresult", "showcomment"});
        for (int i = 0; i < dynamicObjectCollection.size(); ++i) {
            String coopstatus = ((DynamicObject)dynamicObjectCollection.get(i)).getString("coopstatus");
            if (CoopStatusEnum.DISCARD.getVal().equals(coopstatus)) continue;
            tableValueSetter.addRow(new Object[]{HRDyObjectPropUtil.getName((DynamicObject)((DynamicObject)dynamicObjectCollection.get(i)).getDynamicObject("cooperater")), coopstatus, ((DynamicObject)dynamicObjectCollection.get(i)).getString("revresult"), ((DynamicObject)dynamicObjectCollection.get(i)).getString("revcomment")});
        }
        model.batchCreateNewEntryRow(COOPERATE_ENTRY, tableValueSetter);
        model.endInit();
        this.getView().updateView(COOPERATE_ENTRY);
        this.getView().updateView("reviewflex");
    }

    private void showPublicInfo(long appointId) {
        DynamicObject reviewDO = publicityBillApplicationService.queryPublicityBillByAppointId("pubfilenum,pubstartdate,pubenddate,pubbatchnum,pubresult,resultdesc", Long.valueOf(appointId));
        if (HRObjectUtils.isEmpty((Object)reviewDO)) {
            return;
        }
        this.getModel().setValue(PUB_FILE_NUM, reviewDO.get(PUB_FILE_NUM));
        this.getModel().setValue(PUB_START_DATE, (Object)(reviewDO.get(PUB_START_DATE) == null ? "" : HRDateTimeUtils.format((Date)reviewDO.getDate(PUB_START_DATE), (String)"yyyy-MM-dd ")));
        this.getModel().setValue(PUB_END_DATE, (Object)(reviewDO.get(PUB_END_DATE) == null ? "" : HRDateTimeUtils.format((Date)reviewDO.getDate(PUB_END_DATE), (String)"yyyy-MM-dd ")));
        this.getModel().setValue("pubbatchnum", (Object)reviewDO.getString("pubbatchnum"));
        this.getModel().setValue("pubresult", (Object)reviewDO.getString("pubresult"));
        this.getModel().setValue("resultdesc", (Object)reviewDO.getString("resultdesc"));
        List publicityAttachment = AttachmentServiceHelper.getAttachments((String)"cadm_publicity", (Object)reviewDO.getPkValue(), (String)ATTACHMENT_PANEL);
        if (null != publicityAttachment && !publicityAttachment.isEmpty()) {
            AttachmentPanel attachmentPaneLap = (AttachmentPanel)this.getView().getControl(PUBLICITY_PANEL);
            attachmentPaneLap.bindData(publicityAttachment);
        }
        this.getView().updateView("publictyflex");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label label = (Label)this.getControl(GET_MORE_DETAIL);
        label.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (GET_MORE_DETAIL.equals(source.getKey())) {
            String arrangeId;
            String examId = this.getPageCache().get("examid");
            if (HRStringUtils.isBlank((CharSequence)examId)) {
                examId = "0";
            }
            if (HRStringUtils.isBlank((CharSequence)(arrangeId = this.getPageCache().get("examarrangeId")))) {
                arrangeId = "0";
            }
            examineFormService.openMoreDetail(this.getView(), Long.parseLong(examId), Long.parseLong(arrangeId));
        }
    }

    private void showIssueInfo(long appointId) {
        DynamicObject issueDO = issueBillApplicationService.queryOneByNominateId("id,issuetime,issuehandler,issueresult,issueoptions", appointId);
        if (Objects.isNull(issueDO)) {
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)issueDO.get(ISSUE_TIME))) {
            this.getModel().setValue(ISSUE_TIME, (Object)HRDateTimeUtils.format((Date)issueDO.getDate(ISSUE_TIME), (String)"yyyy-MM-dd"));
        }
        this.getModel().setValue(ISSUE_HANDLER, issueDO.get("issuehandler.name"));
        this.getModel().setValue("issueresult", (Object)issueDO.getString("issueresult"));
        this.getModel().setValue("issueoptions", (Object)issueDO.getString("issueoptions"));
        List issueAttachment = AttachmentServiceHelper.getAttachments((String)"cadm_appointissue", (Object)issueDO.getPkValue(), (String)ATTACHMENT_PANEL);
        if (null != issueAttachment && !issueAttachment.isEmpty()) {
            AttachmentPanel issueAttachmentPanel = (AttachmentPanel)this.getView().getControl(ISSUE_PANEL);
            issueAttachmentPanel.bindData(issueAttachment);
        }
        this.getView().updateView("issueflex");
    }
}

