/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.util.PermissionUtil;
import kd.tdc.cadm.common.enums.PositionTypeEnum;
import kd.tdc.tdcs.bussiness.application.external.ExternalService;

public class EffectTenureWindowPlugin
extends HRDynamicFormBasePlugin {
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String POSITION = "position";
    private static final String JOB = "job";
    private static final String STANDARD_POSITION = "standardpost";
    private static final String POSITION_TYPE = "apositiontype";
    private static final String CURRENT_POSITION = "currentposition";
    private static final String CLICK_OK = "donothing_selecttenure";

    public void beforeBindData(EventObject e) {
        long employeeId;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object employeeObjId = customParams.get("employee");
        Object operateKey = customParams.get("operateKey");
        this.getPageCache().put("operateKey", operateKey.toString());
        if (null == employeeObjId || (employeeId = Long.parseLong(employeeObjId.toString())) == 0L) {
            return;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        List permissionQFilter = PermissionUtil.getPermissionQFilter((String)"cadm_tenure", (long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac");
        if (CollectionUtils.isNotEmpty((Collection)permissionQFilter)) {
            qFilters.addAll(permissionQFilter);
        }
        qFilters.add(new QFilter("employee", "=", (Object)employeeId));
        qFilters.add(new QFilter("tenurestatus", "!=", (Object)TenureStatusEnum.LEAVE.getNumber()));
        Object[] dynamicObjects = tenureApplicationService.queryEmployeeTenureData("position,job,standardpost,apositiontype,id,depemp", qFilters.toArray(new QFilter[0]), "createtime desc");
        if (ArrayUtils.isEmpty((Object[])dynamicObjects)) {
            return;
        }
        List depempIds = Arrays.stream(dynamicObjects).map(p -> p.getLong("depemp.id")).distinct().collect(Collectors.toList());
        List empOrgrelsList = ExternalService.listDataEmpOrgrels(depempIds);
        IDataModel model = this.getModel();
        int[] entryEntities = model.batchCreateNewEntryRow(ENTRY_ENTITY, dynamicObjects.length);
        for (int i = 0; i < entryEntities.length; ++i) {
            DynamicObject position = dynamicObjects[i].getDynamicObject(POSITION);
            DynamicObject job = dynamicObjects[i].getDynamicObject(JOB);
            DynamicObject standardPost = dynamicObjects[i].getDynamicObject(STANDARD_POSITION);
            String positionType = dynamicObjects[i].getString(POSITION_TYPE);
            long depempId = dynamicObjects[i].getLong("depemp.id");
            Optional<Map> depempOptional = empOrgrelsList.stream().filter(p -> p.get("depemp") != null && (Long)p.get("depemp") == depempId).findFirst();
            if (depempOptional.isPresent()) {
                Map map = depempOptional.get();
                long posTypeId = map.get("postype") == null ? 0L : Long.parseLong(String.valueOf(map.get("postype")));
                model.setValue("postype", (Object)posTypeId, i);
            }
            if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
                model.setValue(CURRENT_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)position), i);
            }
            if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
                model.setValue(CURRENT_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)job), i);
            }
            if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
                model.setValue(CURRENT_POSITION, (Object)HRDyObjectPropUtil.getName((DynamicObject)standardPost), i);
            }
            model.setValue("tenure", dynamicObjects[i].getPkValue(), i);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (CLICK_OK.equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c", (String)"EffectTenureWindowPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRY_ENTITY);
            int selectRowNum = selectRows[0];
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRowNum);
            DynamicObject tenure = dynamicObject.getDynamicObject("tenure");
            HashMap returnMap = Maps.newHashMap();
            operateKey = this.getPageCache().get("operateKey");
            returnMap.put("tenure", HRDyObjectPropUtil.getId((DynamicObject)tenure));
            returnMap.put("operateKey", operateKey);
            returnMap.put("showResult", dynamicObject.getString(CURRENT_POSITION));
            returnMap.put("postype", dynamicObject.getLong("postype.id"));
            this.getView().returnDataToParent((Object)returnMap);
            this.getView().close();
        }
    }
}

