/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRBaseDataCommonEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;

public class TenureBasePlugin
extends HRBaseDataCommonEdit {
    private static final Log LOG = LogFactory.getLog(TenureBasePlugin.class);
    private static final String SUPERVISORY_ENTRY_ENTITY = "supervisoryentryentity";
    private static final String GENERAL_FLEX = "generalflex";
    private static final String TAMP_ATT_CACHE = "TampAttCache";
    private static final String PRE_POSITIVE_DATE = "prepositivedate";
    private static final String POSITIVE_ENTRY_ENTITY = "positiveentryentity";
    private static final String APPOINT_DATE = "appointdate";
    private static final String NO_DATE_CARD_ENTRY = "nodatecardentry";
    private static final String EXAM_HIS_FLEX_PANEL = "examhisflexpanel";
    private static final String BEFORE_DELETE_ENTRY = "before_delete_entry";
    private static final String TENURE_MANAGE_CANCEL = "tenure_manage_cancel";
    private static final String TENURE_ASSESS_CANCEL = "tenure_assess_cancel";
    private static final String MODIFY_LIMIT_ID = "4715a0df000000ac";
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final ExpedBillApplicationService expedBillApplicationService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final List<String> LABEL_LIST = Arrays.asList("personalinfo", "properiod", "performancebill", "supvinfo", "outreprecordlist", "avoidinfomation", "tenure", "appointinfo", "empposorgrel", "pereduexp", "memberlabel", "empproexp", "emptrainfile", "perrprecord");
    private static final List<String> LABEL_LIST_4_PAGE_TDCS = Arrays.asList("personalinfo", "appointinfo", "performancebill", "empposorgrel", "pereduexp", "memberlabel", "empproexp", "emptrainfile", "perrprecord", "avoidinfomation", "outreprecordlist");

    public void afterBindData(EventObject eventObject) {
        this.setColor("personalinfo", "personalinfo");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long pkId = Long.parseLong(((BaseShowParameter)formShowParameter).getPkId().toString());
        String selectField = "employee,person,appoint_id,extenuredate,tenurestatus,realstartdate,assessdate,assessresult,assesscontent,planstartdate,planenddate,realenddate,depemp";
        DynamicObject tenureDO = tenureApplicationService.queryTenureOneById(selectField, (Object)pkId);
        Long employeeId = tenureDO.getDynamicObject("employee") == null ? 0L : tenureDO.getDynamicObject("employee").getLong("id");
        Long personId = tenureDO.getDynamicObject("person") == null ? 0L : tenureDO.getDynamicObject("person").getLong("id");
        Long depEmpId = tenureDO.getDynamicObject("depemp") == null ? 0L : tenureDO.getDynamicObject("depemp").getLong("id");
        long appointId = tenureDO.getLong("appoint_id");
        this.getPageCache().put("pkId", pkId.toString());
        this.getPageCache().put("employeeId", employeeId.toString());
        this.getPageCache().put("personId", personId.toString());
        this.getPageCache().put("depempId", depEmpId.toString());
        this.getPageCache().put("appointId", Long.toString(appointId));
        if (!HRObjectUtils.isEmpty((Object)tenureDO) && TenureStatusEnum.LEAVE.getNumber().equals(tenureDO.getString("tenurestatus"))) {
            this.getPageCache().put("isTenureLeave", "1");
        } else {
            this.getPageCache().put("isTenureLeave", "0");
        }
        this.getPageCache().put("tenureDO", SerializationUtils.serializeToBase64((Object)tenureDO));
        this.hiddenAllFlex();
        FormShowParameter head = new FormShowParameter();
        head.getOpenStyle().setShowType(ShowType.InContainer);
        head.getOpenStyle().setTargetKey("head");
        head.setFormId("cadm_perbaseinfo");
        head.setStatus(OperationStatus.VIEW);
        head.setCustomParam("tenure", (Object)pkId);
        this.getView().showForm(head);
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        baseShowParameter.getOpenStyle().setTargetKey(GENERAL_FLEX);
        baseShowParameter.setFormId("tdcs_personalinfo");
        baseShowParameter.setStatus(OperationStatus.VIEW);
        baseShowParameter.setCustomParam("employee", (Object)employeeId);
        baseShowParameter.setCustomParam("person", (Object)personId);
        baseShowParameter.setCustomParam("tenureId", (Object)pkId);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{GENERAL_FLEX});
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (LABEL_LIST.contains(source.getKey())) {
            this.clickLabelChangeForeColor(source.getKey());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess()) {
            return;
        }
        this.opSupervisory(operateKey, args);
        this.opTenure(operateKey, args);
        this.opTenureExam(operateKey, args);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        LABEL_LIST.forEach(label -> ((Button)this.getView().getControl(label)).addClickListener((ClickListener)this));
    }

    private void opTenureExam(String operateKey, AfterDoOperationEventArgs args) {
        if ("updateexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"assessdate", "assessresult", "assesscontent", "tenureattachment"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"saveexam", "cancelexam"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updateexam"});
            Date tenureRealStartTime = (Date)this.getModel().getValue("tenurerealstarttime");
            Date realEndDate = (Date)this.getModel().getValue("realenddate");
            DateEdit dateEdit = (DateEdit)this.getControl("assessdate");
            if (tenureRealStartTime != null) {
                dateEdit.setMinDate(tenureRealStartTime);
            } else {
                dateEdit.setMinDate(new Date(-9223372036854775807L));
            }
            if (realEndDate != null) {
                dateEdit.setMaxDate(HRDateTimeUtils.addDay((Date)realEndDate, (long)-1L));
            }
        }
        if ("cancelexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String changeDesc = this.getAssessFiledChangeDesc();
            if (!HRStringUtils.isEmpty((String)changeDesc)) {
                this.showTenureCancelConfirmForm(changeDesc, TENURE_ASSESS_CANCEL);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveexam"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelexam"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"updateexam"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessdate"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessresult"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"assesscontent"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"tenureattachment"});
                this.deleteAllAttachmentFieldData();
                this.getView().updateView("tenureattachment");
            }
        }
        if ("saveexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"extenuredate"});
            DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
            dynamicObject.set("assessdate", this.getModel().getValue("assessdate"));
            dynamicObject.set("assessresult", this.getModel().getValue("assessresult"));
            dynamicObject.set("assesscontent", this.getModel().getValue("assesscontent"));
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
            tenureApplicationService.saveOne(dynamicObject);
            this.saveAttachment();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessdate"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessresult"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assesscontent"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"tenureattachment"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveexam"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelexam"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updateexam"});
            DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
            tenureDO.set("assessdate", this.getModel().getValue("assessdate"));
            tenureDO.set("assessresult", this.getModel().getValue("assessresult"));
            tenureDO.set("assesscontent", this.getModel().getValue("assesscontent"));
            this.getPageCache().put("tenureDO", SerializationUtils.serializeToBase64((Object)tenureDO));
        }
    }

    private void opSupervisory(String operateKey, AfterDoOperationEventArgs args) {
        BaseShowParameter formShowParameter;
        if ("addsupv".equals(operateKey) && args.getOperationResult().isSuccess()) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("cadm_supervisoryinfo");
            formShowParameter.setCustomParam("operation", (Object)"add");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "supervisory"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
        if ("deletesupv".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u6570\u636e\u5c06\u88ab\u5220\u9664\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TenureBasePlugin_11", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BEFORE_DELETE_ENTRY, (IFormPlugin)this));
        }
        if ("modifysupe".equals(operateKey) && args.getOperationResult().isSuccess()) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("cadm_supervisoryinfo");
            formShowParameter.setStatus(OperationStatus.ADDNEW);
            formShowParameter.setCustomParam("id", (Object)Long.parseLong(this.getPageCache().get("employeeId")));
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(SUPERVISORY_ENTRY_ENTITY);
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity(SUPERVISORY_ENTRY_ENTITY).get(entryCurrentRowIndex);
            String base64 = SerializationUtils.serializeToBase64((Object)dynamicObject);
            formShowParameter.setCustomParam("entryDO", (Object)base64);
            formShowParameter.setCustomParam("operation", (Object)"edit");
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "supervisory"));
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (BEFORE_DELETE_ENTRY.equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().invokeOperation("deleteentrysupe");
            this.getView().invokeOperation("saveentry");
            this.flexHandlerSupervisory();
            this.getModel().setDataChanged(false);
        }
        this.confirmCallBackTenureManager(evt);
        this.confirmCallBackTenureAssess(evt);
    }

    private void confirmCallBackTenureManager(MessageBoxClosedEvent evt) {
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)TENURE_MANAGE_CANCEL) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
            this.getModel().setValue("extenuredate", (Object)tenureDO.getDate("extenuredate"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"extenuredate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savemanage", "cancelmanage"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatemanage"});
        }
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)TENURE_MANAGE_CANCEL) && MessageBoxResult.Cancel.equals((Object)evt.getResult())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"extenuredate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"savemanage", "cancelmanage"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatemanage"});
        }
    }

    private void confirmCallBackTenureAssess(MessageBoxClosedEvent evt) {
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)TENURE_ASSESS_CANCEL) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
            this.getModel().setValue("assessdate", (Object)tenureDO.getDate("assessdate"));
            this.getModel().setValue("assessresult", tenureDO.get("assessresult"));
            this.getModel().setValue("assesscontent", tenureDO.get("assesscontent"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessdate", "tenureattachment", "assessresult", "assesscontent"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveexam", "cancelexam"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updateexam"});
            this.getView().updateView("tenureexamflex");
        }
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)TENURE_ASSESS_CANCEL) && MessageBoxResult.Cancel.equals((Object)evt.getResult())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"assessdate", "assessresult", "assesscontent", "tenureattachment"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"saveexam", "cancelexam"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updateexam"});
        }
    }

    private void opTenure(String operateKey, AfterDoOperationEventArgs args) {
        if ("updatemanage".equals(operateKey)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"extenuredate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"savemanage", "cancelmanage"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatemanage"});
            Date tenurePlanStartTime = (Date)this.getModel().getValue("tenureplanstarttime");
            DateEdit dateEdit = (DateEdit)this.getControl("extenuredate");
            if (tenurePlanStartTime != null) {
                dateEdit.setMinDate(tenurePlanStartTime);
            } else {
                dateEdit.setMinDate(new Date(-9223372036854775807L));
            }
        }
        if ("cancelmanage".equals(operateKey) && args.getOperationResult().isSuccess()) {
            Date date = (Date)this.getModel().getValue("extenuredate");
            if (this.checkExTenureDateIsChange(date)) {
                String changeDesc = ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a\u8c03\u6574\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f", (String)"TenureBasePlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
                this.showTenureCancelConfirmForm(changeDesc, TENURE_MANAGE_CANCEL);
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"savemanage", "cancelmanage"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatemanage"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"extenuredate"});
            }
        }
        if ("savemanage".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"extenuredate"});
            DynamicObject dynamicObject = this.getView().getModel().getDataEntity();
            dynamicObject.set("extenuredate", this.getModel().getValue("extenuredate"));
            dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dynamicObject.set("modifytime", (Object)new Date());
            tenureApplicationService.saveOne(dynamicObject);
            DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
            tenureDO.set("extenuredate", this.getModel().getValue("extenuredate"));
            this.getPageCache().put("tenureDO", SerializationUtils.serializeToBase64((Object)tenureDO));
            this.getView().updateView("tenuremangeflex");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"savemanage", "cancelmanage"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatemanage"});
        }
    }

    private boolean checkExTenureDateIsChange(Date date) {
        DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
        Date oldDate = tenureDO.getDate("extenuredate");
        if (oldDate == null && date == null) {
            return false;
        }
        if (oldDate == null && date != null || oldDate != null && date == null) {
            return true;
        }
        return oldDate.compareTo(date) != 0;
    }

    private String getAssessFiledChangeDesc() {
        String changeDesc = "";
        DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
        Date oldAssessDate = tenureDO.getDate("assessdate");
        String oldAssessResult = tenureDO.getString("assessresult");
        String oldAssessContent = tenureDO.getString("assesscontent");
        StringBuilder changeDescBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5355\u636e\u5934\u53d8\u52a8\u5b57\u6bb5\uff1a", (String)"TenureBasePlugin_10", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        Date assessDate = (Date)this.getModel().getValue("assessdate");
        Object assessResultObject = this.getModel().getValue("assessresult");
        String assessResult = HRObjectUtils.isEmpty((Object)assessResultObject) ? "" : assessResultObject.toString();
        Object assessContentObject = this.getModel().getValue("assesscontent");
        String assessContent = HRObjectUtils.isEmpty((Object)assessContentObject) ? "" : assessContentObject.toString();
        ArrayList<String> strList = new ArrayList<String>();
        this.setTenureAssessDate(oldAssessDate, assessDate, strList);
        this.setTenureResult(oldAssessResult, assessResult, strList);
        this.setTenureContent(oldAssessContent, assessContent, strList);
        if (!CollectionUtils.isEmpty(strList)) {
            changeDesc = changeDescBuilder.append(StringUtils.join((Object[])strList.toArray(), (String)"\uff0c")).toString();
        }
        return changeDesc;
    }

    private void setTenureContent(String oldAssessContent, String assessContent, List<String> strList) {
        if (!HRObjectUtils.equals((Object)oldAssessContent, (Object)assessContent)) {
            strList.add(ResManager.loadKDString((String)"\u8003\u6838\u5185\u5bb9", (String)"TenureBasePlugin_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setTenureResult(String oldAssessResult, String assessResult, List<String> strList) {
        if (!HRObjectUtils.equals((Object)oldAssessResult, (Object)assessResult)) {
            strList.add(ResManager.loadKDString((String)"\u8003\u6838\u7ed3\u679c", (String)"TenureBasePlugin_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
    }

    private void setTenureAssessDate(Date oldAssessDate, Date assessDate, List<String> strList) {
        if (oldAssessDate == null && assessDate != null) {
            strList.add(ResManager.loadKDString((String)"\u8003\u6838\u65e5\u671f", (String)"TenureBasePlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (oldAssessDate != null && assessDate == null) {
            strList.add(ResManager.loadKDString((String)"\u8003\u6838\u65e5\u671f", (String)"TenureBasePlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (oldAssessDate != null && Objects.requireNonNull(oldAssessDate).compareTo(assessDate) != 0) {
            strList.add(ResManager.loadKDString((String)"\u8003\u6838\u65e5\u671f", (String)"TenureBasePlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        }
    }

    private void showTenureCancelConfirmForm(String changeDesc, String actionId) {
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TenureBasePlugin_14", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"TenureBasePlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        String msg = String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"TenureBasePlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), System.lineSeparator());
        this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener(actionId, (IFormPlugin)this), btnNameMaps);
    }

    private void saveAttachment() {
        String attachStr = (String)this.getPageCache().getAll().get(TAMP_ATT_CACHE + this.getView().getPageId());
        if (HRStringUtils.isNotEmpty((String)attachStr)) {
            Map attachments = (Map)SerializationUtils.fromJsonString((String)attachStr, Map.class);
            List attachmentsList = (List)attachments.get("tenureattachment");
            HashMap<String, List> attachmentInfo = new HashMap<String, List>();
            attachmentInfo.put("tenureattachment", attachmentsList);
            AttachmentServiceHelper.saveTempAttachments((String)"cadm_tenure", (Object)Long.parseLong(this.getPageCache().get("pkId")), (String)"cadm", attachmentInfo);
            this.getPageCache().getAll().put(TAMP_ATT_CACHE + this.getView().getPageId(), null);
            IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
            cache.remove(TAMP_ATT_CACHE + this.getView().getPageId());
        }
    }

    private void clickLabelChangeForeColor(String label) {
        LABEL_LIST.forEach(allLabel -> this.setColor(label, (String)allLabel));
        this.clickLabelShowPage(label);
    }

    private void setColor(String label, String allLabel) {
        HashMap<String, String> itemMap = new HashMap<String, String>();
        HashMap<String, String> flexMap = new HashMap<String, String>();
        HashMap<String, String> leftBordMap = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> leftBordStyleMap = new HashMap<String, HashMap<String, String>>();
        HashMap<String, HashMap<String, HashMap<String, String>>> styleMap = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        if (allLabel.equals(label)) {
            itemMap.put("fc", "themeColor");
            this.getView().updateControlMetadata(label, itemMap);
            flexMap.put("bc", "#F2F6FF");
            this.getView().updateControlMetadata(label + "labelflex", flexMap);
            leftBordMap.put("l", "1px_solid_themeColor");
            leftBordStyleMap.put("b", leftBordMap);
            styleMap.put("s", leftBordStyleMap);
            this.getView().updateControlMetadata(label + "labelflex", styleMap);
        } else {
            itemMap.put("fc", "#000000");
            this.getView().updateControlMetadata(allLabel, itemMap);
            flexMap.put("bc", "#fff");
            this.getView().updateControlMetadata(allLabel + "labelflex", flexMap);
            leftBordMap.put("l", "0px");
            leftBordStyleMap.put("b", leftBordMap);
            styleMap.put("s", leftBordStyleMap);
            this.getView().updateControlMetadata(allLabel + "labelflex", styleMap);
        }
    }

    private void clickLabelShowPage(String label) {
        if (LABEL_LIST_4_PAGE_TDCS.contains(label)) {
            this.hiddenAllFlex();
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"cadm", (String)"cadm_tenure", (String)MODIFY_LIMIT_ID);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            formShowParameter.getOpenStyle().setTargetKey(GENERAL_FLEX);
            formShowParameter.setStatus(hasPerm ? OperationStatus.EDIT : OperationStatus.VIEW);
            formShowParameter.setCustomParam("person", (Object)Long.parseLong(this.getPageCache().get("personId")));
            formShowParameter.setCustomParam("employee", (Object)Long.parseLong(this.getPageCache().get("employeeId")));
            if ("outreprecordlist".equals(label)) {
                formShowParameter.setFormId("tdcs_outreprecordlist");
                formShowParameter.setCustomParam("isTenureLeave", (Object)this.getPageCache().get("isTenureLeave"));
            } else if ("appointinfo".equals(label)) {
                formShowParameter.setFormId("cadm_" + label);
                formShowParameter.setCustomParam("tenure", (Object)Long.parseLong(this.getPageCache().get("pkId")));
                this.getView().setStatus(OperationStatus.VIEW);
            } else {
                formShowParameter.setFormId("tdcs_" + label);
                formShowParameter.setCustomParam("tenure", (Object)Long.parseLong(this.getPageCache().get("pkId")));
                this.getView().setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm(formShowParameter);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{GENERAL_FLEX});
        } else {
            if ("tenure".equals(label)) {
                this.flexHandlerTenure();
            }
            if ("properiod".equals(label)) {
                this.flexHandlerProPeriod();
            }
            if ("supvinfo".equals(label)) {
                this.flexHandlerSupervisory();
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{GENERAL_FLEX});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{label + "flex"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if ("supervisory".equals(closedCallBackEvent.getActionId())) {
            this.flexHandlerSupervisory();
        }
    }

    private void hiddenAllFlex() {
        LABEL_LIST.forEach(label -> this.getView().setVisible(Boolean.valueOf(false), new String[]{label + "flex"}));
        this.getView().setVisible(Boolean.valueOf(false), new String[]{GENERAL_FLEX});
    }

    private void flexHandlerSupervisory() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"properiodflex", "tenureflex"});
        DynamicObjectCollection supervisoryEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(SUPERVISORY_ENTRY_ENTITY);
        DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
        int isShowButton = 1;
        if (!HRObjectUtils.isEmpty((Object)tenureDO) && TenureStatusEnum.LEAVE.getNumber().equals(tenureDO.getString("tenurestatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cardentryfixrowap"});
            isShowButton = 0;
        }
        List dynamicObjects = supervisoryEntryEntity.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("recorddate"), Comparator.reverseOrder())).collect(Collectors.toList());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            ((DynamicObject)dynamicObjects.get(i)).set("isshowlinesuper", (Object)(dynamicObjects.size() == 1 ? 1 : dynamicObjects.size() - 1 - i));
            ((DynamicObject)dynamicObjects.get(i)).set("isshowbutton", (Object)isShowButton);
        }
        supervisoryEntryEntity.clear();
        supervisoryEntryEntity.addAll(dynamicObjects);
        this.getModel().getDataEntity(true).set(SUPERVISORY_ENTRY_ENTITY, (Object)supervisoryEntryEntity);
        this.getView().updateView(SUPERVISORY_ENTRY_ENTITY);
        this.getModel().setDataChanged(false);
    }

    private void flexHandlerProPeriod() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"supvinfoflex", "tenureflex"});
        this.getView().setStatus(OperationStatus.VIEW);
        DynamicObject appointBill = nominateApplicationService.queryNominateBillAppointDateByPKId(Long.parseLong(this.getPageCache().get("appointId")));
        if (!ObjectUtils.isEmpty((Object)appointBill)) {
            this.getModel().setValue("planstartdate", (Object)appointBill.getDate(APPOINT_DATE));
        }
        String selectField = "position.id,prepositivedate,positiveentryentity,positiveentryentity.operation";
        DynamicObject tenureDO = tenureApplicationService.queryTenureOneById(selectField, (Object)Long.parseLong(this.getPageCache().get("pkId")));
        DynamicObject empPosOrgDO = ExternalDataService.getEmpPosOrgRelByDepEmpId((long)Long.parseLong(this.getPageCache().get("depempId")));
        if (!ObjectUtils.isEmpty((Object)empPosOrgDO)) {
            this.getModel().setValue("realstartdate", (Object)empPosOrgDO.getDate("startdate"));
        }
        this.getModel().setValue(PRE_POSITIVE_DATE, (Object)tenureDO.getDate(PRE_POSITIVE_DATE));
        DynamicObjectCollection dynamicObjectCollection = tenureDO.getDynamicObjectCollection(POSITIVE_ENTRY_ENTITY);
        if (!dynamicObjectCollection.isEmpty()) {
            for (DynamicObject dynamicObject2 : dynamicObjectCollection) {
                if (!"1".equals(dynamicObject2.getString("operation")) && !"0".equals(dynamicObject2.getString("operation"))) continue;
                this.getModel().setValue("positivedate", (Object)dynamicObject2.getDate("prepositivedateentry"));
                break;
            }
        }
        DynamicObjectCollection positiveEntryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(POSITIVE_ENTRY_ENTITY);
        List dynamicObjects = positiveEntryEntity.stream().sorted(Comparator.comparing(dynamicObject -> dynamicObject.getDate("operationdate"), Comparator.reverseOrder())).collect(Collectors.toList());
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            ((DynamicObject)dynamicObjects.get(i)).set("isshowlinepositive", (Object)(dynamicObjects.size() == 1 ? 1 : dynamicObjects.size() - 1 - i));
        }
        positiveEntryEntity.clear();
        positiveEntryEntity.addAll(dynamicObjects);
        this.getModel().getDataEntity(true).set(POSITIVE_ENTRY_ENTITY, (Object)positiveEntryEntity);
        this.getView().updateView(POSITIVE_ENTRY_ENTITY);
        this.getModel().setDataChanged(false);
        FlexPanelAp relateLabelPanelAp = new HRFlexPanelAp.Builder(EXAM_HIS_FLEX_PANEL).setWrap(true).setGrow(0).setShrink(0).build();
        this.showExpedRecord(relateLabelPanelAp);
    }

    private void showExpedRecord(FlexPanelAp relateLabelPanelAp) {
        DynamicObject[] billList = expedBillApplicationService.queryExpedByTenure(Long.parseLong(this.getPageCache().get("pkId")));
        if (billList == null || billList.length == 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{NO_DATE_CARD_ENTRY});
            this.getView().updateControlMetadata(EXAM_HIS_FLEX_PANEL, relateLabelPanelAp.createControl());
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{NO_DATE_CARD_ENTRY});
        int i = 0;
        for (DynamicObject dynamicObject : billList) {
            FlexPanelAp relateLabelPanelApItem = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder("examhisflexpanelItem" + i).setWrap(true).setGrow(0).setShrink(0).setWidth("100%").setMarginBottom("5px")).build();
            FormShowParameter billShowParameter = new FormShowParameter();
            billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            billShowParameter.getOpenStyle().setTargetKey(relateLabelPanelApItem.getKey());
            billShowParameter.setStatus(OperationStatus.VIEW);
            billShowParameter.setFormId("cadm_expedrecord");
            HashMap customMap = Maps.newHashMap();
            customMap.put("pkId", dynamicObject.getLong("id"));
            billShowParameter.setCustomParams((Map)customMap);
            this.getView().showForm(billShowParameter);
            relateLabelPanelAp.getItems().add(relateLabelPanelApItem);
            ++i;
            this.getView().updateControlMetadata(EXAM_HIS_FLEX_PANEL, relateLabelPanelAp.createControl());
        }
    }

    private void flexHandlerTenure() {
        Date longDate;
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"savemanage"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelmanage"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"saveexam"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelexam"});
        DynamicObject tenureDO = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tenureDO"));
        if (!HRObjectUtils.isEmpty((Object)tenureDO) && TenureStatusEnum.LEAVE.getNumber().equals(tenureDO.getString("tenurestatus"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updateexam"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"updatemanage"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updateexam"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"updatemanage"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"properiodflex", "supvinfoflex"});
        this.getView().setStatus(OperationStatus.EDIT);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"extenuredate"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessdate"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"assessresult"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"assesscontent"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"tenureattachment"});
        this.getModel().setValue("tenurerealstarttime", (Object)tenureDO.getDate("realstartdate"));
        this.getModel().setValue("tenureplanstarttime", (Object)tenureDO.getDate("planstartdate"));
        this.getModel().setValue("planenddate", (Object)tenureDO.getDate("planenddate"));
        try {
            longDate = HRDateTimeUtils.parseDate((String)"2999-01-01", (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOG.error((Throwable)e);
            return;
        }
        if (!HRObjectUtils.isEmpty((Object)tenureDO.getDate("realenddate"))) {
            this.getModel().setValue("realenddate", HRDateTimeUtils.dayAfter((Date)tenureDO.getDate("realenddate"), (Date)longDate) ? null : tenureDO.getDate("realenddate"));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"supvinfoflex"});
    }

    public void beforeClosed(BeforeClosedEvent e) {
        cadmFormService.setPropertyNotDataChanged(this.getModel(), new String[]{"tenureplanstarttime", "tenurerealstarttime", "realenddate", POSITIVE_ENTRY_ENTITY, "exampositentryentity", SUPERVISORY_ENTRY_ENTITY});
        super.beforeClosed(e);
    }

    private void deleteAllAttachmentFieldData() {
        AttachmentPanel attachmentEdit = (AttachmentPanel)this.getControl("tenureattachment");
        List attachmentData = attachmentEdit.getAttachmentData();
        attachmentData.forEach(map -> {
            Object pkId = map.get("billPkId");
            Object fileUid = map.get("uid");
            List dataBaseAttacheList = AttachmentServiceHelper.getAttachments((String)this.getView().getEntityId(), pkId, (String)"tenureattachment");
            if (CollectionUtils.isEmpty((Collection)dataBaseAttacheList)) {
                attachmentEdit.remove(map);
                return;
            }
            ArrayList fileUidList = Lists.newArrayList();
            dataBaseAttacheList.forEach(dataBaseMap -> {
                Object dataBaseUid = dataBaseMap.get("uid");
                fileUidList.add(dataBaseUid);
            });
            if (!fileUidList.contains(fileUid)) {
                attachmentEdit.remove(map);
            }
        });
    }
}

