/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.entity.ExpedCoopBo;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.common.constants.AppointCommonConstants;

public class TenureExpedDynamicPlugin
extends HRDynamicFormBasePlugin {
    public static final Log LOG = LogFactory.getLog(TenureExpedDynamicPlugin.class);
    private static final ExpedBillApplicationService expedBillApplicationService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final ExpedCoopBillApplicationService expedCoopBillApplicationService = (ExpedCoopBillApplicationService)ServiceFactory.getService(ExpedCoopBillApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showForm();
    }

    private void showForm() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (CollectionUtils.isEmpty((Map)customParams)) {
            return;
        }
        String selectProperties = "createtime,expedresult,expedcomment";
        Object pkIdOjb = customParams.get("pkId");
        DynamicObject dynamicObject = expedBillApplicationService.queryExpedOneById(selectProperties, pkIdOjb);
        if (null == dynamicObject) {
            return;
        }
        if (null != dynamicObject.getDate("createtime")) {
            this.getModel().setValue("createtimecopy", (Object)HRDateTimeUtils.format((Date)dynamicObject.getDate("createtime"), (String)"yyyy-MM-dd"));
        }
        if (null != dynamicObject.get("expedcomment")) {
            this.getModel().setValue("expedcomment", dynamicObject.get("expedcomment"));
        }
        this.getModel().setValue("expedresult", dynamicObject.get("expedresult"));
        selectProperties = "coopstatus,expedplan,expedplan.examplanentry,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score,\" +\n                \"entryentity.itemremark,examarrrecordid,startTime,handler,handletime";
        DynamicObject[] dynamicObjects = expedCoopBillApplicationService.queryNotAbandonedDataByExpedId(selectProperties, pkIdOjb);
        if (null != dynamicObjects && dynamicObjects.length > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"entryentity"});
            dynamicObjects = expedCoopBillApplicationService.adjustCoopsBySeq(dynamicObjects);
            this.loadExamCoopEntry(this.parseCoopBills(dynamicObjects));
            this.getView().updateView("entryentity");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity"});
        }
        List attachmentList = AttachmentServiceHelper.getAttachments((String)"cadm_expedbill", pkIdOjb, (String)"attachmentpanel", (boolean)false);
        if (!CollectionUtils.isEmpty((Collection)attachmentList)) {
            AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanel");
            attachmentPanel.upload(attachmentList);
        }
    }

    private void loadExamCoopEntry(List<ExpedCoopBo> expedCoopBos) {
        this.getModel().deleteEntryData("entryentity");
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", expedCoopBos.size());
        for (int i = 0; i < indexArr.length; ++i) {
            ExpedCoopBo expedCoopBo = expedCoopBos.get(i);
            this.getModel().setValue("timeused", (Object)expedCoopBo.getTimeUsed(), indexArr[i]);
            this.getModel().setValue("expedcoop", (Object)expedCoopBo.getCoopId(), indexArr[i]);
            if (ExpedCoopStatusEnum.COMPLETED.getNumber().equals(expedCoopBo.getCoopStatus())) {
                this.getModel().setValue("coopresultvalue", (Object)expedCoopBo.getCoopResult(), indexArr[i]);
                this.getModel().setValue("coopcomment", (Object)expedCoopBo.getCoopComment(), indexArr[i]);
            }
            List examItemBoList = expedCoopBo.getExamItemBoList();
            Object[] examItemIdArr = examItemBoList.stream().map(item -> Long.valueOf(item.getExamItemId())).toArray();
            this.getModel().setValue("planexpeditem", (Object)examItemIdArr, indexArr[i]);
        }
        this.getView().updateView("entryentity");
    }

    private List<ExpedCoopBo> parseCoopBills(DynamicObject[] coopBills) {
        ArrayList expedCoopBos = Lists.newArrayListWithCapacity((int)coopBills.length);
        for (DynamicObject coopBill : coopBills) {
            Long coopBillId = coopBill.getLong("id");
            String coopResult = coopBill.getString("coopresult");
            String itemGroupName = coopBill.getDynamicObject("itemgroup").getString("name");
            String coopStatus = coopBill.getString("coopstatus");
            String coopComment = coopBill.getString("coopcomment");
            Date handleTime = coopBill.getDate("handletime");
            Date startTime = coopBill.getDate("starttime");
            long handlerId = coopBill.getLong("handler.id");
            BigDecimal timeUsed = !ExpedCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus) ? this.calculateProcessedTime(coopStatus, startTime) : coopBill.getBigDecimal("cooptaketime");
            List examItemBoList = cadmFormService.convertCoopBillToExamItemBos(coopBill);
            ExpedCoopBo expedCoopBo = new ExpedCoopBo(coopBillId, itemGroupName, coopResult, coopComment, timeUsed, examItemBoList, coopStatus);
            expedCoopBos.add(expedCoopBo);
            expedCoopBo.setHandleTime(handleTime);
            expedCoopBo.setHandlerId(Long.valueOf(handlerId));
        }
        return expedCoopBos;
    }

    private BigDecimal calculateProcessedTime(String coopStatus, Date startTime) {
        if (ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) && startTime != null) {
            Date currentDate = new Date();
            long num = currentDate.getTime() - startTime.getTime();
            BigDecimal costTimeMills = BigDecimal.valueOf(num);
            return costTimeMills.divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
        }
        return BigDecimal.ZERO;
    }
}

