/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.ExternalDataService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.common.enums.PositionTypeEnum;

public class TenureHeadFormPlugin
extends HRCoreBaseBillList {
    private static final String LABOR_REL_TYPE = "laborreltype";
    private static final String LABOR_REL_STATUS = "laborrelstatus";
    private static final String TENURE_STATUS = "tenurestatus";
    private static final String CAD_RE_CAT = "cadrecat";
    private static final String DEP_EMP = "depemp";
    private static final String GENDER = "gender";
    private static final String COMPANY = "company";
    private static final String BU_TITLE = "butitle";
    private static final String ADMIN_ORG_TITLE = "adminorgtitle";
    private static final String EMP_GROUP_TITLE = "empgrouptitle";
    private static final String EFF_DATE_TITLE = "effdatetitle";
    private static final String SEX_ICON = "sexicon";
    private static final String COMPANY_ICON = "companyicon";
    private static final String ORG_ICON = "orgicon";
    private static final String POSITION_ICON = "positionicon";
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long tenureId = (Long)formShowParameter.getCustomParam("tenure");
        String selectFiled = "person,employee,depemp,company,org,adminorg,position,job,standardpost,apositiontype,affiliateadminorg,empgroup,createtime,tenurestatus,cadrecat";
        DynamicObject tenureDO = tenureApplicationService.queryTenureOneById(selectFiled, (Object)tenureId);
        long personId = tenureDO.getDynamicObject("person") == null ? 0L : tenureDO.getDynamicObject("person").getLong("id");
        long employeeId = tenureDO.getDynamicObject("employee") == null ? 0L : tenureDO.getDynamicObject("employee").getLong("id");
        long depEmpId = tenureDO.getDynamicObject(DEP_EMP) == null ? 0L : tenureDO.getDynamicObject(DEP_EMP).getLong("id");
        long positionId = tenureDO.getDynamicObject("position") == null ? 0L : tenureDO.getDynamicObject("position").getLong("id");
        long jobId = tenureDO.getDynamicObject("job") == null ? 0L : tenureDO.getDynamicObject("job").getLong("id");
        long standardPositionId = tenureDO.getDynamicObject("standardpost") == null ? 0L : tenureDO.getDynamicObject("standardpost").getLong("id");
        Map personInfoMap = ExternalDataService.getPersonInfo((Long)personId);
        this.showPersonInfo(tenureDO, personInfoMap);
        this.showLeaderInfo(depEmpId);
        this.showPosTypeLabelInfo(employeeId, positionId, jobId, standardPositionId);
        this.showLaborLabelInfo(employeeId);
        this.showProPeriodLabelInfo(tenureDO);
        this.getView().setStatus(OperationStatus.VIEW);
        this.getModel().setDataChanged(false);
    }

    private void showPersonInfo(DynamicObject tenureDO, Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        Label nameLabel = (Label)this.getView().getControl("name");
        nameLabel.setText(map.get("name").toString());
        Label numberLabel = (Label)this.getView().getControl("number");
        numberLabel.setText(map.get("number").toString());
        this.showIconInfo(map.get(GENDER), tenureDO);
        this.getView().getModel().setValue("personimg", map.get("headsculpture"));
        this.showOrgInfo(tenureDO.getDynamicObject("org"), tenureDO.getDynamicObject("affiliateadminorg"), tenureDO.getDynamicObject("empgroup"), tenureDO.getDate("createtime"));
    }

    private void showIconInfo(Object sex, DynamicObject tenureDo) {
        DynamicObject company = tenureDo.getDynamicObject(COMPANY);
        DynamicObject org = tenureDo.getDynamicObject("adminorg");
        DynamicObject position = tenureDo.getDynamicObject("position");
        DynamicObject job = tenureDo.getDynamicObject("job");
        DynamicObject stdPosition = tenureDo.getDynamicObject("standardpost");
        String positionType = tenureDo.getString("apositiontype");
        Label sexLabel = (Label)this.getView().getControl("sex");
        Label companyLabel = (Label)this.getView().getControl(COMPANY);
        Label orgLabel = (Label)this.getView().getControl("org");
        Label positionLabel = (Label)this.getView().getControl("position");
        if (HRObjectUtils.isEmpty((Object)sex)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SEX_ICON});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"sex"});
        } else {
            sexLabel.setText(sex.toString());
        }
        if (HRObjectUtils.isEmpty((Object)company)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COMPANY_ICON});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{COMPANY});
        } else {
            companyLabel.setText(company.getString("name"));
        }
        if (HRObjectUtils.isEmpty((Object)org)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ORG_ICON});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"org"});
        } else {
            orgLabel.setText(org.getString("name"));
        }
        if (PositionTypeEnum.POSITION.getNumber().equals(positionType)) {
            String type = ResManager.loadKDString((String)"\u5c97\u4f4d", (String)"TenureHeadFormPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            positionLabel.setText(position.getString("name") + "(" + type + ")");
        } else if (PositionTypeEnum.JOB.getNumber().equals(positionType)) {
            String type = ResManager.loadKDString((String)"\u804c\u4f4d", (String)"TenureHeadFormPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            positionLabel.setText(job.getString("name") + "(" + type + ")");
        } else if (PositionTypeEnum.STANDER_POSITION.getNumber().equals(positionType)) {
            String type = ResManager.loadKDString((String)"\u6807\u51c6\u5c97\u4f4d", (String)"TenureHeadFormPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            positionLabel.setText(stdPosition.getString("name") + "(" + type + ")");
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{POSITION_ICON});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"position"});
        }
    }

    private void showOrgInfo(DynamicObject bu, DynamicObject adminOrg, DynamicObject empGroup, Date effDate) {
        Label buLabel = (Label)this.getView().getControl("bu");
        Label adminLabel = (Label)this.getView().getControl("adminorg");
        Label empGroupLabel = (Label)this.getView().getControl("empgroup");
        Label effDateLabel = (Label)this.getView().getControl("effdate");
        if (HRObjectUtils.isEmpty((Object)bu)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BU_TITLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bu"});
        } else {
            buLabel.setText(bu.getString("name"));
        }
        if (HRObjectUtils.isEmpty((Object)adminOrg)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ADMIN_ORG_TITLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"adminorg"});
        } else {
            adminLabel.setText(adminOrg.getString("name"));
        }
        if (HRObjectUtils.isEmpty((Object)empGroup)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EMP_GROUP_TITLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"empgroup"});
        } else {
            empGroupLabel.setText(empGroup.getString("name"));
        }
        if (HRObjectUtils.isEmpty((Object)effDate)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{EFF_DATE_TITLE});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"effdate"});
            effDateLabel.setText(null);
        } else {
            effDateLabel.setText(HRInteDateTimeUtil.formatDate((String)"cadm_tenure", (String)"createtime", (Date)effDate));
        }
    }

    private void showLeaderInfo(long depEmpId) {
        Map directSuperiorList = ExternalDataService.getDirectSuperiorByDepEmpId((List)Lists.newArrayList((Object[])new Long[]{depEmpId}));
        if (directSuperiorList.size() > 0) {
            String superiorName = (String)((Map)((List)directSuperiorList.get(depEmpId)).get(0)).get("superior.name");
            String superiorNumber = (String)((Map)((List)directSuperiorList.get(depEmpId)).get(0)).get("superior.number");
            String supHeadSculpture = (String)((Map)((List)directSuperiorList.get(depEmpId)).get(0)).get("superior.headsculpture");
            if (HRStringUtils.isEmpty((String)superiorName) && HRStringUtils.isEmpty((String)superiorNumber) && HRStringUtils.isEmpty((String)supHeadSculpture)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"leaderflex"});
            }
            Label leaderNameLabel = (Label)this.getView().getControl("leadername");
            Label leaderNumberLabel = (Label)this.getView().getControl("leadernumber");
            leaderNameLabel.setText(superiorName);
            leaderNumberLabel.setText(superiorNumber);
            this.getView().getModel().setValue("leaderimg", (Object)HRImageUrlUtil.getImageFullUrl((String)supHeadSculpture));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"leaderflex"});
        }
    }

    private void showLaborLabelInfo(long employeeId) {
        Map empEntRelMap = ExternalDataService.getEmpEntrel((Long)employeeId);
        Label laborTypeLabel = (Label)this.getView().getControl("labortype");
        if (empEntRelMap.get(LABOR_REL_TYPE) == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABOR_REL_TYPE});
        } else {
            laborTypeLabel.setText(empEntRelMap.get(LABOR_REL_TYPE).toString());
        }
        Label formalLabel = (Label)this.getView().getControl("formal");
        if (empEntRelMap.get(LABOR_REL_STATUS) == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LABOR_REL_STATUS});
        } else {
            formalLabel.setText(empEntRelMap.get(LABOR_REL_STATUS).toString());
        }
    }

    private void showPosTypeLabelInfo(long employeeId, long positionId, long jobId, long standardId) {
        String positionTypeName = ExternalDataService.getEmpPosPosTypeName((long)employeeId, (long)standardId, (long)jobId, (long)positionId);
        Label fullTimeLabel = (Label)this.getView().getControl("fulltime");
        if (HRStringUtils.isEmpty((String)positionTypeName)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fulltime"});
        } else {
            fullTimeLabel.setText(positionTypeName);
        }
    }

    private void showProPeriodLabelInfo(DynamicObject tenureDO) {
        Label proPeriodLabel = (Label)this.getView().getControl("properiod");
        if (HRStringUtils.isEmpty((String)tenureDO.getString(TENURE_STATUS))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"properiod"});
        } else {
            proPeriodLabel.setText(TenureStatusEnum.getEnumByVal((String)tenureDO.getString(TENURE_STATUS)).getName());
        }
        Label jobLevelLabel = (Label)this.getView().getControl("joblevel");
        if (HRStringUtils.isEmpty((String)tenureDO.getString(CAD_RE_CAT))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"joblevel"});
        } else {
            jobLevelLabel.setText(tenureDO.getDynamicObject(CAD_RE_CAT).getString("name"));
        }
    }
}

