/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.exped;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.url.UrlService;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRCoreBaseBillEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.external.BosMessageService;
import kd.tdc.cadm.bussiness.application.external.CallRuleEngineService;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamPlanTypeEnum;
import kd.tdc.cadm.bussiness.domain.exped.entity.ExpedCoopBo;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.bussiness.util.UrlBuilder;
import kd.tdc.cadm.common.constants.AppointCommonConstants;
import kd.tdc.cadm.formplugin.web.formservice.ExamineFormService;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.TenureFormService;
import org.apache.commons.lang3.StringUtils;

public class ExpedBillEdit
extends HRCoreBaseBillEdit
implements BeforeF7SelectListener {
    private static final CallRuleEngineService ruleService = (CallRuleEngineService)ServiceFactory.getService(CallRuleEngineService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ExamineFormService examineFormService = (ExamineFormService)ServiceFactory.getService(ExamineFormService.class);
    private static final TenureApplicationService tenureService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final ExpedBillApplicationService expedBillApplicationService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final ExpedCoopBillApplicationService expedCoopService = (ExpedCoopBillApplicationService)ServiceFactory.getService(ExpedCoopBillApplicationService.class);
    private static final CadmFormService cadmService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final TenureFormService TENURE_FORM_SERVICE = FormServiceFactory.getService(TenureFormService.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("person");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldName = event.getProperty().getName();
        if (HRStringUtils.equals((String)fieldName, (String)"person")) {
            BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
            boolean f7Click = basedataEdit.isF7Click();
            event.setCancel(true);
            if (!f7Click) {
                return;
            }
            BasedataEdit control = (BasedataEdit)this.getControl("tenure");
            control.click();
        }
    }

    public void initialize() {
        super.initialize();
        this.setColItemVisible();
    }

    private void setColItemVisible() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addPackageDataListener(pkEvent -> {
            String coopstatus = pkEvent.getRowData().getString("expedcoop.coopstatus");
            if (pkEvent.getSource() instanceof OperationColumn && "operationcolumnap".equalsIgnoreCase(((OperationColumn)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    boolean isHide = "donothing_urge".equals(operationKey) && !ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus) || "donothing_start_coop".equals(operationKey) && !ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopstatus) || "donothing_restart_coop".equals(operationKey) && !ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus) && !ExpedCoopStatusEnum.COMPLETED.getNumber().equals(coopstatus) || "adjust_person".equals(operationKey) && !ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopstatus) && !ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopstatus);
                    if (!isHide) continue;
                    operationColItem.setVisible(false);
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if ("donothing_restart_coop".equals(callBackId) && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.startCoopByType("restart_coop");
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isDefault = this.getPageCache().get("isDefault");
        if (HRStringUtils.equals((String)isDefault, (String)"false")) {
            return;
        }
        BillShowParameter showParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
        this.getModel().setValue("createtime", (Object)new Date());
        if (!CollectionUtils.isEmpty((Map)customParams)) {
            this.getPageCache().put("isDefault", "false");
            this.getModel().setValue("person", customParams.get("person"));
            this.getModel().setValue("tenure", customParams.get("tenure"));
        }
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.loadPageCoopData();
        this.getModel().setDataChanged(false);
    }

    private void loadPageCoopData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Long expedId = dataEntity.getLong("id");
        DynamicObject[] coopBills = this.getExpedCoopDataByExpedId(expedId);
        if (coopBills.length > 0) {
            List<ExpedCoopBo> expedCoopBos = this.parseCoopBills(coopBills);
            this.setExpedCoopEntryVisible(true);
            this.loadExamCoopEntry(expedCoopBos);
            this.loadHisData(expedCoopBos);
            FlexPanelAp flexPanelAp = this.createAp(expedCoopBos);
            Container flexPanel = (Container)this.getView().getControl("examdetailsflex");
            flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
            this.getView().updateControlMetadata("examdetailsflex", flexPanelAp.createControl());
            this.getView().updateView("examdetailsflex");
            this.refreshValue(expedId);
            this.setResultStatistics(expedCoopBos);
            for (ExpedCoopBo examCoopBo : expedCoopBos) {
                String key = "examdetailstabpageap-" + examCoopBo.getCoopId();
                this.showExamCoopLayout(key);
            }
            Tab tab = (Tab)this.getControl("examdetailstabap");
            String firstKey = "examdetailstabpageap-" + expedCoopBos.get(0).getCoopId();
            tab.activeTab(firstKey);
        } else {
            this.setExpedCoopEntryVisible(false);
        }
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (HRStringUtils.isEmpty((String)dataEntity.getString("expedcoopratio"))) {
            dataEntity.set("expedcoopratio", (Object)"-");
        }
        String expedStatus = dataEntity.getString("expedstatus");
        DynamicObject person = dataEntity.getDynamicObject("person");
        if (ExpedStatusEnum.NOT.getNumber().equals(expedStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"headflexview"});
            if (Objects.isNull(person)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"personinfocardedit"});
            }
        } else if (HRStringUtils.isEmpty((String)expedStatus)) {
            this.getModel().setValue("expedstatus", (Object)ExpedStatusEnum.NOT.getNumber());
        } else {
            this.getModel().setValue("billnocopy", (Object)dataEntity.getString("billno"));
            this.getModel().setValue("orgcopy", (Object)dataEntity.getDynamicObject("org").getString("name"));
            this.getModel().setValue("createtimecopy", (Object)dataEntity.getDate("createtime"));
            this.getModel().setValue("createdatenew", (Object)dataEntity.getDate("createtime"));
            this.getModel().setValue("creatorcopy", dataEntity.get("creator"));
            this.getView().setVisible(Boolean.FALSE, new String[]{"headflexedit"});
            this.showPerInfoCardFlex(dataEntity, "personinfocardview");
        }
        if (!Objects.isNull(person)) {
            this.showPerInfoCardFlex(dataEntity, "personinfocardedit");
        }
        this.getView().setVisible(Boolean.valueOf(ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus)), new String[]{"bestart"});
        this.getView().setVisible(Boolean.valueOf(ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)), new String[]{"inexplore"});
        this.getView().setVisible(Boolean.valueOf(ExpedStatusEnum.COMPLETE.getNumber().equals(expedStatus)), new String[]{"finishstatus"});
        this.getView().setVisible(Boolean.valueOf(ExpedStatusEnum.TERMINATED.getNumber().equals(expedStatus)), new String[]{"stopstatus"});
        this.getModel().setDataChanged(false);
    }

    private void showPerInfoCardFlex(DynamicObject dataEntity, String targetKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_appointbaseinfo");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        DynamicObject tenureDy = tenureService.queryTenureOriginalOneById("depemp.id,employee.id", dataEntity.getDynamicObject("tenure").getPkValue());
        showParameter.setCustomParam("depEmpId", (Object)tenureDy.getString("depemp.id"));
        showParameter.setCustomParam("personId", (Object)dataEntity.getString("person.id"));
        showParameter.setCustomParam("employee", (Object)tenureDy.getString("employee.id"));
        showParameter.getOpenStyle().setTargetKey(targetKey);
        this.getView().showForm(showParameter);
    }

    private DynamicObject[] getExpedCoopDataByExpedId(Long expedId) {
        String selectProperties = "coopstatus,expedplan,expedplan.examplanentry,coopresult,coopcomment,examsla,isurge,createtime,cooptaketime,itemgroup,entryentity.examitem,entryentity.score,entryentity.itemremark,examarrrecordid,startTime,handler,handletime";
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        DynamicObject[] coops = arrangeRecordId != null ? expedCoopService.queryExpedCoopByArrangeRecordId(selectProperties, Long.valueOf(Long.parseLong(arrangeRecordId.toString()))) : expedCoopService.queryNotAbandonedDataByExpedId(selectProperties, (Object)expedId);
        if (arrangeRecordId == null) {
            Arrays.stream(coops).forEach(value -> {
                if (!ExpedCoopStatusEnum.COMPLETED.getNumber().equals(value.getString("coopstatus"))) {
                    value.set("coopresult", (Object)"");
                    value.set("coopcomment", (Object)"");
                    DynamicObjectCollection entryEntity = value.getDynamicObjectCollection("entryentity");
                    entryEntity.forEach(element -> element.set("score", (Object)0));
                }
            });
        }
        if (coops.length > 0) {
            coops = expedCoopService.adjustCoopsBySeq(coops);
        }
        return coops;
    }

    private void setExpedCoopEntryVisible(boolean visible) {
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{"entryentity", "expedinfoflex", "expeddetailflex", "examdetailsflex"});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"emptyexpedcoopflex"});
        String expedStatus = this.getModel().getDataEntity().getString("expedstatus");
        this.getView().setVisible(Boolean.FALSE, new String[]{"nodataflex"});
        if (ExpedStatusEnum.COMPLETE.getNumber().equals(expedStatus) || ExpedStatusEnum.TERMINATED.getNumber().equals(expedStatus)) {
            this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"nodataflex"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"recordsflex"});
        }
    }

    private void setResultStatistics(List<ExpedCoopBo> expedCoopBos) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        Map resultStatisticsMap = arrangeRecordId != null ? expedCoopBos.stream().filter(p -> p.getHandlerId() != null && p.getHandlerId() != 0L).map(ExpedCoopBo::getCoopResult).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())) : expedCoopBos.stream().map(ExpedCoopBo::getCoopResult).filter(HRStringUtils::isNotEmpty).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        String resultStatisticsStr = resultStatisticsMap.entrySet().stream().map(entry -> MessageFormat.format("{0} {1}", entry.getKey(), entry.getValue())).collect(Collectors.joining("     "));
        Label resultStatisticsLabel = (Label)this.getControl("resultstatistics");
        if (HRStringUtils.isEmpty((String)resultStatisticsStr)) {
            resultStatisticsStr = "-";
        }
        resultStatisticsLabel.setText(resultStatisticsStr);
    }

    private void loadExamCoopEntry(List<ExpedCoopBo> expedCoopBos) {
        this.getModel().deleteEntryData("entryentity");
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", expedCoopBos.size());
        for (int i = 0; i < indexArr.length; ++i) {
            ExpedCoopBo expedCoopBo = expedCoopBos.get(i);
            this.getModel().setValue("expedcoop", (Object)expedCoopBo.getCoopId(), indexArr[i]);
            this.getModel().setValue("timeused", (Object)expedCoopBo.getTimeUsed(), indexArr[i]);
            if (ExpedCoopStatusEnum.COMPLETED.getNumber().equals(expedCoopBo.getCoopStatus())) {
                this.getModel().setValue("coopresultvalue", (Object)expedCoopBo.getCoopResult(), indexArr[i]);
                this.getModel().setValue("coopcomment", (Object)expedCoopBo.getCoopComment(), indexArr[i]);
            }
            boolean canUrge = HRStringUtils.equals((String)expedCoopBo.getCoopStatus(), (String)ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber());
            String urge = ResManager.loadKDString((String)"\u50ac\u529e", (String)"ExpedBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            this.getModel().setValue("urge", (Object)(canUrge ? urge : ""), indexArr[i]);
            List examItemBoList = expedCoopBo.getExamItemBoList();
            Object[] examItemIdArr = examItemBoList.stream().map(item -> Long.valueOf(item.getExamItemId())).toArray();
            this.getModel().setValue("planexpeditem", (Object)examItemIdArr, indexArr[i]);
        }
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String expedStatus;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"save") && (HRStringUtils.isEmpty((String)(expedStatus = this.getModel().getDataEntity().getString("expedstatus"))) || ExpedStatusEnum.NOT.getNumber().equals(expedStatus))) {
            this.getModel().setValue("expedstatus", (Object)ExpedStatusEnum.TO_BE_EXAMINE.getNumber());
        }
    }

    private FlexPanelAp createAp(List<ExpedCoopBo> expedCoopBos) {
        FlexPanelAp containerAp = cadmFormService.createFlexPanelAp("examdetailsflex");
        TabAp tabAp = new TabAp();
        tabAp.setKey("examdetailstabap");
        tabAp.setTabStyle(3);
        tabAp.setCanSlide(true);
        tabAp.setShowDropdownIcon(true);
        for (ExpedCoopBo expedCoopBo : expedCoopBos) {
            String itemGroupName = expedCoopBo.getItemGroupName();
            TabPageAp tabPageAp = new TabPageAp();
            tabPageAp.setKey("examdetailstabpageap-" + expedCoopBo.getCoopId());
            tabPageAp.setName(new LocaleString(itemGroupName));
            tabAp.getItems().add(tabPageAp);
        }
        containerAp.getItems().add(tabAp);
        return containerAp;
    }

    private List<ExpedCoopBo> parseCoopBills(DynamicObject[] coopBills) {
        ArrayList<ExpedCoopBo> expedCoopBos = new ArrayList<ExpedCoopBo>(coopBills.length);
        for (DynamicObject coopBill : coopBills) {
            Long coopBillId = coopBill.getLong("id");
            String itemGroupName = coopBill.getDynamicObject("itemgroup").getString("name");
            String coopResult = coopBill.getString("coopresult");
            String coopComment = coopBill.getString("coopcomment");
            String coopStatus = coopBill.getString("coopstatus");
            long handlerId = coopBill.getLong("handler.id");
            Date handleTime = coopBill.getDate("handletime");
            Date startTime = coopBill.getDate("starttime");
            BigDecimal timeUsed = ExpedCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus) ? coopBill.getBigDecimal("cooptaketime") : this.calculateProcessedTime(coopStatus, startTime);
            List examItemBoList = cadmFormService.convertCoopBillToExamItemBos(coopBill);
            ExpedCoopBo expedCoopBo = new ExpedCoopBo(coopBillId, itemGroupName, coopResult, coopComment, timeUsed, examItemBoList, coopStatus);
            expedCoopBo.setHandlerId(Long.valueOf(handlerId));
            expedCoopBo.setHandleTime(handleTime);
            expedCoopBos.add(expedCoopBo);
        }
        return expedCoopBos;
    }

    private BigDecimal calculateProcessedTime(String coopStatus, Date startTime) {
        if (ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) && startTime != null) {
            Date currentDate = new Date();
            long num = currentDate.getTime() - startTime.getTime();
            BigDecimal costTimeMills = BigDecimal.valueOf(num);
            BigDecimal costDay = costTimeMills.divide(AppointCommonConstants.MILLISECONDS_IN_A_DAY, 1, RoundingMode.HALF_UP);
            return costDay;
        }
        return BigDecimal.ZERO;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"tenure") && !Objects.isNull(this.getModel().getValue("tenure"))) {
            ChangeData[] changeSet = e.getChangeSet();
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            DynamicObject tenureDy = tenureService.queryTenureOriginalOneById("person", newValue.getPkValue());
            this.getModel().setValue("person", tenureDy.get("person"));
            cadmService.setPropertyNotDataChanged(this.getModel(), new String[]{"tenure"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"personinfocardedit"});
            this.showPerInfoCardFlex(this.getModel().getDataEntity(), "personinfocardedit");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String expedStatus = dataEntity.getString("expedstatus");
        if ("save".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String invokeByFinishExped = this.getPageCache().get("invokeByFinishExped");
            if (invokeByFinishExped != null) {
                args.getOperationResult().setShowMessage(false);
                this.getPageCache().remove("invokeByFinishExped");
            }
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("expedstatus", dataEntity.getString("expedstatus"));
            paramMap.put("expedcoopratio", dataEntity.getString("expedcoopratio"));
            paramMap.put("expedresult", " ");
            long tenureId = dataEntity.getDynamicObject("tenure").getLong("id");
            tenureService.updateExpedBillInfo((Object)tenureId, Long.valueOf(dataEntity.getLong("id")), (Map)paramMap);
            this.getView().invokeOperation("refresh");
        }
        if ("start_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("restart_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("donothing_startexped".equals(operateKey) && args.getOperationResult().isSuccess()) {
            String examineStatus;
            long id = dataEntity.getLong("id");
            DynamicObject bill = expedBillApplicationService.queryOne("expedstatus", id);
            if (bill != null && StringUtils.isNotBlank((CharSequence)(examineStatus = bill.getString("expedstatus"))) && !ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(examineStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(examineStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExpedBillEdit_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject tenureDy = dataEntity.getDynamicObject("tenure");
            tenureDy.set("creator", dataEntity.get("creator"));
            tenureDy.set("org", dataEntity.get("org"));
            List planIds = ruleService.matchExpedPlan(tenureDy);
            List<Long> ids = examineFormService.getControlledExamPlanData(planIds, this.getModel().getDataEntity().getLong("org.id"), ExamPlanTypeEnum.POSITIVE_EXAM);
            if (CollectionUtils.isEmpty(ids)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u53ef\u7528\u7684\u8003\u5bdf\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5\u8003\u5bdf\u65b9\u6848\u6216\u89c4\u5219\u7b56\u7565\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"ExpedBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setCustomParam("tenure", (Object)SerializationUtils.serializeToBase64((Object)dataEntity.getDynamicObject("tenure")));
            parameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
            DynamicObjectCollection entryentityList = dataEntity.getDynamicObjectCollection("entryentity");
            boolean isRestartExamCoop = false;
            boolean isAdjustExamPlan = false;
            if (!entryentityList.isEmpty()) {
                long count = entryentityList.stream().filter(p -> p.get("expedcoop.coopstatus").equals(ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber()) || p.get("expedcoop.coopstatus").equals(ExpedCoopStatusEnum.COMPLETED.getNumber())).count();
                if (count > 0L) {
                    isRestartExamCoop = true;
                } else {
                    isAdjustExamPlan = true;
                }
            }
            parameter.setCustomParam("isRestartExamCoop", (Object)isRestartExamCoop);
            parameter.setCustomParam("adjustexamplan", (Object)isAdjustExamPlan);
            parameter.setFormId("cadm_startexped");
            parameter.setCustomParam("expedplan", ids);
            parameter.setFormId("cadm_startexped");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
            this.getView().showForm(parameter);
        }
        if ("showexamhistory".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.showExamHistory();
        }
        if ("donothing_start_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.startCoopByType("start_coop");
        }
        if ("donothing_restart_coop".equals(operateKey) && args.getOperationResult().isSuccess()) {
            DynamicObject exped = expedBillApplicationService.queryOne("expedstatus", Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()));
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u540e\uff0c\u5c06\u5e9f\u5f03\u4e4b\u524d\u5df2\u542f\u52a8\u7684\u8003\u5bdf\u534f\u4f5c\u4efb\u52a1\uff0c\u5e76\u751f\u6210\u65b0\u7684\u4efb\u52a1\uff0c\u4e14\u4e0d\u53ef\u64a4\u56de\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"ExamineBillEdit_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_restart_coop", (IFormPlugin)this));
        }
        if ("adjust_person".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.adjustPerson();
        }
        if ("save_startexam".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.loadPageCoopData();
        }
        if ("donothing_urge".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.urge();
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operateKey));
        if ("donothing_finishexped".equals(operateKey) && args.getOperationResult().isSuccess()) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ExpedBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            TENURE_FORM_SERVICE.showFinishWindow(this.getView(), this.getModel().getDataEntity().getPkValue(), new CloseCallBack((IFormPlugin)this, operateKey));
        } else if ("donothing_stopexped".equals(operateKey) && args.getOperationResult().isSuccess()) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u7ec8\u6b62\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ExpedBillEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            expedBillApplicationService.setDefaultReasonByDepart((AbstractFormPlugin)this);
            TENURE_FORM_SERVICE.showTerminateWindow(this.getView(), dataEntity.get("person.name"), null, new CloseCallBack((IFormPlugin)this, operateKey));
        }
        if (args.getOperationResult() != null && !args.getOperationResult().isSuccess() && ("save".equals(operateKey) || "submit".equals(operateKey))) {
            this.loadPageCoopData();
            this.setColItemVisible();
            this.getView().updateView("entryentity");
        }
    }

    private void urge() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRow = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        long examCoopId = entryRow.getDynamicObject("expedcoop").getLong("id");
        DynamicObject examCoop = expedCoopService.queryExpedCoopById(Long.valueOf(examCoopId));
        String coopStatus = examCoop.getString("coopStatus");
        if (!ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExpedBillEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("id", String.valueOf(examCoopId));
        this.getView().invokeOperation("urge", operateOption);
        Long id = (Long)this.getModel().getValue("id");
        DynamicObject[] examCoopArr = this.getExpedCoopDataByExpedId(id);
        List<ExpedCoopBo> expedCoopBos = this.parseCoopBills(examCoopArr);
        this.loadExamCoopEntry(expedCoopBos);
    }

    private void adjustPerson() {
        boolean isAllow;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        long coopId = entryentity.getLong("expedcoop.id");
        DynamicObject examCoop = expedCoopService.queryExpedCoopBillById("coopStatus", Long.valueOf(coopId));
        String coopStatus = examCoop.getString("coopStatus");
        DynamicObject exped = expedBillApplicationService.queryOne("expedstatus", Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()));
        String expedStatus = exped.getString("expedstatus");
        boolean bl = isAllow = (ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)) && ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus);
        if (!isAllow) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExpedBillEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("currentRowIndex", (Object)currentRowIndex);
        parameter.setFormId("cadm_expedadjustperson");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "expedAdjustPersonCloseCallBack"));
        this.getView().showForm(parameter);
    }

    private void showExamHistory() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("id", (Object)dataEntity.getLong("id"));
        parameter.setFormId("cadm_expedhisdynamic");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "expedHisCloseCallback"));
        this.getView().showForm(parameter);
    }

    private void startCoopByType(String type) {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
        DynamicObjectCollection coopHandler = entryentity.getDynamicObjectCollection("expedcoop.coophandler");
        if (coopHandler.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u4f4d\u8003\u5bdf\u7ec4\u6210\u5458\u3002", (String)"ExpedBillEdit_9", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        long coopId = entryentity.getLong("expedcoop.id");
        DynamicObject examCoop = expedCoopService.queryExpedCoopBillById("coopStatus", Long.valueOf(coopId));
        String coopStatus = examCoop.getString("coopStatus");
        DynamicObject exped = expedBillApplicationService.queryOne("expedstatus", Long.parseLong(this.getModel().getDataEntity().getPkValue().toString()));
        String expedStatus = exped.getString("expedstatus");
        if ("start_coop".equals(type) && (!ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExpedStatusEnum.COMPLETE.getNumber().equals(expedStatus) || ExpedStatusEnum.TERMINATED.getNumber().equals(expedStatus))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("restart_coop".equals(type) && (ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus) || ExpedCoopStatusEnum.ABANDONED.getNumber().equals(coopStatus) || ExpedCoopStatusEnum.TERMINATED.getNumber().equals(coopStatus) || ExpedStatusEnum.COMPLETE.getNumber().equals(expedStatus) || ExpedStatusEnum.TERMINATED.getNumber().equals(expedStatus))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u8be5\u8003\u5bdf\u534f\u4f5c\u5355\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExamineBillList_13", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("coop_type", type);
        operateOption.setVariableValue("coopId", String.valueOf(coopId));
        if ("restart_coop".equals(type)) {
            this.getView().invokeOperation("restart_coop", operateOption);
        } else if ("start_coop".equals(type)) {
            this.getView().invokeOperation("start_coop", operateOption);
        }
    }

    private void loadHisData(List<ExpedCoopBo> examCoopBos) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        if (arrangeRecordId != null) {
            long handlerNum = examCoopBos.stream().filter(p -> p.getHandlerId() != 0L).count() * 100L;
            BigDecimal ratio = BigDecimal.ZERO;
            if (handlerNum != 0L) {
                ratio = new BigDecimal(handlerNum).divide(new BigDecimal(examCoopBos.size()), 1, 4);
            }
            String ratioStr = ratio.toString() + "%";
            this.getModel().setValue("expedcoopratio", (Object)ratioStr);
            DynamicObject expedArrange = expedBillApplicationService.getExpedArrangeHisById("examplanid.id", Long.parseLong(arrangeRecordId.toString()));
            long expedplanid = expedArrange.getLong("examplanid.id");
            this.getModel().setValue("expedplan", (Object)expedplanid);
        }
    }

    private void refreshValue(Long expedId) {
        Object arrangeRecordId = this.getView().getFormShowParameter().getCustomParams().get("arrangeRecordId");
        if (arrangeRecordId != null) {
            return;
        }
        DynamicObject exped = expedBillApplicationService.queryOne("expedcoopratio,expedplan", expedId.longValue());
        String expedcoopratio = exped.getString("expedcoopratio");
        long expedplanId = exped.getLong("expedplan_id");
        this.getModel().setValue("expedplan", (Object)expedplanId);
        if (StringUtils.isBlank((CharSequence)expedcoopratio)) {
            this.getModel().setValue("expedcoopratio", (Object)"-");
        } else {
            this.getModel().setValue("expedcoopratio", (Object)expedcoopratio);
        }
        this.getView().updateView("expedcoopratio");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        Boolean success;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        long tenureId = this.getModel().getDataEntity().getDynamicObject("tenure").getLong("id");
        if ("donothing_finishexped".equals(actionId) && evt.getReturnData() instanceof Map && (success = (Boolean)((Map)(returnData = evt.getReturnData())).get("success")).booleanValue()) {
            this.getPageCache().put("invokeByFinishExped", "true");
            this.getView().invokeOperation("save");
            expedBillApplicationService.completeOrTerminateExpedBill(ExpedStatusEnum.COMPLETE, null, (Object)tenureId, (Long)this.getModel().getDataEntity().getPkValue(), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u5b8c\u6210\u3002", (String)"ExpedBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_stopexped".equals(actionId) && evt.getReturnData() instanceof Map && (success = (Boolean)((Map)(returnData = evt.getReturnData())).get("success")).booleanValue()) {
            this.getPageCache().put("invokeByFinishExped", "true");
            this.getView().invokeOperation("save");
            expedBillApplicationService.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, ((Map)returnData).get("terminatereason"), (Object)tenureId, (Long)this.getModel().getDataEntity().getPkValue(), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u7ec8\u6b62\u3002", (String)"ExpedBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_startexped".equals(actionId) && evt.getReturnData() instanceof Map && (success = (Boolean)(returnData = CastUtils.castMap((Object)evt.getReturnData(), String.class)).get("success")).booleanValue()) {
            TENURE_FORM_SERVICE.expedStartOpAfterCloseCallBack(this.getView(), evt);
        }
        if ("expedAdjustPersonCloseCallBack".equals(actionId) && !(returnData = CastUtils.castMap((Object)evt.getReturnData(), String.class)).isEmpty()) {
            int currentRowIndex = (Integer)returnData.get("currentRowIndex");
            DynamicObjectCollection coophandler = (DynamicObjectCollection)returnData.get("coophandler");
            DynamicObjectCollection interviewee = (DynamicObjectCollection)returnData.get("interviewee");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", currentRowIndex);
            long coopId = entryRowEntity.getLong("expedcoop.id");
            DynamicObject expedCoop = expedCoopService.queryExpedCoopById(Long.valueOf(coopId));
            String coopStatus = expedCoop.getString("coopStatus");
            if (!ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) && !ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"ExpedBillEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection beforeCoopHandler = entryRowEntity.getDynamicObjectCollection("expedcoop.coophandler");
            Set before = beforeCoopHandler.stream().map(p -> p.getLong("fbasedataid_id")).collect(Collectors.toSet());
            Set after = coophandler.stream().map(p -> p.getLong("fbasedataid_id")).collect(Collectors.toSet());
            HashSet addHandler = new HashSet(16);
            addHandler.addAll(after);
            addHandler.removeAll(before);
            entryRowEntity.set("expedcoop.coophandler", (Object)coophandler);
            entryRowEntity.set("expedcoop.interviewee", (Object)interviewee);
            expedCoop.set("coophandler", (Object)coophandler);
            expedCoop.set("interviewee", (Object)interviewee);
            try (TXHandle txhandle = TX.required();){
                expedCoopService.updateExpedCoop(expedCoop);
                if (!CollectionUtils.isEmpty(addHandler) && !ExpedCoopStatusEnum.NOT_START.getNumber().equals(coopStatus)) {
                    String contentUrl = new UrlBuilder(UrlService.getDomainContextUrl(), "cadm_expedcooperate").setParameter("formPkId", String.valueOf(coopId)).builder();
                    BosMessageService.sendTemplateMessage((String)contentUrl, new ArrayList(addHandler), (Long)coopId, (String)"cadm_expedcooperate", (String)"cadm_startexplore", (Long)coopId);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ExamineBillList_17", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("entryentity");
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        Long pkId;
        super.preOpenForm(args);
        BillShowParameter showParameter = (BillShowParameter)args.getFormShowParameter();
        String pkValue = (String)showParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkValue)) {
            showParameter.setPkId((Object)Long.valueOf(pkValue));
        }
        if (!Objects.isNull(pkId = (Long)showParameter.getPkId()) && pkId != 0L) {
            DynamicObject dynamicObject = expedBillApplicationService.queryExpedOneById("person.name,expedstatus", (Object)pkId);
            if ("cadm_expedbill".equals(showParameter.getFormId())) {
                String customCaption = (String)showParameter.getCustomParam("caption");
                String caption = ResManager.loadKDString((String)"\u8f6c\u6b63\u8003\u5bdf\u8bb0\u5f55-%s", (String)"ExpedBillEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[]{dynamicObject.getString("person.name")});
                if (HRStringUtils.isNotEmpty((String)customCaption)) {
                    caption = customCaption;
                }
                showParameter.setCaption(caption);
            }
            if (ExpedStatusEnum.isViewStatus((String)dynamicObject.getString("expedstatus"))) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
        }
    }

    private void showExamCoopLayout(String tabKey) {
        String[] split = tabKey.split("-");
        Long coopId = Long.valueOf(split[1]);
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setPkId((Object)coopId);
        HashMap customMap = Maps.newHashMap();
        customMap.put("showFromExamBill", true);
        billShowParameter.setCustomParams((Map)customMap);
        billShowParameter.setFormId("cadm_expedcoop_embed");
        billShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        billShowParameter.getOpenStyle().setTargetKey(tabKey);
        billShowParameter.setStatus(OperationStatus.VIEW);
        billShowParameter.setBillStatus(BillOperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)billShowParameter);
    }
}

