/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.exped;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.TenureFormService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ExpedBillList
extends HRDataBaseList {
    private static final List<String> OPERATE_KEY_LIST = Lists.newArrayList((Object[])new String[]{"donothing_exped", "donothing_stopexped", "donothing_finishexped", "donothing_apply"});
    private static final TenureApplicationService TENURE_SERVICE = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final ExpedBillApplicationService EXPED_SERVICE = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final TenureFormService TENURE_FORM_SERVICE = FormServiceFactory.getService(TenureFormService.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object dataSource = customParams.get("dataSource");
        List fastFilterColumns = args.getFastFilterColumns();
        if ("departMsg".equals(dataSource) || "withdrawDepartMsg".equals(dataSource)) {
            Object personNumber = customParams.get("personNumber");
            Object personName = customParams.get("personName");
            fastFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("person.number".equals(fieldName) && personNumber != null) {
                    item.setDefaultValue(String.valueOf(personNumber));
                }
                if ("person.name".equals(fieldName) && personName != null) {
                    item.setDefaultValue(String.valueOf(personName));
                }
            });
        }
        if ("departMsg".equals(dataSource)) {
            List commonFilterColumns = args.getCommonFilterColumns();
            commonFilterColumns.forEach(item -> {
                String fieldName = item.getFieldName();
                if ("expedstatus".equals(fieldName)) {
                    item.setDefaultValue(ExpedStatusEnum.IN_EXAMINE.getNumber());
                }
            });
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!OPERATE_KEY_LIST.contains(operateKey) || !args.getOperationResult().isSuccess()) {
            return;
        }
        if ("donothing_exped".equals(operateKey)) {
            HashMap params = Maps.newHashMap();
            TENURE_FORM_SERVICE.showExploreWindow(this.getView(), params);
            return;
        }
        if (this.getSelectedRows().size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u884c\u6570\u636e\u3002", (String)"ExpedBillList_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            return;
        }
        Object primaryKeyValue = this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject expedBill = EXPED_SERVICE.queryExpedOriOneById("tenure,expedstatus", primaryKeyValue);
        String expedStatus = expedBill.getString("expedstatus");
        DynamicObject tenureDy = TENURE_SERVICE.queryTenureOriginalOneById("person,person.name,prepositivedate,expedcoopratio,positivestatus,expedstatus,realstartdate,extenuredate", (Object)expedBill.getLong("tenure"));
        if ("donothing_finishexped".equals(operateKey)) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ExpedBillList_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            TENURE_FORM_SERVICE.showFinishWindow(this.getView(), primaryKeyValue, new CloseCallBack((IFormPlugin)this, operateKey));
        } else if ("donothing_stopexped".equals(operateKey)) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedStatus) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u7ec8\u6b62\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ExpedBillList_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            EXPED_SERVICE.setDefaultReasonByDepart((AbstractFormPlugin)this);
            TENURE_FORM_SERVICE.showTerminateWindow(this.getView(), tenureDy.get("person.name"), null, new CloseCallBack((IFormPlugin)this, operateKey));
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        DynamicObject expedBill;
        Object primaryKeyValue;
        Boolean success;
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        if ("donothing_exped".equals(actionId) || !OPERATE_KEY_LIST.contains(actionId)) {
            return;
        }
        Object returnData = callBackEvent.getReturnData();
        if ("donothing_finishexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            primaryKeyValue = this.getSelectedRows().getPrimaryKeyValues()[0];
            expedBill = EXPED_SERVICE.queryExpedOriOneById("tenure", primaryKeyValue);
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.COMPLETE, null, (Object)expedBill.getLong("tenure"), (Long)primaryKeyValue, RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u5b8c\u6210\u3002", (String)"ExpedBillList_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_stopexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            primaryKeyValue = this.getSelectedRows().getPrimaryKeyValues()[0];
            expedBill = EXPED_SERVICE.queryExpedOriOneById("tenure", primaryKeyValue);
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, ((Map)returnData).get("terminatereason"), (Object)expedBill.getLong("tenure"), (Long)primaryKeyValue, RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u7ec8\u6b62\u3002", (String)"ExpedBillList_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

