/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.exped;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Rate;
import kd.bos.form.control.events.RateEvent;
import kd.bos.form.control.events.RateListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.RateAp;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedCoopBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.examine.entity.ExamItemBo;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedCoopStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;

public class ExpedCoopBillEdit
extends HRDataBaseEdit
implements RateListener {
    private static final TenureApplicationService tenureService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final CadmFormService cadmFormService = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final ExpedCoopBillApplicationService expedCoopService = (ExpedCoopBillApplicationService)ServiceFactory.getService(ExpedCoopBillApplicationService.class);

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().setValue("createdatenew", (Object)dataEntity.getDate("createtime"));
        Long id = dataEntity.getLong("id");
        String coopStatus = dataEntity.getString("coopstatus");
        long handlerId = dataEntity.getLong("handler_id");
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        String lock = "view,submit,audit";
        if (!ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus) || showFromExamBill != null) {
            lock = "new,edit,view,submit,audit";
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit"});
        }
        DynamicObject expedCoop = expedCoopService.queryExpedCoopBillById("entryentity.examitem,entryentity.itemremark,entryentity.score", id);
        List examItemBoList = cadmFormService.convertCoopBillToExamItemBos(expedCoop);
        if (showFromExamBill != null) {
            this.setValueFromParent(coopStatus, examItemBoList, handlerId);
        }
        FlexPanelAp flexPanelAp = this.createAp(examItemBoList, lock);
        Container flexPanel = (Container)this.getView().getControl("rateflex");
        flexPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        for (ExamItemBo examItemBo : examItemBoList) {
            String examItemId = examItemBo.getExamItemId();
            BigDecimal score = examItemBo.getScore();
            String key = "rateap-" + examItemId;
            this.getView().getPageCache().put(key, score.toString());
            Rate rate = (Rate)this.getView().getControl(key);
            rate.setRateScore((Number)score);
        }
        this.getView().updateControlMetadata("rateflex", flexPanelAp.createControl());
        DynamicObjectCollection interviewee = this.getModel().getDataEntity().getDynamicObjectCollection("interviewee");
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty((Collection)interviewee)), new String[]{"defaultinterviewee"});
        this.showPerInfoCardFlex(dataEntity);
        this.setCoopResultCombo();
        this.getModel().setDataChanged(false);
    }

    private void setValueFromParent(String coopStatus, List<ExamItemBo> examItemBoList, long handlerId) {
        boolean isDiscard;
        boolean isCompleted = ExpedCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus);
        boolean bl = isDiscard = ExpedCoopStatusEnum.ABANDONED.getNumber().equals(coopStatus) && handlerId != 0L;
        if (!isCompleted && !isDiscard) {
            this.getModel().setValue("coopresult", (Object)"");
            this.getModel().setValue("coopcomment", (Object)"");
            this.getModel().setValue("score", (Object)0);
            examItemBoList.forEach(p -> p.setScore(BigDecimal.ZERO));
        }
    }

    private void loadAttachments() {
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        if (showFromExamBill == null) {
            DynamicObject examPlan = (DynamicObject)this.getModel().getValue("expedplan");
            long examPlanId = examPlan.getLong("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_examplan", (Object)examPlanId, (String)"attachmentpanelap");
            if (CollectionUtils.isEmpty((Collection)attachments)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"examplanpanel", "attachlab"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"examplanpanel", "attachlab"});
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("examplanpanel");
                attachmentPanel.bindData(attachments);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String coopStatus = this.getModel().getDataEntity().getString("coopstatus");
        this.getView().setVisible(Boolean.valueOf(ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(coopStatus)), new String[]{"behandle"});
        this.getView().setVisible(Boolean.valueOf(ExpedCoopStatusEnum.COMPLETED.getNumber().equals(coopStatus)), new String[]{"completed"});
        this.getView().setVisible(Boolean.valueOf(ExpedCoopStatusEnum.TERMINATED.getNumber().equals(coopStatus)), new String[]{"terminated"});
        this.getView().setVisible(Boolean.valueOf(ExpedCoopStatusEnum.ABANDONED.getNumber().equals(coopStatus)), new String[]{"abandoned"});
        this.loadAttachments();
        Object showFromExamBill = this.getView().getFormShowParameter().getCustomParam("showFromExamBill");
        if (showFromExamBill != null) {
            long id = (Long)this.getModel().getValue("id");
            List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_expedcooperate", (Object)id, (String)"attachmentpanelap");
            if (!CollectionUtils.isEmpty((Collection)attachments) && ExpedCoopStatusEnum.COMPLETED.getNumber().equals(this.getModel().getDataEntity().getString("coopstatus"))) {
                AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
                attachmentPanel.bindData(attachments);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap", "attachlap"});
            }
        }
    }

    private void showPerInfoCardFlex(DynamicObject dataEntity) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_appointbaseinfo");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        DynamicObject tenureDy = tenureService.queryTenureOriginalOneById("depemp.id,employee.id", dataEntity.getDynamicObject("tenure").getPkValue());
        showParameter.setCustomParam("depEmpId", (Object)tenureDy.getString("depemp.id"));
        showParameter.setCustomParam("personId", (Object)dataEntity.getString("person.id"));
        showParameter.setCustomParam("employee", (Object)tenureDy.getString("employee.id"));
        showParameter.getOpenStyle().setTargetKey("personinfocardview");
        this.getView().showForm(showParameter);
    }

    private void setCoopResultCombo() {
        DynamicObject examResultPlan = (DynamicObject)this.getModel().getValue("examresultplan");
        if (examResultPlan == null) {
            DynamicObject examPlan = (DynamicObject)this.getModel().getValue("expedplan");
            Long examResultPlanId = examPlan.getDynamicObject("examresultplan").getLong("id");
            examResultPlan = expedCoopService.queryExamResultPlanByExamResultPlanId(examResultPlanId);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("coopresult");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        DynamicObjectCollection resultPlanEntry = examResultPlan.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : resultPlanEntry) {
            String result = entryRow.getString("result");
            data.add(new ComboItem(new LocaleString(result), result));
        }
        comboEdit.setComboItems(data);
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.startsWith("rateap-")) {
            Rate rate = new Rate();
            rate.setKey(key);
            rate.setView(this.getView());
            rate.addRateListener((RateListener)this);
            args.setControl((Control)rate);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            Map rateScoreMap = this.getView().getPageCache().getAll();
            DynamicObjectCollection examItemScoreRows = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < examItemScoreRows.size(); ++i) {
                DynamicObject row = (DynamicObject)examItemScoreRows.get(i);
                String examItemId = row.getDynamicObject("examitem").getString("id");
                String key = "rateap-" + examItemId;
                BigDecimal score = new BigDecimal((String)rateScoreMap.get(key));
                this.getModel().setValue("score", (Object)score, i);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.loadAttachments();
        }
        if (HRStringUtils.equals((String)args.getOperateKey(), (String)"submit") && args.getOperationResult().isSuccess()) {
            IFormView parentView = this.getView().getParentView();
            parentView.showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"ExpedCoopBillEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
            this.getView().close();
        }
    }

    private FlexPanelAp createAp(List<ExamItemBo> examItemBoList, String lock) {
        FlexPanelAp containerAp = cadmFormService.createFlexPanelAp("rateflex");
        int index = 1;
        for (ExamItemBo examItemBo : examItemBoList) {
            String examItemId = examItemBo.getExamItemId();
            LabelAp labelAp = cadmFormService.createLabelAp(index, examItemBo);
            containerAp.getItems().add(labelAp);
            if (HRStringUtils.isNotEmpty((String)examItemBo.getItemRemark())) {
                LabelAp remarkLabelAp = cadmFormService.createRemarkLabelAp(examItemBo);
                containerAp.getItems().add(remarkLabelAp);
            }
            RateAp rateAp = cadmFormService.createRateAp(examItemId, lock);
            containerAp.getItems().add(rateAp);
            ++index;
        }
        return containerAp;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        boolean opStatus;
        super.preOpenForm(e);
        BillShowParameter baseShowParameter = (BillShowParameter)e.getSource();
        String pkId = (String)baseShowParameter.getCustomParam("formPkId");
        if (HRStringUtils.isNotEmpty((String)pkId)) {
            baseShowParameter.setPkId((Object)Long.valueOf(pkId));
        }
        DynamicObject expedCoopDy = expedCoopService.queryExpedCoopBillById("coopstatus,coophandler,person.name", (Long)baseShowParameter.getPkId());
        String expedCoopStatus = expedCoopDy.getString("coopstatus");
        List handlerIds = expedCoopDy.getDynamicObjectCollection("coophandler").stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (ExpedCoopStatusEnum.isViewStatus((String)expedCoopStatus)) {
            baseShowParameter.setStatus(OperationStatus.VIEW);
        }
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u8f6c\u6b63\u8003\u5bdf\u534f\u4f5c-%s", (String)"ExpedCoopBillEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{expedCoopDy.getString("person.name")}));
        long currUserId = RequestContext.get().getCurrUserId();
        Object showFromExamBill = baseShowParameter.getCustomParam("showFromExamBill");
        if (showFromExamBill == null && !handlerIds.contains(currUserId)) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u4f60\u6ca1\u6709\u5f53\u524d\u5355\u636e\u7684\u5904\u7406\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ExpedCoopBillEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        baseShowParameter.setStatus((opStatus = ExpedCoopStatusEnum.TO_BE_HANDLED.getNumber().equals(expedCoopStatus)) ? OperationStatus.EDIT : OperationStatus.VIEW);
    }

    public void update(RateEvent rateEvent) {
        Control rate = (Control)rateEvent.getSource();
        String key = rate.getKey();
        Number rateScore = rateEvent.getRateScore();
        this.getView().getPageCache().put(key, rateScore.toString());
    }
}

