/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.exped;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;

public class StartExpedPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOG = LogFactory.getLog(StartExpedPlugin.class);
    private static final ExpedBillApplicationService expedService = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final String ADJUST_HANDLER_FLEX = "adjusthandler";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("org", this.getView().getParentView().getModel().getValue("org"));
        boolean isRestartExamCoop = (Boolean)this.getView().getFormShowParameter().getCustomParam("isRestartExamCoop");
        boolean isAdjustExamPlan = (Boolean)this.getView().getFormShowParameter().getCustomParam("adjustexamplan");
        if (!isRestartExamCoop) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"repeatstartexplore"});
        }
        if (!isAdjustExamPlan) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ADJUST_HANDLER_FLEX});
        }
        this.setExpedPlanFilterAndDefaultVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showExpedPlanEntryByExamPlanId();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String key = args.getProperty().getName();
        if ("expedplan".equals(key)) {
            this.showExpedPlanEntryByExamPlanId();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_confirm".equals(operateKey) && args.getOperationResult().isSuccess()) {
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            long examPlanSourceVid = this.getModel().getDataEntity().getDynamicObject("expedplan").getLong("sourcevid");
            returnData.put("expedplan", examPlanSourceVid);
            returnData.put("success", true);
            Map<String, List<Long>> intervieweeMap = this.getInterviewee();
            returnData.put("interviewee", intervieweeMap);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            boolean isAdjustExamPlan = (Boolean)formShowParameter.getCustomParam("adjustexamplan");
            returnData.put("adjustexamplan", isAdjustExamPlan);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private Map<String, List<Long>> getInterviewee() {
        HashMap<String, List<Long>> rltMap = new HashMap<String, List<Long>>(16);
        DynamicObjectCollection examPlanEntry = this.getModel().getDataEntity().getDynamicObjectCollection("examplanentry");
        for (DynamicObject row : examPlanEntry) {
            String itemGroupName = row.getString("itemgroup.name");
            DynamicObjectCollection interviewee = row.getDynamicObjectCollection("interviewee");
            List list = interviewee.stream().map(p -> p.getLong("fbasedataid.masterid")).collect(Collectors.toList());
            rltMap.put(itemGroupName, list);
        }
        return rltMap;
    }

    private void setExpedPlanFilterAndDefaultVal() {
        List ids = (List)this.getView().getFormShowParameter().getCustomParam("expedplan");
        BasedataEdit examPlanEdit = (BasedataEdit)this.getView().getControl("expedplan");
        examPlanEdit.setQFilter(new QFilter("id", "in", (Object)ids));
        Object examPlan = this.getModel().getValue("expedplan");
        if (examPlan == null) {
            this.getModel().setValue("expedplan", ids.get(0));
        }
    }

    private void showExpedPlanEntryByExamPlanId() {
        DynamicObject expedPlan = this.getModel().getDataEntity().getDynamicObject("expedplan");
        if (expedPlan != null) {
            Long examPlanId = expedPlan.getLong("id");
            DynamicObject examPlanQ = expedService.queryExamPlanByExamPlanId(examPlanId);
            this.loadExamPlanEntry(examPlanQ);
            this.loadAttachments(examPlanId);
        }
    }

    private void loadAttachments(Long examPlanId) {
        List attachments = AttachmentServiceHelper.getAttachments((String)"cadm_examplan", (Object)examPlanId, (String)"attachmentpanelap");
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attachmentpanelap", "attachlabel"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"attachmentpanelap", "attachlabel"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.bindData(attachments);
    }

    private void loadExamPlanEntry(DynamicObject examPlan) {
        String tenureData = (String)this.getView().getFormShowParameter().getCustomParam("tenure");
        DynamicObject tenureDy = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)tenureData);
        tenureDy.set("creator", this.getView().getParentView().getModel().getDataEntity().get("creator"));
        Map handlerMap = expedService.getExpedCoopHandlerMap(examPlan, tenureDy);
        this.getModel().deleteEntryData("examplanentry");
        DynamicObjectCollection examPlanEntryRows = examPlan.getDynamicObjectCollection("examplanentry");
        if (examPlanEntryRows != null && examPlanEntryRows.size() > 0) {
            int[] indexArr = this.getModel().batchCreateNewEntryRow("examplanentry", examPlanEntryRows.size());
            this.getView().setVisible(Boolean.TRUE, new String[]{"btn_ok", "btn_cancel"});
            for (int i = 0; i < indexArr.length; ++i) {
                DynamicObject row = (DynamicObject)examPlanEntryRows.get(i);
                String id = row.getString("id");
                Long itemGroupId = row.getDynamicObject("itemgroup").getLong("id");
                DynamicObjectCollection examItems = row.getDynamicObjectCollection("planexamitem");
                this.getModel().setValue("itemgroup", (Object)itemGroupId, indexArr[i]);
                this.getModel().setValue("planexamitem", (Object)examItems.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).toArray(), indexArr[i]);
                List coopHandlerIds = (List)handlerMap.get(id);
                LOG.info("examplanentry-id:{},coopHandlerIds\uff1a{}", (Object)id, (Object)coopHandlerIds);
                if (CollectionUtils.isEmpty((Collection)coopHandlerIds)) continue;
                this.getModel().setValue("coophandler", (Object)coopHandlerIds.toArray(), indexArr[i]);
            }
        }
        this.getView().updateView("examplanentry");
    }
}

