/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.probation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveOperateEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenurePlanUnitEnum;

public class ConfirmApplyPlugin
extends HRDynamicFormBasePlugin {
    private static final List<String> LISTEN_FIELDS = Lists.newArrayList((Object[])new String[]{"plannumber", "planunit"});
    private static final Map<String, Integer> FIELD = Maps.newHashMap();
    private static final String OP_CONFIRM = "confirm";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("person", params.get("person"));
        this.getModel().setValue("prepositivedate", params.get("prepositivedate"));
        this.getModel().setValue("planenddate", params.get("planenddate"));
        this.getModel().setValue("realstartdate", params.get("realstartdate"));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DateEdit realPosDate = (DateEdit)this.getControl("realpositivedate");
        Date planEndDate = dataEntity.getDate("planenddate");
        Date realStartDate = dataEntity.getDate("realstartdate");
        String realStartDateStr = HRDateTimeUtils.format((Date)realStartDate, (String)"yyyy-MM-dd");
        String planEndDateStr = Objects.isNull(planEndDate) ? "" : ResManager.loadKDString((String)"<\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff08{0}\uff09", (String)"ConfirmApplyPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)planEndDate, (String)"yyyy-MM-dd")});
        this.setTips(realPosDate, ResManager.loadKDString((String)"\u8bd5\u7528\u5b9e\u9645\u5f00\u59cb\u65e5\u671f\uff08{0}\uff09<=\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f{1}", (String)"ConfirmApplyPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{realStartDateStr, planEndDateStr}));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (OP_CONFIRM.equals(source.getOperateKey())) {
            String operation = this.getModel().getDataEntity().getString("operation");
            if (PositiveOperateEnum.NORMAL.getNumber().equals(operation)) {
                Date realPosDate = dataEntity.getDate("realpositivedate");
                Date planEndDate = dataEntity.getDate("planenddate");
                Date realStartDate = dataEntity.getDate("realstartdate");
                if (HRDateTimeUtils.dayAfter((Date)realStartDate, (Date)realPosDate) || !Objects.isNull(planEndDate) && !HRDateTimeUtils.dayBefore((Date)realPosDate, (Date)planEndDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c\u8bd5\u7528\u5b9e\u9645\u5f00\u59cb\u65e5\u671f\u201d\uff0c\u4e14\u5e94\u65e9\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\u3002", (String)"ConfirmApplyPlugin_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (PositiveOperateEnum.ADVANCED.getNumber().equals(operation)) {
                Date realStartDate = dataEntity.getDate("realstartdate");
                Date realPosDate = dataEntity.getDate("realpositivedate");
                Date prePosDate = dataEntity.getDate("prepositivedate");
                if (HRDateTimeUtils.dayBefore((Date)realPosDate, (Date)realStartDate) || HRDateTimeUtils.dayBefore((Date)prePosDate, (Date)realPosDate) || HRDateTimeUtils.dayEquals((Date)prePosDate, (Date)realPosDate)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\uff0c\u4e14\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u201c\u8bd5\u7528\u5b9e\u9645\u5f00\u59cb\u65e5\u671f\u201d\u3002", (String)"ConfirmApplyPlugin_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            } else if (PositiveOperateEnum.DELAY.getNumber().equals(operation)) {
                Date prePosDate = dataEntity.getDate("prepositivedate");
                Date planEndDate = dataEntity.getDate("planenddate");
                Date delayPrePosDate = dataEntity.getDate("delaypreposdate");
                if (HRDateTimeUtils.dayAfter((Date)prePosDate, (Date)delayPrePosDate) || !Objects.isNull(planEndDate) && HRDateTimeUtils.dayBefore((Date)planEndDate, (Date)delayPrePosDate)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5ef6\u957f\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u201d\uff0c\u4e14\u5e94\u665a\u4e8e\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"ConfirmApplyPlugin_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("donothing_confirm".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().invokeOperation(OP_CONFIRM);
        }
        if (OP_CONFIRM.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)HRDynamicObjectUtils.convertDynamicObjectToMap((DynamicObject)this.getModel().getDataEntity()));
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String changeName = args.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if ("operation".equals(changeName)) {
            String planEndDateStr;
            String operation = dataEntity.getString("operation");
            DateEdit realPosDate = (DateEdit)this.getControl("realpositivedate");
            DateEdit delayPreDate = (DateEdit)this.getControl("delaypreposdate");
            Date planEndDate = dataEntity.getDate("planenddate");
            Date realStartDate = dataEntity.getDate("realstartdate");
            String realStartDateStr = HRDateTimeUtils.format((Date)realStartDate, (String)"yyyy-MM-dd");
            if (PositiveOperateEnum.NORMAL.getNumber().equals(operation)) {
                planEndDateStr = Objects.isNull(planEndDate) ? "" : ResManager.loadKDString((String)"<\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff08{0}\uff09", (String)"ConfirmApplyPlugin_0", (String)"tdc-cadm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)planEndDate, (String)"yyyy-MM-dd")});
                this.setTips(realPosDate, ResManager.loadKDString((String)"\u8bd5\u7528\u5b9e\u9645\u5f00\u59cb\u65e5\u671f\uff08{0}\uff09<=\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f{1}", (String)"ConfirmApplyPlugin_1", (String)"tdc-cadm-formplugin", (Object[])new Object[]{realStartDateStr, planEndDateStr}));
            }
            if (PositiveOperateEnum.ADVANCED.getNumber().equals(operation)) {
                this.setTips(realPosDate, ResManager.loadKDString((String)"\u8bd5\u7528\u5b9e\u9645\u5f00\u59cb\u65e5\u671f\uff08{0}\uff09<=\u5b9e\u9645\u8f6c\u6b63\u65e5\u671f<\u9884\u8f6c\u6b63\u65e5\u671f", (String)"ConfirmApplyPlugin_5", (String)"tdc-cadm-formplugin", (Object[])new Object[]{realStartDateStr}));
            }
            if (PositiveOperateEnum.DELAY.getNumber().equals(operation)) {
                planEndDateStr = Objects.isNull(planEndDate) ? "" : ResManager.loadKDString((String)"<=\u4efb\u671f\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\uff08{0}\uff09", (String)"ConfirmApplyPlugin_6", (String)"tdc-cadm-formplugin", (Object[])new Object[]{HRDateTimeUtils.format((Date)planEndDate, (String)"yyyy-MM-dd")});
                this.setTips(delayPreDate, ResManager.loadKDString((String)"\u201c\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u5e94\u65e9\u4e8e\u201c\u5ef6\u957f\u9884\u8f6c\u6b63\u65e5\u671f\u201d\u3002", (String)"ConfirmApplyPlugin_7", (String)"tdc-cadm-formplugin", (Object[])new Object[]{planEndDateStr}));
            }
        }
        if (LISTEN_FIELDS.contains(changeName)) {
            Date prePosDate = dataEntity.getDate("prepositivedate");
            String planUnit = dataEntity.getString("planunit");
            int planNum = dataEntity.getInt("plannumber");
            if (!HRStringUtils.isEmpty((String)planUnit) && planNum != 0) {
                Calendar delayPrePosDate = Calendar.getInstance();
                delayPrePosDate.setTime(prePosDate);
                delayPrePosDate.add(FIELD.get(planUnit), planNum);
                this.getModel().setValue("delaypreposdate", (Object)delayPrePosDate.getTime());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\u9884\u8f6c\u6b63\u65e5\u671f\u3002", (String)"ConfirmApplyPlugin_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void setTips(DateEdit realPosDate, String localeValue) {
        LocaleString localeString = new LocaleString();
        localeString.setLocaleValue(localeValue);
        Tips tips = new Tips();
        tips.setContent(localeString);
        tips.setType("text");
        tips.setTriggerType("hover");
        realPosDate.addTips(tips);
    }

    static {
        FIELD.put(TenurePlanUnitEnum.DAY.getNumber(), 7);
        FIELD.put(TenurePlanUnitEnum.MONTH.getNumber(), 2);
        FIELD.put(TenurePlanUnitEnum.YEAR.getNumber(), 1);
    }
}

