/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.probation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveOperateEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.formservice.CadmFormService;
import kd.tdc.cadm.bussiness.util.CastUtils;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.TenureFormService;

public class ProbationManageEdit
extends HRDynamicFormBasePlugin
implements SetFilterListener,
HyperLinkClickListener {
    private static final TenureApplicationService TENURE_SERVICE = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final ExpedBillApplicationService EXPED_SERVICE = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final CadmFormService CADM_FORM_SERVICE = (CadmFormService)ServiceFactory.getService(CadmFormService.class);
    private static final TenureFormService TENURE_FORM_SERVICE = FormServiceFactory.getService(TenureFormService.class);
    private static final List<String> OPERATE_KEY_LIST = Lists.newArrayList((Object[])new String[]{"donothing_exped", "donothing_stopexped", "donothing_finishexped", "donothing_apply", "donothing_seemoredetails", "donothing_list_finishexped", "donothing_list_stopexped"});

    public void initialize() {
        super.initialize();
        BillList entryGrid = (BillList)this.getView().getControl("billlistap");
        entryGrid.addPackageDataListener(pkEvent -> {
            String expedStatus = pkEvent.getRowData().getString("expedstatus");
            if (pkEvent.getSource() instanceof ListOperationColumnDesc && "listoperationcolumnap".equalsIgnoreCase(((ListOperationColumnDesc)pkEvent.getSource()).getKey())) {
                List operationColItems = (List)pkEvent.getFormatValue();
                for (OperationColItem operationColItem : operationColItems) {
                    String operationKey = operationColItem.getOperationKey();
                    if (!"donothing_list_finishexped".equals(operationKey) && !"donothing_list_stopexped".equals(operationKey) || !ExpedStatusEnum.COMPLETE.getNumber().equals(expedStatus) && !ExpedStatusEnum.TERMINATED.getNumber().equals(expedStatus)) continue;
                    operationColItem.setVisible(false);
                    operationColItem.setLocked(true);
                }
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("expedplan_name".equals(fieldName)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = list.getSelectedRows();
            for (ListSelectedRow selectedRow : selectedRows) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPkId(selectedRow.getPrimaryKeyValue());
                parameter.setFormId("cadm_expedbill");
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object tenureId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        DynamicObject tenure = TENURE_SERVICE.queryTenureOneById("id,positiveentryentity", tenureId);
        this.getModel().setValue("ispositiveinfo", (Object)(tenure.getDynamicObjectCollection("positiveentryentity").size() > 0 ? 1 : 0));
        DynamicObject[] expedBills = EXPED_SERVICE.queryOriByTenureIdOrderByTime("id,createtime,expedplan,expedcomment,expedresult,expedcoopratio,expedstatus", tenureId);
        boolean existExploreData = expedBills.length > 0;
        this.getModel().setValue("isexpedinfo", (Object)existExploreData);
        this.getModel().setDataChanged(false);
        String positiveStatus = this.getModel().getDataEntity().getString("positivestatus");
        this.getView().setVisible(Boolean.valueOf(PositiveStatusEnum.TODO.getNumber().equals(positiveStatus) || PositiveStatusEnum.DELAY.getNumber().equals(positiveStatus)), new String[]{"positivebtn"});
        this.buildPerInfoCard(tenureId);
        CardEntry cardEntry = (CardEntry)this.getControl("proentryentity");
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity().getDynamicObjectCollection("proentryentity");
        if (entryEntity.size() > 1) {
            cardEntry.setChildVisible(false, entryEntity.size() - 1, new String[]{"line"});
            for (int i = 0; i < entryEntity.size() - 1; ++i) {
                for (int j = 0; j < entryEntity.size() - i - 1; ++j) {
                    Date date2;
                    Date date1 = ((DynamicObject)entryEntity.get(j)).getDate("entryoperationdate");
                    if (!date1.before(date2 = ((DynamicObject)entryEntity.get(j + 1)).getDate("entryoperationdate"))) continue;
                    this.getModel().moveEntryRowDown("proentryentity", j);
                }
            }
            this.getView().updateView("proentryentity");
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilter(this.getQFilter());
    }

    private void buildPerInfoCard(Object tenureId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cadm_perbaseinfo");
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("probationhead");
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setCustomParam("tenure", tenureId);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!OPERATE_KEY_LIST.contains(operateKey)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Object pkValue = dataEntity.getPkValue();
        if (args.getOperationResult().isSuccess()) {
            if ("donothing_apply".equals(operateKey)) {
                if (!PositiveStatusEnum.DELAY.getNumber().equals(dataEntity.getString("positivestatus")) && !PositiveStatusEnum.TODO.getNumber().equals(dataEntity.getString("positivestatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63/\u5ef6\u671f\u8f6c\u6b63\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageEdit_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    return;
                }
                HashMap paramMap = Maps.newHashMap();
                paramMap.put("person", dataEntity.getDynamicObject("person").getLong("id"));
                paramMap.put("prepositivedate", dataEntity.getDate("prepositivedate"));
                paramMap.put("planenddate", dataEntity.getDate("planenddate"));
                paramMap.put("realstartdate", dataEntity.getDate("realstartdate"));
                TENURE_FORM_SERVICE.showApplyWindow(this.getView(), paramMap, new CloseCallBack((IFormPlugin)this, operateKey));
            } else if ("donothing_exped".equals(operateKey)) {
                HashMap params = Maps.newHashMap();
                params.put("person", dataEntity.getLong("person.id"));
                params.put("tenure", dataEntity.getPkValue());
                TENURE_FORM_SERVICE.showExploreWindow(this.getView(), params);
            } else if ("donothing_finishexped".equals(operateKey)) {
                if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(dataEntity.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(dataEntity.getString("expedstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageEdit_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject beHandleExpedDy = EXPED_SERVICE.queryNewestExpedOneByTenureId("id", pkValue);
                TENURE_FORM_SERVICE.showFinishWindow(this.getView(), beHandleExpedDy.getPkValue(), new CloseCallBack((IFormPlugin)this, operateKey));
            } else if ("donothing_stopexped".equals(operateKey)) {
                if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(dataEntity.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(dataEntity.getString("expedstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u7ec8\u6b62\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageEdit_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TENURE_FORM_SERVICE.showTerminateWindow(this.getView(), dataEntity.get("person.name"), null, new CloseCallBack((IFormPlugin)this, operateKey));
            } else if ("donothing_seemoredetails".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getControl("billlistap");
                long expedBillId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                billShowParameter.setFormId("cadm_moredetail");
                billShowParameter.setStatus(OperationStatus.VIEW);
                billShowParameter.setPkId((Object)expedBillId);
                this.getView().showForm((FormShowParameter)billShowParameter);
            } else if ("donothing_list_finishexped".equals(args.getOperateKey())) {
                BillList billList = (BillList)this.getControl("billlistap");
                long expedBillId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject expedBill = EXPED_SERVICE.queryOne("expedstatus", expedBillId);
                if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedBill.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedBill.getString("expedstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageEdit_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TENURE_FORM_SERVICE.showFinishWindow(this.getView(), expedBillId, new CloseCallBack((IFormPlugin)this, operateKey));
            } else if ("donothing_list_stopexped".equals(operateKey)) {
                BillList billList = (BillList)this.getControl("billlistap");
                long expedBillId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
                DynamicObject expedBill = EXPED_SERVICE.queryOne("expedstatus,person", expedBillId);
                if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(expedBill.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(expedBill.getString("expedstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u7ec8\u6b62\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageEdit_8", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                    return;
                }
                TENURE_SERVICE.setDefaultReasonByDepart((AbstractFormPlugin)this);
                TENURE_FORM_SERVICE.showTerminateWindow(this.getView(), expedBill.get("person.name"), expedBillId, new CloseCallBack((IFormPlugin)this, operateKey));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        DynamicObject expedBill;
        Map rltMap;
        Boolean success;
        Boolean success2;
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object returnData = callBackEvent.getReturnData();
        if (!OPERATE_KEY_LIST.contains(actionId)) {
            return;
        }
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        if ("donothing_apply".equals(actionId) && returnData instanceof Map) {
            DynamicObject tenureDy = TENURE_SERVICE.queryTenureOneById("id,positiveentryentity,positiveentryentity.operation,positiveentryentity.operationdate,positiveentryentity.planunit,positiveentryentity.opinion,positiveentryentity.plannumber,positiveentryentity.prepositivedateentry,tenurestatus,positivestatus,realpositivedate,prepositivedate", pkValue);
            String operation = (String)((Map)returnData).get("operation");
            DynamicObjectCollection positiveEntryEntity = tenureDy.getDynamicObjectCollection("positiveentryentity");
            DynamicObject entry = positiveEntryEntity.addNew();
            Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
            entry.set("operation", (Object)operation);
            entry.set("operationdate", (Object)new Date());
            entry.set("opinion", ((Map)returnData).get("opinion"));
            if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.NORMAL.getNumber())) {
                Date realPositiveDate = (Date)((Map)returnData).get("realpositivedate");
                tenureDy.set("realpositivedate", (Object)realPositiveDate);
                if (HRDateTimeUtils.dayAfter((Date)realPositiveDate, (Date)currDate)) {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.INEFFECTIVE.getNumber());
                } else {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DONE.getNumber());
                    tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
                }
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.ADVANCED.getNumber())) {
                Date realPositiveDate = (Date)((Map)returnData).get("realpositivedate");
                tenureDy.set("realpositivedate", (Object)realPositiveDate);
                if (realPositiveDate.compareTo(currDate) <= 0) {
                    tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DONE.getNumber());
                } else {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.INEFFECTIVE.getNumber());
                }
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.DELAY.getNumber())) {
                entry.set("plannumber", ((Map)returnData).get("plannumber"));
                entry.set("planunit", ((Map)returnData).get("planunit"));
                entry.set("prepositivedateentry", ((Map)returnData).get("delaypreposdate"));
                tenureDy.set("prepositivedate", ((Map)returnData).get("delaypreposdate"));
                tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DELAY.getNumber());
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.REFUSE.getNumber())) {
                tenureDy.set("positivestatus", (Object)PositiveStatusEnum.REFUSE.getNumber());
            }
            TENURE_SERVICE.update(tenureDy);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u6b63\u7ed3\u679c\u5df2\u786e\u8ba4\u3002", (String)"ProbationManageEdit_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_finishexped".equals(actionId) && returnData instanceof Map && (success2 = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.COMPLETE, null, pkValue, Long.valueOf(0L), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u5b8c\u6210\u3002", (String)"ProbationManageEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_stopexped".equals(actionId) && returnData instanceof Map && (success2 = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, ((Map)returnData).get("terminatereason"), pkValue, Long.valueOf(0L), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u7ec8\u6b62\u3002", (String)"ProbationManageEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_list_finishexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)(rltMap = CastUtils.castMap((Object)returnData, String.class)).get("success")).booleanValue()) {
            long expedId = Long.parseLong(rltMap.get("pkValue").toString());
            expedBill = EXPED_SERVICE.queryOne("tenure.id", expedId);
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.COMPLETE, null, (Object)expedBill.getLong("tenure_id"), Long.valueOf(expedId), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u5b8c\u6210\u3002", (String)"ExpedBillEdit_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_list_stopexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)(rltMap = CastUtils.castMap((Object)returnData, String.class)).get("success")).booleanValue()) {
            long expedId = Long.parseLong(rltMap.get("expedBillId").toString());
            expedBill = EXPED_SERVICE.queryOne("tenure.id", expedId);
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, ((Map)returnData).get("terminatereason"), (Object)expedBill.getLong("tenure_id"), Long.valueOf(expedId), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u7ec8\u6b62\u3002", (String)"ExpedBillEdit_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        super.preOpenForm(args);
        BaseShowParameter showParameter = (BaseShowParameter)args.getFormShowParameter();
        Long pkId = (Long)showParameter.getPkId();
        if (!Objects.isNull(pkId) && pkId != 0L) {
            DynamicObject dynamicObject = TENURE_SERVICE.queryTenureOriginalOneById("person.name", (Object)pkId);
            showParameter.setCaption(ResManager.loadKDString((String)"\u5e72\u90e8\u8bd5\u7528\u53ca\u8f6c\u6b63-%s", (String)"ProbationManageEdit_6", (String)"tdc-cadm-formplugin", (Object[])new Object[]{dynamicObject.getString("person.name")}));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        setFilterEvent.addCustomQFilter(this.getQFilter());
    }

    private QFilter getQFilter() {
        Object tenureId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        QFilter tenureIdFilter = new QFilter("tenure", "=", tenureId);
        return tenureIdFilter;
    }
}

