/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.tenure.probation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.ExpedBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.exped.enums.ExpedStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveOperateEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.formplugin.web.formservice.FormServiceFactory;
import kd.tdc.cadm.formplugin.web.formservice.TenureFormService;
import kd.tdc.tdcs.bussiness.formservice.FormCommonService;

public class ProbationManageList
extends HRDataBaseList {
    private static final List<String> OPERATE_KEY_LIST = Lists.newArrayList((Object[])new String[]{"donothing_exped", "donothing_stopexped", "donothing_finishexped", "donothing_apply"});
    private static final TenureApplicationService TENURE_SERVICE = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final ExpedBillApplicationService EXPED_SERVICE = (ExpedBillApplicationService)ServiceFactory.getService(ExpedBillApplicationService.class);
    private static final TenureFormService TENURE_FORM_SERVICE = FormServiceFactory.getService(TenureFormService.class);
    private static final FormCommonService FORM_COMMON_SERVICE = FormServiceFactory.getService(FormCommonService.class);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("positivestatus asc,prepositivedate asc");
        QFilter filter = this.getCustomFilter();
        setFilterEvent.getQFilters().add(filter);
    }

    private QFilter getCustomFilter() {
        return new QFilter("positivestatus", "!=", (Object)" ");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FORM_COMMON_SERVICE.beforeCreateListColumns(args, "person.number");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (!OPERATE_KEY_LIST.contains(operateKey) || !args.getOperationResult().isSuccess()) {
            return;
        }
        if (this.getSelectedRows().size() > 1) {
            String errorNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u884c\u6570\u636e\u3002", (String)"ProbationManageList_0", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            if ("donothing_apply".equals(operateKey)) {
                errorNotification = ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4e00\u6b21\u53ea\u80fd\u64cd\u4f5c\u4e00\u884c\u6570\u636e\u3002", (String)"ProbationManageList_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
            }
            this.getView().showErrorNotification(errorNotification);
            return;
        }
        if ("donothing_exped".equals(operateKey)) {
            HashMap params = Maps.newHashMap();
            if (this.getSelectedRows().size() > 0) {
                Object primaryKeyValue = this.getSelectedRows().get(0).getPrimaryKeyValue();
                DynamicObject tenureDy = TENURE_SERVICE.queryTenureOriginalOneById("person", primaryKeyValue);
                params.put("person", tenureDy.getLong("person"));
                params.put("tenure", primaryKeyValue);
            }
            TENURE_FORM_SERVICE.showExploreWindow(this.getView(), params);
            return;
        }
        Object primaryKeyValue = this.getSelectedRows().get(0).getPrimaryKeyValue();
        DynamicObject tenureDy = TENURE_SERVICE.queryTenureOriginalOneById("person,person.name,prepositivedate,expedcoopratio,positivestatus,expedstatus,realstartdate,planenddate", primaryKeyValue);
        if ("donothing_apply".equals(operateKey)) {
            if (!PositiveStatusEnum.DELAY.getNumber().equals(tenureDy.getString("positivestatus")) && !PositiveStatusEnum.TODO.getNumber().equals(tenureDy.getString("positivestatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8f6c\u6b63\u72b6\u6001\u4e3a\u201c\u5f85\u8f6c\u6b63/\u5ef6\u671f\u8f6c\u6b63\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageList_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap paramMap = Maps.newHashMap();
            paramMap.put("person", tenureDy.get("person"));
            paramMap.put("prepositivedate", tenureDy.getDate("prepositivedate"));
            paramMap.put("planenddate", tenureDy.getDate("planenddate"));
            paramMap.put("realstartdate", tenureDy.getDate("realstartdate"));
            TENURE_FORM_SERVICE.showApplyWindow(this.getView(), paramMap, new CloseCallBack((IFormPlugin)this, operateKey));
        } else if ("donothing_finishexped".equals(operateKey)) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(tenureDy.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(tenureDy.getString("expedstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u64cd\u4f5c\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageList_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject beHandleExpedDy = EXPED_SERVICE.queryNewestExpedOneByTenureId("id", this.getSelectedRows().get(0).getPrimaryKeyValue());
            TENURE_FORM_SERVICE.showFinishWindow(this.getView(), beHandleExpedDy.getPkValue(), new CloseCallBack((IFormPlugin)this, operateKey));
        } else if ("donothing_stopexped".equals(operateKey)) {
            if (!ExpedStatusEnum.TO_BE_EXAMINE.getNumber().equals(tenureDy.getString("expedstatus")) && !ExpedStatusEnum.IN_EXAMINE.getNumber().equals(tenureDy.getString("expedstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u4ec5\u53ef\u7ec8\u6b62\u8003\u5bdf\u72b6\u6001\u4e3a\u201c\u5f85\u542f\u52a8/\u8003\u5bdf\u4e2d\u201d\u7684\u6570\u636e\u3002", (String)"ProbationManageList_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
                return;
            }
            TENURE_SERVICE.setDefaultReasonByDepart((AbstractFormPlugin)this);
            TENURE_FORM_SERVICE.showTerminateWindow(this.getView(), tenureDy.get("person.name"), null, new CloseCallBack((IFormPlugin)this, operateKey));
        }
    }

    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        Boolean success;
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        if ("donothing_exped".equals(actionId) || !OPERATE_KEY_LIST.contains(actionId)) {
            return;
        }
        Object returnData = callBackEvent.getReturnData();
        if ("donothing_apply".equals(actionId) && returnData instanceof Map) {
            Object primaryKeyValue = this.getSelectedRows().getPrimaryKeyValues()[0];
            DynamicObject tenureDy = TENURE_SERVICE.queryTenureOneById("id,positiveentryentity,positiveentryentity.operation,positiveentryentity.operationdate,positiveentryentity.planunit,positiveentryentity.opinion,positiveentryentity.prepositivedateentry,positiveentryentity.plannumber,tenurestatus,positivestatus,realpositivedate,prepositivedate", primaryKeyValue);
            String operation = (String)((Map)returnData).get("operation");
            DynamicObjectCollection positiveEntryEntity = tenureDy.getDynamicObjectCollection("positiveentryentity");
            Date currDate = HRDateTimeUtils.truncateDate((Date)new Date());
            DynamicObject entry = positiveEntryEntity.addNew();
            entry.set("operation", (Object)operation);
            entry.set("operationdate", (Object)new Date());
            entry.set("opinion", ((Map)returnData).get("opinion"));
            if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.NORMAL.getNumber())) {
                Date realPositiveDate = (Date)((Map)returnData).get("realpositivedate");
                tenureDy.set("realpositivedate", (Object)realPositiveDate);
                if (HRDateTimeUtils.dayAfter((Date)realPositiveDate, (Date)currDate)) {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.INEFFECTIVE.getNumber());
                } else {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DONE.getNumber());
                    tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
                }
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.ADVANCED.getNumber())) {
                Date realPositiveDate = (Date)((Map)returnData).get("realpositivedate");
                tenureDy.set("realpositivedate", (Object)realPositiveDate);
                if (realPositiveDate.compareTo(currDate) <= 0) {
                    tenureDy.set("tenurestatus", (Object)TenureStatusEnum.ASSUME.getNumber());
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DONE.getNumber());
                } else {
                    tenureDy.set("positivestatus", (Object)PositiveStatusEnum.INEFFECTIVE.getNumber());
                }
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.DELAY.getNumber())) {
                entry.set("plannumber", ((Map)returnData).get("plannumber"));
                entry.set("planunit", ((Map)returnData).get("planunit"));
                entry.set("prepositivedateentry", ((Map)returnData).get("delaypreposdate"));
                tenureDy.set("prepositivedate", ((Map)returnData).get("delaypreposdate"));
                tenureDy.set("positivestatus", (Object)PositiveStatusEnum.DELAY.getNumber());
            } else if (HRStringUtils.equals((String)operation, (String)PositiveOperateEnum.REFUSE.getNumber())) {
                tenureDy.set("positivestatus", (Object)PositiveStatusEnum.REFUSE.getNumber());
            }
            TENURE_SERVICE.update(tenureDy);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u6b63\u7ed3\u679c\u5df2\u786e\u8ba4\u3002", (String)"ProbationManageList_5", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_finishexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.COMPLETE, null, this.getSelectedRows().getPrimaryKeyValues()[0], Long.valueOf(0L), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u5b8c\u6210\u3002", (String)"ProbationManageList_6", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
        if ("donothing_stopexped".equals(actionId) && returnData instanceof Map && (success = (Boolean)((Map)returnData).get("success")).booleanValue()) {
            EXPED_SERVICE.completeOrTerminateExpedBill(ExpedStatusEnum.TERMINATED, ((Map)returnData).get("terminatereason"), this.getSelectedRows().getPrimaryKeyValues()[0], Long.valueOf(0L), RequestContext.get().getCurrUserId());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8003\u5bdf\u5df2\u7ec8\u6b62\u3002", (String)"ProbationManageList_7", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }
}

