/*
 * Decompiled with CFR 0.152.
 */
package kd.tdc.cadm.formplugin.web.workbench.card;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.TextEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.tdc.cadm.bussiness.ServiceFactory;
import kd.tdc.cadm.bussiness.application.service.AuditBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ExamineBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.IssueBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.NominateApplicationService;
import kd.tdc.cadm.bussiness.application.service.PublicityBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReleaseBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.ReviewBillApplicationService;
import kd.tdc.cadm.bussiness.application.service.TenureApplicationService;
import kd.tdc.cadm.bussiness.domain.appointaudit.enums.AppointAuditStatusEnum;
import kd.tdc.cadm.bussiness.domain.examine.enums.ExamineStatusEnum;
import kd.tdc.cadm.bussiness.domain.issue.enums.IssueStatusEnum;
import kd.tdc.cadm.bussiness.domain.nominate.enums.AppointStatusEnum;
import kd.tdc.cadm.bussiness.domain.publicity.enums.PublicityStatusEnum;
import kd.tdc.cadm.bussiness.domain.release.enums.ReleaseStatusEnum;
import kd.tdc.cadm.bussiness.domain.review.enmus.ReviewStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.PositiveStatusEnum;
import kd.tdc.cadm.bussiness.domain.tenure.enums.TenureStatusEnum;
import kd.tdc.cadm.bussiness.util.DateUtil;

public class CoreDataOverviewPlugin
extends HRDynamicFormBasePlugin
implements CellClickListener {
    private static final Log logger = LogFactory.getLog(CoreDataOverviewPlugin.class);
    private static final TenureApplicationService tenureApplicationService = (TenureApplicationService)ServiceFactory.getService(TenureApplicationService.class);
    private static final NominateApplicationService nominateApplicationService = (NominateApplicationService)ServiceFactory.getService(NominateApplicationService.class);
    private static final AuditBillApplicationService auditBillApplicationService = (AuditBillApplicationService)ServiceFactory.getService(AuditBillApplicationService.class);
    private static final ExamineBillApplicationService examineBillApplicationService = (ExamineBillApplicationService)ServiceFactory.getService(ExamineBillApplicationService.class);
    private static final ReviewBillApplicationService reviewBillApplicationService = (ReviewBillApplicationService)ServiceFactory.getService(ReviewBillApplicationService.class);
    private static final PublicityBillApplicationService publicityBillApplicationService = (PublicityBillApplicationService)ServiceFactory.getService(PublicityBillApplicationService.class);
    private static final IssueBillApplicationService issueBillApplicationService = (IssueBillApplicationService)ServiceFactory.getService(IssueBillApplicationService.class);
    private static final ReleaseBillApplicationService releaseBillApplicationService = (ReleaseBillApplicationService)ServiceFactory.getService(ReleaseBillApplicationService.class);
    private static final HRBaseServiceHelper TDCS_APPOINTTYPE_HELPER = new HRBaseServiceHelper("hbss_appointtype");
    private static HashMap<Integer, String> colorMap = new HashMap(4);
    private static List<String> btnList;
    private static Map<String, String> entityNumMap;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"today", "threedays", "sevendays", "all", "pending", "delay", "refuse", "expiration"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadTenureData();
        this.loadFocusData("sevendays");
        HashMap<String, Boolean> customStyles = new HashMap<String, Boolean>(1);
        customStyles.put("followTheme", Boolean.TRUE);
        this.getView().updateControlMetadata("sevendays", customStyles);
        this.getPageCache().put("currentTimeRange", "sevendays");
        this.loadAppointmentTypeData();
        this.loadEntryEntityData();
    }

    private void loadTenureData() {
        List statusList = Arrays.stream(TenureStatusEnum.values()).map(TenureStatusEnum::getNumber).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] tenureData = tenureApplicationService.queryByPermission("tenurestatus", currUserId, statusList, "47150e89000000ac");
        Map<String, Long> statusMap = Arrays.stream(tenureData).collect(Collectors.groupingBy(p -> p.getString("tenurestatus"), Collectors.counting()));
        this.getModel().setValue("assumenum", (Object)this.getMapData(statusMap, TenureStatusEnum.ASSUME.getNumber()));
        this.getModel().setValue("probationnum", (Object)this.getMapData(statusMap, TenureStatusEnum.PROBATION.getNumber()));
        this.getModel().setValue("leavenum", (Object)this.getMapData(statusMap, TenureStatusEnum.LEAVE.getNumber()));
    }

    private void loadFocusData(String type) {
        long userId = RequestContext.get().getCurrUserId();
        List<QFilter> pendingFilters = this.getPendingFilters(type);
        DynamicObject[] pendingArr = tenureApplicationService.queryProbationByPermission("id", userId, pendingFilters, "47150e89000000ac");
        Label pending = (Label)this.getControl("pending");
        pending.setText(pendingArr.length + "");
        List<QFilter> delayFilters = this.getDelayFilters(type);
        DynamicObject[] delayArr = tenureApplicationService.queryProbationByPermission("id", userId, delayFilters, "47150e89000000ac");
        Label delay = (Label)this.getControl("delay");
        delay.setText(delayArr.length + "");
        List<QFilter> refuseFilters = this.getRefuseFilters(type);
        DynamicObject[] refuseArr = tenureApplicationService.queryProbationByPermission("id", userId, refuseFilters, "47150e89000000ac");
        Label refuse = (Label)this.getControl("refuse");
        refuse.setText(refuseArr.length + "");
        List<QFilter> expireFilters = this.getExpireFilters(type);
        DynamicObject[] expirationData = tenureApplicationService.queryByPermissionAndQFilters("id", userId, expireFilters, "47150e89000000ac");
        Label expiration = (Label)this.getControl("expiration");
        expiration.setText(expirationData.length + "");
        this.getPageCache().put("currentTimeRange", type);
    }

    private long getMapData(Map<String, Long> map, String key) {
        if (map == null) {
            return 0L;
        }
        return map.get(key) == null ? 0L : map.get(key);
    }

    private Map<String, Date> getTimeRange(String type) {
        HashMap<String, Date> map = new HashMap<String, Date>(2);
        if ("all".equals(type)) {
            return map;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date startDate = calendar.getTime();
        Date endDate = null;
        if ("today".equals(type)) {
            calendar.add(7, 1);
            endDate = calendar.getTime();
        } else if ("threedays".equals(type)) {
            calendar.add(7, 3);
            endDate = calendar.getTime();
        } else if ("sevendays".equals(type)) {
            calendar.add(7, 7);
            endDate = calendar.getTime();
        } else if ("duetoday".equals(type)) {
            calendar.add(7, 1);
            endDate = calendar.getTime();
        } else if ("overdue".equals(type)) {
            startDate = null;
            endDate = new Date();
        }
        map.put("startDate", startDate);
        map.put("endDate", endDate);
        return map;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        String currentTimeRangeType = this.getPageCache().get("currentTimeRange");
        if ("today".equals(key)) {
            this.loadFocusData("today");
            this.changeBtnColor("today");
        }
        if ("threedays".equals(key)) {
            this.loadFocusData("threedays");
            this.changeBtnColor("threedays");
        }
        if ("sevendays".equals(key)) {
            this.loadFocusData("sevendays");
            this.changeBtnColor("sevendays");
        }
        if ("all".equals(key)) {
            this.loadFocusData("all");
            this.changeBtnColor("all");
        }
        if ("pending".equals(key)) {
            List<QFilter> pendingFilters = this.getPendingFilters(currentTimeRangeType);
            this.showFormByQFilter("cadm_probation", pendingFilters);
        }
        if ("delay".equals(key)) {
            List<QFilter> delayFilters = this.getDelayFilters(currentTimeRangeType);
            this.showFormByQFilter("cadm_probation", delayFilters);
        }
        if ("refuse".equals(key)) {
            List<QFilter> refuseFilters = this.getRefuseFilters(currentTimeRangeType);
            this.showFormByQFilter("cadm_probation", refuseFilters);
        }
        if ("expiration".equals(key)) {
            List<QFilter> expireFilters = this.getExpireFilters(currentTimeRangeType);
            this.showFormByQFilter("cadm_tenure", expireFilters);
        }
    }

    private void showFormByQFilter(String formId, List<QFilter> qFilterList) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.setBillFormId(formId);
        List qFilters = parameter.getListFilterParameter().getQFilters();
        qFilters.addAll(qFilterList);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void changeBtnColor(String btn) {
        btnList.forEach(p -> {
            HashMap<String, Boolean> customStyles = new HashMap<String, Boolean>(1);
            customStyles.put("followTheme", p.equals(btn));
            this.getView().updateControlMetadata(p, customStyles);
        });
    }

    private void loadAppointmentTypeData() {
        logger.info("begin loadAppointmentTypeData");
        PieChart piechartap = (PieChart)this.getControl("piechartap");
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] appointTypes = nominateApplicationService.queryNominateByPermission("appointtype.number,appointtype.name", currUserId, Collections.singletonList(AppointStatusEnum.ING_APPOINT.getVal()), "47150e89000000ac");
        Map<String, List<DynamicObject>> map = Arrays.stream(appointTypes).filter(p -> StringUtils.isNotBlank((CharSequence)p.getString("appointtype.number")) && StringUtils.isNotBlank((CharSequence)p.getString("appointtype.name"))).collect(Collectors.groupingBy(p -> p.getString("appointtype.number")));
        TreeMap<String, List<DynamicObject>> sortedMap = new TreeMap<String, List<DynamicObject>>(map);
        boolean isEmpty = false;
        if (sortedMap.size() == 0) {
            isEmpty = true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String seriesName = ResManager.loadKDString((String)"\u4efb\u514d\u7c7b\u578b", (String)"WorkBench_1", (String)"tdc-cadm-formplugin", (Object[])new Object[0]);
        PieSeries series = piechartap.createSeries(seriesName);
        for (Map.Entry entry : sortedMap.entrySet()) {
            List list = (List)entry.getValue();
            String name = ((DynamicObject)list.get(0)).getString("appointtype.name");
            int value = list.size();
            stringBuilder.append(String.format("{name:'%s',value:%d},", name, value));
            series.addData(name, (Number)value);
        }
        String dataStr = "";
        if (stringBuilder.length() > 0) {
            dataStr = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        series.setRadius("50%", "70%");
        series.setCenter("25%", "50%");
        kd.bos.form.chart.Label label = new kd.bos.form.chart.Label();
        label.setShow(false);
        series.setLabel(label);
        piechartap.setTitlePropValue("text", (Object)seriesName);
        piechartap.setTitlePropValue("left", (Object)"25%");
        piechartap.setTitlePropValue("top", (Object)"center");
        piechartap.setTitlePropValue("textAlign", (Object)"center");
        if (isEmpty) {
            HashMap<String, Object> seriesItemStyle = new HashMap<String, Object>(2);
            seriesItemStyle.put("color", "#D9D9D9");
            seriesItemStyle.put("borderRadius", 0);
            seriesItemStyle.put("borderColor", "#D9D9D9");
            series.setPropValue("itemStyle", seriesItemStyle);
        } else {
            series.setPropValue("itemStyle", null);
        }
        HashMap<String, Object> titleStyle = new HashMap<String, Object>(16);
        titleStyle.put("fontSize", 12);
        titleStyle.put("color", "#212121");
        titleStyle.put("fontWeight", "400");
        titleStyle.put("fontFamily", "Microsoft YaHei");
        piechartap.setTitlePropValue("textStyle", titleStyle);
        piechartap.setShowTitle(true);
        piechartap.setShowLegend(true);
        piechartap.setLegendVertical(true);
        piechartap.setLegendPropValue("type", (Object)"scroll");
        piechartap.setLegendPropValue("align", (Object)"left");
        piechartap.setLegendPropValue("icon", (Object)"circle");
        piechartap.setLegendPropValue("left", (Object)"50%");
        piechartap.setLegendPropValue("top", (Object)"middle");
        HashMap legendTextStyle = Maps.newHashMap();
        HashMap legendRichMap = Maps.newHashMap();
        HashMap numRichMap = Maps.newHashMap();
        numRichMap.put("fontSize", 12);
        numRichMap.put("fontWeight", 500);
        numRichMap.put("color", "#212121");
        numRichMap.put("fontFamily", "PingFangSC-Medium");
        legendRichMap.put("numrich", numRichMap);
        HashMap textRichMap = Maps.newHashMap();
        textRichMap.put("color", "#666666");
        textRichMap.put("fontWeight", 400);
        textRichMap.put("fontFamily", "PingFangSC-Regular");
        legendRichMap.put("textrich", textRichMap);
        legendTextStyle.put("rich", legendRichMap);
        piechartap.setLegendPropValue("textStyle", (Object)legendTextStyle);
        piechartap.setLegendPropValue("formatter", (Object)("function (name) { if (!name) return '';var data = [" + dataStr + "];let tarValue;      for (let i = 0; i < data.length; i++) {        if (data[i].name === name) {          tarValue = data[i].value;        }      }var resultName = echarts.format.truncateText(name, 100, '\u2026');return '{textrich|'+resultName+'}'  +'{numrich|'+ ' : '+tarValue+'}';}"));
        HashMap<String, Boolean> legendToolTipMap = new HashMap<String, Boolean>(2);
        legendToolTipMap.put("show", true);
        piechartap.setLegendPropValue("tooltip", legendToolTipMap);
        HashMap<String, String> toolTipMap = new HashMap<String, String>();
        toolTipMap.put("formatter", "function (params, ticket, callback) {      return (        params.seriesName +        '<br/>' +        params.name +        ' : ' +        params.value +        ' (' +        Number(params.percent).toFixed(1) +        '%)'      );    }");
        toolTipMap.put("trigger", "item");
        piechartap.addProperty("tooltip", toolTipMap);
        piechartap.addFuncPath((List)Lists.newArrayList((Object[])new Object[]{"tooltip", "formatter"}));
        piechartap.addFuncPath((List)Lists.newArrayList((Object[])new Object[]{"legend", "formatter"}));
        piechartap.setShowTooltip(true);
        this.getView().updateView("piechartap");
        logger.info("end loadAppointmentTypeData");
    }

    private List<QFilter> getDeadlineFilter(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        String timeRangeType = "";
        if (rowIndex == 0) {
            timeRangeType = "all";
        } else if (rowIndex == 1) {
            timeRangeType = "duetoday";
        } else if (rowIndex == 2) {
            timeRangeType = "overdue";
        }
        Map<String, Date> timeRange = this.getTimeRange(timeRangeType);
        Date startDate = timeRange.get("startDate");
        Date endDate = timeRange.get("endDate");
        if (startDate != null && endDate != null) {
            QFilter startTodayDateQFilter = new QFilter("deadline", ">=", (Object)startDate);
            QFilter endTodayDateQFilter = new QFilter("deadline", "<", (Object)endDate);
            QFilter lastFinishedDateQFilter = new QFilter("deadline", ">=", (Object)new Date());
            filters.add(startTodayDateQFilter);
            filters.add(endTodayDateQFilter);
            filters.add(lastFinishedDateQFilter);
        }
        if (startDate == null && endDate != null) {
            QFilter endDateQFilter = new QFilter("deadline", "<", (Object)endDate);
            filters.add(endDateQFilter);
        }
        return filters;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        String entityNum = entityNumMap.get(fieldKey);
        if ("cadm_appointaudit".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getAuditFilters(row));
        }
        if ("cadm_examinebill".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getExamFilters(row));
        }
        if ("cadm_reviewbill".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getReviewFilters(row));
        }
        if ("cadm_publicity".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getPubFilters(row));
        }
        if ("cadm_appointissue".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getIssueFilters(row));
        }
        if ("cadm_appointrelease".equals(entityNum)) {
            this.showFormByQFilter(entityNum, this.getReleaseFilters(row));
        }
    }

    private List<QFilter> getAuditFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("appoauditstatus", "=", (Object)AppointAuditStatusEnum.TO_BE_AUDIT.getNumber());
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private List<QFilter> getExamFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("examinestatus", "in", Arrays.asList(ExamineStatusEnum.TO_BE_EXAMINE.getNumber(), ExamineStatusEnum.IN_EXAMINE.getNumber()));
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private List<QFilter> getReviewFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("reviewstatus", "in", Arrays.asList(ReviewStatusEnum.BE_REVIEW.getReviewStatus(), ReviewStatusEnum.IN_REVIEW.getReviewStatus()));
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private List<QFilter> getPubFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("pubstatus", "in", Arrays.asList(PublicityStatusEnum.BE_PUBLIC.getPubStatus(), PublicityStatusEnum.RE_PUBLICIZED.getPubStatus(), PublicityStatusEnum.BE_EFFECTIVE.getPubStatus(), PublicityStatusEnum.IN_PUBLIC.getPubStatus(), PublicityStatusEnum.BE_SUBMIT.getPubStatus()));
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private List<QFilter> getIssueFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("issuestatus", "=", (Object)IssueStatusEnum.TOBE_ISSUE.getNumber());
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private List<QFilter> getReleaseFilters(int rowIndex) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("releasestatus", "in", Arrays.asList(ReleaseStatusEnum.BE_RELEASE.getNum(), ReleaseStatusEnum.RE_PUBLICIZED.getNum(), ReleaseStatusEnum.BE_EFFECTIVE.getNum()));
        filters.add(qFilter);
        List<QFilter> deadlineFilter = this.getDeadlineFilter(rowIndex);
        filters.addAll(deadlineFilter);
        return filters;
    }

    private void loadEntryEntityData() {
        logger.info("begin loadEntryEntityData");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject[] auditList = auditBillApplicationService.queryByPermission("id,deadline", currentUserId, Collections.singletonList(AppointAuditStatusEnum.TO_BE_AUDIT.getNumber()), "47150e89000000ac");
        DynamicObject[] examList = examineBillApplicationService.queryByPermission("id,deadline", currentUserId, Arrays.asList(ExamineStatusEnum.TO_BE_EXAMINE.getNumber(), ExamineStatusEnum.IN_EXAMINE.getNumber()), "47150e89000000ac");
        DynamicObject[] reviewList = reviewBillApplicationService.queryByPermission("id,deadline", currentUserId, Arrays.asList(ReviewStatusEnum.BE_REVIEW.getReviewStatus(), ReviewStatusEnum.IN_REVIEW.getReviewStatus()), "47150e89000000ac");
        DynamicObject[] pubList = publicityBillApplicationService.queryByPermission("id,deadline", currentUserId, Arrays.asList(PublicityStatusEnum.BE_PUBLIC.getPubStatus(), PublicityStatusEnum.RE_PUBLICIZED.getPubStatus(), PublicityStatusEnum.BE_EFFECTIVE.getPubStatus(), PublicityStatusEnum.IN_PUBLIC.getPubStatus(), PublicityStatusEnum.BE_SUBMIT.getPubStatus()), "47150e89000000ac");
        DynamicObject[] issueList = issueBillApplicationService.queryByPermission("id,deadline", currentUserId, Collections.singletonList(IssueStatusEnum.TOBE_ISSUE.getNumber()), "47150e89000000ac");
        DynamicObject[] releaseList = releaseBillApplicationService.queryByPermission("id,deadline", currentUserId, Arrays.asList(ReleaseStatusEnum.BE_RELEASE.getNum(), ReleaseStatusEnum.RE_PUBLICIZED.getNum(), ReleaseStatusEnum.BE_EFFECTIVE.getNum()), "47150e89000000ac");
        Date nowDate = new Date();
        long auditDueTodayCount = this.getDueTodayCount(auditList, nowDate);
        long examDueTodayCount = this.getDueTodayCount(examList, nowDate);
        long reviewDueTodayCount = this.getDueTodayCount(reviewList, nowDate);
        long pubDueTodayCount = this.getDueTodayCount(pubList, nowDate);
        long issueDueTodayCount = this.getDueTodayCount(issueList, nowDate);
        long releaseDueTodayCount = this.getDueTodayCount(releaseList, nowDate);
        long auditWarnCount = Arrays.stream(auditList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        long examWarnCount = Arrays.stream(examList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        long reviewWarnCount = Arrays.stream(reviewList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        long pubWarnCount = Arrays.stream(pubList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        long issueWarnCount = Arrays.stream(issueList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        long releaseWarnCount = Arrays.stream(releaseList).filter(p -> p.getDate("deadline") != null && p.getDate("deadline").getTime() < nowDate.getTime()).count();
        List<Number> auditNumList = Arrays.asList(auditList.length, auditDueTodayCount, auditWarnCount);
        List<Number> examNumList = Arrays.asList(examList.length, examDueTodayCount, examWarnCount);
        List<Number> reviewNumList = Arrays.asList(reviewList.length, reviewDueTodayCount, reviewWarnCount);
        List<Number> pubNumList = Arrays.asList(pubList.length, pubDueTodayCount, pubWarnCount);
        List<Number> issueNumList = Arrays.asList(issueList.length, issueDueTodayCount, issueWarnCount);
        List<Number> releaseNumList = Arrays.asList(releaseList.length, releaseDueTodayCount, releaseWarnCount);
        this.getModel().deleteEntryData("entryentity");
        int[] indexArr = this.getModel().batchCreateNewEntryRow("entryentity", 3);
        List<String> descList = Arrays.asList(ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"WorkBench_2", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4eca\u65e5\u5230\u671f", (String)"WorkBench_3", (String)"tdc-cadm-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u903e\u671f", (String)"WorkBench_4", (String)"tdc-cadm-formplugin", (Object[])new Object[0]));
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        for (int i = 0; i < indexArr.length; ++i) {
            this.getModel().setValue("desc", (Object)descList.get(i), indexArr[i]);
            String color = colorMap.get(i);
            ArrayList<CellStyle> csList = new ArrayList<CellStyle>();
            CellStyle cs = new CellStyle();
            cs.setForeColor(color);
            cs.setFieldKey("desc");
            cs.setRow(i);
            csList.add(cs);
            grid.setCellStyle(csList);
            this.getModel().setValue("appointaudit", (Object)auditNumList.get(i), indexArr[i]);
            this.getModel().setValue("examine", (Object)examNumList.get(i), indexArr[i]);
            this.getModel().setValue("review", (Object)reviewNumList.get(i), indexArr[i]);
            this.getModel().setValue("pub", (Object)pubNumList.get(i), indexArr[i]);
            this.getModel().setValue("issue", (Object)issueNumList.get(i), indexArr[i]);
            this.getModel().setValue("release", (Object)releaseNumList.get(i), indexArr[i]);
        }
        grid.setColumnProperty("desc", "isFixed", (Object)true);
        grid.getItems().forEach(col -> {
            TextEdit textEdit;
            if (col instanceof TextEdit && !(textEdit = (TextEdit)col).getFieldKey().equals("desc")) {
                grid.setColumnProperty(textEdit.getFieldKey(), "text-align", (Object)"center");
            }
        });
        this.getView().updateView("entryentity");
        this.getModel().setDataChanged(false);
        logger.info("end loadEntryEntityData");
    }

    private long getDueTodayCount(DynamicObject[] arr, Date nowDate) {
        return Arrays.stream(arr).filter(p -> {
            if (p.getDate("deadline") == null) {
                return false;
            }
            Date deadline = p.getDate("deadline");
            return DateUtil.isToday((Date)deadline) && deadline.getTime() >= nowDate.getTime();
        }).count();
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private List<QFilter> getPendingFilters(String timeRangeType) {
        Map<String, Date> timeRange = this.getTimeRange(timeRangeType);
        Date startDate = timeRange.get("startDate");
        Date endDate = timeRange.get("endDate");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (startDate != null && endDate != null) {
            QFilter startDateQFilter = new QFilter("prepositivedate", ">=", (Object)startDate);
            QFilter endDateQFilter = new QFilter("prepositivedate", "<", (Object)endDate);
            filters.add(startDateQFilter);
            filters.add(endDateQFilter);
        }
        QFilter statusFilter = new QFilter("positivestatus", "in", Arrays.asList(PositiveStatusEnum.TODO.getNumber(), PositiveStatusEnum.INEFFECTIVE.getNumber()));
        filters.add(statusFilter);
        return filters;
    }

    private List<QFilter> getDelayFilters(String timeRangeType) {
        Map<String, Date> timeRange = this.getTimeRange(timeRangeType);
        Date startDate = timeRange.get("startDate");
        Date endDate = timeRange.get("endDate");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (startDate != null && endDate != null) {
            QFilter startDateQFilter = new QFilter("prepositivedate", ">=", (Object)startDate);
            QFilter endDateQFilter = new QFilter("prepositivedate", "<", (Object)endDate);
            filters.add(startDateQFilter);
            filters.add(endDateQFilter);
        }
        QFilter statusFilter = new QFilter("positivestatus", "=", (Object)PositiveStatusEnum.DELAY.getNumber());
        filters.add(statusFilter);
        return filters;
    }

    private List<QFilter> getRefuseFilters(String timeRangeType) {
        Map<String, Date> timeRange = this.getTimeRange(timeRangeType);
        Date startDate = timeRange.get("startDate");
        Date endDate = timeRange.get("endDate");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (startDate != null && endDate != null) {
            QFilter refuseStartDateQFilter = new QFilter("proentryentity.entryoperationdate", ">=", (Object)startDate);
            QFilter refuseEndDateQFilter = new QFilter("proentryentity.entryoperationdate", "<", (Object)endDate);
            filters.add(refuseStartDateQFilter);
            filters.add(refuseEndDateQFilter);
        }
        QFilter positiveFilter = new QFilter("positivestatus", "=", (Object)PositiveStatusEnum.REFUSE.getNumber());
        QFilter tenureFilter = new QFilter("tenurestatus", "in", Arrays.asList(TenureStatusEnum.PROBATION.getNumber(), TenureStatusEnum.ASSUME.getNumber()));
        filters.add(positiveFilter);
        filters.add(tenureFilter);
        return filters;
    }

    private List<QFilter> getExpireFilters(String timeRangeType) {
        Map<String, Date> timeRange = this.getTimeRange(timeRangeType);
        Date startDate = timeRange.get("startDate");
        Date endDate = timeRange.get("endDate");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (startDate != null && endDate != null) {
            QFilter startDateQFilter = new QFilter("realenddate", ">=", (Object)startDate);
            QFilter endDateQFilter = new QFilter("realenddate", "<", (Object)endDate);
            filters.add(startDateQFilter);
            filters.add(endDateQFilter);
        }
        QFilter statusQFilter = new QFilter("tenurestatus", "=", (Object)TenureStatusEnum.ASSUME.getNumber());
        filters.add(statusQFilter);
        return filters;
    }

    static {
        entityNumMap = new HashMap<String, String>(16);
        colorMap.put(0, "#212121");
        colorMap.put(1, "#FF991C");
        colorMap.put(2, "#FB2323");
        btnList = Arrays.asList("today", "threedays", "sevendays", "all");
        entityNumMap.put("appointaudit", "cadm_appointaudit");
        entityNumMap.put("examine", "cadm_examinebill");
        entityNumMap.put("review", "cadm_reviewbill");
        entityNumMap.put("pub", "cadm_publicity");
        entityNumMap.put("issue", "cadm_appointissue");
        entityNumMap.put("release", "cadm_appointrelease");
    }
}

